/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.upgrade;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CountersignNodesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceDeleteByBusinessListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceEndDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceGetTraceDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceQueryActivityTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceQueryCommentDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceQueryFinishedDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceStartByIdDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceStartByKeyDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessDefinitionQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.dto.UpdatePendingTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessCompleteStatusDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstActivateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstBatchDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstEndDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstFinishedQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstSuspendDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStatusCheckDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.ActivityTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.CommentQueryDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.feign.RemoteInstanceEngineService;
import com.jxdinfo.hussar.workflow.upgrade.StandardInstanceEngineApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardRemoteInstanceEngineApiService
implements StandardInstanceEngineApiService {
    @Autowired
    private RemoteInstanceEngineService remoteInstanceEngineService;

    public BpmResponseResult queryActivityTask(ActivityTaskQueryDto activityTaskQueryDto) {
        InstanceQueryActivityTaskDto instanceQueryActivityTaskDto = new InstanceQueryActivityTaskDto();
        HussarUtils.copy((Object)activityTaskQueryDto, (Object)instanceQueryActivityTaskDto);
        if (activityTaskQueryDto.getType() == 0) {
            return this.remoteInstanceEngineService.queryCallActivityTask(instanceQueryActivityTaskDto);
        }
        if (activityTaskQueryDto.getType() == 1) {
            return this.remoteInstanceEngineService.queryMainActivityTask(instanceQueryActivityTaskDto);
        }
        throw new HussarException("\u4e0d\u652f\u6301\u7684\u6d41\u7a0b\u7c7b\u578b");
    }

    public BpmResponseResult checkProcessInstByBusinessKey(String businessId) {
        return this.remoteInstanceEngineService.checkProcessInstByBusinessId(businessId);
    }

    public BpmResponseResult queryAllComment(CommentQueryDto commentQueryDto) {
        InstanceQueryCommentDto instanceQueryCommentDto = new InstanceQueryCommentDto();
        HussarUtils.copy((Object)commentQueryDto, (Object)instanceQueryCommentDto);
        return this.remoteInstanceEngineService.queryCompletecomment(instanceQueryCommentDto);
    }

    public BpmResponseResult queryProcessDefinition(ProcessDefinitionQueryDto processDefinitionQueryDto) {
        if (HussarUtils.isNotEmpty((Object)processDefinitionQueryDto.getProcessInsId())) {
            return this.remoteInstanceEngineService.queryProcessDefinitionByInstanceId(processDefinitionQueryDto.getProcessInsId());
        }
        return this.remoteInstanceEngineService.queryProcessDefinitionByBusinessId(processDefinitionQueryDto.getBusinessId());
    }

    public BpmResponseResult checkProcessStatus(ProcessStatusCheckDto processStatusCheckDto) {
        return this.remoteInstanceEngineService.checkProcessStatus(processStatusCheckDto);
    }

    public BpmResponseResult queryAllProcessTrace(InstanceGetTraceDto processTraceQueryDto) {
        return this.remoteInstanceEngineService.getAllProcessTrace(processTraceQueryDto);
    }

    public BpmResponseResult suspendProcessInstance(ProcessInstSuspendDto processInstSuspendDto) {
        if (HussarUtils.isNotEmpty((Object)processInstSuspendDto.getProcessInsId())) {
            return this.remoteInstanceEngineService.suspendProcessInstanceById(processInstSuspendDto.getProcessInsId());
        }
        return this.remoteInstanceEngineService.suspendProcessInstanceByBusinessId(processInstSuspendDto.getBusinessId());
    }

    public BpmResponseResult activateProcessInstance(ProcessInstActivateDto processInstActivateDto) {
        if (HussarUtils.isNotEmpty((Object)processInstActivateDto.getProcessInsId())) {
            return this.remoteInstanceEngineService.activateProcessInstanceById(processInstActivateDto.getProcessInsId());
        }
        return this.remoteInstanceEngineService.activateProcessInstanceByBusinessId(processInstActivateDto.getBusinessId());
    }

    public BpmResponseResult deleteProcessInstance(ProcessInstDeleteDto processInstDeleteDto) {
        if (processInstDeleteDto.getIsFinish()) {
            if (HussarUtils.isNotEmpty((Object)processInstDeleteDto.getProcessInsId())) {
                return this.remoteInstanceEngineService.deleteFinishedProcessInstance(processInstDeleteDto.getProcessInsId());
            }
            return this.remoteInstanceEngineService.deleteFinishProcessInstanceByBusinessId(processInstDeleteDto.getBusinessId());
        }
        if (HussarUtils.isNotEmpty((Object)processInstDeleteDto.getProcessInsId())) {
            InstanceDeleteDto instanceDeleteDto = new InstanceDeleteDto();
            HussarUtils.copy((Object)processInstDeleteDto, (Object)instanceDeleteDto);
            return this.remoteInstanceEngineService.deleteProcessInstance(instanceDeleteDto);
        }
        return this.remoteInstanceEngineService.deleteProcessInstanceByBusinessId(processInstDeleteDto.getBusinessId());
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIds(ProcessInstBatchDeleteDto processInstBatchDeleteDto) {
        InstanceDeleteByBusinessListDto instanceDeleteByBusinessListDto = new InstanceDeleteByBusinessListDto();
        instanceDeleteByBusinessListDto.setBusinessId(String.join((CharSequence)",", processInstBatchDeleteDto.getBusinessIdList()));
        instanceDeleteByBusinessListDto.setIsValidate(processInstBatchDeleteDto.getIsValidate());
        return this.remoteInstanceEngineService.deleteProcessInstanceByBusinessIdList(instanceDeleteByBusinessListDto);
    }

    public BpmResponseResult queryFinishedProcessInstance(ProcessInstFinishedQueryDto processInstFinishedQueryDto) {
        InstanceQueryFinishedDto instanceQueryFinishedDto = new InstanceQueryFinishedDto();
        HussarUtils.copy((Object)processInstFinishedQueryDto, (Object)instanceQueryFinishedDto);
        return this.remoteInstanceEngineService.queryFinishedProcessInstance(instanceQueryFinishedDto);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(ProcessCompleteStatusDto processCompleteStatusDto) {
        if (HussarUtils.isNotEmpty((Object)processCompleteStatusDto.getProcessInsId())) {
            return this.remoteInstanceEngineService.queryProcessInstanceCompleteState(processCompleteStatusDto.getProcessInsId());
        }
        return this.remoteInstanceEngineService.queryProcessInstanceCompleteStateByBusinessId(processCompleteStatusDto.getBusinessId());
    }

    public BpmResponseResult getProcessTrace(String processInsId) {
        InstanceGetTraceDto instanceGetTraceDto = new InstanceGetTraceDto();
        instanceGetTraceDto.setProcessInsId(processInsId);
        return this.remoteInstanceEngineService.getProcessTrace(instanceGetTraceDto);
    }

    public BpmResponseResult endProcess(ProcessInstEndDto processInstEndDto) {
        InstanceEndDto instanceEndDto = new InstanceEndDto();
        HussarUtils.copy((Object)processInstEndDto, (Object)instanceEndDto);
        return this.remoteInstanceEngineService.endProcess(instanceEndDto);
    }

    public BpmResponseResult queryProcessByStarter(ProcessQueryByStarterDto processQueryByStarterDto) {
        return this.remoteInstanceEngineService.queryProcessByStarter(processQueryByStarterDto);
    }

    public BpmResponseResult queryRevokeProcessByStarter(ProcessQueryByStarterDto processQueryByStarterDto) {
        processQueryByStarterDto.setIsRevoke(Boolean.TRUE.booleanValue());
        return this.remoteInstanceEngineService.queryProcessByStarter(processQueryByStarterDto);
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        return this.remoteInstanceEngineService.revokeProcess(processRevokeDto);
    }

    public BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        return this.remoteInstanceEngineService.queryProcessInstance(processDto);
    }

    public BpmResponseResult queryAllCountersignNodes(CountersignNodesDto countersignNodesBean) {
        return this.remoteInstanceEngineService.queryAllCountersignNodes(countersignNodesBean);
    }

    public BpmResponseResult startProcessInstanceById(InstanceStartByIdDto instanceStartByIdDto) {
        return this.remoteInstanceEngineService.startProcessInstanceById(instanceStartByIdDto);
    }

    public BpmResponseResult startProcessInstanceByKey(InstanceStartByKeyDto instanceStartByKeyDto) {
        return this.remoteInstanceEngineService.startProcessInstanceByKey(instanceStartByKeyDto);
    }

    public BpmResponseResult updatePendingTask(UpdatePendingTaskDto updatePendingTaskDto) {
        return this.remoteInstanceEngineService.updatePendingTask(updatePendingTaskDto);
    }
}

