/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.upgrade;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.DefinitionSearchDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.NodeInfQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefActivateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefSuspendDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.feign.RemoteDefinitionEngineService;
import com.jxdinfo.hussar.workflow.upgrade.StandardDefinitionEngineApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardRemoteDefinitionEngineApiService
implements StandardDefinitionEngineApiService {
    @Autowired
    private RemoteDefinitionEngineService remoteDefinitionEngineService;

    public BpmResponseResult queryProcessMainOrNew(String processKey) {
        return this.remoteDefinitionEngineService.getProcessMainOrNew(processKey);
    }

    public BpmResponseResult queryProcessDefList(ProcessDefQueryDto processDefQueryDto) {
        if (HussarUtils.isNotEmpty((Object)processDefQueryDto.getProcessKey())) {
            return this.remoteDefinitionEngineService.getProcessDefList(processDefQueryDto.getProcessKey());
        }
        return this.remoteDefinitionEngineService.queryProcessDefList(processDefQueryDto.getProcessName());
    }

    public BpmResponseResult activateProcessDefinition(ProcessDefActivateDto processDefActivateDto) {
        if (!HussarUtils.isEmpty((Object)processDefActivateDto.getProcessDefinitionId())) {
            return this.remoteDefinitionEngineService.activateProcessDefinitionById(processDefActivateDto.getProcessDefinitionId());
        }
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        HussarUtils.copy((Object)processDefActivateDto, (Object)definitionSearchDto);
        return this.remoteDefinitionEngineService.activateProcessByKeyAndVersion(definitionSearchDto);
    }

    public BpmResponseResult deleteProcessDefinition(ProcessDefDeleteDto processDefDeleteDto) {
        if (!HussarUtils.isEmpty((Object)processDefDeleteDto.getProcessDefinitionId())) {
            return this.remoteDefinitionEngineService.deleteProcessDefinition(processDefDeleteDto.getProcessDefinitionId());
        }
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        HussarUtils.copy((Object)processDefDeleteDto, (Object)definitionSearchDto);
        return this.remoteDefinitionEngineService.deleteProcessDefinitionByKeyAndVersion(definitionSearchDto);
    }

    public BpmResponseResult suspendProcessDefinition(ProcessDefSuspendDto processDefSuspendDto) {
        if (HussarUtils.isNotEmpty((Object)processDefSuspendDto.getProcessDefinitionId())) {
            return this.remoteDefinitionEngineService.suspendProcessDefinitionById(processDefSuspendDto.getProcessDefinitionId());
        }
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        HussarUtils.copy((Object)processDefSuspendDto, (Object)definitionSearchDto);
        return this.remoteDefinitionEngineService.suspendProcessByKeyAndVersion(definitionSearchDto);
    }

    public BpmResponseResult queryAllProcessDefinitions() {
        return this.remoteDefinitionEngineService.queryProcess();
    }

    public BpmResponseResult queryAllNodeFormInfo(NodeInfQueryDto nodeInfQueryDto) {
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        HussarUtils.copy((Object)nodeInfQueryDto, (Object)definitionSearchDto);
        return this.remoteDefinitionEngineService.queryAllNodeFormKey(definitionSearchDto);
    }

    public BpmResponseResult queryPublishStatusByProcessKey(String processKey) {
        return InstallResult.success((Object)this.remoteDefinitionEngineService.queryIsPublish(processKey));
    }

    public BpmResponseResult queryNodeInfo(NodeInfQueryDto nodeInfQueryDto) {
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        HussarUtils.copy((Object)nodeInfQueryDto, (Object)definitionSearchDto);
        return this.remoteDefinitionEngineService.queryNodeInfoByProcessKeyAndVersion(definitionSearchDto);
    }
}

