/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.unifiedtodatapush.service;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.GetTokenUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import com.jxdinfo.hussar.workflow.unifiedtodatapush.util.UnifiedRequestHttpUtil;
import com.jxdinfo.hussar.workflow.unifiedtodatapush.util.UnifiedToDoDataPushProperties;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="integrationPlatformToDoDataPush")
public class IntegrationPlatformToDoDataPush
implements DataPushListener {
    private static Logger logger = LoggerFactory.getLogger(IntegrationPlatformToDoDataPush.class);
    @Autowired
    private UnifiedToDoDataPushProperties unifiedToDoDataPushProperties;
    @Autowired
    private IBpmConfigService bpmConfigService;
    @Lazy
    @Autowired
    private ModelService modelService;
    @Autowired
    private UnifiedRequestHttpUtil unifiedRequestHttpUtil;

    private String getUnifiedToDoCallAddress() {
        return this.unifiedToDoDataPushProperties.getUnifiedToDoCallAddress();
    }

    private boolean needDataPush() {
        return this.unifiedToDoDataPushProperties.isUseDatapush() && this.unifiedToDoDataPushProperties.isRemoteDatapush() && "integrationPlatformToDoDataPush".equals(this.unifiedToDoDataPushProperties.getUnifiedTodoServerName());
    }

    public void addTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_addTask");
    }

    public void completeTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_completeTask");
    }

    public void deleteTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_deleteTask");
    }

    public void entrustTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_entrustTask");
    }

    public void rejectTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_rejectTask");
    }

    public void revokeTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_revokeTask");
    }

    public void freeJumpTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_freeJumpTask");
    }

    public void addUser(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_addUser");
    }

    public void deleteMultiTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_deleteMultiTask");
    }

    public void addCcTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_addCcTask");
    }

    public void addCcTask(List<DataPush> dataPushList) {
        this.dataPushTodo(dataPushList, "/hussarBpm_todo_dataPushTodo_addBatchCcTask");
    }

    public void readCcTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_readCcTask");
    }

    public void addUrgeTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_addUrgeTask");
    }

    public void endProcess(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_endProcess");
    }

    public void transferTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_transferTask");
    }

    public void reTransferTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_reTransferTask");
    }

    public void changeProcessState(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_changeProcessState");
    }

    public void transferUserTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_transferUserTask");
    }

    public void deleteCcTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_deleteCcTask");
    }

    public void addStartProcess(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_addStartProcess");
    }

    public void updateStartProcess(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_updateStartProcess");
    }

    public void deleteStartProcess(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_deleteStartProcess");
    }

    public void changeProcessNode(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm_todo_dataPushTodo_changeProcessNode");
    }

    private void dataPushTodo(Object dataPush, String url) {
        if (this.needDataPush()) {
            logger.info("\u63a8\u9001\u79df\u6237\u7edf\u4e00\u5f85\u529e\uff0c\u63a5\u53e3: {}", (Object)url);
            DataPush dataPush1 = (DataPush)dataPush;
            String processKey = dataPush1.getProcessKey();
            String clientId = this.unifiedToDoDataPushProperties.getClientId(null);
            String clientSecret = this.unifiedToDoDataPushProperties.getClientSecret(null);
            String unifiedToDoCallAddress = this.unifiedToDoDataPushProperties.getUnifiedToDoCallAddress(null);
            String integrationPlatformCallAddress = this.bpmConfigService.getStringByKeyUseCache("integration_platform_call_address");
            String result = HttpClient.doPost((String)(unifiedToDoCallAddress + url), (String)JSON.toJSONString((Object)dataPush), (Map)GetTokenUtil.buildHeaderMap((String)GetTokenUtil.getUnifiedToken((String)integrationPlatformCallAddress, (String)"", (String)clientId, (String)clientSecret), null, (String)clientId));
            logger.info("\u63a5\u53e3\uff1a{} \u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)url, (Object)result);
        }
    }
}

