/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.unifiedtodatapush.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar.bpm")
public class UnifiedToDoDataPushProperties {
    private final IBpmConfigService bpmConfigService;
    public static final String PREFIX = "hussar.bpm";
    private String deploymentModel;

    public UnifiedToDoDataPushProperties(IBpmConfigService bpmConfigService) {
        this.bpmConfigService = bpmConfigService;
    }

    public String getDeploymentModel() {
        return this.deploymentModel;
    }

    public void setDeploymentModel(String deploymentModel) {
        this.deploymentModel = deploymentModel;
    }

    public boolean isWorkflowPlatformStandalone() {
        return "workflow-platform".equals(this.deploymentModel);
    }

    public boolean isUseDatapush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_data_push");
    }

    public Long getSystemId() {
        return this.bpmConfigService.getLongByKeyUseCache("unified_system_id");
    }

    public String getClientId() {
        return this.bpmConfigService.getStringByKeyUseCache("client_id");
    }

    public String getClientSecret() {
        return this.bpmConfigService.getStringByKeyUseCache("client_secret");
    }

    public Long getSystemId(String processModelType) {
        if ("0".equals(processModelType)) {
            return this.bpmConfigService.getLongByKeyUseCache("nocode_unified_system_id");
        }
        return this.bpmConfigService.getLongByKeyUseCache("unified_system_id");
    }

    public String getClientId(String processModelType) {
        if ("0".equals(processModelType)) {
            return this.bpmConfigService.getStringByKeyUseCache("nocode_client_id");
        }
        return this.bpmConfigService.getStringByKeyUseCache("client_id");
    }

    public String getClientSecret(String processModelType) {
        if ("0".equals(processModelType)) {
            return this.bpmConfigService.getStringByKeyUseCache("nocode_client_secret");
        }
        return this.bpmConfigService.getStringByKeyUseCache("client_secret");
    }

    public String getUnifiedToDoCallAddress(String processModelType) {
        String address = null;
        address = "0".equals(processModelType) ? this.bpmConfigService.getStringByKeyUseCache("nocode_unified_to_do_call_address") : this.bpmConfigService.getStringByKeyUseCache("unified_to_do_call_address");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }

    public String getClientScope() {
        return "permission_list";
    }

    public String getUnifiedToDoCallAddress() {
        String address = this.bpmConfigService.getStringByKeyUseCache("unified_to_do_call_address");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }

    public boolean isRemoteDatapush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("remote_data_push");
    }

    public String getUnifiedTodoServerName() {
        return this.bpmConfigService.getStringByKeyUseCache("unified_todo_server_name");
    }
}

