/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.unifiedtodatapush.service;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import com.jxdinfo.hussar.workflow.unifiedtodatapush.util.UnifiedToDoDataPushProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tenantToDoDataPush")
public class TenantToDoDataPush
implements DataPushListener {
    private static Logger logger = LoggerFactory.getLogger(TenantToDoDataPush.class);
    @Autowired
    private UnifiedToDoDataPushProperties unifiedToDoDataPushProperties;

    private String getUnifiedToDoCallAddress() {
        return this.unifiedToDoDataPushProperties.getUnifiedToDoCallAddress();
    }

    private boolean needDataPush() {
        return this.unifiedToDoDataPushProperties.isUseDatapush() && "tenantToDoDataPush".equals(this.unifiedToDoDataPushProperties.getUnifiedTodoServerName());
    }

    public void addTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/addTask");
    }

    public void completeTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/completeTask");
    }

    public void deleteTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/deleteTask");
    }

    public void entrustTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/entrustTask");
    }

    public void rejectTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/rejectTask");
    }

    public void revokeTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/revokeTask");
    }

    public void freeJumpTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/freeJumpTask");
    }

    public void addUser(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/addUser");
    }

    public void deleteMultiTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/deleteMultiTask");
    }

    public void addCcTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/addCcTask");
    }

    public void addCcTask(List<DataPush> dataPushList) {
        this.dataPushTodo(dataPushList, "/hussarBpm/todo/dataPushTodo/addBatchCcTask");
    }

    public void readCcTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/readCcTask");
    }

    public void addUrgeTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/addUrgeTask");
    }

    public void endProcess(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/endProcess");
    }

    public void transferTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/transferTask");
    }

    public void reTransferTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/reTransferTask");
    }

    public void changeProcessState(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/changeProcessState");
    }

    public void transferUserTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/transferUserTask");
    }

    public void deleteCcTask(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/deleteCcTask");
    }

    public void addStartProcess(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/addStartProcess");
    }

    public void updateStartProcess(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/deleteStartProcess");
    }

    public void deleteStartProcess(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/updateStartProcess");
    }

    public void changeProcessNode(DataPush dataPush) {
        this.dataPushTodo(dataPush, "/hussarBpm/todo/dataPushTodo/changeProcessNode");
    }

    private void dataPushTodo(Object dataPush, String url) {
        if (this.needDataPush()) {
            logger.info("\u63a8\u9001\u79df\u6237\u7edf\u4e00\u5f85\u529e\uff0c\u63a5\u53e3: {}", (Object)url);
            String result = HttpClient.doPost((String)(this.getUnifiedToDoCallAddress() + url), (String)JSON.toJSONString((Object)dataPush));
            logger.info("\u63a5\u53e3\uff1a{} \u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)url, (Object)result);
        }
    }
}

