/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskmodel.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuIdentitylinkService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.service.WorkflowCommonCacheService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.ProcessDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowPageMsg;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.taskmodel.service.TaskModelBackFillService;
import com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessChangeDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessChangeListDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto;
import com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto;
import com.jxdinfo.hussar.workflow.task.model.service.TaskModelService;
import com.jxdinfo.hussar.workflow.task.model.util.TaskModelServiceBeanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class TaskModelDataPush
implements DataPushListener {
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;
    @Lazy
    @Autowired
    private RepositoryService repositoryService;
    @Lazy
    @Autowired
    private HistoryService historyService;
    @Lazy
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Resource
    private IFlowTaskService flowTaskService;
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);
    @Autowired
    private IBpmActRuIdentitylinkService bpmActRuIdentitylinkService;
    private static Logger logger = LogManager.getLogger(TaskModelDataPush.class);
    private static final String MICRO = "micro";
    private static final String WORKFLOW_PLATFORM = "workflow-platform";
    private static final String SINGLE = "single";
    @Lazy
    @Autowired
    private ModelService modelService;
    @Autowired
    private WorkflowCommonCacheService workflowCommonCacheService;
    private static final String TODO = "0";
    private static final String DONE = "1";
    private static final String addTaskInfoUrl = "/hussarBpm/bpm/taskModel/addTaskInfo";
    private static final String completeTaskUrl = "/hussarBpm/bpm/taskModel/completeTask";
    private static final String updateTaskUserUrl = "/hussarBpm/bpm/taskModel/updateTaskUser";
    private static final String deleteTaskInfoUrl = "/hussarBpm/bpm/taskModel/deleteTaskInfo";
    private static final String deleteProcessUrl = "/hussarBpm/bpm/taskModel/deleteProcess";
    private static final String changeProcessInfoUrl = "/hussarBpm/bpm/taskModel/changeProcessInfo";
    private static final String changeProcessNodeUrl = "/hussarBpm/bpm/taskModel/changeProcessNode";
    private static final String processChangeUrl = "/hussarBpm/bpm/taskModel/processChange";
    private static final String processChangeListUrl = "/hussarBpm/bpm/taskModel/processChangeList";
    private static Map<String, String> stateType = new HashMap<String, String>();

    private String getFormId(String processKey) {
        String appId = this.flowTaskService.getProcessAppId(processKey);
        if (HussarUtils.isNotEmpty((Object)appId)) {
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(processKey, null);
            if (HussarUtils.isEmpty((Object)workFlow)) {
                throw new PublicClientException(BpmExceptionCodeEnum.ERROR_PROCESS_IDENTITY.getMessage());
            }
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
            List list = flowModel.getSlots().getElement();
            for (FlowObject flowObject : list) {
                if (!BpmNodeTypeUtil.isUserTask((String)flowObject.getName()) || !HussarUtils.isNotEmpty((Object)flowObject.getProps().getFormDetailAddress())) continue;
                return ((FlowPageMsg)flowObject.getProps().getFormDetailAddress().get("web")).getId();
            }
        }
        return null;
    }

    private boolean isEmulationProcess(DataPush dataPush) {
        String procInstId = dataPush.getProcessInsId();
        if (HussarUtils.isNotEmpty((Object)procInstId)) {
            if (!procInstId.contains(",")) {
                Object historicProcessInstance = Context.getCommandContext() != null ? Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(dataPush.getProcessInsId()) : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(dataPush.getProcessInsId()).singleResult();
                return historicProcessInstance != null && DONE.equals(historicProcessInstance.getIsEmulation());
            }
            HashSet<String> procInstIds = new HashSet<String>(Arrays.asList(procInstId.split(",")));
            List list = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(procInstIds).list();
            List dataPushList = list.stream().filter(e -> !DONE.equals(e.getIsEmulation())).collect(Collectors.toList());
            if (dataPushList.isEmpty()) {
                return true;
            }
            dataPush.setProcessInsId(StringUtils.join((Object[])new Object[]{dataPushList.stream().map(HistoricProcessInstance::getId), ","}));
            Map businessMap = dataPush.getBusinessMap();
            if (HussarUtils.isNotEmpty((Object)businessMap)) {
                List removeBusinessIds = list.stream().filter(e -> DONE.equals(e.getIsEmulation())).map(HistoricProcessInstance::getBusinessKey).collect(Collectors.toList());
                HashMap newBusinessMap = new HashMap();
                for (Map.Entry entry : businessMap.entrySet()) {
                    ArrayList<String> newBusinessIds = new ArrayList<String>(Arrays.asList(((String)entry.getValue()).split(",")));
                    newBusinessIds.removeAll(removeBusinessIds);
                    if (newBusinessIds.isEmpty()) continue;
                    newBusinessMap.put(entry.getKey(), StringUtils.join(newBusinessIds, (String)","));
                }
                dataPush.setBusinessMap(newBusinessMap);
            }
        } else if (dataPush.getTaskIds() != null) {
            Map map = dataPush.getProcTaskMap();
            List list = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(map.keySet()).list();
            List dataPushList = list.stream().filter(e -> !DONE.equals(e.getIsEmulation())).collect(Collectors.toList());
            if (dataPushList.isEmpty()) {
                return true;
            }
            List removeProcInstIds = list.stream().filter(e -> DONE.equals(e.getIsEmulation())).map(HistoricProcessInstance::getId).collect(Collectors.toList());
            for (String procIds : map.keySet()) {
                if (!removeProcInstIds.contains(procIds)) continue;
                dataPush.getTaskIds().removeAll((Collection)map.get(procIds));
            }
        }
        return false;
    }

    public void addTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        TaskInfoDto taskInfoDto = new TaskInfoDto();
        taskInfoDto.setFormId(this.getFormId(dataPush.getProcessKey()));
        taskInfoDto.setBusinessId(dataPush.getBusinessKey());
        taskInfoDto.setProcessKey(dataPush.getProcessKey());
        taskInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
        taskInfoDto.setTaskId(dataPush.getTaskId());
        taskInfoDto.setTaskDefinitionKey(dataPush.getTaskDefinitionKey());
        taskInfoDto.setTaskDefinitionName(dataPush.getTaskDefinitionName());
        taskInfoDto.setStartTime(dataPush.getProcessStartTime());
        taskInfoDto.setCreateTime(dataPush.getStartDate());
        taskInfoDto.setDueTime(dataPush.getTaskDueTime());
        taskInfoDto.setFormKey(dataPush.getUrl());
        taskInfoDto.setAppId(this.modelService.getAppId(dataPush.getProcessKey()));
        taskInfoDto.setAppCode(this.modelService.getAppCode(dataPush.getProcessKey()));
        String formDetailKey = dataPush.getFormDetailKey();
        if (HussarUtils.isEmpty((Object)formDetailKey)) {
            String processDefinitionId = dataPush.getProcessDefinitionId();
            String taskDefinitionKey = dataPush.getTaskDefinitionKey();
            formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, taskDefinitionKey);
        }
        taskInfoDto.setFormDetailKey(formDetailKey);
        String taskType = this.convertTaskType(dataPush.getTaskType(), TODO);
        taskInfoDto.setTaskType(taskType);
        taskInfoDto.setTaskState(TODO);
        ArrayList<WorkflowUserDto> workflowUserDtoList = new ArrayList<WorkflowUserDto>();
        if (HussarUtils.isNotEmpty((Object)dataPush.getUserMaps())) {
            for (Map user : dataPush.getUserMaps()) {
                WorkflowUserDto workflowUserDto = new WorkflowUserDto();
                workflowUserDto.setUserId((String)user.get("userId"));
                if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                    workflowUserDto.setOwnerId((String)user.get("mandator"));
                }
                workflowUserDtoList.add(workflowUserDto);
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getUserId())) {
            for (String userId : dataPush.getUserId().split(",")) {
                WorkflowUserDto workflowUserDto = new WorkflowUserDto();
                workflowUserDto.setUserId(userId);
                workflowUserDtoList.add(workflowUserDto);
            }
        }
        taskInfoDto.setUsers(workflowUserDtoList);
        this.addTaskInfoPush(taskInfoDto);
    }

    public void completeTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ArrayList<CompleteTaskInfoDto> completeTaskInfoDtos = new ArrayList<CompleteTaskInfoDto>();
        CompleteTaskInfoDto completeTaskInfoDto = new CompleteTaskInfoDto();
        completeTaskInfoDto.setFormId(this.getFormId(dataPush.getProcessKey()));
        completeTaskInfoDto.setBusinessId(dataPush.getBusinessKey());
        completeTaskInfoDto.setProcessKey(dataPush.getProcessKey());
        completeTaskInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
        completeTaskInfoDto.setTaskId(dataPush.getTaskId());
        completeTaskInfoDto.setEndTime(dataPush.getEndDate());
        completeTaskInfoDto.setAssignee(dataPush.getUserId());
        if (HussarUtils.isNotEmpty((Object)dataPush.getConsignor())) {
            completeTaskInfoDto.setOwner(dataPush.getConsignor());
        }
        String taskType = this.convertTaskType(dataPush.getTaskType(), DONE);
        completeTaskInfoDto.setTaskType(taskType);
        completeTaskInfoDto.setTaskState(DONE);
        completeTaskInfoDto.setAppId(this.modelService.getAppId(dataPush.getProcessKey()));
        completeTaskInfoDto.setAppCode(this.modelService.getAppCode(dataPush.getProcessKey()));
        completeTaskInfoDtos.add(completeTaskInfoDto);
        this.completeTaskPush(completeTaskInfoDtos);
    }

    public void deleteTask(DataPush dataPush) {
        List emulationBusinessKey = dataPush.getEmulationBusinessKey();
        ArrayList<DeletedTaskInfoDto> deletedTaskInfoDtos = new ArrayList<DeletedTaskInfoDto>();
        Map businessMap = dataPush.getBusinessMap();
        for (Map.Entry entry : businessMap.entrySet()) {
            DeletedTaskInfoDto deletedTaskInfoDto = new DeletedTaskInfoDto();
            String processDefinitionId = (String)entry.getKey();
            boolean backFill = this.isBackFill(processDefinitionId);
            if (!backFill) continue;
            String processKey = processDefinitionId.split(":")[0];
            deletedTaskInfoDto.setProcessKey(processKey);
            deletedTaskInfoDto.setFormId(this.getFormId(processKey));
            List<String> businessIds = Arrays.asList(((String)entry.getValue()).split(","));
            if (emulationBusinessKey != null) {
                businessIds.removeAll(emulationBusinessKey);
            }
            if (businessIds.isEmpty()) continue;
            deletedTaskInfoDto.setBusinessIdList(businessIds);
            deletedTaskInfoDto.setAppId(this.modelService.getAppId(processKey));
            deletedTaskInfoDto.setAppCode(this.modelService.getAppCode(processKey));
            deletedTaskInfoDtos.add(deletedTaskInfoDto);
            this.deleteTaskInfoPush(deletedTaskInfoDtos);
        }
    }

    public void entrustTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ArrayList<UpdateTaskUserDto> updateTaskUserDtos = new ArrayList<UpdateTaskUserDto>();
        UpdateTaskUserDto updateTaskUserDto = new UpdateTaskUserDto();
        updateTaskUserDto.setFormId(this.getFormId(dataPush.getProcessKey()));
        updateTaskUserDto.setProcessKey(dataPush.getProcessKey());
        updateTaskUserDto.setTaskId(dataPush.getTaskId());
        ArrayList<WorkflowUserDto> workflowUserDtoList = new ArrayList<WorkflowUserDto>();
        List userMapList = dataPush.getUserMapList();
        if (HussarUtils.isNotEmpty((Object)userMapList)) {
            for (Map map : userMapList) {
                WorkflowUserDto workflowUserDto = new WorkflowUserDto();
                workflowUserDto.setUserId((String)map.get("userId"));
                if (HussarUtils.isNotEmpty(map.get("mandator"))) {
                    workflowUserDto.setOwnerId((String)map.get("mandator"));
                }
                workflowUserDtoList.add(workflowUserDto);
            }
        }
        updateTaskUserDto.setUsers(workflowUserDtoList);
        updateTaskUserDto.setAppId(this.modelService.getAppId(dataPush.getProcessKey()));
        updateTaskUserDto.setAppCode(this.modelService.getAppCode(dataPush.getProcessKey()));
        updateTaskUserDtos.add(updateTaskUserDto);
        this.updateTaskUserPush(updateTaskUserDtos);
    }

    public void transferUserTask(DataPush dataPush) {
        this.entrustTask(dataPush);
    }

    public void rejectTask(DataPush dataPush) {
        this.completeTask(dataPush);
    }

    public void revokeTask(DataPush dataPush) {
        this.completeTask(dataPush);
    }

    public void freeJumpTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ArrayList<CompleteTaskInfoDto> completeTaskInfoDtos = new ArrayList<CompleteTaskInfoDto>();
        ArrayList<String> taskIds = dataPush.getTaskIds();
        String taskId = dataPush.getTaskId();
        if (HussarUtils.isEmpty((Object)taskIds)) {
            taskIds = new ArrayList<String>();
            taskIds.add(taskId);
        }
        for (String id : taskIds) {
            CompleteTaskInfoDto completeTaskInfoDto = new CompleteTaskInfoDto();
            completeTaskInfoDto.setFormId(this.getFormId(dataPush.getProcessKey()));
            completeTaskInfoDto.setBusinessId(dataPush.getBusinessKey());
            completeTaskInfoDto.setProcessKey(dataPush.getProcessKey());
            completeTaskInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
            completeTaskInfoDto.setTaskId(id);
            completeTaskInfoDto.setEndTime(dataPush.getEndDate());
            completeTaskInfoDto.setAssignee(dataPush.getUserId());
            String taskType = this.convertTaskType(dataPush.getTaskType(), DONE);
            completeTaskInfoDto.setTaskType(taskType);
            completeTaskInfoDto.setTaskState(DONE);
            completeTaskInfoDto.setAppId(this.modelService.getAppId(dataPush.getProcessKey()));
            completeTaskInfoDto.setAppCode(this.modelService.getAppCode(dataPush.getProcessKey()));
            if (id.equals(taskId)) {
                completeTaskInfoDto.setOwner(dataPush.getConsignor());
            }
            completeTaskInfoDtos.add(completeTaskInfoDto);
        }
        this.completeTaskPush(completeTaskInfoDtos);
    }

    public void addUser(DataPush dataPush) {
        this.entrustTask(dataPush);
    }

    public void deleteMultiTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        DeletedTaskInfoDto deletedTaskInfoDto = new DeletedTaskInfoDto();
        List taskIds = dataPush.getTaskIds();
        String processKey = dataPush.getProcessKey();
        deletedTaskInfoDto.setFormId(this.getFormId(processKey));
        deletedTaskInfoDto.setProcessKey(processKey);
        deletedTaskInfoDto.setTaskIdList(taskIds);
        deletedTaskInfoDto.setAppId(this.modelService.getAppId(processKey));
        deletedTaskInfoDto.setAppCode(this.modelService.getAppCode(processKey));
        this.deleteTaskInfoPush(Arrays.asList(deletedTaskInfoDto));
    }

    public void endProcess(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ArrayList<CompleteTaskInfoDto> completeTaskInfoDtos = new ArrayList<CompleteTaskInfoDto>();
        List taskIds = dataPush.getTaskIds();
        String taskId = dataPush.getTaskId();
        for (String id : taskIds) {
            CompleteTaskInfoDto completeTaskInfoDto = new CompleteTaskInfoDto();
            completeTaskInfoDto.setFormId(this.getFormId(dataPush.getProcessKey()));
            completeTaskInfoDto.setBusinessId(dataPush.getBusinessKey());
            completeTaskInfoDto.setProcessKey(dataPush.getProcessKey());
            completeTaskInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
            completeTaskInfoDto.setTaskId(id);
            completeTaskInfoDto.setAssignee(dataPush.getUserId());
            if (HussarUtils.isNotEmpty((Object)dataPush.getConsignor()) && HussarUtils.isNotEmpty((Object)taskId) && taskId.equals(id)) {
                completeTaskInfoDto.setOwner(dataPush.getConsignor());
            }
            completeTaskInfoDto.setEndTime(dataPush.getEndDate());
            String taskType = this.convertTaskType(dataPush.getTaskType(), DONE);
            completeTaskInfoDto.setTaskType(taskType);
            completeTaskInfoDto.setTaskState(DONE);
            completeTaskInfoDto.setAppId(this.modelService.getAppId(dataPush.getProcessKey()));
            completeTaskInfoDto.setAppCode(this.modelService.getAppCode(dataPush.getProcessKey()));
            completeTaskInfoDtos.add(completeTaskInfoDto);
        }
        this.completeTaskPush(completeTaskInfoDtos);
    }

    public void transferTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        ArrayList<UpdateTaskUserDto> updateTaskUserDtos = new ArrayList<UpdateTaskUserDto>();
        Map taskProcDefIdMap = dataPush.getTaskProcDefIdMap();
        HashMap procDefTaskMap = new HashMap();
        for (Map.Entry entry : taskProcDefIdMap.entrySet()) {
            String taskIds = (String)entry.getKey();
            if (procDefTaskMap.containsKey(entry.getValue())) {
                taskIds = (String)procDefTaskMap.get(entry.getValue()) + "," + taskIds;
            }
            procDefTaskMap.put(entry.getValue(), taskIds);
        }
        for (Map.Entry entry : procDefTaskMap.entrySet()) {
            String processDefinitionId = (String)entry.getKey();
            boolean backFill = this.isBackFill(processDefinitionId);
            if (!backFill) {
                return;
            }
            String processKey = processDefinitionId.split(":")[0];
            for (String taskId : ((String)entry.getValue()).split(",")) {
                UpdateTaskUserDto updateTaskUserDto = new UpdateTaskUserDto();
                updateTaskUserDto.setFormId(this.getFormId(processKey));
                updateTaskUserDto.setProcessKey(processKey);
                updateTaskUserDto.setTaskId(taskId);
                List<WorkflowUserDto> workflowUserDtoList = this.getIdentiLink(taskId);
                updateTaskUserDto.setUsers(workflowUserDtoList);
                updateTaskUserDto.setAppId(this.modelService.getAppId(processKey));
                updateTaskUserDto.setAppCode(this.modelService.getAppCode(processKey));
                updateTaskUserDtos.add(updateTaskUserDto);
            }
            this.updateTaskUserPush(updateTaskUserDtos);
        }
    }

    public void reTransferTask(DataPush dataPush) {
        this.transferTask(dataPush);
    }

    public void changeProcessState(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        Map businessMap = dataPush.getBusinessMap();
        if (HussarUtils.isNotEmpty((Object)businessMap)) {
            ArrayList<DeletedProcessInfoDto> deletedProcessInfoDtos = new ArrayList<DeletedProcessInfoDto>();
            for (Map.Entry entry : businessMap.entrySet()) {
                String processDefinitionId = (String)entry.getKey();
                boolean backFill = this.isBackFill(processDefinitionId);
                if (!backFill) {
                    return;
                }
                String processKey = processDefinitionId.split(":")[0];
                String businessIds = (String)entry.getValue();
                ArrayList<String> ids = new ArrayList<String>(Arrays.asList(businessIds.split(",")));
                if (ids.isEmpty()) continue;
                for (String businessId : ids) {
                    DeletedProcessInfoDto deletedProcessInfoDto = new DeletedProcessInfoDto();
                    deletedProcessInfoDto.setFormId(this.getFormId(processKey));
                    deletedProcessInfoDto.setProcessKey(processKey);
                    deletedProcessInfoDto.setProcessState(stateType.get(dataPush.getProcessState()));
                    deletedProcessInfoDto.setBusinessId(businessId);
                    deletedProcessInfoDto.setFinishTime(new Date());
                    deletedProcessInfoDto.setAppId(this.modelService.getAppId(processKey));
                    deletedProcessInfoDto.setAppCode(this.modelService.getAppCode(processKey));
                    deletedProcessInfoDtos.add(deletedProcessInfoDto);
                }
                this.deleteProcessPush(deletedProcessInfoDtos);
            }
        } else {
            boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
            if (!backFill) {
                return;
            }
            ProcessInfoDto processInfoDto = new ProcessInfoDto();
            processInfoDto.setFormId(this.getFormId(dataPush.getProcessKey()));
            processInfoDto.setBusinessId(dataPush.getBusinessKey());
            processInfoDto.setProcessKey(dataPush.getProcessKey());
            processInfoDto.setProcessState(stateType.get(dataPush.getProcessState()));
            processInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
            processInfoDto.setStartTime(dataPush.getProcessStartTime());
            processInfoDto.setFinishTime(dataPush.getProcessEndTime());
            processInfoDto.setStartUserId(dataPush.getStartUserId());
            processInfoDto.setDueDate(dataPush.getDueDate());
            processInfoDto.setAppId(this.modelService.getAppId(dataPush.getProcessKey()));
            processInfoDto.setAppCode(this.modelService.getAppCode(dataPush.getProcessKey()));
            this.changeProcessInfoPush(processInfoDto);
        }
    }

    public void changeProcessNode(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ProcessNodeInfoDto processNodeInfoDto = new ProcessNodeInfoDto();
        processNodeInfoDto.setBusinessId(dataPush.getBusinessKey());
        processNodeInfoDto.setFormId(this.getFormId(dataPush.getProcessKey()));
        processNodeInfoDto.setProcessKey(dataPush.getProcessKey());
        processNodeInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
        processNodeInfoDto.setProcessNodeList(dataPush.getProcessNodeList());
        processNodeInfoDto.setAppId(this.modelService.getAppId(dataPush.getProcessKey()));
        processNodeInfoDto.setAppCode(this.modelService.getAppCode(dataPush.getProcessKey()));
        this.changeProcessNodePush(processNodeInfoDto);
    }

    private List<WorkflowUserDto> getIdentiLink(String taskId) {
        ArrayList<WorkflowUserDto> workflowUserDtoList = new ArrayList<WorkflowUserDto>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BpmActRuIdentitylink::getTaskId, (Object)Long.valueOf(taskId));
        List identitylinkList = this.bpmActRuIdentitylinkService.list((Wrapper)wrapper);
        for (BpmActRuIdentitylink identitylink : identitylinkList) {
            WorkflowUserDto workflowUserDto = new WorkflowUserDto();
            workflowUserDto.setUserId(identitylink.getUserId());
            if (HussarUtils.isNotEmpty((Object)identitylink.getMandator())) {
                workflowUserDto.setOwnerId(identitylink.getMandator());
            }
            workflowUserDtoList.add(workflowUserDto);
        }
        return workflowUserDtoList;
    }

    private String convertTaskType(String taskType, String taskState) {
        if (HussarUtils.isNotEmpty((Object)taskType) && "2".equals(taskType)) {
            if (TODO.equals(taskState)) {
                return "4";
            }
            return "5";
        }
        if (TODO.equals(taskState)) {
            return "2";
        }
        return DONE;
    }

    private boolean isBackFill(String processDefinitionId) {
        if (HussarUtils.isEmpty((Object)processDefinitionId)) {
            return false;
        }
        boolean isBackFill = false;
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        List isBackFillElement = (List)extensionElementList.get("isBackfill");
        if (HussarUtils.isNotEmpty((Object)isBackFillElement) && HussarUtils.isNotEmpty(((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill"))) {
            String isBackFillText = ((ExtensionAttribute)((List)((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill")).get(0)).getValue();
            isBackFill = HussarUtils.isEmpty((Object)isBackFillText) ? false : Boolean.valueOf(isBackFillText);
        }
        return isBackFill;
    }

    private void addTaskInfoPush(TaskInfoDto taskInfoDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((Long)taskInfoDto.getAppId(), (String)taskInfoDto.getProcessKey(), (String)taskInfoDto.getAppCode());
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Integer num = taskModelService.addTaskInfo(taskInfoDto);
                    if (num <= 0) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.workflowCommonCacheService.getServiceName(taskInfoDto.getProcessKey()));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Integer num = taskModelBackFillService.addTaskInfo(taskInfoDto, serviceName);
                if (num > 0) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = addTaskInfoUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    Integer n = Integer.valueOf(HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)taskInfoDto)));
                    if (n <= 0) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void completeTaskPush(List<CompleteTaskInfoDto> completeTaskInfoDtos) {
        String deploymentModel;
        CompleteTaskInfoDto completeTaskInfoDto = completeTaskInfoDtos.get(0);
        String processKey = null;
        Long appId = null;
        String appCode = null;
        if (HussarUtils.isNotEmpty((Object)completeTaskInfoDto)) {
            processKey = completeTaskInfoDto.getProcessKey();
            appId = completeTaskInfoDto.getAppId();
            appCode = completeTaskInfoDto.getAppCode();
        }
        if (HussarUtils.isEmpty(processKey)) {
            return;
        }
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((Long)appId, (String)processKey, (String)appCode);
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Boolean flag = taskModelService.completeTask(completeTaskInfoDtos);
                    if (!flag.booleanValue()) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.workflowCommonCacheService.getServiceName(processKey));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.completeTask(completeTaskInfoDtos, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = completeTaskUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString(completeTaskInfoDtos));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void updateTaskUserPush(List<UpdateTaskUserDto> updateTaskUserDtos) {
        Map updateTaskUserDtoMap = WorkflowBpmUtil.getListMap(updateTaskUserDtos, UpdateTaskUserDto::getProcessKey, null);
        block15: for (Map.Entry entry : updateTaskUserDtoMap.entrySet()) {
            String deploymentModel;
            List taskUserDtos = (List)entry.getValue();
            UpdateTaskUserDto updateTaskUserDto = (UpdateTaskUserDto)taskUserDtos.get(0);
            String processKey = (String)entry.getKey();
            Long appId = null;
            String appCode = null;
            if (HussarUtils.isNotEmpty((Object)updateTaskUserDto)) {
                appId = updateTaskUserDto.getAppId();
                appCode = updateTaskUserDto.getAppCode();
            }
            if (HussarUtils.isEmpty((Object)processKey)) {
                return;
            }
            switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
                case "single": {
                    TaskModelService taskModelService = null;
                    try {
                        taskModelService = TaskModelServiceBeanUtil.getVisitorBean((Long)appId, (String)processKey, (String)appCode);
                        if (HussarUtils.isEmpty((Object)taskModelService)) {
                            return;
                        }
                        Integer num = taskModelService.updateTaskUser(taskUserDtos);
                        if (num > 0) continue block15;
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    catch (BpmException e) {
                        throw e;
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                }
                case "micro": {
                    String serviceName = String.valueOf(this.workflowCommonCacheService.getServiceName(updateTaskUserDto.getProcessKey()));
                    TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                    Integer num = taskModelBackFillService.updateTaskUser(taskUserDtos, serviceName);
                    if (num > 0) continue block15;
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
                default: {
                    try {
                        String url = updateTaskUserUrl;
                        url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                        Integer n = Integer.valueOf(HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)taskUserDtos)));
                        if (n > 0) continue block15;
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    catch (BpmException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                }
            }
        }
    }

    private void deleteTaskInfoPush(List<DeletedTaskInfoDto> deletedTaskInfoDtos) {
        Map deletedTaskInfoDtoMap = WorkflowBpmUtil.getListMap(deletedTaskInfoDtos, DeletedTaskInfoDto::getProcessKey, null);
        block15: for (Map.Entry entry : deletedTaskInfoDtoMap.entrySet()) {
            String deploymentModel;
            DeletedTaskInfoDto deletedTaskInfoDto;
            String processKey = (String)entry.getKey();
            Long appId = null;
            String appCode = null;
            List taskUserDtos = (List)entry.getValue();
            if (HussarUtils.isNotEmpty((Object)taskUserDtos) && HussarUtils.isNotEmpty((Object)(deletedTaskInfoDto = deletedTaskInfoDtos.get(0)))) {
                appId = deletedTaskInfoDto.getAppId();
                appCode = deletedTaskInfoDto.getAppCode();
            }
            if (HussarUtils.isEmpty((Object)processKey)) {
                return;
            }
            switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
                case "single": {
                    TaskModelService taskModelService = null;
                    try {
                        taskModelService = TaskModelServiceBeanUtil.getVisitorBean((Long)appId, (String)processKey, (String)appCode);
                        if (HussarUtils.isEmpty((Object)taskModelService)) {
                            return;
                        }
                        Boolean flag = taskModelService.deleteTaskInfo(taskUserDtos);
                        if (flag.booleanValue()) continue block15;
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    catch (BpmException e) {
                        throw e;
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                }
                case "micro": {
                    String serviceName = String.valueOf(this.workflowCommonCacheService.getServiceName(processKey));
                    TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                    Boolean flag = taskModelBackFillService.deleteTaskInfo(taskUserDtos, serviceName);
                    if (flag.booleanValue()) continue block15;
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
                default: {
                    try {
                        String url = deleteTaskInfoUrl;
                        url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                        HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)taskUserDtos));
                        break;
                    }
                    catch (BpmException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                }
            }
        }
    }

    private void deleteProcessPush(List<DeletedProcessInfoDto> deletedProcessInfoDtos) {
        Map deletedProcessInfoDtoMap = WorkflowBpmUtil.getListMap(deletedProcessInfoDtos, DeletedProcessInfoDto::getProcessKey, null);
        block15: for (Map.Entry entry : deletedProcessInfoDtoMap.entrySet()) {
            String deploymentModel;
            DeletedProcessInfoDto deletedProcessInfoDto;
            String processKey = (String)entry.getKey();
            Long appId = null;
            String appCode = null;
            List taskUserDtos = (List)entry.getValue();
            if (HussarUtils.isNotEmpty((Object)taskUserDtos) && HussarUtils.isNotEmpty((Object)(deletedProcessInfoDto = deletedProcessInfoDtos.get(0)))) {
                appId = deletedProcessInfoDto.getAppId();
                appCode = deletedProcessInfoDto.getAppCode();
            }
            if (HussarUtils.isEmpty((Object)processKey)) {
                return;
            }
            switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
                case "single": {
                    TaskModelService taskModelService = null;
                    try {
                        taskModelService = TaskModelServiceBeanUtil.getVisitorBean((Long)appId, (String)processKey, (String)appCode);
                        if (HussarUtils.isEmpty((Object)taskModelService)) {
                            return;
                        }
                        Boolean flag = taskModelService.deleteProcess(taskUserDtos);
                        if (flag.booleanValue()) continue block15;
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    catch (BpmException e) {
                        throw e;
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                }
                case "micro": {
                    String serviceName = String.valueOf(this.workflowCommonCacheService.getServiceName(processKey));
                    TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                    Boolean flag = taskModelBackFillService.deleteProcess(taskUserDtos, serviceName);
                    if (flag.booleanValue()) continue block15;
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
                default: {
                    try {
                        String url = deleteProcessUrl;
                        url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                        HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)taskUserDtos));
                        break;
                    }
                    catch (BpmException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                }
            }
        }
    }

    private void changeProcessInfoPush(ProcessInfoDto processInfoDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((Long)processInfoDto.getAppId(), (String)processInfoDto.getProcessKey(), (String)processInfoDto.getAppCode());
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Boolean flag = taskModelService.changeProcessInfo(processInfoDto);
                    if (!flag.booleanValue()) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.workflowCommonCacheService.getServiceName(processInfoDto.getProcessKey()));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.changeProcessInfo(processInfoDto, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = changeProcessInfoUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)processInfoDto));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void changeProcessNodePush(ProcessNodeInfoDto processNodeInfoDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((Long)processNodeInfoDto.getAppId(), (String)processNodeInfoDto.getProcessKey(), (String)processNodeInfoDto.getAppCode());
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Boolean flag = taskModelService.changeProcessNode(processNodeInfoDto);
                    if (!flag.booleanValue()) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.workflowCommonCacheService.getServiceName(processNodeInfoDto.getProcessKey()));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.changeProcessNode(processNodeInfoDto, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = changeProcessNodeUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)processNodeInfoDto));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    public void processChange(ProcessDataPush processDataPush) {
        DataPush dataPush = processDataPush.getDataPush();
        List emulationBusinessKey = dataPush.getEmulationBusinessKey();
        if (emulationBusinessKey == null && this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ProcessChangeDto processChangeDto = new ProcessChangeDto();
        ProcessInfoDto processInfoDto = new ProcessInfoDto();
        processChangeDto.setProcessInfoDto(processInfoDto);
        processInfoDto.setFormId(this.getFormId(dataPush.getProcessKey()));
        processInfoDto.setBusinessId(dataPush.getBusinessKey());
        processInfoDto.setProcessKey(dataPush.getProcessKey());
        processInfoDto.setProcessState(stateType.get(dataPush.getProcessState()));
        processInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
        processInfoDto.setStartTime(dataPush.getProcessStartTime());
        processInfoDto.setFinishTime(dataPush.getProcessEndTime());
        processInfoDto.setStartUserId(dataPush.getStartUserId());
        processInfoDto.setDueDate(dataPush.getDueDate());
        processInfoDto.setProcessNodeList(dataPush.getProcessNodeList());
        List dataPushList = processDataPush.getTaskDataPush();
        ArrayList<TaskInfoDto> taskInfoDtos = new ArrayList<TaskInfoDto>();
        processChangeDto.setTaskInfoDto(taskInfoDtos);
        ArrayList<TaskInfoDto> updateTaskInfoDtos = new ArrayList<TaskInfoDto>();
        processChangeDto.setUpdateTaskInfoDto(updateTaskInfoDtos);
        ArrayList<TaskInfoDto> deleteTaskInfoDtos = new ArrayList<TaskInfoDto>();
        processChangeDto.setRemoveTaskInfoDto(deleteTaskInfoDtos);
        for (DataPush taskDataPush : dataPushList) {
            WorkflowUserDto workflowUserDto;
            ArrayList<WorkflowUserDto> workflowUserDtoList;
            String taskType;
            Object taskDefinitionKey;
            String processDefinitionId;
            String formDetailKey;
            TaskInfoDto taskInfoDto;
            if ("ccAdd".equals(taskDataPush.getType()) || "ccRead".equals(taskDataPush.getType()) || "ccDelete".equals(taskDataPush.getType())) continue;
            if ("add".equals(taskDataPush.getType()) || "addComplete".equals(taskDataPush.getType())) {
                taskInfoDto = new TaskInfoDto();
                taskInfoDtos.add(taskInfoDto);
                taskInfoDto.setFormId(this.getFormId(taskDataPush.getProcessKey()));
                taskInfoDto.setBusinessId(taskDataPush.getBusinessKey());
                taskInfoDto.setProcessKey(taskDataPush.getProcessKey());
                taskInfoDto.setProcessInstanceId(taskDataPush.getProcessInsId());
                taskInfoDto.setTaskId(taskDataPush.getTaskId());
                taskInfoDto.setTaskDefinitionKey(taskDataPush.getTaskDefinitionKey());
                taskInfoDto.setTaskDefinitionName(taskDataPush.getTaskDefinitionName());
                taskInfoDto.setStartTime(taskDataPush.getProcessStartTime());
                taskInfoDto.setCreateTime(taskDataPush.getStartDate());
                taskInfoDto.setDueTime(taskDataPush.getTaskDueTime());
                taskInfoDto.setFormKey(taskDataPush.getUrl());
                formDetailKey = taskDataPush.getFormDetailKey();
                if (HussarUtils.isEmpty((Object)formDetailKey)) {
                    processDefinitionId = taskDataPush.getProcessDefinitionId();
                    taskDefinitionKey = taskDataPush.getTaskDefinitionKey();
                    formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, (String)taskDefinitionKey);
                }
                taskInfoDto.setFormDetailKey(formDetailKey);
                if (taskDataPush.getEndDate() != null) {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), DONE);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(DONE);
                } else {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), TODO);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(TODO);
                }
                workflowUserDtoList = new ArrayList<WorkflowUserDto>();
                if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserMaps())) {
                    for (Map user : taskDataPush.getUserMaps()) {
                        WorkflowUserDto workflowUserDto2 = new WorkflowUserDto();
                        workflowUserDto2.setUserId((String)user.get("userId"));
                        if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                            workflowUserDto2.setOwnerId((String)user.get("mandator"));
                        }
                        workflowUserDtoList.add(workflowUserDto2);
                    }
                } else if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserId())) {
                    for (String string : taskDataPush.getUserId().split(",")) {
                        workflowUserDto = new WorkflowUserDto();
                        workflowUserDto.setUserId(string);
                        workflowUserDtoList.add(workflowUserDto);
                    }
                }
                taskInfoDto.setUsers(workflowUserDtoList);
                taskInfoDto.setEndTime(taskDataPush.getEndDate());
                taskInfoDto.setAssignee(taskDataPush.getUserId());
                continue;
            }
            if ("delete".equals(taskDataPush.getType())) {
                taskInfoDto = new TaskInfoDto();
                deleteTaskInfoDtos.add(taskInfoDto);
                taskInfoDto.setFormId(this.getFormId(taskDataPush.getProcessKey()));
                taskInfoDto.setBusinessId(taskDataPush.getBusinessKey());
                taskInfoDto.setProcessKey(taskDataPush.getProcessKey());
                taskInfoDto.setProcessInstanceId(taskDataPush.getProcessInsId());
                taskInfoDto.setTaskId(taskDataPush.getTaskId());
                taskInfoDto.setTaskDefinitionKey(taskDataPush.getTaskDefinitionKey());
                taskInfoDto.setTaskDefinitionName(taskDataPush.getTaskDefinitionName());
                taskInfoDto.setStartTime(taskDataPush.getProcessStartTime());
                taskInfoDto.setCreateTime(taskDataPush.getStartDate());
                taskInfoDto.setDueTime(taskDataPush.getTaskDueTime());
                taskInfoDto.setFormKey(taskDataPush.getUrl());
                formDetailKey = taskDataPush.getFormDetailKey();
                if (HussarUtils.isEmpty((Object)formDetailKey)) {
                    processDefinitionId = taskDataPush.getProcessDefinitionId();
                    taskDefinitionKey = taskDataPush.getTaskDefinitionKey();
                    formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, (String)taskDefinitionKey);
                }
                taskInfoDto.setFormDetailKey(formDetailKey);
                if (taskDataPush.getEndDate() != null) {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), DONE);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(DONE);
                } else {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), TODO);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(TODO);
                }
                workflowUserDtoList = new ArrayList();
                if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserMaps())) {
                    for (Map user : taskDataPush.getUserMaps()) {
                        WorkflowUserDto workflowUserDto3 = new WorkflowUserDto();
                        workflowUserDto3.setUserId((String)user.get("userId"));
                        if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                            workflowUserDto3.setOwnerId((String)user.get("mandator"));
                        }
                        workflowUserDtoList.add(workflowUserDto3);
                    }
                } else if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserId())) {
                    for (String string : taskDataPush.getUserId().split(",")) {
                        workflowUserDto = new WorkflowUserDto();
                        workflowUserDto.setUserId(string);
                        workflowUserDtoList.add(workflowUserDto);
                    }
                }
                taskInfoDto.setUsers(workflowUserDtoList);
                taskInfoDto.setEndTime(taskDataPush.getEndDate());
                taskInfoDto.setAssignee(taskDataPush.getUserId());
                continue;
            }
            if (!"complete".equals(taskDataPush.getType())) continue;
            taskInfoDto = new TaskInfoDto();
            updateTaskInfoDtos.add(taskInfoDto);
            taskInfoDto.setFormId(this.getFormId(taskDataPush.getProcessKey()));
            taskInfoDto.setBusinessId(taskDataPush.getBusinessKey());
            taskInfoDto.setProcessKey(taskDataPush.getProcessKey());
            taskInfoDto.setProcessInstanceId(taskDataPush.getProcessInsId());
            taskInfoDto.setTaskId(taskDataPush.getTaskId());
            taskInfoDto.setTaskDefinitionKey(taskDataPush.getTaskDefinitionKey());
            taskInfoDto.setTaskDefinitionName(taskDataPush.getTaskDefinitionName());
            taskInfoDto.setStartTime(taskDataPush.getProcessStartTime());
            taskInfoDto.setCreateTime(taskDataPush.getStartDate());
            taskInfoDto.setDueTime(taskDataPush.getTaskDueTime());
            taskInfoDto.setFormKey(taskDataPush.getUrl());
            formDetailKey = taskDataPush.getFormDetailKey();
            if (HussarUtils.isEmpty((Object)formDetailKey)) {
                processDefinitionId = taskDataPush.getProcessDefinitionId();
                taskDefinitionKey = taskDataPush.getTaskDefinitionKey();
                formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, (String)taskDefinitionKey);
            }
            taskInfoDto.setFormDetailKey(formDetailKey);
            if (taskDataPush.getEndDate() != null) {
                taskType = this.convertTaskType(taskDataPush.getTaskType(), DONE);
                taskInfoDto.setTaskType(taskType);
                taskInfoDto.setTaskState(DONE);
            } else {
                taskType = this.convertTaskType(taskDataPush.getTaskType(), TODO);
                taskInfoDto.setTaskType(taskType);
                taskInfoDto.setTaskState(TODO);
            }
            workflowUserDtoList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserMaps())) {
                for (Map user : taskDataPush.getUserMaps()) {
                    WorkflowUserDto workflowUserDto4 = new WorkflowUserDto();
                    workflowUserDto4.setUserId((String)user.get("userId"));
                    if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                        workflowUserDto4.setOwnerId((String)user.get("mandator"));
                    }
                    workflowUserDtoList.add(workflowUserDto4);
                }
            } else if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserId())) {
                for (String string : taskDataPush.getUserId().split(",")) {
                    workflowUserDto = new WorkflowUserDto();
                    workflowUserDto.setUserId(string);
                    workflowUserDtoList.add(workflowUserDto);
                }
            }
            taskInfoDto.setUsers(workflowUserDtoList);
            taskInfoDto.setEndTime(taskDataPush.getEndDate());
            taskInfoDto.setAssignee(taskDataPush.getUserId());
        }
        processChangeDto.setAppId(this.modelService.getAppId(dataPush.getProcessKey()));
        processChangeDto.setAppCode(this.modelService.getAppCode(dataPush.getProcessKey()));
        processChangeDto.setProcessKey(dataPush.getProcessKey());
        this.processChange(processChangeDto);
    }

    public void processChangeList(List<ProcessDataPush> processDataPushList) {
        DataPush dataPushGlobal = new DataPush();
        if (HussarUtils.isNotEmpty(processDataPushList)) {
            ProcessDataPush processDataPush = processDataPushList.get(0);
            dataPushGlobal = processDataPush.getDataPush();
            boolean backFill = this.isBackFill(dataPushGlobal.getProcessDefinitionId());
            if (!backFill) {
                return;
            }
        } else {
            return;
        }
        ProcessChangeListDto processChangeListDto = new ProcessChangeListDto();
        ArrayList<ProcessInfoDto> processInfoDtos = new ArrayList<ProcessInfoDto>();
        processChangeListDto.setProcessInfoDto(processInfoDtos);
        ArrayList<TaskInfoDto> taskInfoDtos = new ArrayList<TaskInfoDto>();
        processChangeListDto.setTaskInfoDto(taskInfoDtos);
        ArrayList<TaskInfoDto> updateTaskInfoDtos = new ArrayList<TaskInfoDto>();
        processChangeListDto.setUpdateTaskInfoDto(updateTaskInfoDtos);
        ArrayList<TaskInfoDto> deleteTaskInfoDtos = new ArrayList<TaskInfoDto>();
        processChangeListDto.setRemoveTaskInfoDto(deleteTaskInfoDtos);
        for (ProcessDataPush processDataPush : processDataPushList) {
            DataPush dataPush = processDataPush.getDataPush();
            ProcessInfoDto processInfoDto = new ProcessInfoDto();
            processInfoDto.setFormId(this.modelService.getProcessFormId(dataPush.getProcessKey(), null));
            processInfoDto.setBusinessId(dataPush.getBusinessKey());
            processInfoDto.setProcessKey(dataPush.getProcessKey());
            processInfoDto.setProcessState(stateType.get(dataPush.getProcessState()));
            processInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
            processInfoDto.setStartTime(dataPush.getProcessStartTime());
            processInfoDto.setFinishTime(dataPush.getProcessEndTime());
            processInfoDto.setStartUserId(dataPush.getStartUserId());
            processInfoDto.setDueDate(dataPush.getDueDate());
            processInfoDto.setProcessNodeList(dataPush.getProcessNodeList());
            processInfoDtos.add(processInfoDto);
            List dataPushList = processDataPush.getTaskDataPush();
            for (DataPush taskDataPush : dataPushList) {
                WorkflowUserDto workflowUserDto;
                ArrayList<WorkflowUserDto> workflowUserDtoList;
                String taskType;
                Object taskDefinitionKey;
                String processDefinitionId;
                String formDetailKey;
                TaskInfoDto taskInfoDto;
                if ("ccAdd".equals(taskDataPush.getType()) || "ccRead".equals(taskDataPush.getType())) continue;
                if ("add".equals(taskDataPush.getType()) || "addComplete".equals(taskDataPush.getType())) {
                    taskInfoDto = new TaskInfoDto();
                    taskInfoDtos.add(taskInfoDto);
                    taskInfoDto.setFormId(this.getFormId(taskDataPush.getProcessKey()));
                    taskInfoDto.setBusinessId(taskDataPush.getBusinessKey());
                    taskInfoDto.setProcessKey(taskDataPush.getProcessKey());
                    taskInfoDto.setProcessInstanceId(taskDataPush.getProcessInsId());
                    taskInfoDto.setTaskId(taskDataPush.getTaskId());
                    taskInfoDto.setTaskDefinitionKey(taskDataPush.getTaskDefinitionKey());
                    taskInfoDto.setTaskDefinitionName(taskDataPush.getTaskDefinitionName());
                    taskInfoDto.setStartTime(taskDataPush.getProcessStartTime());
                    taskInfoDto.setCreateTime(taskDataPush.getStartDate());
                    taskInfoDto.setDueTime(taskDataPush.getTaskDueTime());
                    taskInfoDto.setFormKey(taskDataPush.getUrl());
                    formDetailKey = taskDataPush.getFormDetailKey();
                    if (HussarUtils.isEmpty((Object)formDetailKey)) {
                        processDefinitionId = taskDataPush.getProcessDefinitionId();
                        taskDefinitionKey = taskDataPush.getTaskDefinitionKey();
                        formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, (String)taskDefinitionKey);
                    }
                    taskInfoDto.setFormDetailKey(formDetailKey);
                    if (taskDataPush.getEndDate() != null) {
                        taskType = this.convertTaskType(taskDataPush.getTaskType(), DONE);
                        taskInfoDto.setTaskType(taskType);
                        taskInfoDto.setTaskState(DONE);
                    } else {
                        taskType = this.convertTaskType(taskDataPush.getTaskType(), TODO);
                        taskInfoDto.setTaskType(taskType);
                        taskInfoDto.setTaskState(TODO);
                    }
                    workflowUserDtoList = new ArrayList<WorkflowUserDto>();
                    if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserMaps())) {
                        for (Map user : taskDataPush.getUserMaps()) {
                            WorkflowUserDto workflowUserDto2 = new WorkflowUserDto();
                            workflowUserDto2.setUserId((String)user.get("userId"));
                            if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                                workflowUserDto2.setOwnerId((String)user.get("mandator"));
                            }
                            workflowUserDtoList.add(workflowUserDto2);
                        }
                    } else if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserId())) {
                        for (String string : taskDataPush.getUserId().split(",")) {
                            workflowUserDto = new WorkflowUserDto();
                            workflowUserDto.setUserId(string);
                            workflowUserDtoList.add(workflowUserDto);
                        }
                    }
                    taskInfoDto.setUsers(workflowUserDtoList);
                    taskInfoDto.setEndTime(taskDataPush.getEndDate());
                    taskInfoDto.setAssignee(taskDataPush.getUserId());
                    continue;
                }
                if ("delete".equals(dataPush.getType())) {
                    taskInfoDto = new TaskInfoDto();
                    deleteTaskInfoDtos.add(taskInfoDto);
                    taskInfoDto.setFormId(this.getFormId(taskDataPush.getProcessKey()));
                    taskInfoDto.setBusinessId(taskDataPush.getBusinessKey());
                    taskInfoDto.setProcessKey(taskDataPush.getProcessKey());
                    taskInfoDto.setProcessInstanceId(taskDataPush.getProcessInsId());
                    taskInfoDto.setTaskId(taskDataPush.getTaskId());
                    taskInfoDto.setTaskDefinitionKey(taskDataPush.getTaskDefinitionKey());
                    taskInfoDto.setTaskDefinitionName(taskDataPush.getTaskDefinitionName());
                    taskInfoDto.setStartTime(taskDataPush.getProcessStartTime());
                    taskInfoDto.setCreateTime(taskDataPush.getStartDate());
                    taskInfoDto.setDueTime(taskDataPush.getTaskDueTime());
                    taskInfoDto.setFormKey(taskDataPush.getUrl());
                    formDetailKey = taskDataPush.getFormDetailKey();
                    if (HussarUtils.isEmpty((Object)formDetailKey)) {
                        processDefinitionId = taskDataPush.getProcessDefinitionId();
                        taskDefinitionKey = taskDataPush.getTaskDefinitionKey();
                        formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, (String)taskDefinitionKey);
                    }
                    taskInfoDto.setFormDetailKey(formDetailKey);
                    if (taskDataPush.getEndDate() != null) {
                        taskType = this.convertTaskType(taskDataPush.getTaskType(), DONE);
                        taskInfoDto.setTaskType(taskType);
                        taskInfoDto.setTaskState(DONE);
                    } else {
                        taskType = this.convertTaskType(taskDataPush.getTaskType(), TODO);
                        taskInfoDto.setTaskType(taskType);
                        taskInfoDto.setTaskState(TODO);
                    }
                    workflowUserDtoList = new ArrayList();
                    if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserMaps())) {
                        for (Map user : taskDataPush.getUserMaps()) {
                            WorkflowUserDto workflowUserDto3 = new WorkflowUserDto();
                            workflowUserDto3.setUserId((String)user.get("userId"));
                            if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                                workflowUserDto3.setOwnerId((String)user.get("mandator"));
                            }
                            workflowUserDtoList.add(workflowUserDto3);
                        }
                    } else if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserId())) {
                        for (String string : taskDataPush.getUserId().split(",")) {
                            workflowUserDto = new WorkflowUserDto();
                            workflowUserDto.setUserId(string);
                            workflowUserDtoList.add(workflowUserDto);
                        }
                    }
                    taskInfoDto.setUsers(workflowUserDtoList);
                    taskInfoDto.setEndTime(taskDataPush.getEndDate());
                    taskInfoDto.setAssignee(taskDataPush.getUserId());
                    continue;
                }
                if (!"update".equals(dataPush.getType())) continue;
                taskInfoDto = new TaskInfoDto();
                updateTaskInfoDtos.add(taskInfoDto);
                taskInfoDto.setFormId(this.getFormId(taskDataPush.getProcessKey()));
                taskInfoDto.setBusinessId(taskDataPush.getBusinessKey());
                taskInfoDto.setProcessKey(taskDataPush.getProcessKey());
                taskInfoDto.setProcessInstanceId(taskDataPush.getProcessInsId());
                taskInfoDto.setTaskId(taskDataPush.getTaskId());
                taskInfoDto.setTaskDefinitionKey(taskDataPush.getTaskDefinitionKey());
                taskInfoDto.setTaskDefinitionName(taskDataPush.getTaskDefinitionName());
                taskInfoDto.setStartTime(taskDataPush.getProcessStartTime());
                taskInfoDto.setCreateTime(taskDataPush.getStartDate());
                taskInfoDto.setDueTime(taskDataPush.getTaskDueTime());
                taskInfoDto.setFormKey(taskDataPush.getUrl());
                formDetailKey = taskDataPush.getFormDetailKey();
                if (HussarUtils.isEmpty((Object)formDetailKey)) {
                    processDefinitionId = taskDataPush.getProcessDefinitionId();
                    taskDefinitionKey = taskDataPush.getTaskDefinitionKey();
                    formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, (String)taskDefinitionKey);
                }
                taskInfoDto.setFormDetailKey(formDetailKey);
                if (taskDataPush.getEndDate() != null) {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), DONE);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(DONE);
                } else {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), TODO);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(TODO);
                }
                workflowUserDtoList = new ArrayList();
                if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserMaps())) {
                    for (Map user : taskDataPush.getUserMaps()) {
                        WorkflowUserDto workflowUserDto4 = new WorkflowUserDto();
                        workflowUserDto4.setUserId((String)user.get("userId"));
                        if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                            workflowUserDto4.setOwnerId((String)user.get("mandator"));
                        }
                        workflowUserDtoList.add(workflowUserDto4);
                    }
                } else if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserId())) {
                    for (String string : taskDataPush.getUserId().split(",")) {
                        workflowUserDto = new WorkflowUserDto();
                        workflowUserDto.setUserId(string);
                        workflowUserDtoList.add(workflowUserDto);
                    }
                }
                taskInfoDto.setUsers(workflowUserDtoList);
                taskInfoDto.setEndTime(taskDataPush.getEndDate());
                taskInfoDto.setAssignee(taskDataPush.getUserId());
            }
        }
        processChangeListDto.setAppId(this.modelService.getAppId(dataPushGlobal.getProcessKey()));
        processChangeListDto.setAppCode(this.modelService.getAppCode(dataPushGlobal.getProcessKey()));
        processChangeListDto.setProcessKey(dataPushGlobal.getProcessKey());
        processChangeListDto.setFormId(this.modelService.getProcessFormId(dataPushGlobal.getProcessKey(), null));
        this.processChangeList(processChangeListDto);
    }

    private void processChange(ProcessChangeDto processChangeDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((Long)processChangeDto.getAppId(), (String)processChangeDto.getProcessKey(), (String)processChangeDto.getAppCode());
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    boolean flag = taskModelService.processChange(processChangeDto);
                    if (!flag) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.workflowCommonCacheService.getServiceName(processChangeDto.getProcessKey()));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.processChange(processChangeDto, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = processChangeUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)processChangeDto));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void processChangeList(ProcessChangeListDto processChangeListDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((Long)processChangeListDto.getAppId(), (String)processChangeListDto.getProcessKey(), (String)processChangeListDto.getAppCode());
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    boolean flag = taskModelService.processChangeList(processChangeListDto);
                    if (!flag) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.workflowCommonCacheService.getServiceName(processChangeListDto.getProcessKey()));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.processChangeList(processChangeListDto, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = processChangeListUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)processChangeListDto));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    static {
        stateType.put("startProcess", TODO);
        stateType.put("reStartProcess", TODO);
        stateType.put("activateProcess", TODO);
        stateType.put("completeProcess", DONE);
        stateType.put("endProcess", "2");
        stateType.put("revokeProcess", "3");
        stateType.put("suspendProcess", "4");
        stateType.put("deleteProcess", "5");
    }
}

