/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.unifiedtodatapush.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveProcessDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TransferTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskStatusDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import com.jxdinfo.hussar.workflow.unifiedtodatapush.util.UnifiedRequestHttpUtil;
import com.jxdinfo.hussar.workflow.unifiedtodatapush.util.UnifiedToDoDataPushProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="hussarUnifiedToDoDataPush")
public class HussarUnifiedToDoDataPush
implements DataPushListener {
    @Lazy
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired(required=false)
    private IUnifiedToDoService unifiedToDoService;
    @Autowired
    private UnifiedRequestHttpUtil unifiedRequestHttpUtil;
    @Autowired
    private UnifiedToDoDataPushProperties unifiedToDoDataPushProperties;
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;

    private boolean needDataPush() {
        return this.unifiedToDoDataPushProperties.isUseDatapush() && "hussarUnifiedToDoDataPush".equals(this.unifiedToDoDataPushProperties.getUnifiedTodoServerName());
    }

    private boolean isWorkflowPlatformStandalone() {
        return this.unifiedToDoDataPushProperties.isWorkflowPlatformStandalone() || this.unifiedToDoDataPushProperties.isRemoteDatapush();
    }

    public void addTask(DataPush dataPush) {
        String taskSourceFlag = dataPush.getTaskSourceFlag();
        if (HussarUtils.isNotEmpty((Object)taskSourceFlag) && "revoke".equals(taskSourceFlag)) {
            return;
        }
        if (this.needDataPush()) {
            ArrayList<Object> users = new ArrayList<Object>();
            List userMaps = dataPush.getUserMaps();
            if (HussarUtils.isNotEmpty((Object)userMaps)) {
                for (Map user : userMaps) {
                    users.add(user.get("userId"));
                    if (user.get("mandator") == null) continue;
                    users.add(user.get("mandator"));
                }
            }
            users.add(dataPush.getStartUserId());
            users.add(dataPush.getSendUser());
            Map userMap = this.assigneeChooseService.getUserListByUserId(users);
            SaveToDoDto saveToDoDto = new SaveToDoDto();
            saveToDoDto.setTaskId(dataPush.getTaskId());
            saveToDoDto.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
            saveToDoDto.setGategory(null);
            saveToDoDto.setSubject(dataPush.getDescription());
            saveToDoDto.setProcessTitle(dataPush.getProcessTitle() == null ? dataPush.getDescription() : dataPush.getProcessTitle());
            saveToDoDto.setDataDetail(dataPush.getDataDetail());
            saveToDoDto.setCreateTime(dataPush.getStartDate());
            saveToDoDto.setLastTime(dataPush.getStartDate());
            saveToDoDto.setCreateUserId(dataPush.getStartUserId());
            saveToDoDto.setCreateUserName((String)userMap.get(dataPush.getStartUserId()));
            saveToDoDto.setSendUserId(dataPush.getSendUser());
            saveToDoDto.setSendUserName((String)userMap.get(dataPush.getSendUser()));
            String doneAddress = "";
            String ccDoneAddress = "";
            String doneMobileAddress = "";
            String ccDoneMobileAddress = "";
            String doneUniAddress = "";
            String ccDoneUniAddress = "";
            LambdaQueryWrapper extendPropertiesWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)extendPropertiesWrapper.eq(SysActExtendProperties::getProcDefId, (Object)dataPush.getProcessDefinitionId())).eq(SysActExtendProperties::getTaskDefKey, (Object)dataPush.getTaskDefinitionKey());
            SysActExtendProperties extendProperties = (SysActExtendProperties)this.sysActExtendPropertiesService.getOne((Wrapper)extendPropertiesWrapper);
            if (ToolUtil.isNotEmpty((Object)extendProperties)) {
                if ("2".equals(dataPush.getTaskType())) {
                    doneAddress = JSON.parseObject((String)extendProperties.getAssistFormDetailKey()).getString("web");
                    doneMobileAddress = JSON.parseObject((String)extendProperties.getAssistFormDetailKey()).getString("mobile");
                    doneUniAddress = JSON.parseObject((String)extendProperties.getAssistFormDetailKey()).getString("uni");
                } else {
                    doneAddress = JSON.parseObject((String)extendProperties.getFormDetailKey()).getString("web");
                    doneMobileAddress = JSON.parseObject((String)extendProperties.getFormDetailKey()).getString("mobile");
                    doneUniAddress = JSON.parseObject((String)extendProperties.getFormDetailKey()).getString("uni");
                }
                ccDoneAddress = JSON.parseObject((String)extendProperties.getCcFormDetailKey()).getString("web");
                ccDoneMobileAddress = JSON.parseObject((String)extendProperties.getCcFormDetailKey()).getString("mobile");
                ccDoneUniAddress = JSON.parseObject((String)extendProperties.getCcFormDetailKey()).getString("uni");
            }
            String urlParameter = new StringBuffer().append("?businessId=").append(dataPush.getBusinessKey()).append("&taskId=").append(dataPush.getTaskId()).append("&processDefinitionKey=").append(dataPush.getProcessKey()).append("&taskDefinitionKey=").append(dataPush.getTaskDefinitionKey()).toString();
            if (HussarUtils.isNotEmpty((Object)dataPush.getUrl())) {
                String webAddress = JSON.parseObject((String)dataPush.getUrl()).getString("web");
                String mobileAddress = JSON.parseObject((String)dataPush.getUrl()).getString("mobile");
                String ccWebAddress = "";
                String ccMobileAddress = "";
                String uniAddress = JSON.parseObject((String)dataPush.getUrl()).getString("uni");
                String ccUniAddress = "";
                if (dataPush.getCcUrl() != null) {
                    ccWebAddress = JSON.parseObject((String)dataPush.getCcUrl()).getString("web");
                    ccMobileAddress = JSON.parseObject((String)dataPush.getCcUrl()).getString("mobile");
                    ccUniAddress = JSON.parseObject((String)dataPush.getCcUrl()).getString("uni");
                }
                HashMap<String, String> webUrl = new HashMap<String, String>();
                HashMap<String, String> mobileUrl = new HashMap<String, String>();
                if ("2".equals(dataPush.getTaskType())) {
                    webUrl.put("todo", HussarUtils.isEmpty((Object)webAddress) ? "" : webAddress + urlParameter + "&doneListIdentification=4");
                    webUrl.put("done", HussarUtils.isEmpty((Object)doneAddress) ? "" : doneAddress + urlParameter + "&doneListIdentification=5");
                    webUrl.put("ccTodo", HussarUtils.isEmpty((Object)ccWebAddress) ? "" : ccWebAddress + urlParameter + "&doneListIdentification=6");
                    webUrl.put("ccDone", HussarUtils.isEmpty((Object)ccDoneAddress) ? "" : ccDoneAddress + urlParameter + "&doneListIdentification=7");
                    if (StringUtils.isEmpty((CharSequence)mobileAddress)) {
                        mobileUrl.put("todo", HussarUtils.isEmpty((Object)uniAddress) ? "" : uniAddress + urlParameter + "&doneListIdentification=4");
                    } else {
                        mobileUrl.put("todo", HussarUtils.isEmpty((Object)mobileAddress) ? "" : mobileAddress + urlParameter + "&doneListIdentification=4");
                    }
                    if (StringUtils.isEmpty((CharSequence)doneMobileAddress)) {
                        mobileUrl.put("done", HussarUtils.isEmpty((Object)doneUniAddress) ? "" : doneUniAddress + urlParameter + "&doneListIdentification=5");
                    } else {
                        mobileUrl.put("done", HussarUtils.isEmpty((Object)doneMobileAddress) ? "" : doneMobileAddress + urlParameter + "&doneListIdentification=5");
                    }
                    if (StringUtils.isEmpty((CharSequence)ccMobileAddress)) {
                        mobileUrl.put("ccTodo", HussarUtils.isEmpty((Object)ccUniAddress) ? "" : ccUniAddress + urlParameter + "&doneListIdentification=6");
                    } else {
                        mobileUrl.put("ccTodo", HussarUtils.isEmpty((Object)ccMobileAddress) ? "" : ccMobileAddress + urlParameter + "&doneListIdentification=6");
                    }
                    if (StringUtils.isEmpty((CharSequence)ccDoneMobileAddress)) {
                        mobileUrl.put("ccDone", HussarUtils.isEmpty((Object)ccDoneUniAddress) ? "" : ccDoneUniAddress + urlParameter + "&doneListIdentification=7");
                    } else {
                        mobileUrl.put("ccDone", HussarUtils.isEmpty((Object)ccDoneMobileAddress) ? "" : ccDoneMobileAddress + urlParameter + "&doneListIdentification=7");
                    }
                } else {
                    webUrl.put("todo", HussarUtils.isEmpty((Object)webAddress) ? "" : webAddress + urlParameter);
                    webUrl.put("done", HussarUtils.isEmpty((Object)doneAddress) ? "" : doneAddress + urlParameter + "&doneListIdentification=1");
                    webUrl.put("ccTodo", HussarUtils.isEmpty((Object)ccWebAddress) ? "" : ccWebAddress + urlParameter + "&doneListIdentification=6");
                    webUrl.put("ccDone", HussarUtils.isEmpty((Object)ccDoneAddress) ? "" : ccDoneAddress + urlParameter + "&doneListIdentification=7");
                    if (StringUtils.isEmpty((CharSequence)mobileAddress)) {
                        mobileUrl.put("todo", HussarUtils.isEmpty((Object)uniAddress) ? "" : uniAddress + urlParameter);
                    } else {
                        mobileUrl.put("todo", HussarUtils.isEmpty((Object)mobileAddress) ? "" : mobileAddress + urlParameter);
                    }
                    if (StringUtils.isEmpty((CharSequence)doneMobileAddress)) {
                        mobileUrl.put("done", HussarUtils.isEmpty((Object)doneUniAddress) ? "" : doneUniAddress + urlParameter + "&doneListIdentification=1");
                    } else {
                        mobileUrl.put("done", HussarUtils.isEmpty((Object)doneMobileAddress) ? "" : doneMobileAddress + urlParameter + "&doneListIdentification=1");
                    }
                    if (StringUtils.isEmpty((CharSequence)ccMobileAddress)) {
                        mobileUrl.put("ccTodo", HussarUtils.isEmpty((Object)ccUniAddress) ? "" : ccUniAddress + urlParameter + "&doneListIdentification=6");
                    } else {
                        mobileUrl.put("ccTodo", HussarUtils.isEmpty((Object)ccMobileAddress) ? "" : ccMobileAddress + urlParameter + "&doneListIdentification=6");
                    }
                    if (StringUtils.isEmpty((CharSequence)ccDoneMobileAddress)) {
                        mobileUrl.put("ccDone", HussarUtils.isEmpty((Object)ccDoneUniAddress) ? "" : ccDoneUniAddress + urlParameter + "&doneListIdentification=7");
                    } else {
                        mobileUrl.put("ccDone", HussarUtils.isEmpty((Object)ccDoneMobileAddress) ? "" : ccDoneMobileAddress + urlParameter + "&doneListIdentification=7");
                    }
                }
                saveToDoDto.setWebLinkurl(JSON.toJSONString(webUrl));
                saveToDoDto.setMobileLinkurl(JSON.toJSONString(mobileUrl));
            }
            saveToDoDto.setAppId(String.valueOf(dataPush.getAppId()));
            saveToDoDto.setFormId(dataPush.getFormId());
            saveToDoDto.setTaskType(dataPush.getTaskType());
            saveToDoDto.setBusinessid(dataPush.getBusinessKey());
            saveToDoDto.setProcessName(dataPush.getProcessName());
            saveToDoDto.setTaskDefinitionkey(dataPush.getTaskDefinitionKey());
            saveToDoDto.setTaskName(dataPush.getTaskDefinitionName());
            saveToDoDto.setProcessInstanceid(dataPush.getProcessInsId());
            saveToDoDto.setProcessDefinitionkey(dataPush.getProcessKey());
            saveToDoDto.setProcessVersion(Long.valueOf(dataPush.getProcessVersion()));
            saveToDoDto.setTaskStatus("0");
            if (HussarUtils.isNotEmpty((Object)dataPush.getUserMaps())) {
                ArrayList<UnifiedTaskUser> executors = new ArrayList<UnifiedTaskUser>();
                for (Map user : userMaps) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setUserId((String)user.get("userId"));
                    unifiedTaskUser.setUserName((String)userMap.get(user.get("userId")));
                    if (user.get("mandator") != null) {
                        unifiedTaskUser.setMandator((String)user.get("mandator"));
                        unifiedTaskUser.setMandatorName((String)userMap.get(user.get("mandator")));
                        unifiedTaskUser.setTaskState((String)user.get("taskState"));
                    }
                    executors.add(unifiedTaskUser);
                }
                saveToDoDto.setExecutors(executors);
            }
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/saveTask", JSON.toJSONString((Object)saveToDoDto));
                return;
            }
            this.unifiedToDoService.saveTask(saveToDoDto);
        }
    }

    public void completeTask(DataPush dataPush) {
        if (this.needDataPush()) {
            this.complete(dataPush);
        }
    }

    public void deleteTask(DataPush dataPush) {
        if (this.needDataPush()) {
            if (this.isWorkflowPlatformStandalone()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("taskIds", dataPush.getTaskId());
                map.put("systemId", this.unifiedToDoDataPushProperties.getSystemId().toString());
                map.put("processInstId", dataPush.getProcessInsId());
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/deleteTask", JSON.toJSONString(map));
                return;
            }
            this.unifiedToDoService.deleteTask(dataPush.getTaskId(), this.unifiedToDoDataPushProperties.getSystemId().toString(), dataPush.getProcessInsId());
        }
    }

    public void entrustTask(DataPush dataPush) {
        if (this.needDataPush()) {
            HashSet users = dataPush.getUserId() == null ? new HashSet() : new HashSet<String>(Arrays.asList(dataPush.getUserId().split(",")));
            List userMaps = dataPush.getUserMaps();
            if (HussarUtils.isNotEmpty((Object)userMaps)) {
                for (Map user : userMaps) {
                    users.add(user.get("userId"));
                    if (user.get("mandator") == null) continue;
                    users.add(user.get("mandator"));
                }
            }
            Map userMap = this.assigneeChooseService.getUserListByUserId(new ArrayList(users));
            ArrayList<UnifiedTaskUser> consignorList = new ArrayList<UnifiedTaskUser>();
            if (HussarUtils.isNotEmpty((Object)dataPush.getConsignorMaps())) {
                for (Map delUserMap : dataPush.getConsignorMaps()) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setUserId((String)delUserMap.get("userId"));
                    unifiedTaskUser.setMandator(delUserMap.get("mandator") == null ? "" : (String)delUserMap.get("mandator"));
                    unifiedTaskUser.setTaskId(dataPush.getTaskId());
                    unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    unifiedTaskUser.setUserType("1");
                    unifiedTaskUser.setExecuteStatus("0");
                    consignorList.add(unifiedTaskUser);
                }
            } else if (HussarUtils.isNotEmpty((Object)dataPush.getConsignor())) {
                for (String userId : dataPush.getConsignor().split(",")) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setUserId(userId);
                    unifiedTaskUser.setTaskId(dataPush.getTaskId());
                    unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    unifiedTaskUser.setUserType("1");
                    unifiedTaskUser.setExecuteStatus("0");
                    consignorList.add(unifiedTaskUser);
                }
            }
            if (HussarUtils.isNotEmpty(consignorList)) {
                if (this.isWorkflowPlatformStandalone()) {
                    this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/deleteTaskUser", JSON.toJSONString(consignorList));
                }
                this.unifiedToDoService.deleteTaskUser(consignorList);
            }
            ArrayList<UnifiedTaskUser> userList = new ArrayList<UnifiedTaskUser>();
            if (HussarUtils.isNotEmpty((Object)dataPush.getUserMaps())) {
                for (Map addUserMap : dataPush.getUserMaps()) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setUserId((String)addUserMap.get("userId"));
                    unifiedTaskUser.setUserName((String)userMap.get(addUserMap.get("userId")));
                    if (addUserMap.get("mandator") != null) {
                        unifiedTaskUser.setMandator((String)addUserMap.get("mandator"));
                        unifiedTaskUser.setMandatorName((String)userMap.get(addUserMap.get("mandator")));
                        unifiedTaskUser.setTaskState((String)addUserMap.get("taskState"));
                    }
                    unifiedTaskUser.setTaskId(dataPush.getTaskId());
                    unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    unifiedTaskUser.setUserType("1");
                    unifiedTaskUser.setExecuteStatus("0");
                    userList.add(unifiedTaskUser);
                }
            } else if (HussarUtils.isNotEmpty((Object)dataPush.getUserId())) {
                for (String userId : dataPush.getUserId().split(",")) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setUserId(userId);
                    unifiedTaskUser.setUserName((String)userMap.get(userId));
                    unifiedTaskUser.setTaskId(dataPush.getTaskId());
                    unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    unifiedTaskUser.setUserType("1");
                    unifiedTaskUser.setExecuteStatus("0");
                    if (dataPush.getOwner() != null) {
                        if (!dataPush.getOwner().equals(userId)) {
                            unifiedTaskUser.setMandator(dataPush.getOwner());
                        } else {
                            unifiedTaskUser.setMandator(null);
                        }
                    } else if (HussarUtils.isNotEmpty((Object)dataPush.getConsignor()) && dataPush.getConsignor().split(",").length == 1) {
                        unifiedTaskUser.setMandator(dataPush.getConsignor());
                    }
                    userList.add(unifiedTaskUser);
                }
            }
            if (HussarUtils.isNotEmpty(userList)) {
                if (this.isWorkflowPlatformStandalone()) {
                    this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/addTaskUser", JSON.toJSONString(userList));
                    return;
                }
                this.unifiedToDoService.addTaskUser(userList);
            }
        }
    }

    public void transferUserTask(DataPush dataPush) {
        if (this.needDataPush()) {
            TransferTaskDto transferTaskDto = new TransferTaskDto();
            ArrayList<String> users = new ArrayList<String>();
            users.add(dataPush.getUserId());
            users.add(dataPush.getConsignor());
            Map userMap = this.assigneeChooseService.getUserListByUserId(new ArrayList(users));
            transferTaskDto.setUserId(dataPush.getUserId());
            transferTaskDto.setConsignor(dataPush.getConsignor());
            transferTaskDto.setTaskId(dataPush.getTaskId());
            transferTaskDto.setMap(userMap);
            transferTaskDto.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/transferUserTask", JSON.toJSONString((Object)transferTaskDto));
                return;
            }
            this.unifiedToDoService.transferUserTask(transferTaskDto);
        }
    }

    public void rejectTask(DataPush dataPush) {
        if (this.needDataPush()) {
            this.complete(dataPush);
        }
    }

    public void freeJumpTask(DataPush dataPush) {
        if (this.needDataPush()) {
            this.complete(dataPush);
        }
    }

    public void addUser(DataPush dataPush) {
        if (this.needDataPush()) {
            ArrayList users = dataPush.getUserId() == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(dataPush.getUserId().split(",")));
            Map userMap = this.assigneeChooseService.getUserListByUserId(users);
            ArrayList<UnifiedTaskUser> userList = new ArrayList<UnifiedTaskUser>();
            for (String userId : dataPush.getUserId().split(",")) {
                UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                unifiedTaskUser.setUserId(userId);
                unifiedTaskUser.setUserName((String)userMap.get(userId));
                unifiedTaskUser.setTaskId(dataPush.getTaskId());
                unifiedTaskUser.setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId().toString()));
                unifiedTaskUser.setUserType("1");
                unifiedTaskUser.setExecuteStatus("0");
                userList.add(unifiedTaskUser);
            }
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/addTaskUser", JSON.toJSONString(userList));
                return;
            }
            this.unifiedToDoService.addTaskUser(userList);
        }
    }

    public void deleteMultiTask(DataPush dataPush) {
        if (this.needDataPush()) {
            if (this.isWorkflowPlatformStandalone()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("taskIds", String.join((CharSequence)",", dataPush.getTaskIds()));
                map.put("systemId", this.unifiedToDoDataPushProperties.getSystemId().toString());
                map.put("processInstId", dataPush.getProcessInsId());
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/deleteTask", JSON.toJSONString(map));
                return;
            }
            this.unifiedToDoService.deleteTask(String.join((CharSequence)",", dataPush.getTaskIds()), this.unifiedToDoDataPushProperties.getSystemId().toString(), null);
        }
    }

    public void addCcTask(DataPush dataPush) {
        if (this.needDataPush()) {
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(dataPush.getUserId().split(",")));
            Map userMap = this.assigneeChooseService.getUserListByUserId(users);
            ArrayList<UnifiedTaskUser> userList = new ArrayList<UnifiedTaskUser>();
            for (String userId : dataPush.getUserId().split(",")) {
                UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                unifiedTaskUser.setUserId(userId);
                unifiedTaskUser.setUserName((String)userMap.get(userId));
                unifiedTaskUser.setTaskId(dataPush.getTaskId());
                unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                unifiedTaskUser.setUserType("0");
                unifiedTaskUser.setExecuteStatus("0");
                unifiedTaskUser.setCcMoment(dataPush.getCcMoment());
                unifiedTaskUser.setReceiveTime(dataPush.getStartDate());
                userList.add(unifiedTaskUser);
            }
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/addTaskUser", JSON.toJSONString(userList));
                return;
            }
            this.unifiedToDoService.addTaskUser(userList);
        }
    }

    public void addCcTask(List<DataPush> dataPushList) {
        if (this.needDataPush()) {
            List users = dataPushList.stream().map(DataPush::getUserId).collect(Collectors.toList());
            Map userMap = this.assigneeChooseService.getUserListByUserId(users);
            ArrayList<UnifiedTaskUser> userList = new ArrayList<UnifiedTaskUser>();
            for (DataPush dataPush : dataPushList) {
                UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                unifiedTaskUser.setUserId(dataPush.getUserId());
                unifiedTaskUser.setUserName((String)userMap.get(dataPush.getUserId()));
                unifiedTaskUser.setTaskId(dataPush.getTaskId());
                unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                unifiedTaskUser.setUserType("0");
                unifiedTaskUser.setExecuteStatus(dataPush.getEndDate() == null ? "0" : "1");
                unifiedTaskUser.setCompleteTime(dataPush.getEndDate());
                unifiedTaskUser.setCcMoment(dataPush.getCcMoment());
                unifiedTaskUser.setReceiveTime(dataPush.getStartDate());
                userList.add(unifiedTaskUser);
            }
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/addTaskUser", JSON.toJSONString(userList));
                return;
            }
            this.unifiedToDoService.addTaskUser(userList);
        }
    }

    public void readCcTask(DataPush dataPush) {
        if (this.needDataPush()) {
            String userId = dataPush.getUserId();
            UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
            unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
            unifiedTaskUser.setTaskId(dataPush.getTaskId());
            unifiedTaskUser.setUserId(userId);
            unifiedTaskUser.setUserType("0");
            unifiedTaskUser.setCompleteTime(dataPush.getEndDate());
            unifiedTaskUser.setExecuteStatus("1");
            unifiedTaskUser.setCcMoment(dataPush.getCcMoment());
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/updateUserStatus", JSON.toJSONString((Object)unifiedTaskUser));
                return;
            }
            this.unifiedToDoService.updateUserStatus(unifiedTaskUser);
        }
    }

    public void deleteCcTask(DataPush dataPush) {
        if (this.needDataPush()) {
            String userId = dataPush.getUserId();
            ArrayList<UnifiedTaskUser> unifiedTaskUsers = new ArrayList<UnifiedTaskUser>();
            for (String taskId : dataPush.getTaskIds()) {
                UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                unifiedTaskUser.setTaskId(taskId);
                unifiedTaskUser.setUserId(userId);
                unifiedTaskUser.setUserType("0");
                unifiedTaskUser.setCcMoment(dataPush.getCcMoment());
                unifiedTaskUsers.add(unifiedTaskUser);
            }
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/deleteTaskUser", JSON.toJSONString(unifiedTaskUsers));
                return;
            }
            this.unifiedToDoService.deleteTaskUser(unifiedTaskUsers);
        }
    }

    public void addUrgeTask(DataPush dataPush) {
        if (this.needDataPush()) {
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(dataPush.getUrgeUserId().split(",")));
            Map userMap = this.assigneeChooseService.getUserListByUserId(users);
            SaveToDoDto saveToDoDto = new SaveToDoDto();
            saveToDoDto.setTaskId(dataPush.getTaskId());
            saveToDoDto.setBusinessid(dataPush.getBusinessKey());
            saveToDoDto.setProcessInstanceid(dataPush.getProcessInsId());
            saveToDoDto.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
            saveToDoDto.setUrgeUserId(dataPush.getUrgeUserId());
            saveToDoDto.setUrgeUserName((String)userMap.get(dataPush.getUrgeUserId()));
            saveToDoDto.setUrgeTime(dataPush.getUrgeTime());
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/addUrgeTask", JSON.toJSONString((Object)saveToDoDto));
                return;
            }
            this.unifiedToDoService.addUrgeTask(saveToDoDto);
        }
    }

    private void complete(DataPush dataPush) {
        if (HussarUtils.isNotEmpty((Object)dataPush.getUserId())) {
            String[] userIds = dataPush.getUserId().split(",");
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(userIds));
            if (dataPush.getConsignor() != null) {
                users.add(dataPush.getConsignor());
            }
            Map userMap = this.assigneeChooseService.getUserListByUserId(users);
            ArrayList<UnifiedTaskUser> executors = new ArrayList<UnifiedTaskUser>();
            for (String userId : userIds) {
                UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                unifiedTaskUser.setUserId(userId);
                unifiedTaskUser.setUserName((String)userMap.get(userId));
                unifiedTaskUser.setMandator(dataPush.getConsignor());
                unifiedTaskUser.setMandatorName((String)userMap.get(dataPush.getConsignor()));
                unifiedTaskUser.setTaskState(dataPush.getTaskState());
                unifiedTaskUser.setCompleteTime(dataPush.getEndDate());
                unifiedTaskUser.setExecuteStatus("1");
                executors.add(unifiedTaskUser);
            }
            ArrayList<String> taskIdList = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
                taskIdList.addAll(dataPush.getTaskIds());
            }
            taskIdList.addAll(Arrays.asList(dataPush.getTaskId().split(",")));
            for (String taskId : taskIdList) {
                if (this.isWorkflowPlatformStandalone()) {
                    SaveToDoDto saveToDoDto = new SaveToDoDto();
                    saveToDoDto.setTaskId(taskId);
                    saveToDoDto.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    saveToDoDto.setExecutors(executors);
                    saveToDoDto.setTaskStatus("1");
                    this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/updateTaskUser", JSON.toJSONString((Object)saveToDoDto));
                    continue;
                }
                this.unifiedToDoService.updateTaskUser(taskId, this.unifiedToDoDataPushProperties.getSystemId().toString(), "1", executors, null);
            }
        }
        for (String taskId : dataPush.getTaskId().split(",")) {
            Date endDate = dataPush.getEndDate();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String lastTime = null;
            if (HussarUtils.isNotEmpty((Object)endDate)) {
                lastTime = formatter.format(endDate);
            } else if (HussarUtils.isNotEmpty((Object)dataPush.getStartDate())) {
                lastTime = formatter.format(dataPush.getStartDate());
            }
            if (this.isWorkflowPlatformStandalone()) {
                UpdateTaskStatusDto updateTaskStatusDto = new UpdateTaskStatusDto();
                updateTaskStatusDto.setTaskId(taskId);
                updateTaskStatusDto.setSystemId(this.unifiedToDoDataPushProperties.getSystemId().toString());
                updateTaskStatusDto.setProcessInstId(dataPush.getProcessInsId());
                updateTaskStatusDto.setLastTime(lastTime);
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/updateTaskStatusWithOutFollowers", JSON.toJSONString((Object)updateTaskStatusDto));
                continue;
            }
            this.unifiedToDoService.updateTaskStatusWithOutFollowers(taskId, this.unifiedToDoDataPushProperties.getSystemId().toString(), dataPush.getProcessInsId(), "1", null, null, lastTime, dataPush.getFormId());
        }
    }

    public void endProcess(DataPush dataPush) {
        if (this.needDataPush()) {
            Date endDate = dataPush.getEndDate();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String lastTime = null;
            if (HussarUtils.isNotEmpty((Object)endDate)) {
                lastTime = formatter.format(endDate);
            } else if (HussarUtils.isNotEmpty((Object)dataPush.getStartDate())) {
                lastTime = formatter.format(dataPush.getStartDate());
            }
            if (this.isWorkflowPlatformStandalone()) {
                UpdateTaskStatusDto updateTaskStatusDto = new UpdateTaskStatusDto();
                updateTaskStatusDto.setSystemId(this.unifiedToDoDataPushProperties.getSystemId().toString());
                updateTaskStatusDto.setProcessInstId(dataPush.getProcessInsId());
                updateTaskStatusDto.setLastTime(lastTime);
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/updateTaskStatusWithOutFollowers", JSON.toJSONString((Object)updateTaskStatusDto));
            }
            this.unifiedToDoService.updateTaskStatusWithOutFollowers(null, this.unifiedToDoDataPushProperties.getSystemId().toString(), dataPush.getProcessInsId(), "1", null, null, lastTime, dataPush.getFormId());
            List taskIds = dataPush.getTaskIds();
            ArrayList<UnifiedTaskUser> executors = new ArrayList<UnifiedTaskUser>();
            if (HussarUtils.isNotEmpty((Object)dataPush.getUserId())) {
                String[] userIds = dataPush.getUserId().split(",");
                ArrayList<String> users = new ArrayList<String>(Arrays.asList(userIds));
                Map userMap = this.assigneeChooseService.getUserListByUserId(users);
                for (String userId : userIds) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setUserId(userId);
                    unifiedTaskUser.setUserName((String)userMap.get(userId));
                    unifiedTaskUser.setCompleteTime(dataPush.getEndDate());
                    unifiedTaskUser.setExecuteStatus("1");
                    executors.add(unifiedTaskUser);
                }
            }
            for (String taskId : taskIds) {
                if (this.isWorkflowPlatformStandalone()) {
                    SaveToDoDto saveToDoDto = new SaveToDoDto();
                    saveToDoDto.setTaskId(taskId);
                    saveToDoDto.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    saveToDoDto.setExecutors(executors);
                    saveToDoDto.setTaskStatus("1");
                    this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/updateTaskUser", JSON.toJSONString((Object)saveToDoDto));
                    continue;
                }
                this.unifiedToDoService.updateTaskUser(taskId, this.unifiedToDoDataPushProperties.getSystemId().toString(), "1", executors, null);
            }
        }
    }

    public void transferTask(DataPush dataPush) {
        if (this.needDataPush()) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(dataPush.getUserId());
            users.add(dataPush.getConsignor());
            Map userMap = this.assigneeChooseService.getUserListByUserId(users);
            if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
                ArrayList<UnifiedTaskUser> userList = new ArrayList<UnifiedTaskUser>();
                for (String taskId : dataPush.getTaskIds()) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setUserId(dataPush.getUserId());
                    unifiedTaskUser.setUserName((String)userMap.get(dataPush.getUserId()));
                    unifiedTaskUser.setTaskId(taskId);
                    unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    unifiedTaskUser.setUserType("1");
                    unifiedTaskUser.setExecuteStatus("0");
                    unifiedTaskUser.setTaskState(dataPush.getTaskState());
                    userList.add(unifiedTaskUser);
                }
                if (this.isWorkflowPlatformStandalone()) {
                    this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/addTaskUser", JSON.toJSONString(userList));
                } else {
                    this.unifiedToDoService.addTaskUser(userList);
                }
                ArrayList<UnifiedTaskUser> consignorList = new ArrayList<UnifiedTaskUser>();
                for (String taskId : dataPush.getTaskIds()) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setUserId(dataPush.getConsignor());
                    unifiedTaskUser.setTaskId(taskId);
                    unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    unifiedTaskUser.setUserType("1");
                    unifiedTaskUser.setExecuteStatus("0");
                    consignorList.add(unifiedTaskUser);
                }
                if (this.isWorkflowPlatformStandalone()) {
                    this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/deleteTaskUser", JSON.toJSONString(consignorList));
                    return;
                }
                this.unifiedToDoService.deleteTaskUser(consignorList);
            }
        }
    }

    public void reTransferTask(DataPush dataPush) {
        if (this.needDataPush()) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(dataPush.getUserId());
            Map userMap = this.assigneeChooseService.getUserListByUserId(users);
            if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
                ArrayList<UnifiedTaskUser> userList = new ArrayList<UnifiedTaskUser>();
                for (String taskId : dataPush.getTaskIds()) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setUserId(dataPush.getUserId());
                    unifiedTaskUser.setUserName((String)userMap.get(dataPush.getUserId()));
                    unifiedTaskUser.setTaskId(taskId);
                    unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    unifiedTaskUser.setUserType("1");
                    unifiedTaskUser.setExecuteStatus("0");
                    userList.add(unifiedTaskUser);
                }
                if (this.isWorkflowPlatformStandalone()) {
                    this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/addTaskUser", JSON.toJSONString(userList));
                } else {
                    this.unifiedToDoService.addTaskUser(userList);
                }
                ArrayList<UnifiedTaskUser> consignorList = new ArrayList<UnifiedTaskUser>();
                for (String taskId : dataPush.getTaskIds()) {
                    UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                    unifiedTaskUser.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
                    unifiedTaskUser.setTaskId(taskId);
                    unifiedTaskUser.setUserType("1");
                    unifiedTaskUser.setTaskState(dataPush.getTaskState());
                    consignorList.add(unifiedTaskUser);
                }
                if (this.isWorkflowPlatformStandalone()) {
                    this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/transferTaskDeleteTaskUser", JSON.toJSONString(consignorList));
                    return;
                }
                this.unifiedToDoService.transferTaskDeleteTaskUser(consignorList);
            }
        }
    }

    public void addStartProcess(DataPush dataPush) {
        if (this.needDataPush()) {
            SaveProcessDto saveProcessDto = new SaveProcessDto();
            saveProcessDto.setBusinessId(dataPush.getBusinessKey());
            saveProcessDto.setProcDefkey(dataPush.getProcessKey());
            saveProcessDto.setProcName(dataPush.getProcessName());
            saveProcessDto.setProcInstId(dataPush.getProcessInsId());
            saveProcessDto.setCreateUserId(dataPush.getStartUserId());
            saveProcessDto.setCreateTime(dataPush.getProcessStartTime());
            saveProcessDto.setProcessTitle(dataPush.getProcessTitle() == null ? dataPush.getDescription() : dataPush.getProcessTitle());
            saveProcessDto.setDataDetail(dataPush.getDataDetail());
            saveProcessDto.setProcessState("0");
            saveProcessDto.setSystemId(this.unifiedToDoDataPushProperties.getSystemId());
            String doneAddress = "";
            String doneMobileAddress = "";
            String doneUniAddress = "";
            String formId = "";
            LambdaQueryWrapper extendPropertiesWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)extendPropertiesWrapper.eq(SysActExtendProperties::getProcDefId, (Object)dataPush.getProcessDefinitionId())).eq(SysActExtendProperties::getTaskDefKey, (Object)dataPush.getTaskDefinitionKey());
            SysActExtendProperties extendProperties = (SysActExtendProperties)this.sysActExtendPropertiesService.getOne((Wrapper)extendPropertiesWrapper);
            if (ToolUtil.isNotEmpty((Object)extendProperties)) {
                doneAddress = JSON.parseObject((String)extendProperties.getFormDetailKey()).getString("web");
                doneMobileAddress = JSON.parseObject((String)extendProperties.getFormDetailKey()).getString("mobile");
                doneUniAddress = JSON.parseObject((String)extendProperties.getFormDetailKey()).getString("uni");
                formId = extendProperties.getFormId();
            }
            String urlParameter = new StringBuffer().append("?businessId=").append(dataPush.getBusinessKey()).append("&processDefinitionKey=").append(dataPush.getProcessKey()).append("&taskDefinitionKey=").append(dataPush.getTaskDefinitionKey()).toString();
            if (HussarUtils.isNotEmpty((Object)dataPush.getUrl())) {
                String webAddress = JSON.parseObject((String)dataPush.getUrl()).getString("web");
                String mobileAddress = JSON.parseObject((String)dataPush.getUrl()).getString("mobile");
                String uniAddress = JSON.parseObject((String)dataPush.getUrl()).getString("uni");
                HashMap<String, String> webUrl = new HashMap<String, String>();
                HashMap<String, String> mobileUrl = new HashMap<String, String>();
                webUrl.put("todo", HussarUtils.isEmpty((Object)webAddress) ? "" : webAddress + urlParameter);
                webUrl.put("done", HussarUtils.isEmpty((Object)doneAddress) ? "" : doneAddress + urlParameter + "&doneListIdentification=1");
                if (HussarUtils.isNotEmpty((Object)uniAddress)) {
                    mobileUrl.put("todo", HussarUtils.isEmpty((Object)uniAddress) ? "" : uniAddress + urlParameter);
                } else {
                    mobileUrl.put("todo", HussarUtils.isEmpty((Object)mobileAddress) ? "" : mobileAddress + urlParameter);
                }
                if (HussarUtils.isNotEmpty((Object)doneUniAddress)) {
                    mobileUrl.put("done", HussarUtils.isEmpty((Object)doneUniAddress) ? "" : doneUniAddress + urlParameter + "&doneListIdentification=1");
                } else {
                    mobileUrl.put("done", HussarUtils.isEmpty((Object)doneMobileAddress) ? "" : doneMobileAddress + urlParameter + "&doneListIdentification=1");
                }
                saveProcessDto.setWebLinkUrl(JSON.toJSONString(webUrl));
                saveProcessDto.setMobileLinkUrl(JSON.toJSONString(mobileUrl));
            }
            saveProcessDto.setAppId(String.valueOf(dataPush.getAppId()));
            saveProcessDto.setFormId(formId);
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/addStartProcess", JSON.toJSONString((Object)saveProcessDto));
                return;
            }
            this.unifiedToDoService.addStartProcess(saveProcessDto);
        }
    }

    public void updateStartProcess(DataPush dataPush) {
        if (this.needDataPush()) {
            SaveProcessDto saveProcessDto = new SaveProcessDto();
            saveProcessDto.setBusinessId(dataPush.getBusinessKey());
            saveProcessDto.setProcInstId(dataPush.getProcessInsId());
            if (HussarUtils.isNotEmpty((Object)dataPush.getProcessEndTime())) {
                saveProcessDto.setEndTime(dataPush.getProcessEndTime());
                saveProcessDto.setProcessState("1");
            } else {
                saveProcessDto.setEndTime(null);
                saveProcessDto.setProcessState("0");
            }
            if (HussarUtils.isNotEmpty((Object)dataPush.getProcessTitle())) {
                saveProcessDto.setProcessTitle(dataPush.getProcessTitle());
            }
            if (HussarUtils.isNotEmpty((Object)dataPush.getDataDetail())) {
                saveProcessDto.setDataDetail(dataPush.getDataDetail());
            }
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/updateStartProcess", JSON.toJSONString((Object)saveProcessDto));
                return;
            }
            this.unifiedToDoService.updateStartProcess(saveProcessDto);
        }
    }

    public void deleteStartProcess(DataPush dataPush) {
        if (this.needDataPush()) {
            SaveProcessDto saveProcessDto = new SaveProcessDto();
            saveProcessDto.setBusinessId(dataPush.getBusinessKey());
            saveProcessDto.setProcInstId(dataPush.getProcessInsId());
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/deleteStartProcess", JSON.toJSONString((Object)saveProcessDto));
                return;
            }
            this.unifiedToDoService.deleteStartProcess(saveProcessDto);
        }
    }

    public void updateBusinessInfo(DataPush dataPush) {
        if (this.needDataPush()) {
            SaveToDoDto saveToDoDto = new SaveToDoDto();
            saveToDoDto.setBusinessid(dataPush.getBusinessKey());
            saveToDoDto.setProcessInstanceid(dataPush.getProcessInsId());
            saveToDoDto.setProcessTitle(dataPush.getProcessTitle());
            saveToDoDto.setDataDetail(dataPush.getDataDetail());
            if (this.isWorkflowPlatformStandalone()) {
                this.unifiedRequestHttpUtil.sendPost("/unified/unifiedtodo/updateBusinessInfo", JSON.toJSONString((Object)saveToDoDto));
                return;
            }
            this.unifiedToDoService.updateBusinessInfo(saveToDoDto);
        }
    }
}

