/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskmodel.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuIdentitylinkService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.ProcessDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.taskmodel.service.TaskModelBackFillService;
import com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessChangeDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto;
import com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto;
import com.jxdinfo.hussar.workflow.task.model.service.TaskModelService;
import com.jxdinfo.hussar.workflow.task.model.util.TaskModelServiceBeanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class TaskModelDataPush
implements DataPushListener {
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;
    @Lazy
    @Autowired
    private RepositoryService repositoryService;
    @Lazy
    @Autowired
    private HistoryService historyService;
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);
    @Autowired
    private IBpmActRuIdentitylinkService bpmActRuIdentitylinkService;
    private static Logger logger = LogManager.getLogger(TaskModelDataPush.class);
    private static final String MICRO = "micro";
    private static final String WORKFLOW_PLATFORM = "workflow-platform";
    private static final String SINGLE = "single";
    @Lazy
    @Autowired
    private ModelService modelService;
    private static final String TODO = "0";
    private static final String DONE = "1";
    private static final String addTaskInfoUrl = "/hussarBpm/bpm/taskModel/addTaskInfo";
    private static final String completeTaskUrl = "/hussarBpm/bpm/taskModel/completeTask";
    private static final String updateTaskUserUrl = "/hussarBpm/bpm/taskModel/updateTaskUser";
    private static final String deleteTaskInfoUrl = "/hussarBpm/bpm/taskModel/deleteTaskInfo";
    private static final String deleteProcessUrl = "/hussarBpm/bpm/taskModel/deleteProcess";
    private static final String changeProcessInfoUrl = "/hussarBpm/bpm/taskModel/changeProcessInfo";
    private static final String changeProcessNodeUrl = "/hussarBpm/bpm/taskModel/changeProcessNode";
    private static Map<String, String> stateType = new HashMap<String, String>();

    private boolean isEmulationProcess(DataPush dataPush) {
        String procInstId = dataPush.getProcessInsId();
        if (HussarUtils.isNotEmpty((Object)procInstId)) {
            if (!procInstId.contains(",")) {
                Object historicProcessInstance = Context.getCommandContext() != null ? Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(dataPush.getProcessInsId()) : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(dataPush.getProcessInsId()).singleResult();
                return DONE.equals(historicProcessInstance.getIsEmulation());
            }
            HashSet<String> procInstIds = new HashSet<String>(Arrays.asList(procInstId.split(",")));
            List list = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(procInstIds).list();
            List dataPushList = list.stream().filter(e -> !DONE.equals(e.getIsEmulation())).collect(Collectors.toList());
            if (dataPushList.isEmpty()) {
                return true;
            }
            dataPush.setProcessInsId(StringUtils.join((Object[])new Object[]{dataPushList.stream().map(HistoricProcessInstance::getId), ","}));
            Map businessMap = dataPush.getBusinessMap();
            if (HussarUtils.isNotEmpty((Object)businessMap)) {
                List removeBusinessIds = list.stream().filter(e -> DONE.equals(e.getIsEmulation())).map(HistoricProcessInstance::getBusinessKey).collect(Collectors.toList());
                HashMap newBusinessMap = new HashMap();
                for (Map.Entry entry : businessMap.entrySet()) {
                    ArrayList<String> newBusinessIds = new ArrayList<String>(Arrays.asList(((String)entry.getValue()).split(",")));
                    newBusinessIds.removeAll(removeBusinessIds);
                    if (newBusinessIds.isEmpty()) continue;
                    newBusinessMap.put(entry.getKey(), StringUtils.join(newBusinessIds, (String)","));
                }
                dataPush.setBusinessMap(newBusinessMap);
            }
        } else if (dataPush.getTaskIds() != null) {
            Map map = dataPush.getProcTaskMap();
            List list = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(map.keySet()).list();
            List dataPushList = list.stream().filter(e -> !DONE.equals(e.getIsEmulation())).collect(Collectors.toList());
            if (dataPushList.isEmpty()) {
                return true;
            }
            List removeProcInstIds = list.stream().filter(e -> DONE.equals(e.getIsEmulation())).map(HistoricProcessInstance::getId).collect(Collectors.toList());
            for (String procIds : map.keySet()) {
                if (!removeProcInstIds.contains(procIds)) continue;
                dataPush.getTaskIds().removeAll((Collection)map.get(procIds));
            }
        }
        return false;
    }

    public void addTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        TaskInfoDto taskInfoDto = new TaskInfoDto();
        taskInfoDto.setBusinessId(dataPush.getBusinessKey());
        taskInfoDto.setProcessKey(dataPush.getProcessKey());
        taskInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
        taskInfoDto.setTaskId(dataPush.getTaskId());
        taskInfoDto.setTaskDefinitionKey(dataPush.getTaskDefinitionKey());
        taskInfoDto.setTaskDefinitionName(dataPush.getTaskDefinitionName());
        taskInfoDto.setStartTime(dataPush.getProcessStartTime());
        taskInfoDto.setCreateTime(dataPush.getStartDate());
        taskInfoDto.setDueTime(dataPush.getTaskDueTime());
        taskInfoDto.setFormKey(dataPush.getUrl());
        String formDetailKey = dataPush.getFormDetailKey();
        if (HussarUtils.isEmpty((Object)formDetailKey)) {
            String processDefinitionId = dataPush.getProcessDefinitionId();
            String taskDefinitionKey = dataPush.getTaskDefinitionKey();
            formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, taskDefinitionKey);
        }
        taskInfoDto.setFormDetailKey(formDetailKey);
        String taskType = this.convertTaskType(dataPush.getTaskType(), TODO);
        taskInfoDto.setTaskType(taskType);
        taskInfoDto.setTaskState(TODO);
        ArrayList<WorkflowUserDto> workflowUserDtoList = new ArrayList<WorkflowUserDto>();
        if (HussarUtils.isNotEmpty((Object)dataPush.getUserMaps())) {
            for (Map user : dataPush.getUserMaps()) {
                WorkflowUserDto workflowUserDto = new WorkflowUserDto();
                workflowUserDto.setUserId((String)user.get("userId"));
                if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                    workflowUserDto.setOwnerId((String)user.get("mandator"));
                }
                workflowUserDtoList.add(workflowUserDto);
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getUserId())) {
            for (String userId : dataPush.getUserId().split(",")) {
                WorkflowUserDto workflowUserDto = new WorkflowUserDto();
                workflowUserDto.setUserId(userId);
                workflowUserDtoList.add(workflowUserDto);
            }
        }
        taskInfoDto.setUsers(workflowUserDtoList);
        this.addTaskInfoPush(taskInfoDto);
    }

    public void completeTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ArrayList<CompleteTaskInfoDto> completeTaskInfoDtos = new ArrayList<CompleteTaskInfoDto>();
        CompleteTaskInfoDto completeTaskInfoDto = new CompleteTaskInfoDto();
        completeTaskInfoDto.setBusinessId(dataPush.getBusinessKey());
        completeTaskInfoDto.setProcessKey(dataPush.getProcessKey());
        completeTaskInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
        completeTaskInfoDto.setTaskId(dataPush.getTaskId());
        completeTaskInfoDto.setEndTime(dataPush.getEndDate());
        completeTaskInfoDto.setAssignee(dataPush.getUserId());
        if (HussarUtils.isNotEmpty((Object)dataPush.getConsignor())) {
            completeTaskInfoDto.setOwner(dataPush.getConsignor());
        }
        String taskType = this.convertTaskType(dataPush.getTaskType(), DONE);
        completeTaskInfoDto.setTaskType(taskType);
        completeTaskInfoDto.setTaskState(DONE);
        completeTaskInfoDtos.add(completeTaskInfoDto);
        this.completeTaskPush(completeTaskInfoDtos);
    }

    public void deleteTask(DataPush dataPush) {
        List emulationBusinessKey = dataPush.getEmulationBusinessKey();
        ArrayList<DeletedTaskInfoDto> deletedTaskInfoDtos = new ArrayList<DeletedTaskInfoDto>();
        Map businessMap = dataPush.getBusinessMap();
        for (Map.Entry entry : businessMap.entrySet()) {
            DeletedTaskInfoDto deletedTaskInfoDto = new DeletedTaskInfoDto();
            String processDefinitionId = (String)entry.getKey();
            boolean backFill = this.isBackFill(processDefinitionId);
            if (!backFill) continue;
            String processKey = processDefinitionId.split(":")[0];
            deletedTaskInfoDto.setProcessKey(processKey);
            List<String> businessIds = Arrays.asList(((String)entry.getValue()).split(","));
            businessIds.removeAll(emulationBusinessKey);
            if (businessIds.isEmpty()) continue;
            deletedTaskInfoDto.setBusinessIdList(businessIds);
            deletedTaskInfoDtos.add(deletedTaskInfoDto);
            this.deleteTaskInfoPush(deletedTaskInfoDtos);
        }
    }

    public void entrustTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ArrayList<UpdateTaskUserDto> updateTaskUserDtos = new ArrayList<UpdateTaskUserDto>();
        UpdateTaskUserDto updateTaskUserDto = new UpdateTaskUserDto();
        updateTaskUserDto.setProcessKey(dataPush.getProcessKey());
        updateTaskUserDto.setTaskId(dataPush.getTaskId());
        ArrayList<WorkflowUserDto> workflowUserDtoList = new ArrayList<WorkflowUserDto>();
        List userMapList = dataPush.getUserMapList();
        if (HussarUtils.isNotEmpty((Object)userMapList)) {
            for (Map map : userMapList) {
                WorkflowUserDto workflowUserDto = new WorkflowUserDto();
                workflowUserDto.setUserId((String)map.get("userId"));
                if (HussarUtils.isNotEmpty(map.get("mandator"))) {
                    workflowUserDto.setOwnerId((String)map.get("mandator"));
                }
                workflowUserDtoList.add(workflowUserDto);
            }
        }
        updateTaskUserDto.setUsers(workflowUserDtoList);
        updateTaskUserDtos.add(updateTaskUserDto);
        this.updateTaskUserPush(updateTaskUserDtos);
    }

    public void transferUserTask(DataPush dataPush) {
        this.entrustTask(dataPush);
    }

    public void rejectTask(DataPush dataPush) {
        this.completeTask(dataPush);
    }

    public void revokeTask(DataPush dataPush) {
        this.completeTask(dataPush);
    }

    public void freeJumpTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ArrayList<CompleteTaskInfoDto> completeTaskInfoDtos = new ArrayList<CompleteTaskInfoDto>();
        ArrayList<String> taskIds = dataPush.getTaskIds();
        String taskId = dataPush.getTaskId();
        if (HussarUtils.isEmpty((Object)taskIds)) {
            taskIds = new ArrayList<String>();
            taskIds.add(taskId);
        }
        for (String id : taskIds) {
            CompleteTaskInfoDto completeTaskInfoDto = new CompleteTaskInfoDto();
            completeTaskInfoDto.setBusinessId(dataPush.getBusinessKey());
            completeTaskInfoDto.setProcessKey(dataPush.getProcessKey());
            completeTaskInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
            completeTaskInfoDto.setTaskId(id);
            completeTaskInfoDto.setEndTime(dataPush.getEndDate());
            completeTaskInfoDto.setAssignee(dataPush.getUserId());
            String taskType = this.convertTaskType(dataPush.getTaskType(), DONE);
            completeTaskInfoDto.setTaskType(taskType);
            completeTaskInfoDto.setTaskState(DONE);
            if (id.equals(taskId)) {
                completeTaskInfoDto.setOwner(dataPush.getConsignor());
            }
            completeTaskInfoDtos.add(completeTaskInfoDto);
        }
        this.completeTaskPush(completeTaskInfoDtos);
    }

    public void addUser(DataPush dataPush) {
        this.entrustTask(dataPush);
    }

    public void deleteMultiTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        DeletedTaskInfoDto deletedTaskInfoDto = new DeletedTaskInfoDto();
        List taskIds = dataPush.getTaskIds();
        String processKey = dataPush.getProcessKey();
        deletedTaskInfoDto.setProcessKey(processKey);
        deletedTaskInfoDto.setTaskIdList(taskIds);
        this.deleteTaskInfoPush(Arrays.asList(deletedTaskInfoDto));
    }

    public void endProcess(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ArrayList<CompleteTaskInfoDto> completeTaskInfoDtos = new ArrayList<CompleteTaskInfoDto>();
        List taskIds = dataPush.getTaskIds();
        String taskId = dataPush.getTaskId();
        for (String id : taskIds) {
            CompleteTaskInfoDto completeTaskInfoDto = new CompleteTaskInfoDto();
            completeTaskInfoDto.setBusinessId(dataPush.getBusinessKey());
            completeTaskInfoDto.setProcessKey(dataPush.getProcessKey());
            completeTaskInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
            completeTaskInfoDto.setTaskId(id);
            completeTaskInfoDto.setAssignee(dataPush.getUserId());
            if (HussarUtils.isNotEmpty((Object)dataPush.getConsignor()) && HussarUtils.isNotEmpty((Object)taskId) && taskId.equals(id)) {
                completeTaskInfoDto.setOwner(dataPush.getConsignor());
            }
            completeTaskInfoDto.setEndTime(dataPush.getEndDate());
            String taskType = this.convertTaskType(dataPush.getTaskType(), DONE);
            completeTaskInfoDto.setTaskType(taskType);
            completeTaskInfoDto.setTaskState(DONE);
            completeTaskInfoDtos.add(completeTaskInfoDto);
        }
        this.completeTaskPush(completeTaskInfoDtos);
    }

    public void transferTask(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        ArrayList<UpdateTaskUserDto> updateTaskUserDtos = new ArrayList<UpdateTaskUserDto>();
        Map taskProcDefIdMap = dataPush.getTaskProcDefIdMap();
        HashMap procDefTaskMap = new HashMap();
        for (Map.Entry entry : taskProcDefIdMap.entrySet()) {
            String taskIds = (String)entry.getKey();
            if (procDefTaskMap.containsKey(entry.getValue())) {
                taskIds = (String)procDefTaskMap.get(entry.getValue()) + "," + taskIds;
            }
            procDefTaskMap.put(entry.getValue(), taskIds);
        }
        for (Map.Entry entry : procDefTaskMap.entrySet()) {
            String processDefinitionId = (String)entry.getKey();
            boolean backFill = this.isBackFill(processDefinitionId);
            if (!backFill) {
                return;
            }
            String processKey = processDefinitionId.split(":")[0];
            for (String taskId : ((String)entry.getValue()).split(",")) {
                UpdateTaskUserDto updateTaskUserDto = new UpdateTaskUserDto();
                updateTaskUserDto.setProcessKey(processKey);
                updateTaskUserDto.setTaskId(taskId);
                List<WorkflowUserDto> workflowUserDtoList = this.getIdentiLink(taskId);
                updateTaskUserDto.setUsers(workflowUserDtoList);
                updateTaskUserDtos.add(updateTaskUserDto);
            }
            this.updateTaskUserPush(updateTaskUserDtos);
        }
    }

    public void reTransferTask(DataPush dataPush) {
        this.transferTask(dataPush);
    }

    public void changeProcessState(DataPush dataPush) {
        List emulationBusinessKey = dataPush.getEmulationBusinessKey();
        if (emulationBusinessKey == null && this.isEmulationProcess(dataPush)) {
            return;
        }
        Map businessMap = dataPush.getBusinessMap();
        if (HussarUtils.isNotEmpty((Object)businessMap)) {
            ArrayList<DeletedProcessInfoDto> deletedProcessInfoDtos = new ArrayList<DeletedProcessInfoDto>();
            for (Map.Entry entry : businessMap.entrySet()) {
                String processDefinitionId = (String)entry.getKey();
                boolean backFill = this.isBackFill(processDefinitionId);
                if (!backFill) {
                    return;
                }
                String processKey = processDefinitionId.split(":")[0];
                String businessIds = (String)entry.getValue();
                ArrayList<String> ids = new ArrayList<String>(Arrays.asList(businessIds.split(",")));
                ids.removeAll(emulationBusinessKey);
                if (ids.isEmpty()) continue;
                for (String businessId : ids) {
                    DeletedProcessInfoDto deletedProcessInfoDto = new DeletedProcessInfoDto();
                    deletedProcessInfoDto.setProcessKey(processKey);
                    deletedProcessInfoDto.setProcessState(stateType.get(dataPush.getProcessState()));
                    deletedProcessInfoDto.setBusinessId(businessId);
                    deletedProcessInfoDto.setFinishTime(new Date());
                    deletedProcessInfoDtos.add(deletedProcessInfoDto);
                }
                this.deleteProcessPush(deletedProcessInfoDtos);
            }
        } else {
            boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
            if (!backFill) {
                return;
            }
            ProcessInfoDto processInfoDto = new ProcessInfoDto();
            processInfoDto.setBusinessId(dataPush.getBusinessKey());
            processInfoDto.setProcessKey(dataPush.getProcessKey());
            processInfoDto.setProcessState(stateType.get(dataPush.getProcessState()));
            processInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
            processInfoDto.setStartTime(dataPush.getProcessStartTime());
            processInfoDto.setFinishTime(dataPush.getProcessEndTime());
            processInfoDto.setStartUserId(dataPush.getStartUserId());
            processInfoDto.setDueDate(dataPush.getDueDate());
            this.changeProcessInfoPush(processInfoDto);
        }
    }

    public void changeProcessNode(DataPush dataPush) {
        if (this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ProcessNodeInfoDto processNodeInfoDto = new ProcessNodeInfoDto();
        processNodeInfoDto.setBusinessId(dataPush.getBusinessKey());
        processNodeInfoDto.setProcessKey(dataPush.getProcessKey());
        processNodeInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
        processNodeInfoDto.setProcessNodeList(dataPush.getProcessNodeList());
        this.changeProcessNodePush(processNodeInfoDto);
    }

    private List<WorkflowUserDto> getIdentiLink(String taskId) {
        ArrayList<WorkflowUserDto> workflowUserDtoList = new ArrayList<WorkflowUserDto>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BpmActRuIdentitylink::getTaskId, (Object)Long.valueOf(taskId));
        List identitylinkList = this.bpmActRuIdentitylinkService.list((Wrapper)wrapper);
        for (BpmActRuIdentitylink identitylink : identitylinkList) {
            WorkflowUserDto workflowUserDto = new WorkflowUserDto();
            workflowUserDto.setUserId(identitylink.getUserId());
            if (HussarUtils.isNotEmpty((Object)identitylink.getMandator())) {
                workflowUserDto.setOwnerId(identitylink.getMandator());
            }
            workflowUserDtoList.add(workflowUserDto);
        }
        return workflowUserDtoList;
    }

    private String convertTaskType(String taskType, String taskState) {
        if (HussarUtils.isNotEmpty((Object)taskType) && "2".equals(taskType)) {
            if (TODO.equals(taskState)) {
                return "4";
            }
            return "5";
        }
        if (TODO.equals(taskState)) {
            return "2";
        }
        return DONE;
    }

    private boolean isBackFill(String processDefinitionId) {
        if (HussarUtils.isEmpty((Object)processDefinitionId)) {
            return false;
        }
        boolean isBackFill = false;
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        List isBackFillElement = (List)extensionElementList.get("isBackfill");
        if (HussarUtils.isNotEmpty((Object)isBackFillElement) && HussarUtils.isNotEmpty(((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill"))) {
            String isBackFillText = ((ExtensionAttribute)((List)((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill")).get(0)).getValue();
            isBackFill = HussarUtils.isEmpty((Object)isBackFillText) ? false : Boolean.valueOf(isBackFillText);
        }
        return isBackFill;
    }

    private void addTaskInfoPush(TaskInfoDto taskInfoDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)taskInfoDto.getProcessKey());
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Integer num = taskModelService.addTaskInfo(taskInfoDto);
                    if (num <= 0) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.modelService.getServiceName(taskInfoDto.getProcessKey()));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Integer num = taskModelBackFillService.addTaskInfo(taskInfoDto, serviceName);
                if (num > 0) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = addTaskInfoUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    Integer n = Integer.valueOf(HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)taskInfoDto)));
                    if (n <= 0) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void completeTaskPush(List<CompleteTaskInfoDto> completeTaskInfoDtos) {
        String deploymentModel;
        CompleteTaskInfoDto completeTaskInfoDto = completeTaskInfoDtos.get(0);
        String processKey = null;
        if (HussarUtils.isNotEmpty((Object)completeTaskInfoDto)) {
            processKey = completeTaskInfoDto.getProcessKey();
        }
        if (HussarUtils.isEmpty(processKey)) {
            return;
        }
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processKey);
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Boolean flag = taskModelService.completeTask(completeTaskInfoDtos);
                    if (!flag.booleanValue()) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.modelService.getServiceName(processKey));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.completeTask(completeTaskInfoDtos, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = completeTaskUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString(completeTaskInfoDtos));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void updateTaskUserPush(List<UpdateTaskUserDto> updateTaskUserDtos) {
        String deploymentModel;
        UpdateTaskUserDto updateTaskUserDto = updateTaskUserDtos.get(0);
        String processKey = null;
        if (HussarUtils.isNotEmpty((Object)updateTaskUserDto)) {
            processKey = updateTaskUserDto.getProcessKey();
        }
        if (HussarUtils.isEmpty(processKey)) {
            return;
        }
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)updateTaskUserDto.getProcessKey());
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Integer num = taskModelService.updateTaskUser(updateTaskUserDtos);
                    if (num <= 0) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.modelService.getServiceName(updateTaskUserDto.getProcessKey()));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Integer num = taskModelBackFillService.updateTaskUser(updateTaskUserDtos, serviceName);
                if (num > 0) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = updateTaskUserUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    Integer n = Integer.valueOf(HttpClient.doPost((String)url, (String)JSON.toJSONString(updateTaskUserDtos)));
                    if (n <= 0) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void deleteTaskInfoPush(List<DeletedTaskInfoDto> deletedTaskInfoDtos) {
        String deploymentModel;
        DeletedTaskInfoDto deletedTaskInfoDto = deletedTaskInfoDtos.get(0);
        String processKey = null;
        if (HussarUtils.isNotEmpty((Object)deletedTaskInfoDto)) {
            processKey = deletedTaskInfoDto.getProcessKey();
        }
        if (HussarUtils.isEmpty(processKey)) {
            return;
        }
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processKey);
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Boolean flag = taskModelService.deleteTaskInfo(deletedTaskInfoDtos);
                    if (!flag.booleanValue()) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.modelService.getServiceName(processKey));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.deleteTaskInfo(deletedTaskInfoDtos, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = deleteTaskInfoUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString(deletedTaskInfoDtos));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void deleteProcessPush(List<DeletedProcessInfoDto> deletedProcessInfoDtos) {
        String deploymentModel;
        DeletedProcessInfoDto deletedProcessInfoDto = deletedProcessInfoDtos.get(0);
        String processKey = null;
        if (HussarUtils.isNotEmpty((Object)deletedProcessInfoDto)) {
            processKey = deletedProcessInfoDto.getProcessKey();
        }
        if (HussarUtils.isEmpty(processKey)) {
            return;
        }
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processKey);
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Boolean flag = taskModelService.deleteProcess(deletedProcessInfoDtos);
                    if (!flag.booleanValue()) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.modelService.getServiceName(processKey));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.deleteProcess(deletedProcessInfoDtos, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = deleteProcessUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString(deletedProcessInfoDtos));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void changeProcessInfoPush(ProcessInfoDto processInfoDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processInfoDto.getProcessKey());
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Boolean flag = taskModelService.changeProcessInfo(processInfoDto);
                    if (!flag.booleanValue()) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.modelService.getServiceName(processInfoDto.getProcessKey()));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.changeProcessInfo(processInfoDto, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = changeProcessInfoUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)processInfoDto));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    private void changeProcessNodePush(ProcessNodeInfoDto processNodeInfoDto) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processNodeInfoDto.getProcessKey());
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    Boolean flag = taskModelService.changeProcessNode(processNodeInfoDto);
                    if (!flag.booleanValue()) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                String serviceName = String.valueOf(this.modelService.getServiceName(processNodeInfoDto.getProcessKey()));
                TaskModelBackFillService taskModelBackFillService = (TaskModelBackFillService)BpmSpringContextHolder.getBean(TaskModelBackFillService.class);
                Boolean flag = taskModelBackFillService.changeProcessNode(processNodeInfoDto, serviceName);
                if (flag.booleanValue()) break;
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
            default: {
                try {
                    String url = changeProcessNodeUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)processNodeInfoDto));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    public void processChange(ProcessDataPush processDataPush) {
        DataPush dataPush = processDataPush.getDataPush();
        List emulationBusinessKey = dataPush.getEmulationBusinessKey();
        if (emulationBusinessKey == null && this.isEmulationProcess(dataPush)) {
            return;
        }
        boolean backFill = this.isBackFill(dataPush.getProcessDefinitionId());
        if (!backFill) {
            return;
        }
        ProcessChangeDto processChangeDto = new ProcessChangeDto();
        ProcessInfoDto processInfoDto = new ProcessInfoDto();
        processChangeDto.setProcessInfoDto(processInfoDto);
        processInfoDto.setBusinessId(dataPush.getBusinessKey());
        processInfoDto.setProcessKey(dataPush.getProcessKey());
        processInfoDto.setProcessState(stateType.get(dataPush.getProcessState()));
        processInfoDto.setProcessInstanceId(dataPush.getProcessInsId());
        processInfoDto.setStartTime(dataPush.getProcessStartTime());
        processInfoDto.setFinishTime(dataPush.getProcessEndTime());
        processInfoDto.setStartUserId(dataPush.getStartUserId());
        processInfoDto.setDueDate(dataPush.getDueDate());
        processInfoDto.setProcessNodeList(dataPush.getProcessNodeList());
        List dataPushList = processDataPush.getTaskDataPush();
        ArrayList<TaskInfoDto> taskInfoDtos = new ArrayList<TaskInfoDto>();
        processChangeDto.setTaskInfoDto(taskInfoDtos);
        ArrayList<TaskInfoDto> updateTaskInfoDtos = new ArrayList<TaskInfoDto>();
        processChangeDto.setUpdateTaskInfoDto(updateTaskInfoDtos);
        ArrayList<TaskInfoDto> deleteTaskInfoDtos = new ArrayList<TaskInfoDto>();
        processChangeDto.setRemoveTaskInfoDto(deleteTaskInfoDtos);
        for (DataPush taskDataPush : dataPushList) {
            WorkflowUserDto workflowUserDto;
            ArrayList<WorkflowUserDto> workflowUserDtoList;
            String taskType;
            Object taskDefinitionKey;
            String processDefinitionId;
            String formDetailKey;
            TaskInfoDto taskInfoDto;
            if ("ccAdd".equals(taskDataPush.getType()) || "ccRead".equals(taskDataPush.getType())) continue;
            if ("add".equals(taskDataPush.getType()) || "addComplete".equals(taskDataPush.getType())) {
                taskInfoDto = new TaskInfoDto();
                taskInfoDtos.add(taskInfoDto);
                taskInfoDto.setBusinessId(taskDataPush.getBusinessKey());
                taskInfoDto.setProcessKey(taskDataPush.getProcessKey());
                taskInfoDto.setProcessInstanceId(taskDataPush.getProcessInsId());
                taskInfoDto.setTaskId(taskDataPush.getTaskId());
                taskInfoDto.setTaskDefinitionKey(taskDataPush.getTaskDefinitionKey());
                taskInfoDto.setTaskDefinitionName(taskDataPush.getTaskDefinitionName());
                taskInfoDto.setStartTime(taskDataPush.getProcessStartTime());
                taskInfoDto.setCreateTime(taskDataPush.getStartDate());
                taskInfoDto.setDueTime(taskDataPush.getTaskDueTime());
                taskInfoDto.setFormKey(taskDataPush.getUrl());
                formDetailKey = taskDataPush.getFormDetailKey();
                if (HussarUtils.isEmpty((Object)formDetailKey)) {
                    processDefinitionId = taskDataPush.getProcessDefinitionId();
                    taskDefinitionKey = taskDataPush.getTaskDefinitionKey();
                    formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, (String)taskDefinitionKey);
                }
                taskInfoDto.setFormDetailKey(formDetailKey);
                if (taskDataPush.getEndDate() != null) {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), DONE);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(DONE);
                } else {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), TODO);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(TODO);
                }
                workflowUserDtoList = new ArrayList<WorkflowUserDto>();
                if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserMaps())) {
                    for (Map user : taskDataPush.getUserMaps()) {
                        WorkflowUserDto workflowUserDto2 = new WorkflowUserDto();
                        workflowUserDto2.setUserId((String)user.get("userId"));
                        if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                            workflowUserDto2.setOwnerId((String)user.get("mandator"));
                        }
                        workflowUserDtoList.add(workflowUserDto2);
                    }
                } else if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserId())) {
                    for (String string : taskDataPush.getUserId().split(",")) {
                        workflowUserDto = new WorkflowUserDto();
                        workflowUserDto.setUserId(string);
                        workflowUserDtoList.add(workflowUserDto);
                    }
                }
                taskInfoDto.setUsers(workflowUserDtoList);
                taskInfoDto.setEndTime(taskDataPush.getEndDate());
                taskInfoDto.setAssignee(taskDataPush.getUserId());
                continue;
            }
            if ("delete".equals(dataPush.getType())) {
                taskInfoDto = new TaskInfoDto();
                deleteTaskInfoDtos.add(taskInfoDto);
                taskInfoDto.setBusinessId(taskDataPush.getBusinessKey());
                taskInfoDto.setProcessKey(taskDataPush.getProcessKey());
                taskInfoDto.setProcessInstanceId(taskDataPush.getProcessInsId());
                taskInfoDto.setTaskId(taskDataPush.getTaskId());
                taskInfoDto.setTaskDefinitionKey(taskDataPush.getTaskDefinitionKey());
                taskInfoDto.setTaskDefinitionName(taskDataPush.getTaskDefinitionName());
                taskInfoDto.setStartTime(taskDataPush.getProcessStartTime());
                taskInfoDto.setCreateTime(taskDataPush.getStartDate());
                taskInfoDto.setDueTime(taskDataPush.getTaskDueTime());
                taskInfoDto.setFormKey(taskDataPush.getUrl());
                formDetailKey = taskDataPush.getFormDetailKey();
                if (HussarUtils.isEmpty((Object)formDetailKey)) {
                    processDefinitionId = taskDataPush.getProcessDefinitionId();
                    taskDefinitionKey = taskDataPush.getTaskDefinitionKey();
                    formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, (String)taskDefinitionKey);
                }
                taskInfoDto.setFormDetailKey(formDetailKey);
                if (taskDataPush.getEndDate() != null) {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), DONE);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(DONE);
                } else {
                    taskType = this.convertTaskType(taskDataPush.getTaskType(), TODO);
                    taskInfoDto.setTaskType(taskType);
                    taskInfoDto.setTaskState(TODO);
                }
                workflowUserDtoList = new ArrayList();
                if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserMaps())) {
                    for (Map user : taskDataPush.getUserMaps()) {
                        WorkflowUserDto workflowUserDto3 = new WorkflowUserDto();
                        workflowUserDto3.setUserId((String)user.get("userId"));
                        if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                            workflowUserDto3.setOwnerId((String)user.get("mandator"));
                        }
                        workflowUserDtoList.add(workflowUserDto3);
                    }
                } else if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserId())) {
                    for (String string : taskDataPush.getUserId().split(",")) {
                        workflowUserDto = new WorkflowUserDto();
                        workflowUserDto.setUserId(string);
                        workflowUserDtoList.add(workflowUserDto);
                    }
                }
                taskInfoDto.setUsers(workflowUserDtoList);
                taskInfoDto.setEndTime(taskDataPush.getEndDate());
                taskInfoDto.setAssignee(taskDataPush.getUserId());
                continue;
            }
            if (!"update".equals(dataPush.getType())) continue;
            taskInfoDto = new TaskInfoDto();
            updateTaskInfoDtos.add(taskInfoDto);
            taskInfoDto.setBusinessId(taskDataPush.getBusinessKey());
            taskInfoDto.setProcessKey(taskDataPush.getProcessKey());
            taskInfoDto.setProcessInstanceId(taskDataPush.getProcessInsId());
            taskInfoDto.setTaskId(taskDataPush.getTaskId());
            taskInfoDto.setTaskDefinitionKey(taskDataPush.getTaskDefinitionKey());
            taskInfoDto.setTaskDefinitionName(taskDataPush.getTaskDefinitionName());
            taskInfoDto.setStartTime(taskDataPush.getProcessStartTime());
            taskInfoDto.setCreateTime(taskDataPush.getStartDate());
            taskInfoDto.setDueTime(taskDataPush.getTaskDueTime());
            taskInfoDto.setFormKey(taskDataPush.getUrl());
            formDetailKey = taskDataPush.getFormDetailKey();
            if (HussarUtils.isEmpty((Object)formDetailKey)) {
                processDefinitionId = taskDataPush.getProcessDefinitionId();
                taskDefinitionKey = taskDataPush.getTaskDefinitionKey();
                formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, (String)taskDefinitionKey);
            }
            taskInfoDto.setFormDetailKey(formDetailKey);
            if (taskDataPush.getEndDate() != null) {
                taskType = this.convertTaskType(taskDataPush.getTaskType(), DONE);
                taskInfoDto.setTaskType(taskType);
                taskInfoDto.setTaskState(DONE);
            } else {
                taskType = this.convertTaskType(taskDataPush.getTaskType(), TODO);
                taskInfoDto.setTaskType(taskType);
                taskInfoDto.setTaskState(TODO);
            }
            workflowUserDtoList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserMaps())) {
                for (Map user : taskDataPush.getUserMaps()) {
                    WorkflowUserDto workflowUserDto4 = new WorkflowUserDto();
                    workflowUserDto4.setUserId((String)user.get("userId"));
                    if (HussarUtils.isNotEmpty(user.get("mandator"))) {
                        workflowUserDto4.setOwnerId((String)user.get("mandator"));
                    }
                    workflowUserDtoList.add(workflowUserDto4);
                }
            } else if (HussarUtils.isNotEmpty((Object)taskDataPush.getUserId())) {
                for (String string : taskDataPush.getUserId().split(",")) {
                    workflowUserDto = new WorkflowUserDto();
                    workflowUserDto.setUserId(string);
                    workflowUserDtoList.add(workflowUserDto);
                }
            }
            taskInfoDto.setUsers(workflowUserDtoList);
            taskInfoDto.setEndTime(taskDataPush.getEndDate());
            taskInfoDto.setAssignee(taskDataPush.getUserId());
        }
        this.processChange(processChangeDto, dataPush.getProcessKey());
    }

    private void processChange(ProcessChangeDto processChangeDto, String processKey) {
        String deploymentModel;
        switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
            case "single": {
                TaskModelService taskModelService = null;
                try {
                    taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processKey);
                    if (HussarUtils.isEmpty((Object)taskModelService)) {
                        return;
                    }
                    boolean flag = taskModelService.processChange(processChangeDto);
                    if (!flag) {
                        throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                    }
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
            case "micro": {
                break;
            }
            default: {
                try {
                    String url = changeProcessInfoUrl;
                    url = this.lcdpBpmProperties.getTenantCallAddress() + url;
                    HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)processChangeDto));
                    break;
                }
                catch (BpmException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
                }
            }
        }
    }

    static {
        stateType.put("startProcess", TODO);
        stateType.put("reStartProcess", TODO);
        stateType.put("activateProcess", TODO);
        stateType.put("completeProcess", DONE);
        stateType.put("endProcess", "2");
        stateType.put("revokeProcess", "3");
        stateType.put("suspendProcess", "4");
        stateType.put("deleteProcess", "5");
    }
}

