/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskdatasync.service;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ProcessBinding;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.task.datasync.dto.TaskDataSyncDto;
import com.jxdinfo.hussar.workflow.task.datasync.service.ITaskDataSyncService;
import com.jxdinfo.hussar.workflow.task.datasync.vo.UserInfoVo;
import com.jxdinfo.hussar.workflow.taskdatasync.util.QueryNoCodeBusinessDB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TaskDataSyncPush
implements DataPushListener {
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;
    @Autowired
    private ITaskDataSyncService taskDataSyncService;
    @Lazy
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);
    private static Logger logger = LoggerFactory.getLogger(TaskDataSyncPush.class);
    @Lazy
    @Autowired
    private ModelService modelService;

    public void addTask(DataPush dataPush) {
        String taskSourceFlag = dataPush.getTaskSourceFlag();
        if (HussarUtils.isNotEmpty((Object)taskSourceFlag) && "revoke".equals(taskSourceFlag)) {
            return;
        }
        Map<String, String> wfdMap = this.getWfd(dataPush);
        TaskDataSyncDto taskDataSyncDto = this.getTableName(dataPush.getProcessDefinitionId(), wfdMap);
        if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
            return;
        }
        taskDataSyncDto.setBusinessId(Long.valueOf(dataPush.getBusinessKey()));
        taskDataSyncDto.setProcessInstanceId(dataPush.getProcessInsId());
        taskDataSyncDto.setProcessKey(dataPush.getProcessKey());
        taskDataSyncDto.setTaskId(Long.valueOf(dataPush.getTaskId()));
        taskDataSyncDto.setTaskDefinitionKey(dataPush.getTaskDefinitionKey());
        taskDataSyncDto.setTaskDefinitionName(dataPush.getTaskDefinitionName());
        taskDataSyncDto.setCreateTime(dataPush.getStartDate());
        taskDataSyncDto.setFormKey(dataPush.getUrl());
        String formDetailKey = dataPush.getFormDetailKey();
        if (HussarUtils.isEmpty((Object)formDetailKey)) {
            String processDefinitionId = dataPush.getProcessDefinitionId();
            String taskDefinitionKey = dataPush.getTaskDefinitionKey();
            formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, taskDefinitionKey);
        }
        taskDataSyncDto.setFormDetailKey(formDetailKey);
        String users = dataPush.getUserId();
        ArrayList<UserInfoVo> userInfoVoList = new ArrayList<UserInfoVo>();
        if (HussarUtils.isNotEmpty((Object)users)) {
            List<String> userList = Arrays.asList(users.split(","));
            for (String userId : userList) {
                UserInfoVo userInfoVo = new UserInfoVo();
                userInfoVo.setUserId(userId);
                userInfoVoList.add(userInfoVo);
            }
        } else {
            UserInfoVo userInfoVo = new UserInfoVo();
            userInfoVo.setUserId(null);
            userInfoVoList.add(userInfoVo);
        }
        taskDataSyncDto.setUserInfoList(userInfoVoList);
        if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
            if (HussarUtils.isEmpty((Object)dataPush.getProcessKey())) {
                return;
            }
            String serviceName = this.modelService.getServiceName(dataPush.getProcessKey());
            taskDataSyncDto.setServiceName(serviceName);
        }
        this.taskDataSyncService.addTask(taskDataSyncDto, QueryNoCodeBusinessDB.getNocodeBusinessDB());
    }

    public void completeTask(DataPush dataPush) {
        logger.info("************************\u8fdb\u5165TaskDataSyncPush.completeTask************************");
        logger.info("\u4efb\u52a1\u5b8c\u6210\u63a8\u9001\uff0c\u5165\u53c2:{}", (Object)dataPush);
        Map<String, String> wfdMap = this.getWfd(dataPush);
        TaskDataSyncDto taskDataSyncDto = this.getTableName(dataPush.getProcessDefinitionId(), wfdMap);
        if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
            return;
        }
        taskDataSyncDto.setProcessKey(dataPush.getProcessKey());
        String taskIds = dataPush.getTaskId();
        List<String> taskIdList = Arrays.asList(taskIds.split(","));
        if (HussarUtils.isEmpty(taskIdList)) {
            taskIdList = new ArrayList<String>();
        }
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            taskIdList.addAll(dataPush.getTaskIds());
        }
        ArrayList<Long> taskIdListLong = new ArrayList<Long>();
        for (String taskId : taskIdList) {
            taskIdListLong.add(Long.valueOf(taskId));
        }
        taskDataSyncDto.setTaskIdList(taskIdListLong);
        taskDataSyncDto.setUserId(dataPush.getUserId());
        taskDataSyncDto.setEndTime(dataPush.getEndDate());
        logger.info("\u6570\u636e\u56de\u586bDto\uff0c\u62fc\u88c5\u53c2\u6570\u540e:{}", (Object)taskDataSyncDto);
        if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
            if (HussarUtils.isEmpty((Object)dataPush.getProcessKey())) {
                return;
            }
            String serviceName = this.modelService.getServiceName(dataPush.getProcessKey());
            taskDataSyncDto.setServiceName(serviceName);
        }
        this.taskDataSyncService.completeTask(taskDataSyncDto, QueryNoCodeBusinessDB.getNocodeBusinessDB());
        logger.info("************************\u6267\u884c\u5b8c\u6210TaskDataSyncPush.completeTask************************");
    }

    public void deleteTask(DataPush dataPush) {
        Map<String, String> wfdMap = this.getWfd(dataPush);
        Map businessMap = dataPush.getBusinessMap();
        ArrayList<TaskDataSyncDto> taskDataSyncDtoList = new ArrayList<TaskDataSyncDto>();
        for (String procDefId : businessMap.keySet()) {
            TaskDataSyncDto taskDataSyncDto = this.getTableName(procDefId, wfdMap);
            if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
                return;
            }
            String processKey = procDefId.split(":")[0];
            String businessIds = (String)businessMap.get(procDefId);
            List<String> businessIdList = Arrays.asList(businessIds.split(","));
            ArrayList<Long> businessIdListLong = new ArrayList<Long>();
            for (String businessId : businessIdList) {
                businessIdListLong.add(Long.valueOf(businessId));
            }
            taskDataSyncDto.setBusinessIdList(businessIdListLong);
            if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
                if (HussarUtils.isEmpty((Object)processKey)) {
                    return;
                }
                String serviceName = this.modelService.getServiceName(processKey);
                taskDataSyncDto.setServiceName(serviceName);
            }
            taskDataSyncDtoList.add(taskDataSyncDto);
        }
        if (HussarUtils.isNotEmpty(taskDataSyncDtoList)) {
            this.taskDataSyncService.deleteTask(taskDataSyncDtoList, QueryNoCodeBusinessDB.getNocodeBusinessDB());
        }
    }

    public void entrustTask(DataPush dataPush) {
        Map<String, String> wfdMap = this.getWfd(dataPush);
        TaskDataSyncDto taskDataSyncDto = this.getTableName(dataPush.getProcessDefinitionId(), wfdMap);
        if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
            return;
        }
        String consignor = dataPush.getConsignor();
        List<Object> consignorList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)consignor)) {
            consignorList = Arrays.asList(consignor.split(","));
        }
        taskDataSyncDto.setConsignorList(consignorList);
        taskDataSyncDto.setBusinessId(Long.valueOf(dataPush.getBusinessKey()));
        taskDataSyncDto.setProcessInstanceId(dataPush.getProcessInsId());
        taskDataSyncDto.setProcessKey(dataPush.getProcessKey());
        taskDataSyncDto.setTaskId(Long.valueOf(dataPush.getTaskId()));
        taskDataSyncDto.setTaskDefinitionKey(dataPush.getTaskDefinitionKey());
        taskDataSyncDto.setTaskDefinitionName(dataPush.getTaskDefinitionName());
        taskDataSyncDto.setCreateTime(dataPush.getStartDate());
        taskDataSyncDto.setFormKey(dataPush.getUrl());
        String formDetailKey = dataPush.getFormDetailKey();
        if (HussarUtils.isEmpty((Object)formDetailKey)) {
            String processDefinitionId = dataPush.getProcessDefinitionId();
            String taskDefinitionKey = dataPush.getTaskDefinitionKey();
            formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, taskDefinitionKey);
        }
        taskDataSyncDto.setFormDetailKey(formDetailKey);
        String users = dataPush.getUserId();
        ArrayList<UserInfoVo> userInfoVoList = new ArrayList<UserInfoVo>();
        List<String> userList = Arrays.asList(users.split(","));
        for (String userId : userList) {
            UserInfoVo userInfoVo = new UserInfoVo();
            userInfoVo.setUserId(userId);
            userInfoVoList.add(userInfoVo);
        }
        taskDataSyncDto.setUserInfoList(userInfoVoList);
        if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
            if (HussarUtils.isEmpty((Object)dataPush.getProcessKey())) {
                return;
            }
            String serviceName = this.modelService.getServiceName(dataPush.getProcessKey());
            taskDataSyncDto.setServiceName(serviceName);
        }
        this.taskDataSyncService.entrustTask(taskDataSyncDto, QueryNoCodeBusinessDB.getNocodeBusinessDB());
    }

    public void transferUserTask(DataPush dataPush) {
        Map<String, String> wfdMap = this.getWfd(dataPush);
        TaskDataSyncDto taskDataSyncDto = this.getTableName(dataPush.getProcessDefinitionId(), wfdMap);
        if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
            return;
        }
        String consignor = dataPush.getTransferor();
        List<Object> consignorList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)consignor)) {
            consignorList = Arrays.asList(consignor.split(","));
        }
        taskDataSyncDto.setConsignorList(consignorList);
        taskDataSyncDto.setBusinessId(Long.valueOf(dataPush.getBusinessKey()));
        taskDataSyncDto.setProcessInstanceId(dataPush.getProcessInsId());
        taskDataSyncDto.setProcessKey(dataPush.getProcessKey());
        taskDataSyncDto.setTaskId(Long.valueOf(dataPush.getTaskId()));
        taskDataSyncDto.setTaskDefinitionKey(dataPush.getTaskDefinitionKey());
        taskDataSyncDto.setTaskDefinitionName(dataPush.getTaskDefinitionName());
        taskDataSyncDto.setCreateTime(dataPush.getStartDate());
        taskDataSyncDto.setFormKey(dataPush.getUrl());
        String formDetailKey = dataPush.getFormDetailKey();
        if (HussarUtils.isEmpty((Object)formDetailKey)) {
            String processDefinitionId = dataPush.getProcessDefinitionId();
            String taskDefinitionKey = dataPush.getTaskDefinitionKey();
            formDetailKey = this.sysActExtendPropertiesService.getFormDetailKey(processDefinitionId, taskDefinitionKey);
        }
        taskDataSyncDto.setFormDetailKey(formDetailKey);
        String users = dataPush.getUserId();
        ArrayList<UserInfoVo> userInfoVoList = new ArrayList<UserInfoVo>();
        List<String> userList = Arrays.asList(users.split(","));
        for (String userId : userList) {
            UserInfoVo userInfoVo = new UserInfoVo();
            userInfoVo.setUserId(userId);
            userInfoVoList.add(userInfoVo);
        }
        taskDataSyncDto.setUserInfoList(userInfoVoList);
        if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
            if (HussarUtils.isEmpty((Object)dataPush.getProcessKey())) {
                return;
            }
            String serviceName = this.modelService.getServiceName(dataPush.getProcessKey());
            taskDataSyncDto.setServiceName(serviceName);
        }
        this.taskDataSyncService.transferUserTask(taskDataSyncDto, QueryNoCodeBusinessDB.getNocodeBusinessDB());
    }

    public void rejectTask(DataPush dataPush) {
        this.completeTask(dataPush);
    }

    public void freeJumpTask(DataPush dataPush) {
        this.completeTask(dataPush);
    }

    public void addUser(DataPush dataPush) {
        this.addTask(dataPush);
    }

    public void deleteMultiTask(DataPush dataPush) {
        Map<String, String> wfdMap = this.getWfd(dataPush);
        TaskDataSyncDto taskDataSyncDto = this.getTableName(dataPush.getProcessDefinitionId(), wfdMap);
        if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
            return;
        }
        List taskIdList = dataPush.getTaskIds();
        ArrayList<Long> taskIdListLong = new ArrayList<Long>();
        for (String taskId : taskIdList) {
            taskIdListLong.add(Long.valueOf(taskId));
        }
        taskDataSyncDto.setTaskIdList(taskIdListLong);
        if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
            if (HussarUtils.isEmpty((Object)dataPush.getProcessKey())) {
                return;
            }
            String serviceName = this.modelService.getServiceName(dataPush.getProcessKey());
            taskDataSyncDto.setServiceName(serviceName);
        }
        this.taskDataSyncService.deleteMultiTask(taskDataSyncDto, QueryNoCodeBusinessDB.getNocodeBusinessDB());
    }

    public void transferTask(DataPush dataPush) {
        Map<String, String> wfdMap = this.getWfd(dataPush);
        Set processDefinitionIdList = dataPush.getProcessDefinitionIdList();
        ArrayList<TaskDataSyncDto> taskDataSyncDtoList = new ArrayList<TaskDataSyncDto>();
        for (String processDefinitionId : processDefinitionIdList) {
            TaskDataSyncDto taskDataSyncDto = this.getTableName(processDefinitionId, wfdMap);
            if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
                return;
            }
            String processKey = processDefinitionId.split(":")[0];
            List taskIds = dataPush.getTaskIds();
            ArrayList<Long> taskIdList = new ArrayList<Long>();
            for (String taskId : taskIds) {
                taskIdList.add(Long.valueOf(taskId));
            }
            taskDataSyncDto.setTaskIdList(taskIdList);
            ArrayList<UserInfoVo> userInfoList = new ArrayList<UserInfoVo>();
            UserInfoVo userInfoVo = new UserInfoVo();
            userInfoVo.setUserId(dataPush.getUserId());
            userInfoVo.setConsignor(dataPush.getConsignor());
            userInfoList.add(userInfoVo);
            taskDataSyncDto.setUserInfoList(userInfoList);
            if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
                if (HussarUtils.isEmpty((Object)processKey)) {
                    return;
                }
                String serviceName = this.modelService.getServiceName(processKey);
                taskDataSyncDto.setServiceName(serviceName);
            }
            taskDataSyncDtoList.add(taskDataSyncDto);
        }
        if (HussarUtils.isNotEmpty(taskDataSyncDtoList)) {
            for (TaskDataSyncDto taskDataSyncDto : taskDataSyncDtoList) {
                this.taskDataSyncService.transferTask(taskDataSyncDto, QueryNoCodeBusinessDB.getNocodeBusinessDB());
            }
        }
    }

    public void reTransferTask(DataPush dataPush) {
        Map<String, String> wfdMap = this.getWfd(dataPush);
        List taskIds = dataPush.getTaskIds();
        Map taskProcDefIdMap = dataPush.getTaskProcDefIdMap();
        Map consigneeMap = dataPush.getConsigneeMap();
        for (String taskId : taskIds) {
            String processDefinitionId = (String)taskProcDefIdMap.get(taskId);
            TaskDataSyncDto taskDataSyncDto = this.getTableName(processDefinitionId, wfdMap);
            if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
                return;
            }
            String processKey = processDefinitionId.split(":")[0];
            if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
                if (HussarUtils.isEmpty((Object)processKey)) {
                    return;
                }
                String serviceName = this.modelService.getServiceName(processKey);
                taskDataSyncDto.setServiceName(serviceName);
            }
            taskDataSyncDto.setTaskId(Long.valueOf(taskId));
            ArrayList<UserInfoVo> userInfoList = new ArrayList<UserInfoVo>();
            UserInfoVo userInfoVo = new UserInfoVo();
            userInfoVo.setUserId(dataPush.getUserId());
            String consignor = (String)consigneeMap.get(taskId);
            userInfoVo.setConsignor(consignor);
            userInfoList.add(userInfoVo);
            taskDataSyncDto.setUserInfoList(userInfoList);
            this.taskDataSyncService.reTransferTask(taskDataSyncDto, QueryNoCodeBusinessDB.getNocodeBusinessDB());
        }
    }

    public void endProcess(DataPush dataPush) {
        Map<String, String> wfdMap = this.getWfd(dataPush);
        TaskDataSyncDto taskDataSyncDto = this.getTableName(dataPush.getProcessDefinitionId(), wfdMap);
        if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
            return;
        }
        taskDataSyncDto.setProcessInstanceId(dataPush.getProcessInsId());
        taskDataSyncDto.setUserId(dataPush.getUserId());
        taskDataSyncDto.setEndTime(dataPush.getEndDate());
        taskDataSyncDto.setBusinessId(Long.valueOf(dataPush.getBusinessKey()));
        if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
            if (HussarUtils.isEmpty((Object)dataPush.getProcessKey())) {
                return;
            }
            String serviceName = this.modelService.getServiceName(dataPush.getProcessKey());
            taskDataSyncDto.setServiceName(serviceName);
        }
        this.taskDataSyncService.endProcess(taskDataSyncDto, QueryNoCodeBusinessDB.getNocodeBusinessDB());
    }

    public void changeProcessState(DataPush dataPush) {
        Map<String, String> wfdMap = this.getWfd(dataPush);
        String processDefinitionId = dataPush.getProcessDefinitionId();
        ArrayList<TaskDataSyncDto> taskDataSyncDtoList = new ArrayList<TaskDataSyncDto>();
        if (HussarUtils.isNotEmpty((Object)processDefinitionId)) {
            TaskDataSyncDto taskDataSyncDto = this.getTableName(processDefinitionId, wfdMap);
            if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
                return;
            }
            taskDataSyncDto.setProcessKey(dataPush.getProcessKey());
            taskDataSyncDto.setProcessInstanceId(dataPush.getProcessInsId());
            taskDataSyncDto.setProcessState(dataPush.getProcessState());
            taskDataSyncDto.setBusinessId(Long.valueOf(dataPush.getBusinessKey()));
            taskDataSyncDto.setStartTime(dataPush.getProcessStartTime());
            taskDataSyncDto.setFinishTime(dataPush.getProcessEndTime());
            taskDataSyncDto.setUserId(dataPush.getUserId());
            if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
                if (HussarUtils.isEmpty((Object)dataPush.getProcessKey())) {
                    return;
                }
                String serviceName = this.modelService.getServiceName(dataPush.getProcessKey());
                taskDataSyncDto.setServiceName(serviceName);
            }
            taskDataSyncDtoList.add(taskDataSyncDto);
        } else {
            Map businessMap = dataPush.getBusinessMap();
            for (String procDefId : businessMap.keySet()) {
                TaskDataSyncDto taskDataSyncDto = this.getTableName(procDefId, wfdMap);
                if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
                    return;
                }
                String processKey = procDefId.split(":")[0];
                taskDataSyncDto.setProcessState(dataPush.getProcessState());
                String businessIds = (String)businessMap.get(procDefId);
                List<String> businessIdList = Arrays.asList(businessIds.split(","));
                ArrayList<Long> businessIdListLong = new ArrayList<Long>();
                for (String businessId : businessIdList) {
                    businessIdListLong.add(Long.valueOf(businessId));
                }
                taskDataSyncDto.setBusinessIdList(businessIdListLong);
                taskDataSyncDto.setFinishTime(new Date());
                if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
                    if (HussarUtils.isEmpty((Object)processKey)) {
                        return;
                    }
                    String serviceName = this.modelService.getServiceName(processKey);
                    taskDataSyncDto.setServiceName(serviceName);
                }
                taskDataSyncDtoList.add(taskDataSyncDto);
            }
        }
        if (HussarUtils.isNotEmpty(taskDataSyncDtoList)) {
            this.taskDataSyncService.changeProcessState(taskDataSyncDtoList, QueryNoCodeBusinessDB.getNocodeBusinessDB());
        }
    }

    public void changeProcessNode(DataPush dataPush) {
        Map<String, String> wfdMap = this.getWfd(dataPush);
        TaskDataSyncDto taskDataSyncDto = this.getTableName(dataPush.getProcessDefinitionId(), wfdMap);
        if (HussarUtils.isEmpty((Object)taskDataSyncDto)) {
            return;
        }
        taskDataSyncDto.setProcessInstanceId(dataPush.getProcessInsId());
        taskDataSyncDto.setBusinessId(Long.valueOf(dataPush.getBusinessKey()));
        taskDataSyncDto.setProcessNode(dataPush.getProcessNode());
        if ("micro".equals(this.lcdpBpmProperties.getDeploymentModel())) {
            if (HussarUtils.isEmpty((Object)dataPush.getProcessKey())) {
                return;
            }
            String serviceName = this.modelService.getServiceName(dataPush.getProcessKey());
            taskDataSyncDto.setServiceName(serviceName);
        }
        this.taskDataSyncService.changeProcessNode(taskDataSyncDto, QueryNoCodeBusinessDB.getNocodeBusinessDB());
    }

    public TaskDataSyncDto getTableName(String processDefinitionId, Map<String, String> wfdMap) {
        if (HussarUtils.isEmpty(wfdMap)) {
            return null;
        }
        String result = wfdMap.get(processDefinitionId);
        FlowModel parse = (FlowModel)JSONObject.parseObject((String)result, FlowModel.class);
        FlowProps props = parse.getProps();
        ProcessBinding processBinding = props.getProcessBinding();
        if (processBinding == null) {
            return null;
        }
        String mainTableName = processBinding.getMainTableName();
        String taskTableName = processBinding.getTaskTableName();
        String mainTableBusinessKey = processBinding.getMainTableBusinessKey();
        if (HussarUtils.isEmpty((Object)mainTableName) || HussarUtils.isEmpty((Object)taskTableName) || HussarUtils.isEmpty((Object)mainTableBusinessKey)) {
            return null;
        }
        TaskDataSyncDto taskDataSyncDto = new TaskDataSyncDto();
        taskDataSyncDto.setBusinessTableName(mainTableName);
        taskDataSyncDto.setProcessTaskTableName(taskTableName);
        taskDataSyncDto.setPrimaryKeyColumnName(mainTableBusinessKey);
        return taskDataSyncDto;
    }

    public Map<String, String> getWfd(DataPush dataPush) {
        return null;
    }
}

