/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.unifiedtodatapush.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.unifiedtodatapush.util.UnifiedToDoDataPushProperties;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnifiedRequestHttpUtil {
    private static Logger logger = LoggerFactory.getLogger(UnifiedRequestHttpUtil.class);
    private static UnifiedToDoDataPushProperties unifiedToDoDataPushProperties;
    private static final String UNIFIED_CACHE_NAME = "unified";
    private static final String CLIENT_TOKEN_CACHE_KEY = "clientToken";
    private static final int MAX_RETRY_NUM = 2;

    @Autowired
    public void setUnifiedToDoDataPushProperties(UnifiedToDoDataPushProperties unifiedToDoDataPushProperties) {
        UnifiedRequestHttpUtil.unifiedToDoDataPushProperties = unifiedToDoDataPushProperties;
    }

    public static String sendPost(String url, String soap) {
        JSONObject jsonObject;
        String result;
        HashMap<String, String> headers = new HashMap<String, String>();
        int retryNum = 1;
        while (true) {
            logger.info("\u63a8\u9001\u8f7b\u9a91\u5175\u7edf\u4e00\u5f85\u529e\uff0c\u63a5\u53e3: {}", (Object)url);
            headers.put("Authorization", UnifiedRequestHttpUtil.getClientToken());
            String path = unifiedToDoDataPushProperties.getTenantCallAddress() + url;
            result = HttpClient.doPost((String)path, (String)soap, headers);
            jsonObject = JSON.parseObject((String)result);
            if (!"4100".equals(jsonObject.getString("code")) || retryNum++ > 2) break;
            logger.warn("token[{}]\u5931\u6548\uff0c\u5c06\u91cd\u8bd5\u4e00\u6b21", (Object)UnifiedRequestHttpUtil.getClientToken());
            UnifiedRequestHttpUtil.removeClientToken();
        }
        if (!"10000".equals(jsonObject.getString("code"))) {
            logger.error("{} \u63a5\u53e3\u5931\u8d25, msg: {}", (Object)url, jsonObject.get((Object)"msg"));
        }
        logger.info("\u63a5\u53e3\uff1a{} \u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)url, (Object)result);
        return result;
    }

    private static String getClientToken() {
        String token = (String)HussarCacheUtil.get((String)UNIFIED_CACHE_NAME, (Object)CLIENT_TOKEN_CACHE_KEY);
        if (token == null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("client-id", unifiedToDoDataPushProperties.getClientId());
            headers.put("client-secret", unifiedToDoDataPushProperties.getClientSecret());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "client_credentials");
            params.put("scope", unifiedToDoDataPushProperties.getClientScope());
            String url = unifiedToDoDataPushProperties.getTenantCallAddress() + "/oauth2/client_token";
            String response = HttpClient.doGet((String)url, params, headers);
            if (HussarUtils.isEmpty((Object)response)) {
                throw new BpmException(BpmExceptionCodeEnum.HTTP_REQUEST_EXCEPTION.format(new Object[]{url}));
            }
            JSONObject data = JSON.parseObject((String)response).getJSONObject("data");
            if (HussarUtils.isNotEmpty((Object)data)) {
                token = data.getString("client-token");
            }
            if (ToolUtil.isEmpty((Object)token)) {
                throw new BpmException(JSON.parseObject((String)response).getString("msg"));
            }
            HussarCacheUtil.put((String)UNIFIED_CACHE_NAME, (Object)CLIENT_TOKEN_CACHE_KEY, (Object)token, (long)Long.parseLong(data.getString("expires-in")));
        }
        return token;
    }

    private static void removeClientToken() {
        HussarCacheUtil.evict((String)UNIFIED_CACHE_NAME, (Object)CLIENT_TOKEN_CACHE_KEY);
    }
}

