/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.unifiedtodatapush.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.assignee.model.OrganOrPostInfo;
import com.jxdinfo.hussar.workflow.assignee.model.UserMainInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.BpmModuleTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.service.ISysBusinessModuleService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.ProcessDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskAddBatchDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskChangeDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskChangedDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskInfoWithUser;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskOrUserChangeDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.UnifiedProcessInfoExtend;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.UnifiedTaskInfoExtend;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.UnifiedTaskUserExtend;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.UserAddBatchDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.UserChangeDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.UserDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.UserDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.unifiedtodatapush.util.UnifiedToDoDataPushProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="tenantToDoDataPush")
public class TenantToDoDataPush
implements DataPushListener {
    private static Logger logger = LoggerFactory.getLogger(TenantToDoDataPush.class);
    @Autowired
    private UnifiedToDoDataPushProperties unifiedToDoDataPushProperties;
    @Autowired
    LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired
    @Lazy
    private ISysBusinessModuleService businessModuleService;
    public static final Map<String, String> APPROVAL_MAP = new HashMap<String, String>();

    private String getTenantCallAddress() {
        return this.unifiedToDoDataPushProperties.getTenantCallAddress();
    }

    private boolean isDataPush() {
        return true;
    }

    private void buildFormUrl(String form, UnifiedTaskInfoExtend unifiedTaskInfo) {
        if (HussarUtils.isEmpty((Object)form)) {
            return;
        }
        JSONObject formObject = JSON.parseObject((String)form);
        unifiedTaskInfo.setWebLinkurl(JSON.toJSONString((Object)formObject.get((Object)"web")).replace("\"", ""));
        unifiedTaskInfo.setMobileLinkurl(JSON.toJSONString((Object)formObject.get((Object)"mobile")).replace("\"", ""));
        unifiedTaskInfo.setWebUrlProps(JSON.toJSONString((Object)formObject.get((Object)"webUrlProps")).replace("\"", ""));
        unifiedTaskInfo.setMobileUrlProps(JSON.toJSONString((Object)formObject.get((Object)"mobileUrlProps")).replace("\"", ""));
    }

    <T> void checkReturnValue(ApiResponse<T> apiResponse) {
        if (!apiResponse.isSuccess()) {
            throw new PublicClientException(apiResponse.getMsg());
        }
    }

    public void addTask(DataPush dataPush, List<UserDataPush> userDataPushList) {
        TaskInfoWithUser taskInfoWithUser = new TaskInfoWithUser();
        UnifiedTaskInfoExtend unifiedTaskInfo = new UnifiedTaskInfoExtend();
        taskInfoWithUser.setTaskInfo(unifiedTaskInfo);
        unifiedTaskInfo.setTaskId(dataPush.getTaskId());
        unifiedTaskInfo.setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId()));
        unifiedTaskInfo.setSubject(dataPush.getDescription());
        unifiedTaskInfo.setCreateTime(dataPush.getStartDate());
        unifiedTaskInfo.setDeadLine(dataPush.getDeadLine());
        unifiedTaskInfo.setSendUserId(dataPush.getSendUser());
        this.buildFormUrl(dataPush.getUrl(), unifiedTaskInfo);
        unifiedTaskInfo.setTaskDefinitionkey(dataPush.getTaskDefinitionKey());
        unifiedTaskInfo.setTaskName(dataPush.getTaskDefinitionName());
        unifiedTaskInfo.setProcessInstanceid(dataPush.getProcessInsId());
        unifiedTaskInfo.setTaskStatus("1");
        unifiedTaskInfo.setComment(dataPush.getComment());
        if (HussarUtils.isNotEmpty(userDataPushList)) {
            ArrayList<UnifiedTaskUserExtend> unifiedTaskUsers = new ArrayList<UnifiedTaskUserExtend>();
            taskInfoWithUser.setTaskUsers(unifiedTaskUsers);
            for (UserDataPush userDataPush : userDataPushList) {
                UnifiedTaskUserExtend unifiedTaskUser = new UnifiedTaskUserExtend();
                unifiedTaskUsers.add(unifiedTaskUser);
                unifiedTaskUser.setUserId(userDataPush.getUserId());
                unifiedTaskUser.setDeptId(userDataPush.getDeptId());
                unifiedTaskUser.setUnitId(userDataPush.getUnitId());
                unifiedTaskUser.setPostId(userDataPush.getPostId());
                unifiedTaskUser.setUserType(userDataPush.getIsMain());
            }
        }
        this.buildAllOrganName(taskInfoWithUser);
        List tempUnifiedTaskUsers = taskInfoWithUser.getTaskUsers();
        if (tempUnifiedTaskUsers != null) {
            for (UnifiedTaskUserExtend unifiedTaskUserExtend : tempUnifiedTaskUsers) {
                TaskInfoWithUser tempTaskInfoWithUser = new TaskInfoWithUser();
                tempTaskInfoWithUser.setTaskInfo(taskInfoWithUser.getTaskInfo());
                tempTaskInfoWithUser.setTaskUsers(Collections.singletonList(unifiedTaskUserExtend));
                this.dataPushTodo(tempTaskInfoWithUser, "/remoteUnified/taskAdd");
            }
        } else {
            this.dataPushTodo(taskInfoWithUser, "/remoteUnified/taskAdd");
        }
    }

    public void completeTask(DataPush dataPush) {
        TaskUpdateDto taskUpdateDto = new TaskUpdateDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskId(dataPush.getTaskId()).setComment(dataPush.getComment()).setUpdateTaskType("3").setUpdateCompleteTime(dataPush.getEndDate());
        this.dataPushTodo(taskUpdateDto, "/remoteUnified/taskUpdate");
    }

    public void deleteTask(DataPush dataPush) {
        if (HussarUtils.isEmpty((Object)dataPush.getProcessInsId())) {
            return;
        }
        ProcessDeleteDto processDeleteDto = new ProcessDeleteDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setProcInstId(dataPush.getProcessInsId()).setTombstone(false);
        this.dataPushTodo(processDeleteDto, "/remoteUnified/processDelete");
    }

    public void entrustTask(DataPush dataPush, List<UserDataPush> addUserList) {
        ArrayList<UnifiedTaskUserExtend> unifiedTaskUsers;
        UserAddBatchDto userAddBatchDto;
        if (HussarUtils.isNotEmpty(addUserList)) {
            userAddBatchDto = new UserAddBatchDto();
            userAddBatchDto.setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId()));
            userAddBatchDto.setTaskId(dataPush.getTaskId());
            unifiedTaskUsers = new ArrayList<UnifiedTaskUserExtend>();
            userAddBatchDto.setTaskUsers(unifiedTaskUsers);
            for (UserDataPush userDataPush : addUserList) {
                UnifiedTaskUserExtend unifiedTaskUser = new UnifiedTaskUserExtend();
                unifiedTaskUsers.add(unifiedTaskUser);
                unifiedTaskUser.setUserId(userDataPush.getUserId());
                unifiedTaskUser.setDeptId(userDataPush.getDeptId());
                unifiedTaskUser.setUnitId(userDataPush.getUnitId());
                unifiedTaskUser.setUserType(userDataPush.getIsMain());
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getConsignor())) {
            userAddBatchDto = new UserAddBatchDto();
            userAddBatchDto.setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId()));
            userAddBatchDto.setTaskId(dataPush.getTaskId());
            unifiedTaskUsers = new ArrayList();
            userAddBatchDto.setTaskUsers(unifiedTaskUsers);
            for (String entrustUserId : dataPush.getConsignor().split(",")) {
                UnifiedTaskUserExtend unifiedTaskUser = new UnifiedTaskUserExtend();
                unifiedTaskUsers.add(unifiedTaskUser);
                unifiedTaskUser.setUserId(entrustUserId);
                unifiedTaskUser.setUserType("1");
            }
        } else {
            userAddBatchDto = null;
        }
        this.buildAllOrganName(userAddBatchDto);
        TaskOrUserChangeDto taskOrUserChangeDto = new TaskOrUserChangeDto();
        taskOrUserChangeDto.setUserDeleteDto(HussarUtils.isEmpty((Object)dataPush.getUserId()) ? null : new UserDeleteDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskId(dataPush.getTaskId()).setDeleteUserIds(this.getOutUserIdList(Arrays.asList(dataPush.getUserId().split(",")))));
        taskOrUserChangeDto.setUserAddBatchDto(userAddBatchDto);
        this.dataPushTodo(taskOrUserChangeDto, "/remoteUnified/userDeleteAndAdd");
    }

    public void rejectTask(DataPush dataPush) {
        TaskUpdateDto taskUpdateDto = new TaskUpdateDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskId(dataPush.getTaskId()).setUpdateTaskType("3").setComment(dataPush.getComment()).setUpdateCompleteTime(dataPush.getEndDate());
        this.dataPushTodo(taskUpdateDto, "/remoteUnified/taskUpdate");
    }

    public void revokeTask(DataPush dataPush) {
        TaskUpdateDto taskUpdateDto = new TaskUpdateDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskId(dataPush.getTaskId()).setUpdateTaskType("3").setComment(dataPush.getComment()).setUpdateCompleteTime(dataPush.getEndDate());
        this.dataPushTodo(taskUpdateDto, "/remoteUnified/taskUpdate");
    }

    public void freeJumpTask(DataPush dataPush) {
        TaskUpdateDto taskUpdateDto = new TaskUpdateDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskId(dataPush.getTaskId()).setUpdateTaskType("3").setComment(dataPush.getComment()).setUpdateCompleteTime(dataPush.getEndDate());
        this.dataPushTodo(taskUpdateDto, "/remoteUnified/taskUpdate");
    }

    public void addUser(DataPush dataPush) {
        if (HussarUtils.isEmpty((Object)dataPush.getUserId())) {
            return;
        }
        ArrayList<UnifiedTaskUserExtend> unifiedTaskUsers = new ArrayList<UnifiedTaskUserExtend>();
        UserAddBatchDto userAddBatchDto = new UserAddBatchDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskId(dataPush.getTaskId()).setTaskUsers(unifiedTaskUsers);
        for (String userId : dataPush.getUserId().split(",")) {
            UnifiedTaskUserExtend unifiedTaskUser = new UnifiedTaskUserExtend();
            unifiedTaskUsers.add(unifiedTaskUser);
            unifiedTaskUser.setUserId(userId);
            unifiedTaskUser.setUserType("1");
        }
        this.buildAllOrganName(userAddBatchDto);
        this.dataPushTodo(userAddBatchDto, "/remoteUnified/userAddBatch");
    }

    public void deleteMultiTask(DataPush dataPush) {
        if (HussarUtils.isEmpty((Object)dataPush.getTaskIds())) {
            return;
        }
        TaskDeleteDto taskDeleteDto = new TaskDeleteDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setComment(dataPush.getComment()).setTaskIds(dataPush.getTaskIds());
        this.dataPushTodo(taskDeleteDto, "/remoteUnified/taskDelete");
    }

    public void addCcTask(DataPush dataPushe) {
        if (HussarUtils.isEmpty((Object)dataPushe)) {
            return;
        }
        ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
        dataPushes.add(dataPushe);
        TaskAddBatchDto taskAddBatchDto = new TaskAddBatchDto();
        taskAddBatchDto.setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId()));
        taskAddBatchDto.setProcInstId(((DataPush)dataPushes.get(0)).getProcessInsId());
        ArrayList<TaskInfoWithUser> taskInfoWithUserList = new ArrayList<TaskInfoWithUser>();
        taskAddBatchDto.setTaskInfos(taskInfoWithUserList);
        for (DataPush push : dataPushes) {
            TaskInfoWithUser taskInfoWithUser = new TaskInfoWithUser();
            taskInfoWithUserList.add(taskInfoWithUser);
            UnifiedTaskInfoExtend unifiedTaskInfo = new UnifiedTaskInfoExtend();
            taskInfoWithUser.setTaskInfo(unifiedTaskInfo);
            unifiedTaskInfo.setTaskId(push.getDataPushId());
            unifiedTaskInfo.setSubject(push.getDescription());
            this.buildFormUrl(push.getUrl(), unifiedTaskInfo);
            unifiedTaskInfo.setTaskDefinitionkey(push.getTaskDefinitionKey());
            unifiedTaskInfo.setTaskName(push.getTaskDefinitionName());
            unifiedTaskInfo.setDeadLine(push.getDeadLine());
            unifiedTaskInfo.setTaskStatus("4");
            unifiedTaskInfo.setComment(push.getComment());
            UnifiedTaskUserExtend unifiedTaskUser = new UnifiedTaskUserExtend();
            unifiedTaskUser.setUserId(push.getUserId());
            unifiedTaskUser.setDeptId(push.getDeptId());
            unifiedTaskUser.setUnitId(push.getUnitId());
            unifiedTaskUser.setPostId(push.getPostId());
            unifiedTaskUser.setUserType(push.getUserType());
            taskInfoWithUser.setTaskUsers(Collections.singletonList(unifiedTaskUser));
        }
        this.buildAllOrganName(taskAddBatchDto);
        this.dataPushTodo(taskAddBatchDto, "/remoteUnified/taskAddBatch");
    }

    public void addCcTask(List<DataPush> dataPushes) {
        if (HussarUtils.isEmpty(dataPushes)) {
            return;
        }
        TaskAddBatchDto taskAddBatchDto = new TaskAddBatchDto();
        taskAddBatchDto.setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId()));
        taskAddBatchDto.setProcInstId(dataPushes.get(0).getProcessInsId());
        ArrayList<TaskInfoWithUser> taskInfoWithUserList = new ArrayList<TaskInfoWithUser>();
        taskAddBatchDto.setTaskInfos(taskInfoWithUserList);
        for (DataPush push : dataPushes) {
            TaskInfoWithUser taskInfoWithUser = new TaskInfoWithUser();
            taskInfoWithUserList.add(taskInfoWithUser);
            UnifiedTaskInfoExtend unifiedTaskInfo = new UnifiedTaskInfoExtend();
            taskInfoWithUser.setTaskInfo(unifiedTaskInfo);
            unifiedTaskInfo.setTaskId(push.getDataPushId());
            unifiedTaskInfo.setSubject(push.getDescription());
            this.buildFormUrl(push.getUrl(), unifiedTaskInfo);
            unifiedTaskInfo.setTaskDefinitionkey(push.getTaskDefinitionKey());
            unifiedTaskInfo.setTaskName(push.getTaskDefinitionName());
            unifiedTaskInfo.setDeadLine(push.getDeadLine());
            unifiedTaskInfo.setTaskStatus("4");
            unifiedTaskInfo.setComment(push.getComment());
            UnifiedTaskUserExtend unifiedTaskUser = new UnifiedTaskUserExtend();
            unifiedTaskUser.setUserId(push.getUserId());
            unifiedTaskUser.setDeptId(push.getDeptId());
            unifiedTaskUser.setUnitId(push.getUnitId());
            unifiedTaskUser.setPostId(push.getPostId());
            unifiedTaskUser.setUserType(push.getUserType());
            taskInfoWithUser.setTaskUsers(Collections.singletonList(unifiedTaskUser));
        }
        this.buildAllOrganName(taskAddBatchDto);
        this.dataPushTodo(taskAddBatchDto, "/remoteUnified/taskAddBatch");
    }

    public void readCcTask(List<DataPush> dataPushes) {
        List idList = dataPushes.stream().map(DataPush::getDataPushId).collect(Collectors.toList());
        TaskOrUserChangeDto taskOrUserChangeDto = new TaskOrUserChangeDto();
        taskOrUserChangeDto.setTaskChangeDto(new TaskChangeDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskIds(idList));
        taskOrUserChangeDto.setTaskChangedDto(new TaskChangedDto().setTaskType("5"));
        this.dataPushTodo(taskOrUserChangeDto, "/remoteUnified/taskChange");
        TaskOrUserChangeDto taskOrUserChangeDto1 = new TaskOrUserChangeDto();
        taskOrUserChangeDto1.setUserChangeDto(new UserChangeDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskIds(idList));
        taskOrUserChangeDto1.setUnifiedTaskUser(new UnifiedTaskUserExtend().setCompleteTime(new Date()));
        this.dataPushTodo(taskOrUserChangeDto1, "/remoteUnified/userChange");
    }

    public void readCcTask(DataPush dataPushe) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(dataPushe.getDataPushId());
        TaskOrUserChangeDto taskOrUserChangeDto = new TaskOrUserChangeDto();
        taskOrUserChangeDto.setTaskChangeDto(new TaskChangeDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskIds(idList));
        taskOrUserChangeDto.setTaskChangedDto(new TaskChangedDto().setComment(dataPushe.getComment()).setTaskType("5"));
        this.dataPushTodo(taskOrUserChangeDto, "/remoteUnified/taskChange");
        TaskOrUserChangeDto taskOrUserChangeDto1 = new TaskOrUserChangeDto();
        taskOrUserChangeDto1.setUserChangeDto(new UserChangeDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskIds(idList));
        taskOrUserChangeDto1.setUnifiedTaskUser(new UnifiedTaskUserExtend().setCompleteTime(new Date()));
        this.dataPushTodo(taskOrUserChangeDto1, "/remoteUnified/userChange");
    }

    public void deleteCcTask(DataPush dataPush) {
        TaskDeleteDto taskDeleteDto = new TaskDeleteDto().setTaskIds(Collections.singletonList(dataPush.getDataPushId())).setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId()));
        this.dataPushTodo(taskDeleteDto, "/remoteUnified/taskDelete");
    }

    public void addUrgeTask(DataPush dataPush) {
    }

    public void endProcess(DataPush dataPush) {
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            UserMainInfo mainInfo = this.getUserMainInfo(Collections.singleton(dataPush.getUserId()), this.unifiedToDoDataPushProperties.getUserIdType()).get(dataPush.getUserId());
            UnifiedTaskUserExtend unifiedTaskUser = new UnifiedTaskUserExtend().setCompleteTime(new Date());
            this.buildMainInfo(unifiedTaskUser, mainInfo);
            TaskOrUserChangeDto taskOrUserChangeDto = new TaskOrUserChangeDto();
            taskOrUserChangeDto.setUserChangeDto(new UserChangeDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskIds(dataPush.getTaskIds()).setUserTypes(Collections.singletonList("1")));
            taskOrUserChangeDto.setUnifiedTaskUser(unifiedTaskUser);
            this.dataPushTodo(taskOrUserChangeDto, "/remoteUnified/userChange");
            TaskOrUserChangeDto taskOrUserChangeDto1 = new TaskOrUserChangeDto();
            taskOrUserChangeDto1.setTaskChangeDto(new TaskChangeDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskIds(dataPush.getTaskIds()));
            taskOrUserChangeDto1.setTaskChangedDto(new TaskChangedDto().setComment(dataPush.getComment()).setTaskType("3"));
            this.dataPushTodo(taskOrUserChangeDto1, "/remoteUnified/taskChange");
        }
        TaskUpdateDto taskUpdateDto = new TaskUpdateDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskId(dataPush.getTaskId()).setUpdateTaskType("3").setComment(dataPush.getComment()).setUpdateCompleteTime(new Date());
        this.dataPushTodo(taskUpdateDto, "/remoteUnified/taskUpdate");
        TaskDeleteDto taskDeleteDto = new TaskDeleteDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setProcInstId(dataPush.getProcessInsId()).setComment(dataPush.getComment()).setTaskTypes(Arrays.asList("2", "1"));
        this.dataPushTodo(taskDeleteDto, "/remoteUnified/taskDelete");
    }

    public void transferTask(DataPush dataPush) {
    }

    public void reTransferTask(DataPush dataPush) {
    }

    public void updatePendingTask(List<TaskDataPush> dataPushList, DataPush dataPush) {
        TaskAddBatchDto taskAddBatchDto = this.buildTask(dataPushList, dataPush.getProcessInsId(), "2");
        TaskOrUserChangeDto taskOrUserChangeDto = new TaskOrUserChangeDto();
        taskOrUserChangeDto.setTaskDeleteDto(new TaskDeleteDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setProcInstId(dataPush.getProcessInsId()).setTaskTypes(Collections.singletonList("2")));
        taskOrUserChangeDto.setTaskAddBatchDto(taskAddBatchDto);
        this.dataPushTodo(taskOrUserChangeDto, "/remoteUnified/taskDeleteAndAdd");
    }

    public void updatePendingTaskUser(List<TaskDataPush> deleteDataPushList, List<TaskDataPush> addDataPushList, DataPush dataPush) {
        TaskAddBatchDto taskAddBatchDto = this.buildTask(addDataPushList, dataPush.getProcessInsId(), "2");
        TaskOrUserChangeDto taskOrUserChangeDto = new TaskOrUserChangeDto();
        taskOrUserChangeDto.setTaskDeleteDto(new TaskDeleteDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskIds(deleteDataPushList.stream().map(TaskDataPush::getDataPushId).collect(Collectors.toList())));
        taskOrUserChangeDto.setTaskAddBatchDto(taskAddBatchDto);
        this.dataPushTodo(taskOrUserChangeDto, "/remoteUnified/taskDeleteAndAdd");
    }

    public void addSubTask(List<TaskDataPush> dataPushList) {
        if (HussarUtils.isEmpty(dataPushList)) {
            return;
        }
        TaskAddBatchDto taskAddBatchDto = this.buildTask(dataPushList, dataPushList.get(0).getProcessInsId(), "1");
        this.dataPushTodo(taskAddBatchDto, "/remoteUnified/taskAddBatch");
    }

    public void completeSubTask(DataPush dataPush) {
        TaskUpdateDto taskUpdateDto = new TaskUpdateDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskId(dataPush.getDataPushId()).setUpdateTaskType("3").setComment(dataPush.getComment()).setUpdateCompleteTime(dataPush.getEndDate());
        this.dataPushTodo(taskUpdateDto, "/remoteUnified/taskUpdate");
    }

    public void updateSubTask(List<TaskDataPush> deleteDataPushList, List<TaskDataPush> addDataPushList, DataPush dataPush) {
        TaskAddBatchDto taskAddBatchDto = this.buildTask(addDataPushList, dataPush.getProcessInsId(), "1");
        TaskOrUserChangeDto taskOrUserChangeDto = new TaskOrUserChangeDto();
        taskOrUserChangeDto.setTaskDeleteDto(HussarUtils.isEmpty(deleteDataPushList) ? null : new TaskDeleteDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskIds(deleteDataPushList.stream().map(TaskDataPush::getDataPushId).collect(Collectors.toList())));
        taskOrUserChangeDto.setTaskAddBatchDto(taskAddBatchDto);
        this.dataPushTodo(taskOrUserChangeDto, "/remoteUnified/taskDeleteAndAdd");
    }

    public void createProcess(DataPush dataPush) {
        UnifiedProcessInfoExtend processInfo = new UnifiedProcessInfoExtend().setProcessKey(dataPush.getProcessKey()).setProcDefId(dataPush.getProcessDefinitionId()).setProcessName(dataPush.getProcessName()).setStartUserId(dataPush.getStartUserId()).setBusinessId(dataPush.getBusinessKey()).setProcInstId(dataPush.getProcessInsId()).setStartTime(dataPush.getStartDate()).setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setDeptId(dataPush.getDeptId()).setUnitId(dataPush.getUnitId()).setProcessState(dataPush.getProcessState());
        this.buildAllOrganName(processInfo);
        processInfo.setTenantCode(dataPush.getTenantCode());
        JSONObject formObject = JSON.parseObject((String)dataPush.getUrl());
        processInfo.setWebLinkurl(JSON.toJSONString((Object)formObject.get((Object)"web")).replace("\"", ""));
        processInfo.setMobileLinkurl(JSON.toJSONString((Object)formObject.get((Object)"mobile")).replace("\"", ""));
        processInfo.setWebUrlProps(JSON.toJSONString((Object)formObject.get((Object)"webUrlProps")).replace("\"", ""));
        processInfo.setMobileUrlProps(JSON.toJSONString((Object)formObject.get((Object)"mobileUrlProps")).replace("\"", ""));
        String processKey = dataPush.getProcessKey();
        List businessModelByBusinessKeys = this.businessModuleService.getBusinessModelByBusinessKeys(Collections.singleton(processKey));
        if (!businessModelByBusinessKeys.isEmpty()) {
            BpmModuleTreeModel bpmModuleTreeModel = (BpmModuleTreeModel)businessModelByBusinessKeys.get(0);
            processInfo.setBusinessModelName(bpmModuleTreeModel.getText());
            processInfo.setBusinessModelId(String.valueOf(bpmModuleTreeModel.getId()));
        }
        this.dataPushTodo(processInfo, "/remoteUnified/processAdd");
    }

    private List<String> getOutUserIdList(Collection<String> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, OrganOrPostInfo> organMap = this.getOrganMap(userIds, this.unifiedToDoDataPushProperties.getUserIdType());
        ArrayList<String> result = new ArrayList<String>();
        for (String userId : userIds) {
            OrganOrPostInfo organOrPostInfo = organMap.get(userId);
            if (organOrPostInfo == null) continue;
            result.add(organOrPostInfo.getId());
        }
        return result;
    }

    private void buildAllOrganName(TaskInfoWithUser taskInfoWithUser) {
        if (taskInfoWithUser == null) {
            return;
        }
        HashSet<String> organSet = new HashSet<String>();
        HashSet<String> postSet = new HashSet<String>();
        if (taskInfoWithUser.getTaskUsers() != null && !taskInfoWithUser.getTaskUsers().isEmpty()) {
            Set<String> userSet = taskInfoWithUser.getTaskUsers().stream().map(UnifiedTaskUserExtend::getUserId).collect(Collectors.toSet());
            Map<String, UserMainInfo> userMainInfo = this.getUserMainInfo(userSet, this.unifiedToDoDataPushProperties.getUserIdType());
            taskInfoWithUser.getTaskUsers().forEach(unifiedTaskUser -> this.buildMainInfo((UnifiedTaskUserExtend)unifiedTaskUser, (UserMainInfo)userMainInfo.get(unifiedTaskUser.getUserId())));
        }
        this.buildUserOrganSet(taskInfoWithUser.getTaskUsers(), organSet, postSet);
        this.buildTaskOrganSet(taskInfoWithUser.getTaskInfo(), organSet);
        Map<String, OrganOrPostInfo> organMap = this.getOrganMap(organSet, this.unifiedToDoDataPushProperties.getUserIdType());
        Map<String, OrganOrPostInfo> postMap = this.getPostMap(postSet);
        this.putUserOrganName(taskInfoWithUser.getTaskUsers(), organMap, postMap);
        this.putTaskOrganName(taskInfoWithUser.getTaskInfo(), organMap);
    }

    private void buildAllOrganName(UserAddBatchDto userAddBatchDto) {
        if (userAddBatchDto == null) {
            return;
        }
        HashSet<String> organSet = new HashSet<String>();
        HashSet<String> postSet = new HashSet<String>();
        Set<String> userSet = userAddBatchDto.getTaskUsers().stream().map(UnifiedTaskUserExtend::getUserId).collect(Collectors.toSet());
        Map<String, UserMainInfo> userMainInfo = this.getUserMainInfo(userSet, this.unifiedToDoDataPushProperties.getUserIdType());
        userAddBatchDto.getTaskUsers().forEach(unifiedTaskUser -> {
            UserMainInfo user = (UserMainInfo)userMainInfo.get(unifiedTaskUser.getUserId());
            this.buildMainInfo((UnifiedTaskUserExtend)unifiedTaskUser, user);
        });
        this.buildUserOrganSet(userAddBatchDto.getTaskUsers(), organSet, postSet);
        Map<String, OrganOrPostInfo> organMap = this.getOrganMap(organSet, this.unifiedToDoDataPushProperties.getUserIdType());
        Map<String, OrganOrPostInfo> postMap = this.getPostMap(postSet);
        this.putUserOrganName(userAddBatchDto.getTaskUsers(), organMap, postMap);
    }

    private void buildAllOrganName(TaskAddBatchDto taskAddBatchDto) {
        if (taskAddBatchDto == null) {
            return;
        }
        HashSet<String> organSet = new HashSet<String>();
        HashSet<String> userSet = new HashSet<String>();
        HashSet<String> postSet = new HashSet<String>();
        taskAddBatchDto.getTaskInfos().forEach(taskInfoWithUser -> taskInfoWithUser.getTaskUsers().forEach(user -> userSet.add(user.getUserId())));
        Map<String, UserMainInfo> userMainInfo = this.getUserMainInfo(userSet, this.unifiedToDoDataPushProperties.getUserIdType());
        taskAddBatchDto.getTaskInfos().forEach(taskInfoWithUser -> taskInfoWithUser.getTaskUsers().forEach(unifiedTaskUser -> {
            UserMainInfo user = (UserMainInfo)userMainInfo.get(unifiedTaskUser.getUserId());
            this.buildMainInfo((UnifiedTaskUserExtend)unifiedTaskUser, user);
        }));
        for (TaskInfoWithUser taskInfo : taskAddBatchDto.getTaskInfos()) {
            this.buildUserOrganSet(taskInfo.getTaskUsers(), organSet, postSet);
            this.buildTaskOrganSet(taskInfo.getTaskInfo(), organSet);
        }
        Map<String, OrganOrPostInfo> organMap = this.getOrganMap(organSet, this.unifiedToDoDataPushProperties.getUserIdType());
        Map<String, OrganOrPostInfo> postMap = this.getPostMap(postSet);
        for (TaskInfoWithUser taskInfo : taskAddBatchDto.getTaskInfos()) {
            this.putUserOrganName(taskInfo.getTaskUsers(), organMap, postMap);
            this.putTaskOrganName(taskInfo.getTaskInfo(), organMap);
        }
    }

    private void buildAllOrganName(UnifiedProcessInfoExtend unifiedProcessInfo) {
        OrganOrPostInfo unitInfo;
        OrganOrPostInfo deptInfo;
        if (unifiedProcessInfo == null) {
            return;
        }
        HashSet<String> organSet = new HashSet<String>();
        organSet.add(unifiedProcessInfo.getDeptId());
        organSet.add(unifiedProcessInfo.getUnitId());
        Map<String, OrganOrPostInfo> organMap = this.getOrganMap(organSet, this.unifiedToDoDataPushProperties.getUserIdType());
        Map<String, UserMainInfo> userMainInfo = this.getUserMainInfo(Collections.singleton(unifiedProcessInfo.getStartUserId()), this.unifiedToDoDataPushProperties.getUserIdType());
        UserMainInfo userInfo = userMainInfo.get(unifiedProcessInfo.getStartUserId());
        if (userInfo != null) {
            unifiedProcessInfo.setStartUserId(userInfo.getUserId());
            unifiedProcessInfo.setStartUserName(userInfo.getUserName());
            unifiedProcessInfo.setStartUserNumber(userInfo.getUserNumber());
        }
        if ((deptInfo = organMap.get(unifiedProcessInfo.getDeptId())) != null) {
            unifiedProcessInfo.setDeptId(deptInfo.getId());
            unifiedProcessInfo.setDeptName(deptInfo.getName());
        }
        if ((unitInfo = organMap.get(unifiedProcessInfo.getUnitId())) != null) {
            unifiedProcessInfo.setUnitId(unitInfo.getId());
            unifiedProcessInfo.setUnitName(unitInfo.getName());
        }
    }

    private Map<String, UserMainInfo> getUserMainInfo(Set<String> userSet, String userIdType) {
        return this.assigneeChooseService.getUserOutMainInfo(userSet, userIdType);
    }

    private void buildMainInfo(UnifiedTaskUserExtend unifiedTaskUser, UserMainInfo userMainInfo) {
        if (userMainInfo != null) {
            unifiedTaskUser.setUserId(userMainInfo.getUserId());
            unifiedTaskUser.setUserName(userMainInfo.getUserName());
            unifiedTaskUser.setMainUnitId(userMainInfo.getUnitId());
            unifiedTaskUser.setMainUnitName(userMainInfo.getUnitName());
            unifiedTaskUser.setMainDeptId(userMainInfo.getDeptId());
            unifiedTaskUser.setMainDeptName(userMainInfo.getDeptName());
            unifiedTaskUser.setMainPostId(userMainInfo.getPostId());
            unifiedTaskUser.setMainPostName(userMainInfo.getPostName());
            unifiedTaskUser.setUserNumber(userMainInfo.getUserNumber());
        }
    }

    private void buildUserOrganSet(Collection<UnifiedTaskUserExtend> users, Set<String> organSet, Set<String> postSet) {
        if (HussarUtils.isNotEmpty(users)) {
            for (UnifiedTaskUserExtend user : users) {
                organSet.add(user.getDeptId());
                organSet.add(user.getUnitId());
                postSet.add(user.getPostId());
            }
        }
    }

    private void putUserOrganName(Collection<UnifiedTaskUserExtend> users, Map<String, OrganOrPostInfo> organMap, Map<String, OrganOrPostInfo> postMap) {
        if (HussarUtils.isNotEmpty(users)) {
            for (UnifiedTaskUserExtend user : users) {
                OrganOrPostInfo postInfo;
                OrganOrPostInfo unitInfo;
                OrganOrPostInfo organInfo;
                OrganOrPostInfo userInfo = organMap.get(user.getUserId());
                if (userInfo != null) {
                    user.setUserId(userInfo.getId());
                    user.setUserName(userInfo.getName());
                }
                if ((organInfo = organMap.get(user.getDeptId())) != null) {
                    user.setDeptId(organInfo.getId());
                    user.setDeptName(organInfo.getName());
                }
                if ((unitInfo = organMap.get(user.getUnitId())) != null) {
                    user.setUnitId(unitInfo.getId());
                    user.setUnitName(unitInfo.getName());
                }
                if ((postInfo = postMap.get(user.getPostId())) == null) continue;
                user.setPostId(postInfo.getId());
                user.setPostName(postInfo.getName());
            }
        }
    }

    private void buildTaskOrganSet(Collection<UnifiedTaskInfoExtend> tasks, Set<String> organSet) {
        for (UnifiedTaskInfoExtend task : tasks) {
            this.buildTaskOrganSet(task, organSet);
        }
    }

    private void putTaskOrganName(Collection<UnifiedTaskInfoExtend> tasks, Map<String, OrganOrPostInfo> organMap) {
        for (UnifiedTaskInfoExtend task : tasks) {
            this.putTaskOrganName(task, organMap);
        }
    }

    private void buildTaskOrganSet(UnifiedTaskInfoExtend task, Set<String> organSet) {
        organSet.add(task.getSendUserId());
    }

    private void putTaskOrganName(UnifiedTaskInfoExtend task, Map<String, OrganOrPostInfo> organMap) {
        OrganOrPostInfo userInfo = organMap.get(task.getSendUserId());
        if (userInfo != null) {
            task.setSendUserId(userInfo.getId());
            task.setSendUserName(userInfo.getName());
        }
    }

    private Map<String, OrganOrPostInfo> getOrganMap(Collection<String> userSet, String userIdType) {
        return this.assigneeChooseService.getUserOutOrganInfo(userSet, userIdType);
    }

    private Map<String, OrganOrPostInfo> getPostMap(Set<String> postSet) {
        return this.assigneeChooseService.getUserOutPostInfo(postSet);
    }

    public void updateProcess(DataPush dataPush) {
        UnifiedProcessInfoExtend unifiedProcessInfo = new UnifiedProcessInfoExtend().setProcInstId(dataPush.getProcessInsId()).setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setEndTime(dataPush.getEndDate()).setProcessState(dataPush.getProcessState()).setProcessName(dataPush.getProcessName()).setStartUserId(dataPush.getStartUserId()).setStartTime(dataPush.getProcessStartTime()).setTenantCode(dataPush.getTenantCode()).setRectificationBusinessId(dataPush.getBusinessKey());
        if (HussarUtils.isNotEmpty((Object)dataPush.getUrl())) {
            JSONObject formObject = JSON.parseObject((String)dataPush.getUrl());
            unifiedProcessInfo.setWebLinkurl(JSON.toJSONString((Object)formObject.get((Object)"web")).replace("\"", ""));
            unifiedProcessInfo.setMobileLinkurl(JSON.toJSONString((Object)formObject.get((Object)"mobile")).replace("\"", ""));
            unifiedProcessInfo.setWebUrlProps(JSON.toJSONString((Object)formObject.get((Object)"webUrlProps")).replace("\"", ""));
            unifiedProcessInfo.setMobileUrlProps(JSON.toJSONString((Object)formObject.get((Object)"mobileUrlProps")).replace("\"", ""));
        }
        this.dataPushTodo(unifiedProcessInfo, "/remoteUnified/processUpdate");
    }

    public void assigneeUpdate(DataPush dataPush) {
        UnifiedTaskUserExtend unifiedTaskUser = new UnifiedTaskUserExtend().setUserId(dataPush.getUserId());
        this.buildMainInfo(unifiedTaskUser, this.getUserMainInfo(Collections.singleton(dataPush.getUserId()), this.unifiedToDoDataPushProperties.getUserIdType()).get(dataPush.getUserId()));
        unifiedTaskUser.setDeptId(unifiedTaskUser.getMainDeptId()).setDeptName(unifiedTaskUser.getMainDeptName()).setUnitId(unifiedTaskUser.getMainUnitId()).setUnitName(unifiedTaskUser.getMainUnitName()).setPostId(unifiedTaskUser.getMainPostId()).setPostName(unifiedTaskUser.getMainPostName());
        TaskOrUserChangeDto taskOrUserChangeDto = new TaskOrUserChangeDto();
        taskOrUserChangeDto.setUserChangeDto(new UserChangeDto().setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId())).setTaskIds(dataPush.getTaskIds()));
        taskOrUserChangeDto.setUnifiedTaskUser(unifiedTaskUser);
        this.dataPushTodo(taskOrUserChangeDto, "/remoteUnified/userChange");
    }

    private TaskAddBatchDto buildTask(List<TaskDataPush> dataPushList, String procInstId, String taskType) {
        TaskAddBatchDto taskAddBatchDto;
        if (HussarUtils.isEmpty(dataPushList)) {
            taskAddBatchDto = null;
        } else {
            taskAddBatchDto = new TaskAddBatchDto();
            taskAddBatchDto.setSystemId(Long.valueOf(this.unifiedToDoDataPushProperties.getSystemId()));
            taskAddBatchDto.setProcInstId(procInstId);
            ArrayList<TaskInfoWithUser> taskInfoWithUserList = new ArrayList<TaskInfoWithUser>();
            taskAddBatchDto.setTaskInfos(taskInfoWithUserList);
            for (TaskDataPush push : dataPushList) {
                TaskInfoWithUser taskInfoWithUser = new TaskInfoWithUser();
                taskInfoWithUserList.add(taskInfoWithUser);
                UnifiedTaskInfoExtend unifiedTaskInfo = new UnifiedTaskInfoExtend();
                taskInfoWithUser.setTaskInfo(unifiedTaskInfo);
                unifiedTaskInfo.setTaskId(push.getDataPushId());
                unifiedTaskInfo.setSubject(push.getDescription());
                this.buildFormUrl(push.getUrl(), unifiedTaskInfo);
                unifiedTaskInfo.setTaskDefinitionkey(push.getTaskDefinitionKey());
                unifiedTaskInfo.setTaskName(push.getTaskDefinitionName());
                unifiedTaskInfo.setDeadLine(push.getDeadLine());
                unifiedTaskInfo.setTaskStatus(taskType);
                unifiedTaskInfo.setComment(push.getComment());
                UnifiedTaskUserExtend unifiedTaskUser = new UnifiedTaskUserExtend();
                unifiedTaskUser.setUserId(push.getUserId());
                unifiedTaskUser.setDeptId(push.getDeptId());
                unifiedTaskUser.setUnitId(push.getUnitId());
                unifiedTaskUser.setPostId(push.getPostId());
                unifiedTaskUser.setUserType(push.getUserType());
                taskInfoWithUser.setTaskUsers(Collections.singletonList(unifiedTaskUser));
            }
        }
        this.buildAllOrganName(taskAddBatchDto);
        return taskAddBatchDto;
    }

    private void dataPushTodo(Object dataPush, String url) {
        logger.info("\u63a8\u9001\u79df\u6237\u7edf\u4e00\u5f85\u529e\uff0c\u63a5\u53e3: {}", (Object)url);
        String result = HttpClient.doPost((String)(this.unifiedToDoDataPushProperties.getUnifiedUrl() + url), (String)JSON.toJSONString((Object)dataPush));
        logger.info("\u63a8\u9001\u6570\u636e: {}", (Object)JSON.toJSONString((Object)dataPush));
        logger.info("\u63a5\u53e3\uff1a{} \u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)url, (Object)result);
    }

    static {
        APPROVAL_MAP.put("agree", "1");
        APPROVAL_MAP.put("disagree", "2");
        APPROVAL_MAP.put("accept", "3");
        APPROVAL_MAP.put("rectification", "4");
        APPROVAL_MAP.put("suspend", "5");
        APPROVAL_MAP.put("reject", "6");
    }
}

