/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.constant;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.UnexpectedException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;

public class BpmAttribute {
    public static final String SEND_USER = "sendUser";
    public static final String BPM_NEXT_NODE = "bpm_next_node";
    public static final String BPM_SUBMIT_SOURCE = "bpm_submit_source";
    public static final String JUMP_INFO = "jump_info";
    public static final String HISTORY_TASK = "history_task";
    public static final String HISTORY_ACTIVITY = "history_activity";
    public static final String APPOINT_ASSIGNEE = "appoint_assignee";
    public static final String ADD_ASSIGNEE_OPERATOR = "addAssigneeOperator";
    public static final String MULTI_ID = "multi_id";
    public static final String TASKSOURCE_FLAG = "taskSourceFlag";
    public static final String ALL_PREV_NODE = "all_prev_node";
    public static final String CALL_ACTIVITY_INFO = "call_activity_info";
    public static final String PROCESS_VARIABLES = "processVariables";
    public static final String BEAN_ID = "beanId";
    public static final String LISTENER_MODEL = "listenerModel";
    public static final String REQUEST_METHOD = "requestMethod";
    public static final String IS_EXTENSION = "isExtension";

    public static <T> T getContextAttribute(String key) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new UnexpectedException(BpmExceptionCodeEnum.NO_CONTEXT.getMessage());
        }
        Object attribute = commandContext.getAttribute(key);
        return (T)attribute;
    }

    public static void addCallActivityInfo(ActivityExecution execution, Object callActivityInfo) {
        if (HussarUtils.isNotEmpty((Object)callActivityInfo)) {
            execution.addTempVariable(CALL_ACTIVITY_INFO, callActivityInfo);
        }
    }

    public static void addCallActivityInfoForProcessVariablesListener(ActivityExecution execution, Object callActivityInfo) {
        if (HussarUtils.isNotEmpty((Object)callActivityInfo)) {
            JSONArray oldCallActivityInfos = BpmAttribute.getCallActivityInfo(execution);
            JSONArray newCallActivityInfos = JSONArray.parseArray((String)JSON.toJSONString((Object)callActivityInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            JSONArray newFilterCallActivityInfos = new JSONArray();
            if (HussarUtils.isNotEmpty((Object)oldCallActivityInfos)) {
                HashSet<String> taskDefinitionKeys = new HashSet<String>();
                for (int i = 0; i < newCallActivityInfos.size(); ++i) {
                    JSONObject object = (JSONObject)newCallActivityInfos.get(i);
                    if (!HussarUtils.isNotEmpty((Object)object.get((Object)"taskDefinitionKey"))) continue;
                    taskDefinitionKeys.add(String.valueOf(object.get((Object)"taskDefinitionKey")));
                    newFilterCallActivityInfos.add((Object)object);
                }
                JSONArray filterExist = new JSONArray();
                for (int i = 0; i < oldCallActivityInfos.size(); ++i) {
                    JSONObject object = (JSONObject)oldCallActivityInfos.get(i);
                    if (!HussarUtils.isNotEmpty((Object)object.get((Object)"taskDefinitionKey")) || taskDefinitionKeys.contains(String.valueOf(object.get((Object)"taskDefinitionKey")))) continue;
                    filterExist.add((Object)object);
                }
                JSONArray result = new JSONArray();
                result.addAll((Collection)filterExist);
                result.addAll((Collection)newFilterCallActivityInfos);
                execution.addTempVariable(CALL_ACTIVITY_INFO, (Object)result);
            } else {
                execution.addTempVariable(CALL_ACTIVITY_INFO, callActivityInfo);
            }
        }
    }

    public static JSONArray getCallActivityInfo(ActivityExecution execution) {
        Object callActivityInfo = BpmAttribute.getExecutionAttribute(execution, CALL_ACTIVITY_INFO);
        return callActivityInfo == null ? null : JSONArray.parseArray((String)JSON.toJSONString(callActivityInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    public static void addAllPrevNode(ActivityExecution execution, String taskDefKey, String allPrevNode) {
        HashMap<String, String> allPrevNodeMap = (HashMap<String, String>)BpmAttribute.getExecutionAttribute(execution, ALL_PREV_NODE);
        if (allPrevNodeMap == null) {
            allPrevNodeMap = new HashMap<String, String>();
            execution.addTempVariable(ALL_PREV_NODE, allPrevNodeMap);
        }
        allPrevNodeMap.put(taskDefKey, allPrevNode);
    }

    public static void addAllPrevNode(ActivityExecution execution, List<String> taskDefKeys, String allPrevNode) {
        HashMap<String, String> allPrevNodeMap = (HashMap<String, String>)BpmAttribute.getExecutionAttribute(execution, ALL_PREV_NODE);
        if (allPrevNodeMap == null) {
            allPrevNodeMap = new HashMap<String, String>();
            execution.addTempVariable(ALL_PREV_NODE, allPrevNodeMap);
        }
        for (String taskDefKey : taskDefKeys) {
            allPrevNodeMap.put(taskDefKey, allPrevNode);
        }
    }

    public static String getAllPrevNode(ActivityExecution execution, String taskDefKey) {
        Map allPrevNodeMap = (Map)BpmAttribute.getExecutionAttribute(execution, ALL_PREV_NODE);
        return allPrevNodeMap == null ? null : (String)allPrevNodeMap.get(taskDefKey);
    }

    public static String getTaskSourceFlag(ActivityExecution execution) {
        return (String)BpmAttribute.getExecutionAttribute(execution, TASKSOURCE_FLAG);
    }

    public static String getTaskSourceFlag(TaskEntity task) {
        return BpmAttribute.getTaskSourceFlag((ActivityExecution)task.getProcessInstance());
    }

    public static <T> T getExecutionAttribute(TaskEntity task, String key) {
        return BpmAttribute.getExecutionAttribute((ActivityExecution)task.getProcessInstance(), key);
    }

    public static <T> T getExecutionAttribute(ActivityExecution execution, String key) {
        Object tempVariable = ((ExecutionEntity)execution).getTempVariable(key);
        return (T)tempVariable;
    }

    public static <T> T getExecutionLocalAttribute(ActivityExecution execution, String key) {
        Object tempVariable = ((ExecutionEntity)execution).getLocalTempVariable(key);
        return (T)tempVariable;
    }

    public static void addProcessVariable(ActivityExecution execution, Map<String, Object> map) {
        if (HussarUtils.isNotEmpty(map)) {
            Map<String, Object> variableMap = (Map<String, Object>)execution.getTempVariable(PROCESS_VARIABLES);
            if (HussarUtils.isNotEmpty((Object)variableMap)) {
                variableMap.putAll(map);
            } else {
                variableMap = map;
            }
            execution.addTempVariable(PROCESS_VARIABLES, variableMap);
        }
    }
}

