/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuMultUser;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuMultUserService;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.service.WorkflowCommonCacheService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowOrganProcessUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.form.WorkflowAuthConfigQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActHandleAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysFormHandleAuthService")
@HussarTokenDs
public class SysActHandleAuthServiceImpl
extends ServiceImpl<SysActHandleAuthMapper, SysActHandleAuth>
implements SysActHandleAuthService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private SysActHandleAuthMapper sysActHandleAuthMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private WorkflowCommonCacheService workflowCommonCacheService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private IBpmActRuMultUserService bpmActRuMultUserService;
    @Autowired
    private TaskService taskService;
    private static final String IS_REQUIRE_COMMENT = "isRequireComment";
    private static final String IS_REQUIRE_SIGN = "isRequireSign";
    private static final String EXTEND_CONFIGURATION = "extendConfiguration";
    private static final List<String> HANDLE_AUTH_LIST = new ArrayList<String>();

    private List<SysActHandleAuth> getListByTaskId(String taskId, String formType) {
        String procDefId;
        Integer version;
        boolean changeSubmitType;
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).queryChildTask()).singleResult();
        if (historicTaskInstance == null) {
            return new ArrayList<SysActHandleAuth>();
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance.getEndTime())) {
            return new ArrayList<SysActHandleAuth>();
        }
        boolean bl = changeSubmitType = TaskType.isAssist((String)historicTaskInstance.getTaskType()) && HussarUtils.isEmpty((Object)historicTaskInstance.getEndTime());
        if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getEndTime())) {
            switch (formType) {
                case "2": {
                    formType = "1";
                    break;
                }
                case "4": {
                    formType = "5";
                    break;
                }
            }
        }
        if ((version = Integer.valueOf((procDefId = historicTaskInstance.getProcessDefinitionId()).split(":")[1])) <= 0) {
            version = Integer.valueOf(this.workflowCommonCacheService.getRealVersion(historicTaskInstance.getProcessDefinitionId()));
        }
        Integer conditionVersion = version;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
        String nodeId = CommonCodeUtil.getVisitorNodeId(historicTaskInstance.getTaskDefinitionKey(), bpmnModel);
        String processKey = historicTaskInstance.getProcessDefinitionId().split(":")[0];
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysActHandleAuth::getProcessKey, (Object)processKey);
        lambdaQueryWrapper.eq(SysActHandleAuth::getTaskDefinitionKey, (Object)nodeId);
        lambdaQueryWrapper.eq(SysActHandleAuth::getProcessVersion, (Object)conditionVersion);
        List list = this.sysActHandleAuthMapper.selectList((Wrapper)lambdaQueryWrapper);
        for (SysActHandleAuth sysActHandleAuth : list) {
            sysActHandleAuth.setTaskDefinitionKey(historicTaskInstance.getTaskDefinitionKey());
            if (!"Submit".equals(sysActHandleAuth.getHandleType()) || !changeSubmitType) continue;
            sysActHandleAuth.setHandleType("AssistSubmit");
        }
        if (changeSubmitType) {
            list = list.stream().filter(o -> o.getHandleType().equals("AssistSubmit")).collect(Collectors.toList());
        }
        return list;
    }

    public BpmResponseResult queryHandleAuthConfigs(String processKey, String taskDefintionKey, String processVersion, String taskId, String formType) {
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return InstallResult.fail((String)"");
        }
        JSONArray jsonArray = new JSONArray();
        List<Object> list = new ArrayList();
        if (HussarUtils.isEmpty((Object)taskId)) {
            try {
                if (HussarUtils.isEmpty((Object)processVersion)) {
                    processVersion = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null, null).split(":")[1];
                }
            }
            catch (PublicClientException e) {
                return InstallResult.fail((String)e.getReason());
            }
            list = this.sysActHandleAuthMapper.getHandleAuthWithoutRunning(processKey, processVersion, formType);
        } else {
            list = this.getListByTaskId(taskId, formType);
        }
        for (SysActHandleAuth sysActHandleAuth : list) {
            if ((!HussarUtils.isEmpty((Object)taskId) ? "Save".equals(sysActHandleAuth.getHandleType()) : HANDLE_AUTH_LIST.contains(sysActHandleAuth.getHandleType())) || ("2".equals(formType) ? "Revoke".equals(sysActHandleAuth.getHandleType()) : "1".equals(formType) && !"Revoke".equals(sysActHandleAuth.getHandleType()))) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("handleAuthId", (Object)sysActHandleAuth.getId());
            jsonObject.put("processDefinitionKey", (Object)sysActHandleAuth.getProcessKey());
            jsonObject.put("taskDefinitionKey", (Object)sysActHandleAuth.getTaskDefinitionKey());
            jsonObject.put("processVersion", (Object)String.valueOf(sysActHandleAuth.getProcessVersion()));
            jsonObject.put("handleName", (Object)sysActHandleAuth.getHandleName());
            jsonObject.put("handleType", (Object)sysActHandleAuth.getHandleType());
            jsonObject.put(EXTEND_CONFIGURATION, (Object)sysActHandleAuth.getExtendConfiguration());
            jsonObject.put("handleIcon", (Object)sysActHandleAuth.getHandleIcon());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.success((JSONArray)jsonArray);
    }

    public JSONArray getAllAuthConfigs(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        JSONArray jsonArray = new JSONArray();
        List<Object> list = new ArrayList();
        if (HussarUtils.isEmpty((Object)workflowAuthConfigQueryDto.getTaskId())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getProcessKey()), SysActHandleAuth::getProcessKey, (Object)workflowAuthConfigQueryDto.getProcessKey());
            Integer n = workflowAuthConfigQueryDto.getVersion();
            if (n == null) {
                Integer conditionVersion;
                try {
                    String processDefinitionId = WorkflowOrganProcessUtil.getStartOrganProcessId(workflowAuthConfigQueryDto.getProcessKey(), null, workflowAuthConfigQueryDto.getUserId(), workflowAuthConfigQueryDto.getOrganId(), !workflowAuthConfigQueryDto.isGetLastVersion());
                    conditionVersion = Integer.valueOf(processDefinitionId.split(":")[1]);
                }
                catch (BpmException e) {
                    return new JSONArray();
                }
                lambdaQueryWrapper.eq(SysActHandleAuth::getProcessVersion, (Object)conditionVersion);
            } else {
                lambdaQueryWrapper.eq(SysActHandleAuth::getProcessVersion, (Object)n);
            }
            String taskDefinitionKey = workflowAuthConfigQueryDto.getTaskDefinitionKey();
            if (HussarUtils.isNotEmpty((Object)taskDefinitionKey)) {
                List<String> taskDefinitionKeyList = Arrays.asList(taskDefinitionKey.split(","));
                lambdaQueryWrapper.in(SysActHandleAuth::getTaskDefinitionKey, taskDefinitionKeyList);
            } else {
                lambdaQueryWrapper.isNull(SysActHandleAuth::getTaskDefinitionKey);
            }
            String handleType = workflowAuthConfigQueryDto.getHandleType();
            if (HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getHandleType())) {
                lambdaQueryWrapper.like(SysActHandleAuth::getHandleType, (Object)handleType);
            }
            list = this.sysActHandleAuthMapper.selectList((Wrapper)lambdaQueryWrapper);
        } else {
            String taskId = workflowAuthConfigQueryDto.getTaskId();
            workflowAuthConfigQueryDto.setTaskId(RealTaskId.getRealTaskId(taskId));
            list = this.getListByTaskId(workflowAuthConfigQueryDto.getTaskId(), workflowAuthConfigQueryDto.getFormType());
        }
        for (SysActHandleAuth sysActHandleAuth : list) {
            if (HussarUtils.isEmpty((Object)workflowAuthConfigQueryDto.getTaskId())) {
                if (HANDLE_AUTH_LIST.contains(sysActHandleAuth.getHandleType())) {
                    continue;
                }
            } else {
                if ("2".equals(workflowAuthConfigQueryDto.getFormType()) && "DelAssignee".equals(sysActHandleAuth.getHandleType())) {
                    Task task = this.taskEngineService.getTask(workflowAuthConfigQueryDto.getTaskId(), "1");
                    if (HussarUtils.isNotEmpty((Object)task.getSeqMultiCount())) {
                        Long multiId = task.getMultiId() != null ? task.getMultiId() : Long.valueOf(task.getExecutionId());
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(BpmActRuMultUser::getMultiId, (Object)multiId);
                        queryWrapper.eq(BpmActRuMultUser::getAddAssigneeUserId, (Object)workflowAuthConfigQueryDto.getUserId());
                        List userList = this.bpmActRuMultUserService.list((Wrapper)queryWrapper);
                        if (HussarUtils.isEmpty((Object)userList)) {
                            continue;
                        }
                    } else {
                        List<String> assigneeList = CommonCodeUtil.queryMultiTodoAssignee(null, workflowAuthConfigQueryDto.getTaskDefinitionKey(), workflowAuthConfigQueryDto.getTaskId(), workflowAuthConfigQueryDto.getUserId());
                        if (HussarUtils.isEmpty(assigneeList)) continue;
                    }
                }
                if ("Save".equals(sysActHandleAuth.getHandleType())) continue;
                String taskId = workflowAuthConfigQueryDto.getTaskId();
                Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
                if (HussarUtils.isNotEmpty((Object)task) && "2".equals(task.getTaskType())) {
                    sysActHandleAuth.setHandleType("AssistSubmit");
                }
            }
            if ("2".equals(workflowAuthConfigQueryDto.getFormType()) ? "Revoke".equals(sysActHandleAuth.getHandleType()) : "1".equals(workflowAuthConfigQueryDto.getFormType()) && !"Revoke".equals(sysActHandleAuth.getHandleType())) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("handleAuthId", (Object)sysActHandleAuth.getId());
            jsonObject.put("processDefinitionKey", (Object)sysActHandleAuth.getProcessKey());
            jsonObject.put("taskDefinitionKey", (Object)sysActHandleAuth.getTaskDefinitionKey());
            jsonObject.put("processVersion", (Object)String.valueOf(sysActHandleAuth.getProcessVersion()));
            jsonObject.put("handleName", (Object)sysActHandleAuth.getHandleName());
            jsonObject.put(EXTEND_CONFIGURATION, (Object)sysActHandleAuth.getExtendConfiguration());
            jsonObject.put("handleIcon", (Object)sysActHandleAuth.getHandleIcon());
            jsonObject.put("handleType", (Object)sysActHandleAuth.getHandleType());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public BpmResponseResult queryHandleAuthConfigsByDto(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        return InstallResult.success((JSONArray)this.getAllAuthConfigs(workflowAuthConfigQueryDto));
    }

    public Map<String, Boolean> queryIsRequiredCommentSign(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        JSONArray allAuthConfigs = this.getAllAuthConfigs(workflowAuthConfigQueryDto);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        boolean isRequireComment = false;
        boolean isRequireSign = false;
        for (Object allAuthConfig : allAuthConfigs) {
            JSONObject authConfig = (JSONObject)allAuthConfig;
            JSONObject extendConfiguration = JSON.parseObject((String)authConfig.get((Object)EXTEND_CONFIGURATION).toString());
            if (HussarUtils.isNotEmpty((Object)extendConfiguration)) {
                isRequireComment = HussarUtils.isNotEmpty((Object)extendConfiguration.get((Object)IS_REQUIRE_COMMENT)) ? (Boolean)extendConfiguration.get((Object)IS_REQUIRE_COMMENT) : false;
                boolean bl = isRequireSign = HussarUtils.isNotEmpty((Object)extendConfiguration.get((Object)IS_REQUIRE_SIGN)) ? (Boolean)extendConfiguration.get((Object)IS_REQUIRE_SIGN) : false;
            }
            if (map.containsKey(IS_REQUIRE_COMMENT)) {
                if (isRequireComment) {
                    map.put(IS_REQUIRE_COMMENT, isRequireComment);
                }
            } else {
                map.put(IS_REQUIRE_COMMENT, isRequireComment);
            }
            if (map.containsKey(IS_REQUIRE_SIGN)) {
                if (!isRequireSign) continue;
                map.put(IS_REQUIRE_SIGN, isRequireSign);
                continue;
            }
            map.put(IS_REQUIRE_SIGN, isRequireSign);
        }
        return map;
    }

    public boolean insertBatch(List<SysActHandleAuth> list) {
        return this.sysActHandleAuthMapper.insertBatch(list);
    }

    static {
        HANDLE_AUTH_LIST.add("EndProcess");
        HANDLE_AUTH_LIST.add("EntrustTask");
        HANDLE_AUTH_LIST.add("FreeJump");
        HANDLE_AUTH_LIST.add("AddAssignee");
        HANDLE_AUTH_LIST.add("DelAssignee");
        HANDLE_AUTH_LIST.add("CoOrganize");
    }
}

