/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuMultUser;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuMultUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.model.ConfigUser;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.util.BpmMsgDetailBuildUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmHistoryTask;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;

public class ExtendSequentialMultiInstanceBehavior
extends SequentialMultiInstanceBehavior {
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getSpringContext().getBean(RepositoryService.class);
    private static ISysCalendarRefService sysCalendarRefService = (ISysCalendarRefService)BpmSpringContextHolder.getSpringContext().getBean(ISysCalendarRefService.class);
    private static SysActProcessFileService sysActProcessFileService = (SysActProcessFileService)BpmSpringContextHolder.getSpringContext().getBean(SysActProcessFileService.class);
    private static HistoryService historyService = (HistoryService)BpmSpringContextHolder.getSpringContext().getBean(HistoryService.class);
    private static ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)BpmSpringContextHolder.getSpringContext().getBean(ActivityRedisTimerService.class);
    private static ICandidateUserService candidateUserService = (ICandidateUserService)BpmSpringContextHolder.getSpringContext().getBean(ICandidateUserService.class);
    private static ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)BpmSpringContextHolder.getSpringContext().getBean(ISysActCcTaskService.class);
    private static DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);
    private static BpmMsgPushService msgPushService = (BpmMsgPushService)BpmSpringContextHolder.getSpringContext().getBean(BpmMsgPushService.class);
    private static IBpmActRuMultUserService bpmActRuMultUserService = (IBpmActRuMultUserService)BpmSpringContextHolder.getSpringContext().getBean(IBpmActRuMultUserService.class);
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);

    public ExtendSequentialMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    public void execute(ActivityExecution execution) throws Exception {
        if (this.getLocalLoopVariable(execution, this.getCollectionElementIndexVariable()) == null) {
            try {
                this.createInstances(execution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError((BpmnError)error, (ActivityExecution)execution);
            }
        } else {
            this.innerActivityBehavior.execute(execution);
        }
    }

    protected void createInstances(ActivityExecution execution) throws Exception {
        BpmnModel bm = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        ArrayList<String> messageType = new ArrayList<String>();
        List<ConfigUser> users = this.getUser(bm, execution, messageType);
        int nrOfInstances = users.size();
        int loopCounter = BpmAttribute.getContextAttribute("loopCounter") != null ? (Integer)BpmAttribute.getContextAttribute("loopCounter") : 0;
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), loopCounter);
        this.setLoopVariable(execution, "nrOfActiveInstances", 1);
        this.logLoopDetails(execution, "initialized", 0, 0, 1, nrOfInstances);
        if (nrOfInstances > 0) {
            HashMap<String, Object> ccUserMap = new HashMap();
            if (!TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution))) {
                ccUserMap = AnalyticalModelUtil.getCcUser(bm, execution);
            }
            ArrayList<BpmActRuMultUser> userList = new ArrayList<BpmActRuMultUser>();
            for (int i = 0; i < users.size(); ++i) {
                BpmActRuMultUser bpmActRuMultUser = new BpmActRuMultUser();
                Long multiId = (Long)BpmAttribute.getExecutionAttribute(execution, "multi_id");
                bpmActRuMultUser.setMultiId(multiId == null ? Long.valueOf(execution.getId()) : multiId);
                if (HussarUtils.isNotEmpty((Object)users.get(i))) {
                    bpmActRuMultUser.setUserId(users.get(i).getUserId());
                    bpmActRuMultUser.setOwnerId(users.get(i).getOwner());
                }
                bpmActRuMultUser.setSeqMultiCount(Integer.valueOf(i));
                bpmActRuMultUser.setProcInstId(Long.valueOf(Long.parseLong(execution.getProcessInstanceId())));
                userList.add(bpmActRuMultUser);
            }
            bpmActRuMultUserService.saveBatch(userList);
            this.bpmExecute(bm, execution, users, loopCounter, ccUserMap, messageType);
        } else {
            this.leave(execution);
        }
    }

    public void leave(ActivityExecution execution) {
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances");
        try {
            CommonCodeUtil.updateTodoConfiguration((DelegateExecution)execution);
        }
        catch (Exception e) {
            throw new BpmException(e.getMessage());
        }
        HashMap<String, Integer> taskLoopCount = new HashMap<String, Integer>();
        taskLoopCount.put("multiCount", loopCounter - 1);
        Context.getCommandContext().addAttribute(execution.getActivity().getId(), taskLoopCount);
        if (loopCounter != nrOfInstances && !this.completionConditionSatisfied(execution)) {
            this.callActivityEndListeners(execution);
        }
        this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), loopCounter);
        this.setLoopVariable(execution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        if (loopCounter >= nrOfInstances) {
            ((ExecutionEntity)execution).getParent().setAllPrevNode(((ExecutionEntity)execution).getActivityId());
            this.activityLeaveCcTask(execution);
            Long multiId = (Long)BpmAttribute.getExecutionAttribute(execution, "multi_id");
            multiId = multiId == null ? Long.valueOf(execution.getId()) : multiId;
            List taskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).taskDefinitionKey(((ExecutionEntity)execution).getActivityId())).list();
            HashSet<Long> multiIds = new HashSet<Long>();
            for (HistoricTaskInstance taskInstance : taskInstances) {
                multiIds.add(taskInstance.getMultiId());
            }
            multiIds.add(multiId);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BpmActRuMultUser::getMultiId, multiIds);
            this.bpmnActivityBehavior.performDefaultOutgoingBehavior(execution);
            bpmActRuMultUserService.remove((Wrapper)queryWrapper);
        } else {
            try {
                HistoricTaskInstance historicTaskInstance;
                BpmnModel bm = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
                ArrayList<String> messageType = new ArrayList<String>();
                ArrayList<ConfigUser> users = new ArrayList();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                Long multiId = (Long)BpmAttribute.getExecutionAttribute(execution, "multi_id");
                if (HussarUtils.isEmpty((Object)multiId) && HussarUtils.isNotEmpty((Object)(historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().executionId(execution.getId())).unfinished().singleResult()))) {
                    multiId = historicTaskInstance.getMultiId();
                }
                queryWrapper.eq(BpmActRuMultUser::getMultiId, (Object)(multiId == null ? Long.valueOf(execution.getId()) : multiId));
                List multUsers = bpmActRuMultUserService.list((Wrapper)queryWrapper);
                users = ConfigUser.buildConfigUser(multUsers);
                this.bpmExecute(bm, execution, users, loopCounter, null, messageType);
            }
            catch (BpmnError error) {
                throw error;
            }
            catch (Exception e) {
                throw new ActivitiException("Could not execute inner activity behavior of multi instance behavior", (Throwable)e);
            }
        }
    }

    public void bpmExecute(BpmnModel bm, ActivityExecution execution, List<ConfigUser> users, int loopCounter, Map<String, Object> ccUserMap, List<String> messageType) {
        String timeOutStrategy = null;
        FlowElement element = bm.getFlowElement(execution.getActivity().getId());
        List timeOutElement = (List)element.getExtensionElements().get("TimeOutStrategy");
        if (HussarUtils.isNotEmpty((Object)timeOutElement) && HussarUtils.isNotEmpty((Object)((ExtensionElement)timeOutElement.get(0)).getAttributes())) {
            timeOutStrategy = ((ExtensionAttribute)((List)((ExtensionElement)timeOutElement.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
        }
        ConfigUser user = users.get(loopCounter);
        TaskEntity skipTaskEntity = this.insertTask(execution, user, loopCounter, timeOutStrategy, ccUserMap, ConfigUser.getAppointAssignee(users), messageType);
        if (!TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) && HussarUtils.isNotEmpty((Object)user) && !"main_process_start".equals(BpmAttribute.getTaskSourceFlag(execution))) {
            ArrayList<ConfigUser> userList = new ArrayList<ConfigUser>();
            userList.add(user);
            List receiveUser = ConfigUser.getAllOwner(ArrayList::new, userList);
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
            bpmActMsgDetail.setProcessKey(((ExecutionEntity)execution).getProcessDefinitionKey());
            bpmActMsgDetail.setProcessName(((ExecutionEntity)execution).getProcessDefinition().getName());
            bpmActMsgDetail.setProcessDefinitionId(((ExecutionEntity)execution).getProcessDefinition().getId());
            bpmActMsgDetail.setTaskDefKey(((ExecutionEntity)execution).getActivityId());
            bpmActMsgDetail.setTaskDefName(execution.getCurrentActivityName());
            bpmActMsgDetail.setReceive(receiveUser);
            bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty(messageType) ? messageType.get(0) : null);
            if (TaskSourceFlag.isReject((String)BpmAttribute.getTaskSourceFlag(execution))) {
                bpmActMsgDetail.setSceneCode("reject");
            } else {
                bpmActMsgDetail.setSceneCode("todo");
            }
            if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
                bpmActMsgDetail.setTenantId(BaseSecurityUtil.getUser().getTenantId());
            }
            bpmActMsgDetailList.add(bpmActMsgDetail);
            msgPushService.pushMessage(bpmActMsgDetailList);
        }
        if (skipTaskEntity != null) {
            skipTaskEntity.setSendUser(skipTaskEntity.getAssignee());
            skipTaskEntity.setTaskSourceFlag("skip");
            skipTaskEntity.complete(null, false);
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(skipTaskEntity.getProcessDefinitionId());
            if (dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setBusinessKey(skipTaskEntity.getProcessInstance().getBusinessKey());
                dataPush.setProcessKey(skipTaskEntity.getProcessInstance().getProcessDefinitionKey());
                dataPush.setProcessInsId(skipTaskEntity.getProcessInstanceId());
                dataPush.setTaskId(skipTaskEntity.getId());
                dataPush.setTaskDefinitionKey(skipTaskEntity.getTaskDefinitionKey());
                dataPush.setTaskDefinitionName(skipTaskEntity.getName());
                dataPush.setUrl(skipTaskEntity.getFormKey());
                dataPush.setStartDate(skipTaskEntity.getCreateTime());
                dataPush.setUserId(skipTaskEntity.getAssignee());
                dataPush.setEndDate(new Date());
                dataPush.setProcessDefinitionId(skipTaskEntity.getProcessDefinitionId());
                dataPushService.completeDataPush(dataPush);
            }
        }
    }

    private List<ConfigUser> getUser(BpmnModel bm, ActivityExecution execution, List<String> messageType) {
        List<ConfigUser> configUserList = AnalyticalModelUtil.getEntrustCandidateUser(bm, ((ExecutionEntity)execution).getActivityId(), execution, false, null, messageType);
        Boolean notNeedCheckAssignee = (Boolean)Context.getCommandContext().getAttribute("notNeedCheckAssignee");
        if (notNeedCheckAssignee != null && !notNeedCheckAssignee.booleanValue() && HussarUtils.isEmpty(configUserList)) {
            throw new BpmException(BpmExceptionCodeEnum.NULL_ASSIGNEE);
        }
        if (HussarUtils.isEmpty(configUserList)) {
            configUserList.add(null);
        }
        return configUserList;
    }

    private TaskEntity insertTask(ActivityExecution execution, ConfigUser configUser, int loopCounter, String timeOutStrategy, Map<String, Object> ccUserMap, String appointAssignee, List<String> messageType) {
        boolean skip;
        Map extensionElementsNode;
        BpmnModel bm;
        TaskEntity task;
        block61: {
            String taskSourceFlag;
            Object formKey;
            Object category;
            Object priority;
            HistoricTaskInstance lastComplete;
            task = TaskEntity.create((Date)new Date());
            task.setSeqMultiCount(Integer.valueOf(loopCounter));
            task.setNewTask(true);
            task.setBpmExecution((DelegateExecution)execution);
            task.setProcessCycleCount(((ExecutionEntity)execution).getProcessCycleCount());
            Long multiId = (Long)BpmAttribute.getExecutionAttribute(execution, "multi_id");
            task.setMultiId(multiId == null ? Long.valueOf(execution.getId()) : multiId);
            task.setSuspensionState(((ExecutionEntity)execution).getProcessInstance().getSuspensionState());
            HashMap<String, Object> variable = (HashMap<String, Object>)execution.getProcessInstance().getTempVariable("processVariables");
            if (variable == null) {
                variable = new HashMap<String, Object>();
            }
            variable.putAll(execution.getProcessInstance().getVariables());
            task.setTodoConfiguration(AnalyticalModelUtil.getTodo(variable, AnalyticalModelUtil.getToDoConfiguration(execution.getProcessDefinitionId(), execution.getCurrentActivityId())));
            task.setCompleteType(BpmAttribute.getTaskSourceFlag(execution));
            JumpInfo jumpInfo = (JumpInfo)BpmAttribute.getContextAttribute("jump_info");
            task.setJumpInfo(JumpInfo.toJsonString((JumpInfo)jumpInfo));
            String allPrevNode = TaskSourceFlag.isRejectOrRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) && loopCounter == 0 ? ((lastComplete = BpmHistoryTask.getLastComplete(execution.getProcessInstanceId(), execution.getSubProcessKey(), execution.getCurrentActivityId(), 0)) == null ? null : lastComplete.getAllPrevNode()) : ((ExecutionEntity)execution).getAllPrevNode();
            task.setAllPrevNode(allPrevNode);
            task.insert((ExecutionEntity)execution);
            if (jumpInfo != null && jumpInfo.isJumpExecution() && HussarUtils.isNotEmpty((Object)jumpInfo.getJumpFromExecutionInfo())) {
                task.setVariableLocal("jump_execution_info", (Object)jumpInfo.getJumpFromExecutionInfo());
            }
            task.setAppointAssignee(appointAssignee);
            TaskDefinition taskDefinition = (TaskDefinition)execution.getActivity().getProperty("taskDefinition");
            Expression activeNameExpression = null;
            Expression activeDescriptionExpression = null;
            Expression activeDueDateExpression = null;
            Expression activePriorityExpression = null;
            Expression activeCategoryExpression = null;
            Expression activeFormKeyExpression = null;
            Expression activeSkipExpression = null;
            Expression activeAssigneeExpression = null;
            Expression activeOwnerExpression = null;
            Set<Expression> activeCandidateUserExpressions = null;
            Set<Expression> activeCandidateGroupExpressions = null;
            if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
                ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties((String)execution.getActivity().getId(), (String)execution.getProcessDefinitionId());
                activeNameExpression = this.getActiveValue(taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
                taskDefinition.setNameExpression(activeNameExpression);
                activeDescriptionExpression = this.getActiveValue(taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
                taskDefinition.setDescriptionExpression(activeDescriptionExpression);
                activeDueDateExpression = this.getActiveValue(taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
                taskDefinition.setDueDateExpression(activeDueDateExpression);
                activePriorityExpression = this.getActiveValue(taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
                taskDefinition.setPriorityExpression(activePriorityExpression);
                activeCategoryExpression = this.getActiveValue(taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
                taskDefinition.setCategoryExpression(activeCategoryExpression);
                activeFormKeyExpression = this.getActiveValue(taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
                taskDefinition.setFormKeyExpression(activeFormKeyExpression);
                activeSkipExpression = this.getActiveValue(taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
                taskDefinition.setSkipExpression(activeSkipExpression);
                activeAssigneeExpression = this.getActiveValue(taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
                taskDefinition.setAssigneeExpression(activeAssigneeExpression);
                activeOwnerExpression = this.getActiveValue(taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
                taskDefinition.setOwnerExpression(activeOwnerExpression);
                activeCandidateUserExpressions = this.getActiveValueSet(taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
                taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
                activeCandidateGroupExpressions = this.getActiveValueSet(taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
                taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
            } else {
                activeNameExpression = taskDefinition.getNameExpression();
                activeDescriptionExpression = taskDefinition.getDescriptionExpression();
                activeDueDateExpression = taskDefinition.getDueDateExpression();
                activePriorityExpression = taskDefinition.getPriorityExpression();
                activeCategoryExpression = taskDefinition.getCategoryExpression();
                activeFormKeyExpression = taskDefinition.getFormKeyExpression();
            }
            task.setTaskDefinition(taskDefinition);
            if (activeNameExpression != null) {
                String name = null;
                try {
                    name = (String)activeNameExpression.getValue((VariableScope)execution);
                }
                catch (ActivitiException e) {
                    name = activeNameExpression.getExpressionText();
                    LOGGER.warn("property not found in task name expression {}", (Object)e.getMessage());
                }
                task.setName(name);
            }
            if (activeDescriptionExpression != null) {
                String description = null;
                try {
                    description = (String)activeDescriptionExpression.getValue((VariableScope)execution);
                }
                catch (ActivitiException e) {
                    description = activeDescriptionExpression.getExpressionText();
                    LOGGER.warn("property not found in task description expression {}", (Object)e.getMessage());
                }
                task.setDescription(description);
            }
            bm = repositoryService.getBpmnModel(task.getProcessDefinitionId());
            if (activeDueDateExpression != null) {
                FlowElement element = bm.getFlowElement(execution.getActivity().getId());
                List chosenDayElement = (List)element.getExtensionElements().get("chosenDay");
                String chosenDay = null;
                if (HussarUtils.isNotEmpty((Object)chosenDayElement) && HussarUtils.isNotEmpty((Object)((ExtensionElement)chosenDayElement.get(0)).getAttributes())) {
                    chosenDay = ((ExtensionAttribute)((List)((ExtensionElement)chosenDayElement.get(0)).getAttributes().get("chosenDay")).get(0)).getValue();
                }
                if ("workingDay".equals(chosenDay)) {
                    Date nowDate = new Date();
                    Instant instant = nowDate.toInstant();
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                    LocalDateTime dueTime = sysCalendarRefService.getDueDateDefult(localDateTime, String.valueOf(activeDueDateExpression), true);
                    ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                    Instant instant2 = zonedDateTime.toInstant();
                    Date dueDate = Date.from(instant2);
                    task.setDueDate(dueDate);
                } else {
                    Object dueDate = activeDueDateExpression.getValue((VariableScope)execution);
                    if (dueDate != null) {
                        if (dueDate instanceof Date) {
                            task.setDueDate((Date)dueDate);
                        } else if (dueDate instanceof String) {
                            BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(taskDefinition.getBusinessCalendarNameExpression().getValue((VariableScope)execution).toString());
                            task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
                        } else {
                            throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
                        }
                    }
                }
            }
            if (activePriorityExpression != null && (priority = activePriorityExpression.getValue((VariableScope)execution)) != null) {
                if (priority instanceof String) {
                    try {
                        task.setPriority(Integer.parseInt((String)priority));
                    }
                    catch (NumberFormatException e) {
                        throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                    }
                } else if (priority instanceof Number) {
                    task.setPriority(((Number)priority).intValue());
                } else {
                    throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
                }
            }
            if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue((VariableScope)execution)) != null) {
                if (category instanceof String) {
                    task.setCategory((String)category);
                } else {
                    throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
                }
            }
            if (activeFormKeyExpression != null && (formKey = activeFormKeyExpression.getValue((VariableScope)execution)) != null) {
                if (formKey instanceof String) {
                    task.setFormKey((String)formKey);
                } else {
                    throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
                }
            }
            String processKey = task.getProcessDefinitionId().split(":")[0];
            String processVersion = task.getProcessDefinitionId().split(":")[1];
            String processFormId = modelService.getProcessFormId(processKey, Integer.valueOf(processVersion));
            task.setFormId(processFormId);
            extensionElementsNode = bm.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements();
            skip = false;
            String repeatUser = null;
            if (extensionElementsNode.get("skiprepetition") == null) break block61;
            String skipTypeValue = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("skiprepetition")).get(0)).getAttributes().get("skiprepetition")).get(0)).getValue();
            List hisTaskList = ((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).listPage(0, 1);
            if (hisTaskList == null || hisTaskList.isEmpty() || (taskSourceFlag = BpmAttribute.getTaskSourceFlag(execution)) != null && !TaskSourceFlag.isComplete((String)taskSourceFlag)) break block61;
            List<String> skipList = Arrays.asList(skipTypeValue.split(","));
            if (skipList.contains("1") && configUser == null) {
                if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                    activityRedisTimer.delTimeOutModel(task.getId());
                }
                skip = true;
            }
            ArrayList<String> lastNodeAssignees = new ArrayList<String>();
            if (skipList.contains("3")) {
                List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).subProcessKey(task.getSubProcessKey())).list();
                historicTaskInstances.removeIf(historicTaskInstance -> historicTaskInstance.getEndTime() == null);
                historicTaskInstances.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                Map<String, List<HistoricTaskInstance>> historicTaskInstancesMap = WorkflowBpmUtil.getListMap(historicTaskInstances, TaskInfo::getTaskDefinitionKey, null);
                historicTaskInstancesMap.remove(execution.getCurrentActivityId());
                ArrayList<HistoricTaskInstance> lastTask = new ArrayList<HistoricTaskInstance>();
                for (List list : historicTaskInstancesMap.values()) {
                    if (HussarUtils.isNotEmpty((Object)list) && ((HistoricTaskInstance)list.get(0)).getSubProcessKey() != null) {
                        Map<String, List<HistoricTaskInstance>> subProcessHistoricTaskInstancesMap = WorkflowBpmUtil.getListMap(list, HistoricTaskInstance::getSubProcessKey, null);
                        for (List<HistoricTaskInstance> subProcessHistoricTaskInstancesList : subProcessHistoricTaskInstancesMap.values()) {
                            CommonCodeUtil.getLastTaskCompleted(subProcessHistoricTaskInstancesList, lastTask);
                        }
                        continue;
                    }
                    CommonCodeUtil.getLastTaskCompleted(list, lastTask);
                }
                if (HussarUtils.isNotEmpty(lastTask)) {
                    lastTask.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                    for (HistoricTaskInstance historicTaskInstance2 : lastTask) {
                        String assignee = historicTaskInstance2.getOriginalAssignee();
                        if (!HussarUtils.isNotEmpty((Object)assignee)) continue;
                        lastNodeAssignees.add(assignee);
                    }
                }
            } else if (skipList.contains("2")) {
                String lastActivityId = task.getAllPrevNode();
                Long queryMulti = multiId == null ? Long.valueOf(execution.getId()) : multiId;
                List historicTaskList = ((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().multiId(queryMulti)).list();
                if (HussarUtils.isNotEmpty((Object)historicTaskList)) {
                    for (HistoricTaskInstance historicTaskInstance3 : historicTaskList) {
                        if (historicTaskInstance3.getSeqMultiCount() == null || historicTaskInstance3.getSeqMultiCount() != 0) continue;
                        lastActivityId = historicTaskInstance3.getAllPrevNode();
                    }
                }
                if (HussarUtils.isNotEmpty((Object)lastActivityId)) {
                    List<String> lastTaskDefinitionKeyList = Arrays.asList(lastActivityId.split(","));
                    for (String taskDefinitionKey : lastTaskDefinitionKeyList) {
                        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(taskDefinitionKey)).subProcessKey(task.getSubProcessKey())).list();
                        historicTaskInstances.removeIf(historicTaskInstance -> historicTaskInstance.getEndTime() == null);
                        historicTaskInstances.sort(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed());
                        CommonCodeUtil.getLastCompleted(historicTaskInstances, lastNodeAssignees);
                    }
                }
            }
            if (configUser != null) {
                Set<String> userIdList = ConfigUser.getAllUserId(Collections.singletonList(configUser));
                for (String lastNodeAssignee : lastNodeAssignees) {
                    if (!userIdList.contains(lastNodeAssignee)) continue;
                    task.setAssignee(lastNodeAssignee);
                    skip = true;
                    repeatUser = lastNodeAssignee;
                    if (!HussarUtils.isNotEmpty((Object)task.getDueDate())) break;
                    activityRedisTimer.delTimeOutModel(task.getId());
                    break;
                }
            }
        }
        String delayToAssign = "";
        if (extensionElementsNode.get("delayToAssign") != null) {
            delayToAssign = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("delayToAssign")).get(0)).getAttributes().get("delayToAssign")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)configUser)) {
            if (!"true".equals(delayToAssign) || loopCounter != 0) {
                ConfigUser.recursionUser(user -> task.addCandidateUser(user.getUserId(), user.getOwner(), "1"), Collections.singletonList(configUser));
            } else {
                String taskId = task.getId();
                ArrayList candidateUserList = new ArrayList();
                ConfigUser.recursionUser(user -> {
                    CandidateUser tmp = new CandidateUser();
                    tmp.setTaskId(Long.valueOf(Long.parseLong(taskId)));
                    tmp.setAssignee(user.taskOwner());
                    candidateUserList.add(tmp);
                }, Collections.singletonList(configUser));
                candidateUserService.saveBatch(candidateUserList);
            }
        }
        task.fireEvent("create");
        if (HussarUtils.isNotEmpty(ccUserMap)) {
            List ccUsers = (List)ccUserMap.get("ccUser");
            String sendUserId = (String)ccUserMap.get("ccSendUser");
            if (HussarUtils.isNotEmpty((Object)ccUsers) && HussarUtils.isNotEmpty((Object)sendUserId)) {
                this.ccTask((Task)task, ccUsers, sendUserId, execution, bm, messageType);
            }
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        if (!skip && HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy)) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getDueDate());
            if (HussarUtils.isNotEmpty((Object)configUser)) {
                timeOutModel.setAssignee(String.join((CharSequence)",", ConfigUser.getAllOwner(Collections.singletonList(configUser))));
            }
            timeOutModel.setTimeOutType(timeOutStrategy);
            if (timeOutModel.getTimeOutType().startsWith("http") || "urging".equals(timeOutModel.getTimeOutType())) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", task.getName());
                map.put("processInsId", task.getProcessInstanceId());
                map.put("processDefinitionId", task.getProcessDefinitionId());
                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                map.put("formKey", task.getFormKey());
                map.put("businessId", execution.getProcessBusinessKey());
                map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
                map.put("todoConfiguration", task.getTodoConfiguration());
                map.put("sendUser", task.getSendUser());
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            activityRedisTimer.addTimeOutModel(timeOutModel);
        }
        if (loopCounter != 0) {
            String user2 = null;
            if (HussarUtils.isNotEmpty((Object)configUser)) {
                user2 = ConfigUser.getAllUserId(Collections.singletonList(configUser)).iterator().next();
            }
            this.insertActHiActinst(execution, user2, task);
        }
        task.fireEvent("start");
        if (skip) {
            return task;
        }
        return null;
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Object activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.isEmpty()) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    private void ccTask(Task task, List<String> users, String userId, ActivityExecution execution, BpmnModel bpmnModel, List<String> messageType) {
        if (users.isEmpty()) {
            return;
        }
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        if (processInstance != null) {
            List ccFormKeyList;
            Object ccFormKeyMap;
            List ccElement = (List)bpmnModel.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            for (String user : users) {
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(formKey);
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setProcDefId(processInstance.getProcessDefinitionId());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                sysActCcTask.setTaskState("0");
                sysActCcTask.setCcMoment("0");
                sysActCcTask.setToDoConfig(task.getTodoConfiguration());
                sysActCcTask.setFormId(task.getFormId());
                list.add(sysActCcTask);
            }
        }
        if (!list.isEmpty()) {
            iSysActCcTaskService.saveBatch(list);
        }
        if (!TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) && !"main_process_start".equals(BpmAttribute.getTaskSourceFlag(execution))) {
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = BpmMsgDetailBuildUtil.taskMsgDetail((TaskEntity)task, users, "circulate");
            String type = HussarUtils.isNotEmpty(messageType) ? messageType.get(0) : null;
            ArrayList<String> newMessageType = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)type)) {
                String[] typeList;
                for (String v : typeList = type.split(",")) {
                    if (!"app_im".equals(v) && !"station_message".equals(v)) continue;
                    newMessageType.add(v);
                }
            }
            bpmActMsgDetail.setChannelType(!HussarUtils.isEmpty(newMessageType) ? String.join((CharSequence)",", newMessageType) : null);
            bpmActMsgDetailList.add(bpmActMsgDetail);
            msgPushService.pushMessage(bpmActMsgDetailList);
        }
    }

    private void insertActHiActinst(ActivityExecution execution, String userId, TaskEntity task) {
        IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInsId = execution.getProcessInstanceId();
        String executionId = execution.getId();
        HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
        historicActivityInstance.setId(idGenerator.getNextId());
        historicActivityInstance.setProcessDefinitionId(processDefinitionId);
        historicActivityInstance.setProcessInstanceId(processInsId);
        historicActivityInstance.setExecutionId(executionId);
        historicActivityInstance.setActivityId(execution.getActivity().getId());
        historicActivityInstance.setActivityName((String)execution.getActivity().getProperty("name"));
        historicActivityInstance.setActivityType((String)execution.getActivity().getProperty("type"));
        historicActivityInstance.setStartTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        historicActivityInstance.setAssignee(userId);
        historicActivityInstance.setTaskId(task.getId());
        String separatedVariable = execution.getSubProcessKey();
        if (HussarUtils.isNotEmpty((Object)separatedVariable)) {
            Integer cycleCount = ((ExecutionEntity)execution).getCycleCount();
            historicActivityInstance.setSubProcessKey(separatedVariable);
            historicActivityInstance.setCycleCount(cycleCount);
        }
        historicActivityInstance.setProcessCycleCount(((ExecutionEntity)execution).getProcessCycleCount());
        ((DbSqlSession)Context.getCommandContext().getSession(DbSqlSession.class)).insert((PersistentObject)historicActivityInstance);
    }

    private void activityLeaveCcTask(ActivityExecution execution) {
        if ("callActivity".equals(execution.getActivity().getProperty("type")) || "subProcess".equals(execution.getActivity().getProperty("type"))) {
            return;
        }
        BpmnModel bm = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        Map<String, Object> ccUserMap = AnalyticalModelUtil.getCcEndUser(bm, execution);
        List ccUserIds = (List)ccUserMap.get("ccUser");
        String ccSendUser = (String)ccUserMap.get("ccSendUser");
        if (!ccUserIds.isEmpty()) {
            Object ccFormKeyList;
            Map ccFormKeyMap;
            String processInsId = execution.getProcessInstanceId();
            String taskDefKey = execution.getCurrentActivityId();
            String subProcessKey = execution.getSubProcessKey();
            if (ccUserIds.isEmpty()) {
                return;
            }
            List hisTaskList = Context.getCommandContext().getTaskEntityManager().findAllHistoricTask(processInsId, taskDefKey, subProcessKey);
            hisTaskList.sort((o1, o2) -> o2.getEndTime().compareTo(o1.getEndTime()));
            List<String> userIds = AnalyticalModelUtil.getMultiInstanceUser(hisTaskList);
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
            ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            List ccElement = (List)bm.getFlowElement(historicTaskInstance.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
            String formKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
            }
            ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
            for (String user : ccUserIds) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(historicTaskInstance.getId());
                dataPush.setUserId(user);
                dataPush.setCcMoment("1");
                dataPush.setStartDate((Date)ts);
                dataPush.setProcessInsId(execution.getProcessInstanceId());
                dataPushList.add(dataPush);
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(historicTaskInstance.getProcessInstanceId())));
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(historicTaskInstance.getId())));
                sysActCcTask.setTaskName(historicTaskInstance.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(ccSendUser);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(formKey);
                sysActCcTask.setTaskDefKey(historicTaskInstance.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setProcDefId(processInstance.getProcessDefinitionId());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                sysActCcTask.setTaskState("0");
                sysActCcTask.setCcMoment("1");
                sysActCcTask.setToDoConfig(historicTaskInstance.getTodoConfiguration());
                sysActCcTask.setFormId(historicTaskInstance.getFormId());
                if (userIds.contains(sysActCcTask.getReceiveUser())) {
                    sysActCcTask.setTaskState("1");
                    sysActCcTask.setEndTime(sysActCcTask.getSendTime());
                    dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                }
                list.add(sysActCcTask);
            }
            dataPushService.addCcTask(dataPushList);
            if (!list.isEmpty()) {
                iSysActCcTaskService.saveBatch(list);
            }
            if (!TaskSourceFlag.isRevoke((String)BpmAttribute.getTaskSourceFlag(execution)) && !"main_process_start".equals(BpmAttribute.getTaskSourceFlag(execution))) {
                ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
                BpmActMsgDetail bpmActMsgDetail = BpmMsgDetailBuildUtil.taskMsgDetail((HistoricTaskInstanceEntity)historicTaskInstance, (List<String>)ccUserIds, "circulate");
                bpmActMsgDetailList.add(bpmActMsgDetail);
                msgPushService.pushMessage(bpmActMsgDetailList);
            }
        }
    }
}

