/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuMultUser;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuMultUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.common.model.ConfigUser;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.RevokeAddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendSequentialMultiInstanceBehavior;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.util.ActivityMultiBehaviorUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class SequentialMultiInnerJumpCmd
implements Command<Void> {
    private TaskEntity task;
    private HistoricTaskInstanceEntity historicTaskInstanceEntity;
    private String userId;
    private String mandator;
    private String comment;
    private SysActCcTaskMapper sysActCcTaskMapper = (SysActCcTaskMapper)BpmSpringContextHolder.getBean(SysActCcTaskMapper.class);
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private static IBpmActRuMultUserService bpmActRuMultUserService = (IBpmActRuMultUserService)BpmSpringContextHolder.getSpringContext().getBean(IBpmActRuMultUserService.class);

    public SequentialMultiInnerJumpCmd(TaskEntity task, String userId, String mandator, String comment) {
        this.task = task;
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
    }

    public SequentialMultiInnerJumpCmd(HistoricTaskInstanceEntity historicTaskInstanceEntity, String userId, String mandator, String comment) {
        this.historicTaskInstanceEntity = historicTaskInstanceEntity;
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
    }

    public Void execute(CommandContext commandContext) {
        Integer loopCounter = null;
        ExecutionEntity execution = null;
        if (this.task != null) {
            Object eventMessage;
            Object commentEntity;
            this.task.setAssignee(this.userId, true, true);
            this.task.setAllPrevNode(this.task.getTaskDefinitionKey());
            ParamModel paramModel = this.getParamModel(this.task);
            Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
            this.task.fireEvent("complete");
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)this.task, null, (boolean)false));
            Context.getCommandContext().getTaskEntityManager().deleteTask(this.task, "SequentialMultiInnerJumpCmd-Completed", false, this.mandator);
            if (HussarUtils.isNotEmpty((Object)this.comment)) {
                commentEntity = new CommentEntity();
                commentEntity.setUserId(this.userId);
                commentEntity.setType("complete");
                commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
                commentEntity.setTaskId(this.task.getId());
                commentEntity.setProcessInstanceId(null);
                commentEntity.setAction("AddComment");
                eventMessage = this.comment.replaceAll("\\s+", " ");
                if (((String)eventMessage).length() > BpmConstant.MAX_COMMENT_LENGTG) {
                    eventMessage = ((String)eventMessage).substring(0, BpmConstant.COMMENT_LENGTH) + "...";
                }
                commentEntity.setMessage((String)eventMessage);
                commentEntity.setFullMessage(this.comment);
                commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
            }
            loopCounter = this.task.getSeqMultiCount();
            commentEntity = loopCounter;
            loopCounter = loopCounter - 1;
            eventMessage = loopCounter;
            execution = this.task.getExecution();
            execution.addTempVariable("taskSourceFlag", (Object)"sequential_multi_inner_reject");
            execution.addTempVariable("multi_id", (Object)this.task.getMultiId());
            execution.setAllPrevNode(this.task.getAllPrevNode());
            try {
                CommonCodeUtil.updateTodoConfiguration((DelegateExecution)execution);
            }
            catch (Exception e) {
                throw new BpmException(e.getMessage());
            }
        }
        loopCounter = this.historicTaskInstanceEntity.getSeqMultiCount();
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        execution = executionEntityManager.findExecutionById(this.historicTaskInstanceEntity.getExecutionId());
        Long multiId = (Long)BpmAttribute.getExecutionAttribute((ActivityExecution)execution, "multi_id");
        if (HussarUtils.isEmpty((Object)multiId)) {
            execution.addTempVariable("multi_id", (Object)this.historicTaskInstanceEntity.getMultiId());
        }
        try {
            CommonCodeUtil.updateTodoConfiguration((DelegateExecution)execution);
        }
        catch (Exception e) {
            throw new BpmException(e.getMessage());
        }
        List taskEntities = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.historicTaskInstanceEntity.getExecutionId());
        StringBuilder taskIds = new StringBuilder();
        ArrayList<Long> longDelTaskIds = new ArrayList<Long>();
        ArrayList<String> delTaskIds = new ArrayList<String>();
        for (TaskEntity taskEntity : taskEntities) {
            longDelTaskIds.add(Long.parseLong(taskEntity.getId().replace("'", "")));
            delTaskIds.add(taskEntity.getId().replace("'", ""));
        }
        if (!delTaskIds.isEmpty()) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActCcTask::getTaskId, longDelTaskIds);
            this.sysActCcTaskMapper.delete((Wrapper)lambdaQueryWrapper);
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(execution.getProcessDefinitionId());
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                String processKey = execution.getProcessDefinitionId().split(":")[0];
                dataPush.setProcessKey(processKey);
                dataPush.setProcessDefinitionId(execution.getProcessDefinitionId());
                dataPush.setProcessInsId(execution.getProcessInstanceId());
                dataPush.setTaskIds(delTaskIds);
                this.dataPushService.deleteMultiTask(dataPush);
            }
        }
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            if (HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
                taskIds.append(",").append(taskEntity.getId());
            }
            if (taskEntity.getParentTaskId() != null) {
                Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, null, true);
                continue;
            }
            taskEntity.setAssignee(this.userId, true, true);
            ParamModel paramModel = this.getParamModel(taskEntity);
            Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
            taskEntity.fireEvent("complete");
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "SequentialMultiInnerJumpCmd-Completed", true, this.mandator);
        }
        if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(execution);
        execution.addTempVariable("taskSourceFlag", (Object)"sequential_multi_inner_revoke");
        Date date = new Date();
        new RevokeAddHistoryTaskCmd(execution, this.comment, date, this.userId).execute(commandContext);
        int nrOfCompletedInstances = loopCounter;
        execution.setVariableLocal("nrOfCompletedInstances", (Object)nrOfCompletedInstances);
        execution.setVariableLocal("loopCounter", (Object)loopCounter);
        if (execution.getActivity() == null || !(ActivityMultiBehaviorUtil.getTargetMultiInstanceActivityBehavior((ActivityImpl)execution.getActivity(), (ActivityBehavior)execution.getActivity().getActivityBehavior(), (boolean)true) instanceof ExtendSequentialMultiInstanceBehavior)) {
            throw new PublicClientException("\u4e32\u884c\u4f1a\u7b7e\u64cd\u4f5c\u5f02\u5e38");
        }
        BpmnModel bm = commandContext.getProcessEngineConfiguration().getRepositoryService().getBpmnModel(execution.getProcessDefinitionId());
        ArrayList<String> messageType = new ArrayList<String>();
        ArrayList<ConfigUser> users = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long multiId2 = (Long)BpmAttribute.getExecutionAttribute((ActivityExecution)execution, "multi_id");
        queryWrapper.eq(BpmActRuMultUser::getMultiId, (Object)(multiId2 == null ? Long.valueOf(execution.getId()) : multiId2));
        List multUsers = bpmActRuMultUserService.list((Wrapper)queryWrapper);
        users = ConfigUser.buildConfigUser(multUsers);
        ((ExtendSequentialMultiInstanceBehavior)ActivityMultiBehaviorUtil.getTargetMultiInstanceActivityBehavior((ActivityImpl)execution.getActivity(), (ActivityBehavior)execution.getActivity().getActivityBehavior(), (boolean)true)).bpmExecute(bm, (ActivityExecution)execution, users, loopCounter, null, messageType);
        return null;
    }

    private List<ConfigUser> getUser(BpmnModel bm, ActivityExecution execution, List<String> messageType) {
        List<ConfigUser> configUserList = AnalyticalModelUtil.getEntrustCandidateUser(bm, ((ExecutionEntity)execution).getActivityId(), execution, false, null, messageType);
        Boolean notNeedCheckAssignee = (Boolean)Context.getCommandContext().getAttribute("notNeedCheckAssignee");
        if (notNeedCheckAssignee != null && !notNeedCheckAssignee.booleanValue() && HussarUtils.isEmpty(configUserList)) {
            throw new BpmException(BpmExceptionCodeEnum.NULL_ASSIGNEE);
        }
        if (HussarUtils.isEmpty(configUserList)) {
            configUserList.add(null);
        }
        return configUserList;
    }

    public ParamModel getParamModel(TaskEntity task) {
        ParamModel paramModel = new ParamModel();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.mappingCompleteType("sequential_multi_inner_reject");
        Map targetAssigneeMap = (Map)BpmAttribute.getExecutionAttribute((ActivityExecution)task.getProcessInstance(), "appoint_assignee");
        paramModel.setTargetAssignee(targetAssigneeMap);
        paramModel.setTo(task.getTaskDefinitionKey());
        paramModel.setFrom(task.getTaskDefinitionKey());
        paramModel.setHandler(this.userId);
        paramModel.setSendUser(task.getSendUser());
        paramModel.setLastNodeId(task.getTaskDefinitionKey());
        paramModel.setLastTaskId(task.getId());
        paramModel.setLastNodeName(task.getName());
        paramModel.mappingLastCompleteType("sequential_multi_inner_reject");
        paramModel.setLastNodeHandler(this.userId);
        return paramModel;
    }
}

