/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.definition.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActReModel;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActReModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.cache.HussarWorkflowCacheCleanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.vo.ProcessDefinitionVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.OrganProcessPublishCheckDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ProcessDefinitionsServiceImpl
implements ProcessDefinitionsService {
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Resource
    RepositoryService repositoryService;
    @Autowired
    private IBpmActReModelService bpmActReModelService;
    @Autowired
    private ModelService modelService;
    private static final String NOT_MAIN_PROCESS = "0";

    public IPage<DefinitionModel> queryProcessDefinitionsList(String definitionName, Page<DefinitionModel> page, String organId) {
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName, organId);
        for (DefinitionModel definitionModel : instList) {
            String processFormId = this.modelService.getProcessFormId(definitionModel.getMykey(), Integer.valueOf(definitionModel.getVersion()));
            definitionModel.setFormId(processFormId);
        }
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(instList, DefinitionModel.class).translate(DefinitionModel::getNameTranslateKey, DefinitionModel::setName).execute();
        page.setRecords(instList);
        return page;
    }

    public DefinitionModel getMainOrNew(String processKey, String organId) {
        List<DefinitionModel> mainProdef = this.processDefinitionsMapper.getMainProdef(processKey, organId);
        if (HussarUtils.isEmpty(mainProdef)) {
            mainProdef = this.processDefinitionsMapper.getOtherProdef(processKey, organId);
        }
        if (HussarUtils.isNotEmpty(mainProdef)) {
            return mainProdef.get(0);
        }
        throw new PublicClientException(BpmExceptionCodeEnum.PROCESS_NOT_EXIST.getMessage(), Boolean.valueOf(false));
    }

    public List<DefinitionModel> getMainOrNewBatch(List<String> processKeyList) {
        ArrayList<DefinitionModel> finalProcdef = new ArrayList<DefinitionModel>();
        List<DefinitionModel> mainProdef = this.processDefinitionsMapper.getMainDefIdBatch(processKeyList);
        if (HussarUtils.isNotEmpty(mainProdef)) {
            finalProcdef.addAll(mainProdef);
        }
        List mainKey = mainProdef.stream().map(DefinitionModel::getMykey).collect(Collectors.toList());
        processKeyList.removeAll(mainKey);
        if (HussarUtils.isNotEmpty(processKeyList)) {
            List<DefinitionModel> otherProdef = this.processDefinitionsMapper.getOtherDefIdBatch(processKeyList);
            Map<String, List<DefinitionModel>> procdefIdMap = otherProdef.stream().collect(Collectors.groupingBy(DefinitionModel::getMykey));
            for (List<DefinitionModel> procdefList : procdefIdMap.values()) {
                Optional<DefinitionModel> maxVersionProcdefId = procdefList.stream().max(Comparator.comparingInt(o -> Integer.parseInt(HussarUtils.isEmpty((Object)o.getRealVersion()) ? o.getVersion() : o.getRealVersion())));
                if (!HussarUtils.isNotEmpty((Object)maxVersionProcdefId.orElse(new DefinitionModel()))) continue;
                finalProcdef.add(maxVersionProcdefId.get());
            }
        }
        return finalProcdef;
    }

    public List<DefinitionModel> getMainOrNewWithOrgan(String processKey) {
        List<DefinitionModel> mainProdef = this.processDefinitionsMapper.getMainDefWithOrgan(processKey);
        List<Object> processTagList = new ArrayList();
        if (HussarUtils.isNotEmpty(mainProdef)) {
            processTagList = mainProdef.stream().map(DefinitionModel::getOrganId).collect(Collectors.toList());
        }
        List<DefinitionModel> otherProdef = this.processDefinitionsMapper.getOtherDefWithOrgan(processKey);
        ArrayList finalProcessTagList = processTagList;
        Map<String, List<DefinitionModel>> procdefIdMap = otherProdef.stream().filter(o -> HussarUtils.isEmpty((Object)finalProcessTagList) || !finalProcessTagList.contains(o.getOrganId())).collect(Collectors.groupingBy(DefinitionModel::getOrganId));
        ArrayList<DefinitionModel> organModel = new ArrayList<DefinitionModel>();
        organModel.addAll(procdefIdMap.values().stream().map(e -> e.stream().max(Comparator.comparingInt(o -> Integer.parseInt(HussarUtils.isEmpty((Object)o.getRealVersion()) ? o.getVersion() : o.getRealVersion()))).orElse(null)).collect(Collectors.toList()));
        if (HussarUtils.isNotEmpty(mainProdef)) {
            organModel.addAll(mainProdef);
        }
        return organModel;
    }

    @Cacheable(value={"workflow_process_def_id"}, key="'workflow_process_def_id:'+#processKey+':'+#version")
    public String getStartProcessDefinitionId(String processKey, String version) {
        return this.getStartProcessDefinitionId(processKey, version, null);
    }

    @Cacheable(value={"workflow_process_def_id"}, key="'workflow_process_def_id:'+#processKey+':'+#version+':'+#organId")
    public String getStartProcessDefinitionId(String processKey, String version, String organId) {
        if (HussarUtils.isNotEmpty((Object)version)) {
            return this.processDefinitionsMapper.selectProcessIdByProcessKeyAndVersion(processKey, Long.valueOf(version));
        }
        List<DefinitionModel> mainProdef = this.processDefinitionsMapper.getMainProdef(processKey, organId);
        if (HussarUtils.isEmpty(mainProdef)) {
            mainProdef = this.processDefinitionsMapper.getOtherProdef(processKey, organId);
        }
        if (!mainProdef.isEmpty()) {
            return mainProdef.get(0).getId();
        }
        throw new BpmException(BpmExceptionCodeEnum.PROCESS_KEY_ERROR.getMessage());
    }

    public String getLastProcessDefinitionId(String processKey) {
        return this.getLastProcessDefinitionId(processKey, null);
    }

    public String getLastProcessDefinitionId(String processKey, String organId) {
        List<DefinitionModel> allProdef = this.processDefinitionsMapper.getAllProdef(processKey, organId);
        if (!allProdef.isEmpty()) {
            return allProdef.get(0).getId();
        }
        throw new BpmException(BpmExceptionCodeEnum.PROCESS_KEY_ERROR.getMessage());
    }

    public List<String> getProcessDefinitionId(String processKey, Integer version) {
        return this.processDefinitionsMapper.getProcessDefinitionId(processKey, version);
    }

    public ApiResponse<String> setMain(String processKey, String id, String organId) {
        HussarWorkflowCacheCleanUtil.workflowProcessVersionCacheClean(processKey);
        String mainProcess = this.processDefinitionsMapper.getNotMain(processKey, null, 0, organId);
        mainProcess = "1".equals(mainProcess) ? NOT_MAIN_PROCESS : "4";
        String getMainProcess = this.processDefinitionsMapper.getMain(id);
        getMainProcess = NOT_MAIN_PROCESS.equals(getMainProcess) ? "1" : "5";
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0, organId, mainProcess) + this.processDefinitionsMapper.setMain(id, getMainProcess);
        num += this.processDefinitionsMapper.setModelMain(id, organId);
        DefinitionModel definitionModel = this.getMainOrNew(processKey, organId);
        String name = definitionModel.getName();
        String nameTranslateKey = definitionModel.getNameTranslateKey();
        Long deploymentId = definitionModel.getDeploymentId();
        String workflowStyle = definitionModel.getWorkflowStyle();
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", name);
        modelObjectNode.put("description", definitionModel.getDescription());
        modelObjectNode.put("revision", 1);
        this.processDefinitionsMapper.setNameAndDeploymentId(name, nameTranslateKey, deploymentId, workflowStyle, processKey, modelObjectNode.toString(), organId);
        if (HussarUtils.isNotEmpty((Object)organId)) {
            return ApiResponse.success((String)BpmExceptionCodeEnum.SET_SUCCESS.getMessage());
        }
        if (num != 0) {
            this.sysActProcessFileService.removeTempWorkflowFile(processKey, Integer.valueOf(0));
            if (this.sysActProcessFileService.copyFiles(processKey, id)) {
                return ApiResponse.success((String)BpmExceptionCodeEnum.SET_SUCCESS.getMessage());
            }
            throw new BpmException(BpmExceptionCodeEnum.FILES_NOT_FOUND);
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_SET);
    }

    public void canModelDeleteWithVersion(String processKey, String organId) {
        Integer count = this.processDefinitionsMapper.getOrganProcessCount(processKey, organId);
        if (count == 1) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_DELETE_THE_ONLY_PROCESS_DEFINITION);
        }
        Integer countWithoutTemp = this.processDefinitionsMapper.getOrganProcessCountWithoutTemplate(processKey, organId);
        if (countWithoutTemp == 1) {
            throw new BpmException("\u7981\u6b62\u5220\u9664\u975e\u6a21\u677f\u6d41\u7a0b\u7684\u6700\u540e\u4e00\u4e2a\u7248\u672c");
        }
    }

    public int setNotMain(String processKey, String organId) {
        HussarWorkflowCacheCleanUtil.workflowProcessVersionCacheClean(processKey);
        String mainProcess = this.processDefinitionsMapper.getNotMain(processKey, null, 0, organId);
        if (HussarUtils.isEmpty((Object)mainProcess)) {
            return 0;
        }
        mainProcess = "1".equals(mainProcess) ? NOT_MAIN_PROCESS : "4";
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0, organId, mainProcess);
        DefinitionModel definitionModel = this.getMainOrNew(processKey, organId);
        String name = definitionModel.getName();
        String nameTranslateKey = definitionModel.getNameTranslateKey();
        Long deploymentId = definitionModel.getDeploymentId();
        String workflowStyle = definitionModel.getWorkflowStyle();
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", name);
        modelObjectNode.put("description", definitionModel.getDescription());
        modelObjectNode.put("revision", 1);
        this.processDefinitionsMapper.setNameAndDeploymentId(name, nameTranslateKey, deploymentId, workflowStyle, processKey, modelObjectNode.toString(), organId);
        return num;
    }

    @CacheEvict(value={"workflow_process_def_id", "workflow_process_real_version", "workflow_organ_process_model"}, allEntries=true)
    public void resetModelMsg(String processKey, String organId) {
        DefinitionModel definitionModel = this.getMainOrNew(processKey, organId);
        String name = definitionModel.getName();
        String nameTranslateKey = definitionModel.getNameTranslateKey();
        Long deploymentId = definitionModel.getDeploymentId();
        String workflowStyle = definitionModel.getWorkflowStyle();
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", name);
        modelObjectNode.put("description", definitionModel.getDescription());
        modelObjectNode.put("revision", 1);
        this.processDefinitionsMapper.setNameAndDeploymentId(name, nameTranslateKey, deploymentId, workflowStyle, processKey, modelObjectNode.toString(), organId);
    }

    public int newSetNotMain(String processKey, String organId) {
        HussarWorkflowCacheCleanUtil.workflowProcessVersionCacheClean(processKey);
        return this.processDefinitionsMapper.setNotMain(processKey, null, 0, organId, NOT_MAIN_PROCESS);
    }

    public ApiResponse<String> cancelMain(String processKey, String id, String organId) {
        HussarWorkflowCacheCleanUtil.workflowProcessVersionCacheClean(processKey);
        String mainProcess = this.processDefinitionsMapper.getNotMain(processKey, null, 0, organId);
        mainProcess = "1".equals(mainProcess) ? NOT_MAIN_PROCESS : "4";
        int num = this.processDefinitionsMapper.setNotMain(processKey, id, 0, organId, mainProcess);
        DefinitionModel definitionModel = this.getMainOrNew(processKey, organId);
        String name = definitionModel.getName();
        String nameTranslateKey = definitionModel.getNameTranslateKey();
        Long deploymentId = definitionModel.getDeploymentId();
        String workflowStyle = definitionModel.getWorkflowStyle();
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", name);
        modelObjectNode.put("description", definitionModel.getDescription());
        modelObjectNode.put("revision", 1);
        this.processDefinitionsMapper.setNameAndDeploymentId(name, nameTranslateKey, deploymentId, workflowStyle, processKey, modelObjectNode.toString(), organId);
        if (HussarUtils.isNotEmpty((Object)organId)) {
            return ApiResponse.success((String)BpmExceptionCodeEnum.SET_SUCCESS.getMessage());
        }
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processKey, definitionModel.getId())) {
                return ApiResponse.success((String)BpmExceptionCodeEnum.SUCCESS_UPDATE.getMessage());
            }
            throw new BpmException(BpmExceptionCodeEnum.FILES_NOT_FOUND);
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_UPDATE);
    }

    public int updateProcessName(String id, String processName, String workflowStyle, String processNameTranslateKey) {
        return this.processDefinitionsMapper.updateProcessName(id, processName, workflowStyle, processNameTranslateKey);
    }

    public List<ProcessDefinitionModel> queryProcessDefListOfMainVersion(String processName) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        for (ProcessDefinitionModel oldPro : list) {
            boolean flag = false;
            for (ProcessDefinitionModel newPro : newList) {
                if (!HussarUtils.equals((Object)oldPro.getKey(), (Object)newPro.getKey())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            newList.add(oldPro);
        }
        return newList;
    }

    public List<ProcessDefinitionModel> getProcessMainOrNew(String processKey, String organId) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.getProcessMainOrNew(processKey, organId);
        ArrayList newList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(list)) {
            newList.add(list.get(0));
        }
        return newList;
    }

    public ProcessDefinitionModel getProcessDefitionById(String processId) {
        ProcessDefinitionModel processDefinitionModel = this.processDefinitionsMapper.getProcessDefitionById(processId);
        return processDefinitionModel;
    }

    public List<ProcessDefinitionVo> queryFlowVersion(String processKey) {
        return this.processDefinitionsMapper.queryFlowVersion(processKey);
    }

    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    public void editTemporaryDefId(String defId, Long processInsId, String version) {
        this.processDefinitionsMapper.updateActInst(defId, processInsId);
        this.processDefinitionsMapper.updateExecution(defId, processInsId);
        this.processDefinitionsMapper.updateProcDef(defId, processInsId, Long.parseLong(version));
        this.processDefinitionsMapper.updateTask(defId, processInsId);
        this.processDefinitionsMapper.updateCcTask(defId, processInsId);
        this.processDefinitionsMapper.updateTaskInst(defId, processInsId);
        this.processDefinitionsMapper.updateProcInst(defId, processInsId);
    }

    public void editTemporaryDefIdByOldDefId(String defId, String oldDefId, String version) {
        this.processDefinitionsMapper.updateActInstByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateExecutionByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateProcDefByOldDefId(defId, oldDefId, Long.parseLong(version));
        this.processDefinitionsMapper.updateTaskByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateCcTaskByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateTaskInstByOldDefId(defId, oldDefId);
        this.processDefinitionsMapper.updateProcInstByOldDefId(defId, oldDefId);
    }

    public void editTemporaryDefId(String defId, String processInsId, String version) {
        this.editTemporaryDefId(defId, Long.parseLong(processInsId), version);
    }

    public int queryLatestVersion(String processKey) {
        List processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().list();
        if (HussarUtils.isNotEmpty((Object)processDefinition)) {
            return ((ProcessDefinition)processDefinition.get(0)).getVersion();
        }
        return 0;
    }

    public ApiResponse<String> setMainVersion(String processKey, String processVersion, String organId) {
        HussarWorkflowCacheCleanUtil.workflowProcessVersionCacheClean(processKey);
        DefinitionModel definitionModel = this.processDefinitionsMapper.getProcDefIdByKeyAndVersion(processKey, HussarUtils.isNotEmpty((Object)processVersion) ? Integer.valueOf(processVersion) : null);
        if (HussarUtils.isEmpty((Object)definitionModel)) {
            throw new PublicClientException(BpmExceptionCodeEnum.PROCESS_VERSION_NOT_FOUND.getMessage());
        }
        String processDefinitionId = definitionModel.getId();
        return this.setMain(processKey, processDefinitionId, organId);
    }

    public Integer queryNewVersion(String processKey) {
        return this.processDefinitionsMapper.queryNewVersion(processKey);
    }

    public String getProcessDefIdByVersion(String identity, Integer processVersion) {
        return this.processDefinitionsMapper.getProcessDefIdByVersion(identity, processVersion);
    }

    public DefinitionModel getByVersion(String id, String processKey, Integer version) {
        if (id != null) {
            return this.processDefinitionsMapper.getById(id, null);
        }
        List<DefinitionModel> defByVersion = this.processDefinitionsMapper.getByVersion(processKey, version);
        if (HussarUtils.isNotEmpty(defByVersion)) {
            return defByVersion.get(0);
        }
        return null;
    }

    @CacheEvict(value={"workflow_organ_process_model", "workflow_process_model_status"}, allEntries=true)
    public void editModelStatus(String modelId, String modelStatus) {
        BpmActReModel bpmActReModel = (BpmActReModel)this.bpmActReModelService.getById(Long.valueOf(modelId));
        HussarCacheUtil.evictKeysRightLike((String)"workflow_organ_process_model", (String)("workflow_organ_process_model" + bpmActReModel.getModelKey() + ":"));
        HussarCacheUtil.evictKeysRightLike((String)"workflow_process_model_status", (String)("workflow_process_model_status" + bpmActReModel.getModelKey() + ":"));
        bpmActReModel.setModelStatus(!NOT_MAIN_PROCESS.equals(modelStatus) ? NOT_MAIN_PROCESS : "1");
        this.bpmActReModelService.updateById(bpmActReModel);
    }

    public boolean isTemplateProcessById(String procDefId) {
        ProcessDefinitionModel processDefinition = this.processDefinitionsMapper.getProcessDefitionById(procDefId);
        if (processDefinition != null) {
            return "1".equals(processDefinition.getModelTemplate());
        }
        return false;
    }

    public boolean existExtendProcess(String appCode) {
        Integer defNum = this.processDefinitionsMapper.queryProcessCountWithAppCode(appCode);
        return defNum > 0;
    }

    public boolean isTemplateProcessByProcessKeyAndVersion(String processKey, Integer version) {
        DefinitionModel definitionModel = this.processDefinitionsMapper.getProcDefIdByKeyAndVersion(processKey, version);
        if (definitionModel != null) {
            return "1".equals(definitionModel.getModelTemplate());
        }
        return false;
    }

    public int getTemplateProcessVersion(String processKey, String organId) {
        int version = this.processDefinitionsMapper.getTemplateProcessVersion(processKey, organId);
        return HussarUtils.isEmpty((Object)version) ? 1 : version;
    }

    public List<OrganProcessPublishCheckDto> getStandardExtendWorkflowByKeyAndOrgan(List<OrganProcessPublishCheckDto> organProcessPublishCheckDtoList) {
        if (HussarUtils.isEmpty(organProcessPublishCheckDtoList)) {
            return new ArrayList<OrganProcessPublishCheckDto>();
        }
        return this.processDefinitionsMapper.getStandardExtendWorkflowByKeyAndOrgan(organProcessPublishCheckDtoList);
    }

    public List<String> getTemplateProcessIdByAppCode(String appCode) {
        return this.processDefinitionsMapper.getTemplateProcessIdByAppCode(appCode);
    }
}

