/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.customsql.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.customsql.service.ICustomSqlService;
import com.jxdinfo.hussar.workflow.engine.bpm.customsql.service.IDbCustomSqlService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.customsql.service.CustomSqlOutSideService;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.impl.el.SqlConditionHandleService;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqlConditionHandleServiceImpl
implements SqlConditionHandleService {
    private static final Pattern SQL_REGEX = Pattern.compile("\\@Sql\\{([^@]|[^}]\\@)*\\}\\@");
    @Autowired
    private IDbCustomSqlService dbCustomSqlService;
    @Autowired
    private ICustomSqlService customSqlService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private ModelService modelService;
    private static final String MICRO = "micro";
    private static final String SINGLE = "single";
    private static Logger logger = LogManager.getLogger(SqlConditionHandleServiceImpl.class);

    private String replaceNextBuiltinVariable(String sql, Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            for (Map.Entry<String, Object> key : map.entrySet()) {
                if (sql.contains("(${" + key.getKey() + "})") && key.getValue() == null) {
                    newMap.put(key.getKey(), "null");
                    continue;
                }
                if (sql.contains("('${" + key.getKey() + "}')")) {
                    newMap.put(key.getKey(), String.valueOf(key.getValue()).replace(",", "','"));
                    continue;
                }
                newMap.put(key.getKey(), key.getValue());
            }
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newMap);
        ValueExpression e = factory.createValueExpression((ELContext)context, sql, String.class);
        String finalSql = e.getValue((ELContext)context).toString();
        finalSql = finalSql.replace("'null'", "null");
        return finalSql;
    }

    public String getSqlRealCondition(String condition, ExecutionEntity executionEntity) {
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        AnalyticalModelUtil.getSqlVariableMap(executionEntity, variableMap);
        condition = condition.substring(2, condition.length() - 1);
        String realCondition = condition = "${" + this.replaceNextBuiltinVariable(condition, variableMap) + "}";
        if (condition.contains("@Sql{")) {
            Matcher matcher = SQL_REGEX.matcher(condition);
            while (matcher.find()) {
                String deploymentModel;
                String message = matcher.group().substring(4, matcher.group().length() - 1);
                Map sqlMap = (Map)JSON.parseObject((String)message, Map.class);
                boolean isLegalSql = this.customSqlService.checkSql(sqlMap);
                if (!isLegalSql) {
                    throw new BpmException("\u5b58\u5728\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL");
                }
                block4 : switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
                    case "single": {
                        switch ((String)sqlMap.get("resultType")) {
                            case "Boolean": {
                                Boolean result = this.dbCustomSqlService.getBooleanSqlResult(sqlMap, (String)sqlMap.get("dataBaseName"));
                                if (result == null) {
                                    result = false;
                                }
                                realCondition = realCondition.replace(matcher.group(), String.valueOf(result));
                                break block4;
                            }
                        }
                        throw new BpmException("\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL\u8fd4\u56de\u503c\u7c7b\u578b");
                    }
                    case "micro": {
                        String serviceName = this.modelService.getServiceName(executionEntity.getProcessDefinitionKey());
                        CustomSqlOutSideService customSqlOutSideService = (CustomSqlOutSideService)BpmSpringContextHolder.getBean(CustomSqlOutSideService.class);
                        switch ((String)sqlMap.get("resultType")) {
                            case "Boolean": {
                                Boolean result = customSqlOutSideService.getBooleanSqlResult(sqlMap, (String)sqlMap.get("dataBaseName"), serviceName);
                                if (result == null) {
                                    result = false;
                                }
                                realCondition = realCondition.replace(matcher.group(), String.valueOf(result));
                                break block4;
                            }
                        }
                        throw new BpmException("\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL\u8fd4\u56de\u503c\u7c7b\u578b");
                    }
                    default: {
                        throw new BpmException("\u5f53\u524d\u90e8\u7f72\u6a21\u5f0f\u4e0b\u4e0d\u652f\u6301\u4f7f\u7528\u8be5\u529f\u80fd");
                    }
                }
            }
        }
        return realCondition;
    }

    public String getSqlRealCondition(String condition, Map<String, Object> map) {
        condition = condition.substring(2, condition.length() - 1);
        String realCondition = condition = "${" + this.replaceNextBuiltinVariable(condition, map) + "}";
        if (condition.contains("@Sql{")) {
            Matcher matcher = SQL_REGEX.matcher(condition);
            while (matcher.find()) {
                String deploymentModel;
                String message = matcher.group().substring(4, matcher.group().length() - 1);
                Map sqlMap = (Map)JSON.parseObject((String)message, Map.class);
                boolean isLegalSql = this.customSqlService.checkSql(sqlMap);
                if (!isLegalSql) {
                    throw new BpmException("\u5b58\u5728\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL");
                }
                String serviceName = null;
                block4 : switch (deploymentModel = this.lcdpBpmProperties.getDeploymentModel()) {
                    case "single": {
                        switch ((String)sqlMap.get("resultType")) {
                            case "Boolean": {
                                Boolean result = this.dbCustomSqlService.getBooleanSqlResult(sqlMap, (String)sqlMap.get("dataBaseName"));
                                if (result == null) {
                                    result = false;
                                }
                                realCondition = realCondition.replace(matcher.group(), String.valueOf(result));
                                break block4;
                            }
                        }
                        throw new BpmException("\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL\u8fd4\u56de\u503c\u7c7b\u578b");
                    }
                    case "micro": {
                        if (HussarUtils.isNotEmpty((Object)map.get("hussar_proc_key"))) {
                            String processKey = String.valueOf(map.get("hussar_proc_key"));
                            processKey = processKey.replace("'", "");
                            serviceName = this.modelService.getServiceName(processKey);
                        }
                        if (HussarUtils.isEmpty(serviceName)) {
                            logger.error("\u81ea\u5b9a\u4e49SQL\u67e5\u8be2\u65f6\u83b7\u53d6\u670d\u52a1\u540d\u5931\u8d25");
                        }
                        CustomSqlOutSideService customSqlOutSideService = (CustomSqlOutSideService)BpmSpringContextHolder.getBean(CustomSqlOutSideService.class);
                        switch ((String)sqlMap.get("resultType")) {
                            case "Boolean": {
                                Boolean result = customSqlOutSideService.getBooleanSqlResult(sqlMap, (String)sqlMap.get("dataBaseName"), serviceName);
                                if (result == null) {
                                    result = false;
                                }
                                realCondition = realCondition.replace(matcher.group(), String.valueOf(result));
                                break block4;
                            }
                        }
                        throw new BpmException("\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL\u8fd4\u56de\u503c\u7c7b\u578b");
                    }
                    default: {
                        throw new BpmException("\u5f53\u524d\u90e8\u7f72\u6a21\u5f0f\u4e0b\u4e0d\u652f\u6301\u4f7f\u7528\u8be5\u529f\u80fd");
                    }
                }
            }
        }
        return realCondition;
    }
}

