/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.properties;

import com.jxdinfo.hussar.formdesign.application.config.service.IConfigService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmYmlConfigurationProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LcdpBpmProperties {
    private final IBpmConfigService bpmConfigService;
    private final BpmYmlConfigurationProperties bpmYmlConfigurationProperties;
    @Autowired(required=false)
    private IConfigService iConfigService;

    public LcdpBpmProperties(IBpmConfigService bpmConfigService, BpmYmlConfigurationProperties bpmYmlConfigurationProperties) {
        this.bpmConfigService = bpmConfigService;
        this.bpmYmlConfigurationProperties = bpmYmlConfigurationProperties;
    }

    public boolean isModifyConfigurationOnline() {
        return true;
    }

    public boolean isEditableOnline() {
        return false;
    }

    public String getDeploymentModel() {
        return this.bpmYmlConfigurationProperties.getDeploymentModel();
    }

    public boolean isEnableMessageService() {
        return this.bpmYmlConfigurationProperties.isEnableMessageService();
    }

    public int getReadTimeOut() {
        return (int)this.bpmConfigService.getLongByKeyUseCache("read_timeout");
    }

    public int getConnectionTimeOut() {
        return (int)this.bpmConfigService.getLongByKeyUseCache("connection_timeout");
    }

    public String getCompleteHistoryOrderingRule() {
        return this.bpmConfigService.getStringByKeyUseCache("complete_history_ordering_rule");
    }

    public boolean isUseSecurityLevel() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_security_level");
    }

    public boolean isUseOrganProcess() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_organ_process");
    }

    public String noCodeOpenType() {
        return this.bpmConfigService.getStringByKeyUseCache("personal_matter_zero_process_open_type");
    }

    public String visitorGenerateType() {
        return this.bpmConfigService.getStringByKeyUseCache("visitor_generate_type");
    }

    public boolean isUseDatapush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_data_push");
    }

    public String getUnifiedTodoServerName() {
        return this.bpmConfigService.getStringByKeyUseCache("unified_todo_server_name");
    }

    public String getTenantCallAddress() {
        String address = this.bpmConfigService.getStringByKeyUseCache("tenant_call_address");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }

    public String getIntegrationPlatformCallAddress() {
        String address = this.bpmConfigService.getStringByKeyUseCache("integration_platform_call_address");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }

    public String getIntegrationPlatformCallClientId() {
        String address = this.bpmConfigService.getStringByKeyUseCache("integration_platform_application_client_id");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }

    public String getIntegrationPlatformCallClientSecret() {
        String address = this.bpmConfigService.getStringByKeyUseCache("integration_platform_application_client_secret");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }

    public String getAssigneeMode() {
        return this.bpmConfigService.getStringByKeyUseCache("assignee_mode");
    }

    public String getRemoteDBName() {
        return this.bpmConfigService.getStringByKeyUseCache("remote_db_name");
    }

    public String getTenantType() {
        if (this.isWorkflowPlatformStandalone()) {
            return this.bpmConfigService.getStringByKeyUseCache("tenant_type");
        }
        return "base";
    }

    public boolean isWorkflowPlatformStandalone() {
        return this.bpmYmlConfigurationProperties.isWorkflowPlatformStandalone();
    }

    public boolean isTenantIsBase() {
        return !this.isWorkflowPlatformStandalone() || !"external".equals(this.getTenantType());
    }

    public String getTenantDBPrimaryKeyType() {
        return this.bpmConfigService.getStringByKeyUseCache("tenant_db_primary_key_type");
    }

    public boolean getTenantDBPrimaryKeyIsLong() {
        return "long".equals(this.getTenantDBPrimaryKeyType());
    }

    public String getStationOpenWay() {
        return this.bpmConfigService.getStringByKeyUseCache("station_open_way");
    }

    public String getFrontIp() {
        if (this.iConfigService == null) {
            return "";
        }
        ApiResponse result = this.iConfigService.get();
        Map data = (Map)result.getData();
        if (HussarUtils.isNotEmpty((Object)data) && data.containsKey("frontIp")) {
            return data.get("frontIp").toString();
        }
        return "";
    }

    public Map<String, String> getNodeColourMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("finish", this.bpmConfigService.getStringByKeyUseCache("finish_node_colour"));
        map.put("complete", this.bpmConfigService.getStringByKeyUseCache("complete_node_colour"));
        map.put("reject", this.bpmConfigService.getStringByKeyUseCache("reject_node_colour"));
        map.put("suspend", this.bpmConfigService.getStringByKeyUseCache("suspend_node_colour"));
        map.put("overtime", this.bpmConfigService.getStringByKeyUseCache("overtime_node_colour"));
        map.put("next", this.bpmConfigService.getStringByKeyUseCache("next_node_colour"));
        return map;
    }

    public String useIntegrationPlatform() {
        return this.bpmConfigService.getStringByKeyUseCache("use_integration_platform");
    }

    public String getUseIntegrationPlatform() {
        return this.bpmYmlConfigurationProperties.getUseIntegrationPlatform();
    }

    public Map<String, String> getIntegrationPlatformInfoYml() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("integrationPlatformCallAddress", this.bpmYmlConfigurationProperties.getIntegrationPlatformCallAddress());
        map.put("integrationPlatformApplicationClientId", this.bpmYmlConfigurationProperties.getIntegrationPlatformApplicationClientId());
        map.put("integrationPlatformApplicationClientSecret", this.bpmYmlConfigurationProperties.getIntegrationPlatformApplicationClientSecret());
        return map;
    }

    public Map<String, String> getIntegrationPlatformInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("integrationPlatformCallAddress", this.bpmConfigService.getStringByKeyUseCache("integration_platform_call_address"));
        map.put("integrationPlatformApplicationClientId", this.bpmConfigService.getStringByKeyUseCache("integration_platform_application_client_id"));
        map.put("integrationPlatformApplicationClientSecret", this.bpmConfigService.getStringByKeyUseCache("integration_platform_application_client_secret"));
        return map;
    }

    public String getProcessFileType() {
        return this.bpmConfigService.getStringByKeyUseCache("get_process_file_type");
    }
}

