/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.migration.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActGeBytearrayMapper;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActReModelMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActGeBytearray;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActReModel;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActReProcdef;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActReModelService;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActReProcdefService;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cache.HussarWorkflowCacheCleanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.check.service.impl.ProcessCheckServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.config.WorkflowSnowflakeIdGenerator;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ImportDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl.SysActExtendPropertiesServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.util.SysActExtendPropertiesCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpAppDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadAppDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowPreloadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.model.ExportDataModel;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.service.IWorkflowAppMigrationService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.util.WorkflowMigrationUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowAppDumpAllMsgDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationPreloadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.WorkflowMigrationMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.OrganProcessPublishCheckDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.TemplateInfoDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.userdata.sync.service.SysBpmOrganService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.explorer.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
@HussarTransactional
public class WorkflowAppMigrationServiceImpl
implements IWorkflowAppMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowAppMigrationServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Autowired
    private SysActExtendPropertiesServiceImpl sysActExtendPropertiesService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActHandleAuthService handleAuthService;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private WorkflowMigrationMapper workflowMigrationMapper;
    @Resource
    private BpmActGeBytearrayMapper bpmActGeBytearrayMapper;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ProcessCheckServiceImpl processCheckService;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Resource
    private BpmActReModelMapper bpmActReModelMapper;
    @Autowired
    private WorkflowSnowflakeIdGenerator workflowSnowflakeIdGenerator;
    @Autowired
    private IBpmActReProcdefService bpmActReProcdefService;
    @Autowired
    private SysBpmOrganService sysBpmOrganService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    @Lazy
    private GodAxeModelService godAxeModelService;
    @Autowired
    private IBpmActReModelService bpmActReModelService;

    public WorkflowAppDumpAllMsgDto dumpApp(WorkflowDumpAppDto workflowDumpAppDto) {
        WorkflowAppDumpAllMsgDto workflowAppDumpAllMsgDto = new WorkflowAppDumpAllMsgDto();
        String appCode = workflowDumpAppDto.getAppCode();
        List<ExportModel> list = this.modelMapper.selectModelNamesByAppCode(appCode);
        if (HussarUtils.isNotEmpty(list)) {
            Map<String, String> serviceNameMap = WorkflowBpmUtil.getOtherMap(list, ExportModel::getBusinessId, ExportModel::getCategory, null);
            Map<String, String> modelNameMap = WorkflowBpmUtil.getOtherMap(list, ExportModel::getBusinessId, ExportModel::getName, null);
            List processKeys = list.stream().map(ExportModel::getBusinessId).distinct().collect(Collectors.toList());
            boolean isModelResource = !"1".equals(list.get(0).getModelResource());
            ArrayList workflowDumpDtos = new ArrayList();
            List processDefinitionIdList = this.processDefinitionsService.getMainOrNewBatch(processKeys);
            ExportDataModel exportDataModel = new ExportDataModel();
            exportDataModel.setAssigneeData(Boolean.valueOf(true));
            exportDataModel.setWorkflowData(Boolean.valueOf(true));
            exportDataModel.setFormAuthData(Boolean.valueOf(true));
            exportDataModel.setHandleAuthData(Boolean.valueOf(true));
            processDefinitionIdList.forEach(o -> {
                WorkflowDumpDto workflowDumpDto = new WorkflowDumpDto();
                workflowDumpDto.setName((String)modelNameMap.get(o.getMykey()));
                workflowDumpDto.setProcessKey(o.getMykey());
                workflowDumpDto.setVersion(Integer.parseInt(o.getVersion()));
                workflowDumpDto.setProcessDefId(o.getId());
                workflowDumpDto.setExportData(exportDataModel);
                workflowDumpDtos.add(workflowDumpDto);
            });
            Integer mainNum = 0;
            Integer organNum = 0;
            String workflowFilePath = workflowDumpAppDto.getFilePath() + File.separator + "workflow";
            List<Object> flowPropertyFileList = new ArrayList();
            ArrayList<WorkflowPreloadDto> preloadDtoList = new ArrayList<WorkflowPreloadDto>();
            for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
                ArrayList<WorkflowDumpVo> workflowDumpVoList = new ArrayList<WorkflowDumpVo>();
                this.dumpAppFiles(workflowDumpVoList, workflowDumpDto, serviceNameMap);
                Integer n = mainNum;
                Integer n2 = mainNum = Integer.valueOf(mainNum + 1);
                flowPropertyFileList.addAll(workflowDumpVoList);
                workflowAppDumpAllMsgDto.addDumpList(workflowDumpVoList);
                List<WorkflowDumpVo> organDumpList = this.dumpOrganProcess(workflowDumpDto, serviceNameMap, flowPropertyFileList, organNum);
                workflowAppDumpAllMsgDto.addDumpList(organDumpList);
                preloadDtoList.add(new WorkflowPreloadDto(workflowDumpDto));
            }
            flowPropertyFileList = flowPropertyFileList.stream().map(WorkflowDumpVo::new).collect(Collectors.toList());
            workflowAppDumpAllMsgDto.setPreloadMsg(JSON.toJSONString(preloadDtoList));
            workflowAppDumpAllMsgDto.setFlowProperty(JSON.toJSONString(flowPropertyFileList));
            logger.info("\u5bfc\u51fa\u4e3b\u6d41\u7a0b\u5171\u8ba1{}\u6761\uff0c\u90e8\u95e8\u6d41\u7a0b\u5171\u8ba1{}\u6761", (Object)mainNum, (Object)organNum);
        }
        return workflowAppDumpAllMsgDto;
    }

    private List<WorkflowMigrationPreloadVo> preload(List<WorkflowPreloadDto> workflowPreloadDtos, String appType, List<String> existProcessMap) {
        ArrayList<WorkflowMigrationPreloadVo> result = new ArrayList<WorkflowMigrationPreloadVo>();
        List<String> processKeys = workflowPreloadDtos.stream().map(WorkflowPreloadDto::getProcessKey).collect(Collectors.toList());
        List<DefinitionModel> list = this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys, null);
        Map<String, List<DefinitionModel>> definitionModelListMap = WorkflowBpmUtil.getListMap(list, DefinitionModel::getMykey, null);
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            List<DefinitionModel> models = definitionModelListMap.get(workflowPreloadDto.getProcessKey());
            if (models != null) {
                Map<String, Integer> organVersionMap = WorkflowBpmUtil.getOtherMap(models, DefinitionModel::getOrganId, e -> Integer.parseInt(e.getVersion()), null);
                existProcessMap.add(workflowPreloadDto.getProcessKey() + ":" + (HussarUtils.isEmpty((Object)workflowPreloadDto.getOrganId()) ? "null" : workflowPreloadDto.getOrganId()));
                Integer maxVersion = organVersionMap.values().stream().max(Integer::compareTo).get();
                WorkflowMigrationPreloadVo workflowMigrationPreloadVo = new WorkflowMigrationPreloadVo(workflowPreloadDto, organVersionMap.get(workflowPreloadDto.getOrganId()), false);
                if (HussarUtils.isEmpty((Object)workflowMigrationPreloadVo.getTenantVersion())) {
                    workflowMigrationPreloadVo.setTenantVersion(organVersionMap.get(null));
                }
                organVersionMap.remove(null);
                workflowMigrationPreloadVo.setOrganVersionMap(organVersionMap);
                workflowMigrationPreloadVo.setMaxVersion(maxVersion);
                if (workflowPreloadDto.getOrganModels() != null) {
                    List organInfo = this.assigneeChooseService.queryDept(null);
                    List organList = organInfo.stream().map(AssigneeManageInfoVo::getId).collect(Collectors.toList());
                    ArrayList<WorkflowMigrationPreloadVo> organModels = new ArrayList<WorkflowMigrationPreloadVo>();
                    HashSet organIdSet = new HashSet(organList);
                    for (WorkflowPreloadDto organModel : workflowPreloadDto.getOrganModels()) {
                        boolean isExist = organIdSet.contains(organModel.getOrganId());
                        existProcessMap.add(organModel.getProcessKey() + ":" + (HussarUtils.isEmpty((Object)organModel.getOrganId()) ? "null" : organModel.getOrganId()));
                        organModels.add(new WorkflowMigrationPreloadVo(organModel, organVersionMap.get(organModel.getOrganId()), isExist));
                    }
                    workflowMigrationPreloadVo.setOrganModels(organModels);
                } else {
                    workflowMigrationPreloadVo.setOrganModels(new ArrayList());
                }
                result.add(workflowMigrationPreloadVo);
                continue;
            }
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = new WorkflowMigrationPreloadVo(workflowPreloadDto, Integer.valueOf(0), false);
            workflowMigrationPreloadVo.setOrganVersionMap(new HashMap());
            workflowMigrationPreloadVo.setMaxVersion(Integer.valueOf(0));
            if (workflowPreloadDto.getOrganModels() != null) {
                List organInfo = this.assigneeChooseService.queryDept(null);
                List organList = organInfo.stream().map(AssigneeManageInfoVo::getId).collect(Collectors.toList());
                HashSet organIdSet = new HashSet(organList);
                ArrayList<WorkflowMigrationPreloadVo> organModels = new ArrayList<WorkflowMigrationPreloadVo>();
                for (WorkflowPreloadDto organModel : workflowPreloadDto.getOrganModels()) {
                    boolean isExist = organIdSet.contains(organModel.getOrganId());
                    organModels.add(new WorkflowMigrationPreloadVo(organModel, Integer.valueOf(0), isExist));
                }
                workflowMigrationPreloadVo.setOrganModels(organModels);
            } else {
                workflowMigrationPreloadVo.setOrganModels(new ArrayList());
            }
            result.add(workflowMigrationPreloadVo);
        }
        return result;
    }

    public ApiResponse<?> loadApp(WorkflowLoadAppDto workflowLoadAppDto) {
        String newAppId = workflowLoadAppDto.getAppId();
        String appType = workflowLoadAppDto.getAppType();
        ArrayList<String> existProcessMap = new ArrayList<String>();
        List preloadDtoList = JSON.parseArray((String)workflowLoadAppDto.getPreloadMsg(), WorkflowPreloadDto.class);
        List<WorkflowMigrationPreloadVo> preloadVoList = this.preload(preloadDtoList, appType, existProcessMap);
        Map<Object, Object> importMap = new HashMap();
        if (HussarUtils.isNotEmpty(preloadVoList)) {
            importMap = preloadVoList.stream().collect(Collectors.toMap(WorkflowMigrationPreloadVo::getProcessKey, Function.identity()));
        }
        HashMap<String, String> serviceNameMap = new HashMap<String, String>();
        HashMap<String, String> modelTypeMap = new HashMap<String, String>();
        HashMap<String, String> extendProcessMap = new HashMap<String, String>();
        HashMap<String, List> organVersionList = new HashMap<String, List>();
        List list = JSON.parseArray((String)workflowLoadAppDto.getFlowProperty(), WorkflowDumpVo.class);
        HashMap<String, String> organVersionMap = new HashMap<String, String>();
        String oldAppCode = "";
        String oldServiceName = "";
        for (Object workflowDumpVo : list) {
            if (HussarUtils.isEmpty((Object)oldAppCode)) {
                oldAppCode = workflowDumpVo.getAppCode();
            }
            if (HussarUtils.isEmpty((Object)oldServiceName)) {
                oldServiceName = workflowDumpVo.getServiceName();
            }
            if (HussarUtils.isEmpty(serviceNameMap.get(workflowDumpVo.getProcessKey()))) {
                serviceNameMap.put(workflowDumpVo.getProcessKey(), "2".equals(workflowLoadAppDto.getImportType()) ? workflowLoadAppDto.getServiceName() : workflowDumpVo.getServiceName());
            }
            if (HussarUtils.isEmpty(modelTypeMap.get(workflowDumpVo.getProcessKey()))) {
                modelTypeMap.put(workflowDumpVo.getProcessKey(), workflowDumpVo.getModelType());
            }
            if (HussarUtils.isEmpty(extendProcessMap.get(workflowDumpVo.getProcessKey()))) {
                extendProcessMap.put(workflowDumpVo.getProcessKey(), workflowDumpVo.getModelTemplateExtend());
            }
            String organValue = workflowDumpVo.getProcessKey() + ":" + workflowDumpVo.getOrganId();
            String versionValue = workflowDumpVo.getProcessKey() + ":" + workflowDumpVo.getVersion() + ":";
            if (!existProcessMap.contains(organValue)) {
                versionValue = workflowDumpVo.getProcessKey() + ":0:";
            }
            organVersionMap.put(versionValue, organValue);
            organVersionList.computeIfAbsent(workflowDumpVo.getProcessKey(), o -> new ArrayList()).add(organValue);
        }
        HashMap<String, Integer> versionMap = new HashMap<String, Integer>();
        for (String processKey : organVersionList.keySet()) {
            Object organKey22;
            List organKeyList;
            Integer version = this.processDefinitionsService.queryLatestVersion(processKey);
            if (!"3".equals(appType) || 0 == version) {
                organKeyList = (List)organVersionList.get(processKey);
                for (Object organKey22 : organKeyList) {
                    if (!HussarUtils.isEmpty(versionMap.get(organKey22))) continue;
                    Integer n = version;
                    Integer n2 = version = Integer.valueOf(version + 1);
                    versionMap.put((String)organKey22, version);
                }
                continue;
            }
            organKeyList = (List)organVersionList.get(processKey);
            ArrayList<String> organKeyExample = new ArrayList<String>();
            organKey22 = organKeyList.iterator();
            while (organKey22.hasNext()) {
                String organKey3 = (String)organKey22.next();
                String[] organIdStr = organKey3.split(":");
                String organId = organIdStr[organIdStr.length - 1];
                if (HussarUtils.isNotEmpty(organKeyExample) && !organKeyExample.contains(organKey3)) {
                    organKeyExample.add(organKey3);
                    version = this.processDefinitionsService.getTemplateProcessVersion(processKey, "null".equals(organId) ? null : organId);
                }
                if (!HussarUtils.isEmpty(versionMap.get(organKey3))) continue;
                versionMap.put(organKey3, version);
                Integer n = version;
                Integer n3 = version = Integer.valueOf(version + 1);
            }
        }
        HashMap<String, String> importResult = new HashMap<String, String>();
        HashMap<String, String> overrideProcessDefIdMap = new HashMap<String, String>();
        ArrayList<String> assigneeTable = new ArrayList<String>();
        ArrayList<String> formAuthTable = new ArrayList<String>();
        ArrayList<String> expandTable = new ArrayList<String>();
        ArrayList<String> handleAuthTable = new ArrayList<String>();
        HashMap<String, Map<String, String>> fileMap = new HashMap<String, Map<String, String>>();
        List workflowImportMsgDtoList = workflowLoadAppDto.getWorkflowImportMsgDtoList();
        for (Object file : workflowImportMsgDtoList) {
            String string = file.getProcessKey();
            String version = file.getVersion();
            String fileName = file.getFileName();
            if (fileName.endsWith("\u8868\u5355\u6743\u9650.json")) {
                String string2 = file.getFileContent();
                formAuthTable.add(string2);
            }
            if (fileName.endsWith("\u53c2\u4e0e\u8005.json")) {
                String string3 = file.getFileContent();
                assigneeTable.add(string3);
            }
            if (fileName.endsWith("\u62d3\u5c55.json")) {
                String string4 = file.getFileContent();
                expandTable.add(string4);
            }
            String string5 = string + ":" + (String)version + ":";
            if (fileName.endsWith("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm")) {
                String lcdpbpm = file.getFileContent();
                fileMap.computeIfAbsent(string5, e -> new HashMap()).put("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", lcdpbpm);
            }
            if (fileName.endsWith("bpmn20.xml")) {
                String xml = file.getFileContent();
                fileMap.computeIfAbsent(string5, e -> new HashMap()).put("bpmn20.xml", xml);
            }
            if (!fileName.endsWith("\u64cd\u4f5c\u6743\u9650.json")) continue;
            String handleAuth = file.getFileContent();
            handleAuthTable.add(handleAuth);
        }
        WorkflowLoadDto workflowLoadDto = new WorkflowLoadDto();
        workflowLoadDto.setImportMsgMap(importMap);
        workflowLoadDto.setAssigneeMsgs(assigneeTable);
        workflowLoadDto.setFormAuthMsgs(formAuthTable);
        workflowLoadDto.setHandleAuthMsgs(handleAuthTable);
        workflowLoadDto.setExpandMsgs(expandTable);
        workflowLoadDto.setImportMsgs(preloadVoList);
        if (HussarUtils.isNotEmpty(importMap)) {
            for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : importMap.values()) {
                HussarWorkflowCacheCleanUtil.workflowProcessVersionCacheClean(workflowMigrationPreloadVo.getProcessKey());
                this.importAppFile(workflowMigrationPreloadVo, fileMap, oldServiceName, importResult, overrideProcessDefIdMap, modelTypeMap, oldAppCode, extendProcessMap, appType, versionMap, newAppId, workflowLoadAppDto.getImportType(), workflowLoadAppDto.getAppCode(), workflowLoadAppDto.getServiceName());
                if (workflowMigrationPreloadVo.getOrganModels() == null) continue;
                for (WorkflowMigrationPreloadVo organModel : workflowMigrationPreloadVo.getOrganModels()) {
                    this.importAppFile(organModel, fileMap, oldServiceName, importResult, overrideProcessDefIdMap, modelTypeMap, oldAppCode, extendProcessMap, appType, versionMap, newAppId, workflowLoadAppDto.getImportType(), workflowLoadAppDto.getAppCode(), workflowLoadAppDto.getServiceName());
                }
            }
        }
        HashSet<String> errorImportKeySet = new HashSet<String>(importResult.keySet());
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> overrideProcessVersionMap = new HashMap<String, Integer>();
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : importMap.values()) {
            String processKey = workflowMigrationPreloadVo.getProcessKey();
            int importVersion = workflowMigrationPreloadVo.getImportVersion();
            String key = processKey + ":" + importVersion + ":";
            String importType = workflowMigrationPreloadVo.getImportType();
            if ("override".equals(importType)) {
                HashMap<String, Object> processMap = new HashMap<String, Object>();
                processMap.put("processKey", workflowMigrationPreloadVo.getProcessKey());
                processMap.put("version", workflowMigrationPreloadVo.getTenantVersion());
                overrideProcessVersionMap.put(key, workflowMigrationPreloadVo.getTenantVersion());
                arrayList.add(processMap);
                continue;
            }
            if (!"unable".equals(importType)) continue;
            errorImportKeySet.add(key);
        }
        if (!arrayList.isEmpty()) {
            List<ImportDefinitionModel> newProcessMap = this.processDefinitionsMapper.getProcessDefinitions(arrayList);
            overrideProcessDefIdMap.putAll(WorkflowBpmUtil.getOtherMap(newProcessMap, e -> e.getProcessKey() + ":" + e.getProcessVersion() + ":", ImportDefinitionModel::getProcessDefinition, null));
        }
        for (Map.Entry entry : overrideProcessDefIdMap.entrySet()) {
            if (overrideProcessVersionMap.containsKey(entry.getKey())) continue;
            overrideProcessVersionMap.put((String)entry.getKey(), Integer.valueOf(((String)entry.getValue()).split(":")[1]));
        }
        this.importAssignee(workflowLoadDto, errorImportKeySet, organVersionMap, versionMap);
        this.importFormAuth(workflowLoadDto, errorImportKeySet, organVersionMap, versionMap);
        this.importHandleAuth(workflowLoadDto, errorImportKeySet, organVersionMap, versionMap);
        this.importExtendProperties(workflowLoadDto, errorImportKeySet, organVersionMap, oldAppCode, workflowLoadAppDto.getAppCode(), oldServiceName, workflowLoadAppDto.getServiceName());
        if (!"2".equals(workflowLoadAppDto.getImportType())) {
            List organProcessPublishCheckDtoList;
            List list2;
            if ("3".equals(workflowLoadAppDto.getAppType())) {
                ArrayList organVersion = new ArrayList();
                for (List value : organVersionList.values()) {
                    organVersion.addAll(value);
                }
                existProcessMap = organVersion;
            }
            if (HussarUtils.isNotEmpty((Object)(list2 = this.processDefinitionsService.getStandardExtendWorkflowByKeyAndOrgan(organProcessPublishCheckDtoList = existProcessMap.stream().distinct().map(o -> {
                OrganProcessPublishCheckDto organProcessPublishCheckDto = new OrganProcessPublishCheckDto();
                organProcessPublishCheckDto.setProcessKey(o.split(":")[0]);
                organProcessPublishCheckDto.setOrganId("null".equals(o.split(":")[1]) ? null : o.split(":")[1]);
                return organProcessPublishCheckDto;
            }).collect(Collectors.toList()))))) {
                organProcessPublishCheckDtoList.removeAll(list2);
            }
            if (HussarUtils.isNotEmpty(organProcessPublishCheckDtoList)) {
                this.godAxeModelService.saveExtendWorkflowWithKeyAndOrgan(organProcessPublishCheckDtoList);
            }
        }
        return ApiResponse.success();
    }

    private void dumpAppFiles(List<WorkflowDumpVo> workflowDumpVoList, WorkflowDumpDto workflowDumpDto, Map<String, String> serviceNameMap) {
        String processKey = workflowDumpDto.getProcessKey();
        ArrayList<WorkflowDumpVo> templateList = new ArrayList<WorkflowDumpVo>();
        this.dumpFiles(templateList, workflowDumpDto, serviceNameMap);
        TemplateInfoDto templateInfo = this.modelService.getTemplateInfo(processKey);
        for (WorkflowDumpVo workflowDumpVo : templateList) {
            workflowDumpVo.setModelResource("1");
            workflowDumpVo.setModelTemplateExtend(templateInfo.getModelTemplateExtend());
            workflowDumpVo.setModelTemplate(templateInfo.getModelTemplate());
        }
        workflowDumpVoList.addAll(templateList);
    }

    private List<WorkflowDumpVo> dumpOrganProcess(WorkflowDumpDto workflowDumpDto, Map<String, String> serviceNameMap, List<WorkflowDumpVo> flowPropertyFileList, int organNum) {
        ArrayList<WorkflowDumpDto> workflowDumpDtos = new ArrayList<WorkflowDumpDto>();
        ArrayList<WorkflowDumpVo> workflowDumpVoList = new ArrayList<WorkflowDumpVo>();
        List organProcesses = this.processDefinitionsService.getMainOrNewWithOrgan(workflowDumpDto.getProcessKey());
        if (HussarUtils.isEmpty((Object)organProcesses)) {
            return new ArrayList<WorkflowDumpVo>();
        }
        for (DefinitionModel organProcess : organProcesses) {
            WorkflowDumpDto organProcessDto = new WorkflowDumpDto(workflowDumpDto);
            organProcessDto.setVersion(Integer.parseInt(organProcess.getVersion()));
            organProcessDto.setOrganId(organProcess.getOrganId());
            organProcessDto.setProcessDefId(organProcess.getId());
            workflowDumpDtos.add(organProcessDto);
        }
        workflowDumpDto.setOrganModels(workflowDumpDtos);
        for (WorkflowDumpDto dumpDto : workflowDumpDtos) {
            ArrayList<WorkflowDumpVo> organDumpVoList = new ArrayList<WorkflowDumpVo>();
            this.dumpAppFiles(organDumpVoList, dumpDto, serviceNameMap);
            ++organNum;
            if (!HussarUtils.isNotEmpty(organDumpVoList)) continue;
            flowPropertyFileList.addAll(organDumpVoList);
            workflowDumpVoList.addAll(organDumpVoList);
        }
        return workflowDumpVoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpFiles(List<WorkflowDumpVo> workflowDumpVoList, WorkflowDumpDto workflowDumpDto, Map<String, String> serviceNameMap) {
        WorkflowDumpVo workflowDumpVo;
        String processKey = workflowDumpDto.getProcessKey();
        String organId = HussarUtils.isEmpty((Object)workflowDumpDto.getOrganId()) ? null : workflowDumpDto.getOrganId();
        int version = workflowDumpDto.getVersion();
        if (workflowDumpDto.getExportData().getAssigneeData().booleanValue()) {
            List sysActAssignees = this.sysActAssigneeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey)).eq(SysActAssignee::getProcessVersion, (Object)version));
            workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, JSONObject.toJSONString((Object)sysActAssignees, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "\u53c2\u4e0e\u8005.json", serviceNameMap.get(processKey));
            workflowDumpVo.setOrganId(organId);
            workflowDumpVoList.add(workflowDumpVo);
        }
        if (workflowDumpDto.getExportData().getFormAuthData().booleanValue()) {
            List sysActFormAuths = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)processKey)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getProcessVersion, (Object)version)).or()).isNull(SysActFormAuth::getProcessVersion);
            }));
            List result = sysActFormAuths.stream().filter(e -> e.getProcessVersion() != null).collect(Collectors.toList());
            if (result.isEmpty()) {
                result.addAll(sysActFormAuths);
            }
            WorkflowDumpVo workflowDumpVo2 = new WorkflowDumpVo(workflowDumpDto, JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "\u8868\u5355\u6743\u9650.json", serviceNameMap.get(processKey));
            workflowDumpVo2.setOrganId(organId);
            workflowDumpVoList.add(workflowDumpVo2);
        }
        if (workflowDumpDto.getExportData().getWorkflowData().booleanValue()) {
            List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)workflowDumpDto.getProcessDefId()));
            for (SysActExtendProperties sysActExtendProperty : sysActExtendProperties) {
                String newFormDetailKey = WorkflowMigrationUtil.convertFormKey(sysActExtendProperty.getFormDetailKey());
                String newCcFormDetailKey = WorkflowMigrationUtil.convertFormKey(sysActExtendProperty.getCcFormDetailKey());
                String newAssistFormDetailKey = WorkflowMigrationUtil.convertFormKey(sysActExtendProperty.getAssistFormDetailKey());
                sysActExtendProperty.setFormDetailKey(newFormDetailKey);
                sysActExtendProperty.setCcFormDetailKey(newCcFormDetailKey);
                sysActExtendProperty.setAssistFormDetailKey(newAssistFormDetailKey);
            }
            WorkflowDumpVo extendPropertiesDumpVo = new WorkflowDumpVo(workflowDumpDto, JSONObject.toJSONString((Object)sysActExtendProperties, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "\u62d3\u5c55.json", serviceNameMap.get(processKey));
            extendPropertiesDumpVo.setOrganId(organId);
            workflowDumpVoList.add(extendPropertiesDumpVo);
            List sysActProcessFiles = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)workflowDumpDto.getProcessDefId()));
            sysActProcessFiles.forEach(WorkflowMigrationUtil::convertFileFormKey);
            WorkflowDumpVo sysActProcessFilesDumpVo = new WorkflowDumpVo(workflowDumpDto, JSONObject.toJSONString((Object)sysActProcessFiles, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", serviceNameMap.get(processKey));
            sysActProcessFilesDumpVo.setOrganId(organId);
            workflowDumpVoList.add(sysActProcessFilesDumpVo);
            String modelType = this.modelService.getProcessModelType(processKey);
            String appCode = this.modelService.getAppCode(processKey);
            InputStream resourceAsStream = null;
            ByteArrayOutputStream outputStream = null;
            String xmlByteString = null;
            XMLStreamReader xtr = null;
            try {
                resourceAsStream = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getProcessModel(workflowDumpDto.getProcessDefId());
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                xtr = xif.createXMLStreamReader(resourceAsStream);
                BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                List flowElementList = (List)((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
                WorkflowMigrationUtil.convertFlowElementFormKey(flowElementList);
                for (FlowElement flowElement : flowElementList) {
                    if (!(flowElement instanceof SubProcess)) continue;
                    List subProcessElementList = (List)((SubProcess)flowElement).getFlowElements();
                    WorkflowMigrationUtil.convertFlowElementFormKey(subProcessElementList);
                }
                byte[] finalBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
                xmlByteString = new String(finalBytes);
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
            finally {
                if (HussarUtils.isNotEmpty((Object)xtr)) {
                    try {
                        xtr.close();
                    }
                    catch (Exception e3) {
                        logger.error(e3.getMessage(), (Throwable)e3);
                    }
                }
                if (resourceAsStream != null) {
                    try {
                        resourceAsStream.close();
                    }
                    catch (IOException e4) {
                        logger.error(e4.getMessage(), (Throwable)e4);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e5) {
                        logger.error(e5.getMessage(), (Throwable)e5);
                    }
                }
            }
            WorkflowDumpVo xmlDumpVo = new WorkflowDumpVo(workflowDumpDto, xmlByteString, "bpmn20.xml", serviceNameMap.get(processKey), modelType, appCode);
            xmlDumpVo.setOrganId(organId);
            workflowDumpVoList.add(xmlDumpVo);
        }
        if (workflowDumpDto.getExportData().getHandleAuthData().booleanValue()) {
            List handleAuthList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.handleAuthService.lambdaQuery().eq(SysActHandleAuth::getProcessKey, (Object)processKey)).eq(SysActHandleAuth::getProcessVersion, (Object)version)).list();
            workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, JSONObject.toJSONString((Object)handleAuthList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "\u8868\u5355\u6743\u9650.json", serviceNameMap.get(processKey));
            workflowDumpVo.setOrganId(organId);
            workflowDumpVoList.add(workflowDumpVo);
        }
    }

    private void removeFormAuth(JSONObject props) {
        JSONObject assistFormDetailAddress;
        JSONObject assistFormAddress;
        JSONObject ccFormDetailAddress;
        JSONObject ccFormAddress;
        JSONObject formDetailAddress;
        JSONObject formAddress = props.getJSONObject("formAddress");
        if (formAddress != null) {
            for (Object key : formAddress.keySet()) {
                formAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((formDetailAddress = props.getJSONObject("formDetailAddress")) != null) {
            for (Object key : formDetailAddress.keySet()) {
                formDetailAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((ccFormAddress = props.getJSONObject("ccFormAddress")) != null) {
            for (Object key : ccFormAddress.keySet()) {
                ccFormAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((ccFormDetailAddress = props.getJSONObject("ccFormDetailAddress")) != null) {
            for (Object key : ccFormDetailAddress.keySet()) {
                ccFormDetailAddress.getJSONObject((String)key).remove((Object)"formAuth");
            }
        }
        if ((assistFormAddress = props.getJSONObject("assistFormAddress")) != null) {
            for (String key : assistFormAddress.keySet()) {
                assistFormAddress.getJSONObject(key).remove((Object)"formAuth");
            }
        }
        if ((assistFormDetailAddress = props.getJSONObject("assistFormDetailAddress")) != null) {
            for (String key : assistFormDetailAddress.keySet()) {
                assistFormDetailAddress.getJSONObject(key).remove((Object)"formAuth");
            }
        }
    }

    private void importAppFile(WorkflowMigrationPreloadVo workflowMigrationPreloadVo, Map<String, Map<String, String>> fileMap, String oldServiceName, Map<String, String> importResult, Map<String, String> overrideProcessDefIdMap, Map<String, String> modelTypeMap, String oldAppCode, Map<String, String> extendProcessMap, String appType, Map<String, Integer> versionMap, String newAppId, String importType, String newAppCode, String newServiceName) {
        String processKey = workflowMigrationPreloadVo.getProcessKey();
        int importVersion = workflowMigrationPreloadVo.getImportVersion();
        String key = processKey + ":" + importVersion + ":";
        Map<String, String> workflowFile = fileMap.get(key);
        if (workflowFile == null) {
            return;
        }
        String lcpbBpmFile = workflowFile.get("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
        String xml = workflowFile.get("bpmn20.xml");
        String type = workflowMigrationPreloadVo.getImportType();
        if ("unable".equals(type)) {
            return;
        }
        ApiResponse<String> apiResponse = this.importModel(xml, lcpbBpmFile, oldServiceName, HussarUtils.isNotEmpty((Object)workflowMigrationPreloadVo.getOrganId()) ? workflowMigrationPreloadVo.getOrganId() : null, workflowMigrationPreloadVo.getRealVersion() == null ? workflowMigrationPreloadVo.getImportVersion() : workflowMigrationPreloadVo.getRealVersion().intValue(), "3".equals(appType), modelTypeMap.get(processKey), oldAppCode, extendProcessMap.get(processKey), versionMap, newAppId, importType, newAppCode, newServiceName);
        if (!apiResponse.isSuccess()) {
            importResult.put(key, apiResponse.getMsg());
        } else {
            overrideProcessDefIdMap.put(key, apiResponse.getMsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResponse<String> importModel(String xml, String lcdpbpm, String serviceName, String organId, Integer realVersion, boolean isExportExtend, String modelType, String appCode, String modelTemplateExtend, Map<String, Integer> versionMap, String newAppId, String importType, String newAppCode, String newServiceName) {
        String processKey;
        BpmnModel bpmnModel = null;
        XMLStreamReader xtr = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
            Object object = null;
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                xtr = xif.createXMLStreamReader(in);
                bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
            }
            catch (Throwable xif) {
                object = xif;
                throw xif;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable xif) {
                            ((Throwable)object).addSuppressed(xif);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            ApiResponse apiResponse = ApiResponse.fail((String)e.getMessage());
            return apiResponse;
        }
        finally {
            if (xtr != null) {
                try {
                    xtr.close();
                }
                catch (XMLStreamException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        List flowElementList = (List)((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
        WorkflowMigrationUtil.convertFlowElementFormKeyWithNewAppCode(flowElementList, appCode, newAppCode, serviceName, newServiceName);
        for (FlowElement flowElement : flowElementList) {
            if (!(flowElement instanceof SubProcess)) continue;
            List subProcessElementList = (List)((SubProcess)flowElement).getFlowElements();
            WorkflowMigrationUtil.convertFlowElementFormKeyWithNewAppCode(subProcessElementList, appCode, newAppCode, serviceName, newServiceName);
        }
        String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
        String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
        Integer finalVersion = versionMap.get(modelKey + ":" + organId);
        String identityId = this.modelMapper.getIdByIdentity(modelKey, organId);
        List sysActProcessFiles = JSON.parseArray((String)lcdpbpm, SysActProcessFile.class);
        ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
        ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
        boolean needModify = false;
        String workFlowName = null;
        String workflowStyle = null;
        String processId = null;
        String workflowNameTranslateKey = null;
        if (!isExportExtend || HussarUtils.isEmpty((Object)identityId)) {
            WorkFlow workFlow;
            List oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
                WorkflowMigrationUtil.convertFileFormKey(sysActProcessFile);
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(sysActProcessFile.getType())) continue;
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                        sysActProcessFile.setVersion(Integer.valueOf(0));
                        if ("temp-wfd".equals(sysActProcessFile.getType()) || "wfd".equals(sysActProcessFile.getType())) {
                            wfdList.add(sysActProcessFile);
                            continue;
                        }
                        metaList.add(sysActProcessFile);
                    }
                    continue;
                }
                sysActProcessFile.setId(null);
                sysActProcessFile.setVersion(Integer.valueOf(0));
                if ("temp-wfd".equals(sysActProcessFile.getType()) || "wfd".equals(sysActProcessFile.getType())) {
                    wfdList.add(sysActProcessFile);
                    continue;
                }
                metaList.add(sysActProcessFile);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow2 = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                workflowStyle = workFlow2.getWorkflowStyle();
                if (HussarUtils.isNotEmpty((Object)newAppId)) {
                    workFlow2.setAppId(newAppId);
                }
                if (HussarUtils.isNotEmpty((Object)newAppCode)) {
                    workFlow2.setAppCode(newAppCode);
                }
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow2.setModelId(Long.valueOf(identityId));
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow2).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                String workflowData = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                FlowModel flowModel = (FlowModel)JSON.parseObject((String)workflowData, FlowModel.class);
                workflowNameTranslateKey = flowModel.getProps().getProcessNameTranslateId();
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            wfdList.forEach(o -> WorkflowMigrationUtil.convertFileFormKeyWithNewAppCode(o, appCode, newAppCode, serviceName, newServiceName));
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            for (SysActProcessFile sysActProcessFile : addList) {
                sysActProcessFile.setProcessId(null);
            }
            if (HussarUtils.isEmpty((Object)organId)) {
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            if (HussarUtils.isEmpty((Object)identityId)) {
                ObjectNode modelObjectNode;
                if (HussarUtils.isNotEmpty((Object)organId)) {
                    identityId = this.workflowSnowflakeIdGenerator.getNextId();
                    BpmActReModel bpmActReModel = new BpmActReModel();
                    bpmActReModel.setId(Long.valueOf(Long.parseLong(identityId)));
                    bpmActReModel.setCategory(serviceName);
                    bpmActReModel.setVersion(finalVersion);
                    bpmActReModel.setDeploymentId(null);
                    modelObjectNode = new ObjectMapper().createObjectNode();
                    modelObjectNode.put("name", impModelName);
                    modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                    modelObjectNode.put("revision", 1);
                    bpmActReModel.setMetaInfo(modelObjectNode.toString());
                    bpmActReModel.setName(impModelName);
                    bpmActReModel.setNameTranslateKey(workflowNameTranslateKey);
                    bpmActReModel.setModelKey(modelKey);
                    bpmActReModel.setWorkflowStyle(workflowStyle);
                    bpmActReModel.setRev(Integer.valueOf(1));
                    bpmActReModel.setOrganId(organId);
                    bpmActReModel.setModelType(modelType);
                    bpmActReModel.setAppCode(newAppCode);
                    bpmActReModel.setAppId(HussarUtils.isEmpty((Object)newAppId) ? null : Long.valueOf(newAppId));
                    bpmActReModel.setModelResource("1");
                    bpmActReModel.setModelTemplateExtend("0");
                    bpmActReModel.setModelTemplate(isExportExtend ? "1" : "0");
                    this.bpmActReModelMapper.insert(bpmActReModel);
                } else {
                    Model model = this.repositoryService.newModel();
                    modelObjectNode = new ObjectMapper().createObjectNode();
                    modelObjectNode.put("name", impModelName);
                    modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                    modelObjectNode.put("revision", 1);
                    model.setMetaInfo(modelObjectNode.toString());
                    model.setName(impModelName);
                    model.setNameTranslateKey(workflowNameTranslateKey);
                    model.setKey(modelKey);
                    model.setCategory(serviceName);
                    model.setModelType(modelType);
                    model.setAppCode(newAppCode);
                    model.setAppId(HussarUtils.isEmpty((Object)newAppId) ? null : Long.valueOf(newAppId));
                    model.setWorkflowStyle(workflowStyle);
                    model.setModelTemplate(isExportExtend ? "1" : "0");
                    model.setModelResource("1");
                    model.setModelTemplateExtend(isExportExtend ? "0" : "1");
                    this.repositoryService.saveModel(model);
                    identityId = model.getId();
                }
            } else {
                ModelBuild modelBuild = this.modelService.queryModel(Long.valueOf(identityId));
                if (("2".equals(importType) || "1".equals(importType)) && "1".equals(modelBuild.getModelTemplate()) && "0".equals(modelBuild.getModelTemplateExtend())) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)updateWrapper.eq(BpmActReModel::getId, (Object)Long.valueOf(identityId))).set(BpmActReModel::getModelTemplateExtend, (Object)"1");
                    this.bpmActReModelService.update((Wrapper)updateWrapper);
                }
            }
            ExtendBpmnJsonConverter extendBpmnJsonConverter = new ExtendBpmnJsonConverter();
            extendBpmnJsonConverter.updateConvertersToBpmnMap();
            extendBpmnJsonConverter.updateConvertersToJsonMap();
            ObjectNode editorNode = extendBpmnJsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
            if (HussarUtils.isNotEmpty((Object)organId)) {
                workFlow = (WorkFlow)JSON.parseObject((byte[])((SysActProcessFile)metaList.get(0)).getContent(), WorkFlow.class, (Feature[])new Feature[0]);
                for (SysActProcessFile sysActProcessFile : wfdList) {
                    if (!"wfd".equals(sysActProcessFile.getType())) continue;
                    workFlow.setData(sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8));
                    break;
                }
            } else {
                workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(modelKey, null, false, Integer.valueOf(0), false);
            }
            if (workFlow == null) {
                logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
            }
            workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
            if (HussarUtils.isNotEmpty((Object)serviceName) && HussarUtils.isEmpty((Object)workFlow.getCategory())) {
                workFlow.setCategory(serviceName);
            }
            if (HussarUtils.isEmpty((Object)organId)) {
                this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
            }
            if (HussarUtils.isNotEmpty((Object)organId)) {
                processId = this.modelService.htszDeployModelAboutOrgan(workFlow, bpmnModel, identityId, organId, finalVersion, realVersion, isExportExtend ? "1" : "0");
            } else {
                processId = this.modelService.deployModelWithType(workFlow, Long.valueOf(Long.parseLong(identityId)), workFlow.getWorkflowStyle(), null, finalVersion, false, modelType, appCode, isExportExtend ? "1" : "0");
                String newFinalVersion = processId.split(":")[1];
                if (!newFinalVersion.equals(String.valueOf(realVersion))) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)updateWrapper.eq(BpmActReProcdef::getId, (Object)processId)).set(BpmActReProcdef::getRealVersion, (Object)realVersion);
                    this.bpmActReProcdefService.update((Wrapper)updateWrapper);
                }
            }
        } else {
            int overVersion;
            ApiResponse<String> apiResponse;
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            int templateVersion = 0;
            try {
                templateVersion = Integer.parseInt(this.processDefinitionsMapper.getTemplateProcessMsgByProcessKey(processKey, organId, appCode).getVersion());
            }
            catch (Exception exception) {
                throw new BpmException(String.format("\u672a\u83b7\u53d6\u5230\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u73af\u5883\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u6d41\u7a0b\u6807\u8bc6\u4e3a%s\u7684\u6d41\u7a0b", processKey));
            }
            List list = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)templateVersion)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            WorkFlow oldWorkflow = WorkflowMigrationUtil.getWorkflow(list);
            WorkFlow newWorkflow = WorkflowMigrationUtil.getWorkflow(sysActProcessFiles);
            if (oldWorkflow != null && newWorkflow != null && !(apiResponse = this.processCheckService.checkWorkflow(newWorkflow, oldWorkflow, "3")).isSuccess()) {
                return apiResponse;
            }
            List<DefinitionModel> mainProdef = this.processDefinitionsMapper.getMainProdef(processKey, null);
            if (HussarUtils.isEmpty(mainProdef)) {
                mainProdef = this.processDefinitionsMapper.getOtherProdef(processKey, null);
            }
            needModify = (overVersion = Integer.parseInt(mainProdef.get(0).getVersion())) == templateVersion;
            LambdaQueryWrapper removeWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)modelKey)).eq(SysActProcessFile::getType, (Object)"temp-wfd");
            if (needModify) {
                Iterator removeTempVersions = new ArrayList<Integer>();
                removeTempVersions.add(templateVersion);
                removeTempVersions.add(0);
                removeWrapper.in(SysActProcessFile::getVersion, (Collection)((Object)removeTempVersions));
            } else {
                removeWrapper.eq(SysActProcessFile::getVersion, (Object)templateVersion);
            }
            this.sysActProcessFileMapper.delete((Wrapper)removeWrapper);
            for (SysActProcessFile file : sysActProcessFiles) {
                WorkflowMigrationUtil.convertFileFormKey(file);
                if (HussarUtils.isNotEmpty((Object)list)) {
                    for (SysActProcessFile oldSysActProcessFile : list) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        processId = String.valueOf(oldSysActProcessFile.getProcessId());
                        file.setProcessId(processId);
                        file.setVersion(Integer.valueOf(templateVersion));
                        if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                            wfdList.add(file);
                            continue;
                        }
                        metaList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(templateVersion));
                if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                    wfdList.add(file);
                    continue;
                }
                metaList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                if (HussarUtils.isNotEmpty((Object)newAppId)) {
                    workFlow.setAppId(newAppId);
                }
                if (HussarUtils.isNotEmpty((Object)newAppCode)) {
                    workFlow.setAppCode(newAppCode);
                }
                workFlowName = workFlow.getName();
                workflowStyle = workFlow.getWorkflowStyle();
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                String workflowData = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                FlowModel flowModel = (FlowModel)JSON.parseObject((String)workflowData, FlowModel.class);
                workflowNameTranslateKey = flowModel.getProps().getProcessNameTranslateId();
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            BpmActGeBytearray bpmActGeBytearray = new BpmActGeBytearray();
            bpmActGeBytearray.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getModelId(templateVersion, processKey)) ? this.bpm2XMLMapper.getModelId(templateVersion, processKey) : null;
            bpmActGeBytearray.setId(id);
            this.bpmActGeBytearrayMapper.updateById(bpmActGeBytearray);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
            this.processDefinitionsMapper.updateProcessName(processId, workFlowName, workflowStyle, workflowNameTranslateKey);
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processId));
            if (!finalVersion.equals(realVersion)) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BpmActReProcdef::getId, (Object)processId)).set(BpmActReProcdef::getMainProcess, (Object)4)).set(BpmActReProcdef::getRealVersion, (Object)realVersion);
                this.bpmActReProcdefService.update((Wrapper)updateWrapper);
            }
        }
        if (needModify) {
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<SysActProcessFile> wfds = new ArrayList<SysActProcessFile>();
            ArrayList<SysActProcessFile> arrayList = new ArrayList<SysActProcessFile>();
            List oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        file.setVersion(Integer.valueOf(0));
                        file.setProcessId(null);
                        if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                            wfds.add(file);
                            continue;
                        }
                        arrayList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(0));
                file.setProcessId(null);
                if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                    wfds.add(file);
                    continue;
                }
                arrayList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : arrayList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfds);
            addList.addAll(arrayList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            BpmActGeBytearray bpmActGeBytearray = new BpmActGeBytearray();
            bpmActGeBytearray.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId))) ? this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)) : null;
            bpmActGeBytearray.setId(id);
            this.bpmActGeBytearrayMapper.updateById(bpmActGeBytearray);
            ModelQuery modelQuery = this.repositoryService.createModelQuery().modelId(identityId);
            if (HussarUtils.isNotEmpty((Object)organId)) {
                modelQuery.organId(organId);
            }
            Model modelData = (Model)modelQuery.singleResult();
            String metaInfo = modelData.getMetaInfo();
            JSONObject metaInfoJsonObject = JSONObject.parseObject((String)metaInfo);
            metaInfoJsonObject.put("name", (Object)workFlowName);
            this.processDefinitionsMapper.setNameAndDeploymentId(workFlowName, workflowNameTranslateKey, null, workflowStyle, processKey, metaInfoJsonObject.toString(), null);
        }
        return ApiResponse.success((String)processId);
    }

    public void importAssignee(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, String> organVersionMap, Map<String, Integer> versionMap) {
        ArrayList<String> importAssignee = new ArrayList<String>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getAssigneeData().booleanValue() || errorImportKeyList.contains(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":")) continue;
            importAssignee.add(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":");
        }
        if (!importAssignee.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            for (String key : importAssignee) {
                String[] keys = key.split(":");
                removeWrapper.or(wp -> {
                    wp.eq(SysActAssignee::getProcDefKey, (Object)keys[0]);
                    if (organVersionMap.containsKey(key)) {
                        wp.eq(SysActAssignee::getProcessVersion, versionMap.get(organVersionMap.get(key)));
                    } else {
                        wp.eq(SysActAssignee::getProcessVersion, (Object)Integer.valueOf(keys[1]));
                    }
                });
            }
            this.sysActAssigneeService.remove((Wrapper)removeWrapper);
            if (!workflowLoadDto.getAssigneeMsgs().isEmpty()) {
                ArrayList actAssignees = new ArrayList();
                for (String assignee : workflowLoadDto.getAssigneeMsgs()) {
                    List list = JSON.parseArray((String)assignee, SysActAssignee.class);
                    if (list.isEmpty()) continue;
                    String processKey = ((SysActAssignee)list.get(0)).getProcDefKey();
                    Integer version = ((SysActAssignee)list.get(0)).getProcessVersion();
                    String key = processKey + ":" + version + ":";
                    if (errorImportKeyList.contains(key)) continue;
                    if (organVersionMap.containsKey(key)) {
                        list.forEach(sysActAssignee -> {
                            if (organVersionMap.containsKey(sysActAssignee.getProcDefKey() + ":" + sysActAssignee.getProcessVersion() + ":")) {
                                sysActAssignee.setProcessVersion((Integer)versionMap.get(organVersionMap.get(sysActAssignee.getProcDefKey() + ":" + sysActAssignee.getProcessVersion() + ":")));
                            }
                        });
                    }
                    actAssignees.addAll(list);
                }
                if (!actAssignees.isEmpty()) {
                    for (SysActAssignee sysActAssignee2 : actAssignees) {
                        sysActAssignee2.setId(null);
                    }
                    this.sysActAssigneeService.saveBatch(actAssignees);
                }
            }
        }
    }

    public void importFormAuth(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, String> organVersionMap, Map<String, Integer> versionMap) {
        ArrayList<String> importFormAuth = new ArrayList<String>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getFormAuthData().booleanValue() || errorImportKeyList.contains(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":")) continue;
            importFormAuth.add(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":");
        }
        if (!importFormAuth.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            for (String string : importFormAuth) {
                String[] keys = string.split(":");
                removeWrapper.or(wp -> {
                    wp.eq(SysActFormAuth::getProcessKey, (Object)keys[0]);
                    if (organVersionMap.containsKey(string)) {
                        wp.eq(SysActFormAuth::getProcessVersion, organVersionMap.get(string));
                    } else {
                        wp.eq(SysActFormAuth::getProcessVersion, (Object)keys[1]);
                    }
                });
            }
            if (!workflowLoadDto.getFormAuthMsgs().isEmpty()) {
                ArrayList formAuths = new ArrayList();
                for (String formAuth : workflowLoadDto.getFormAuthMsgs()) {
                    List list = JSON.parseArray((String)formAuth, SysActFormAuth.class);
                    if (list.isEmpty()) continue;
                    String processKey = ((SysActFormAuth)list.get(0)).getProcessKey();
                    Integer version = ((SysActFormAuth)list.get(0)).getProcessVersion();
                    String key = processKey + ":" + version + ":";
                    if (errorImportKeyList.contains(key)) continue;
                    if (organVersionMap.containsKey(key)) {
                        list.forEach(sysActFormAuth -> {
                            if (organVersionMap.containsKey(sysActFormAuth.getProcessKey() + ":" + sysActFormAuth.getProcessVersion() + ":")) {
                                sysActFormAuth.setProcessVersion((Integer)versionMap.get(organVersionMap.get(sysActFormAuth.getProcessKey() + ":" + sysActFormAuth.getProcessVersion() + ":")));
                            }
                        });
                    }
                    formAuths.addAll(list);
                }
                if (!formAuths.isEmpty()) {
                    for (String formAuth : formAuths) {
                        formAuth.setId(null);
                    }
                    List list = this.sysActFormAuthService.list((Wrapper)removeWrapper);
                    ArrayList<Long> removeIds = new ArrayList<Long>();
                    block4: for (SysActFormAuth sysActFormAuth2 : formAuths) {
                        for (SysActFormAuth oldFormAuth : list) {
                            if (!this.isSameFormAuthMsg(oldFormAuth, sysActFormAuth2)) continue;
                            removeIds.add(oldFormAuth.getId());
                            continue block4;
                        }
                    }
                    List removeIdList = WorkflowBpmUtil.getSqlIdList(removeIds);
                    for (List removeId : removeIdList) {
                        this.sysActFormAuthService.removeByIds(removeId);
                    }
                    this.sysActFormAuthService.saveBatch(formAuths);
                }
            }
        }
    }

    public boolean isSameFormAuthMsg(SysActFormAuth oldFormAuth, SysActFormAuth sysActFormAuth) {
        if (oldFormAuth.getProcessKey() == null ? sysActFormAuth.getProcessKey() != null : !oldFormAuth.getProcessKey().equals(sysActFormAuth.getProcessKey())) {
            return false;
        }
        if (oldFormAuth.getProcessVersion() == null ? sysActFormAuth.getProcessVersion() != null : !oldFormAuth.getProcessVersion().equals(sysActFormAuth.getProcessVersion())) {
            return false;
        }
        if (oldFormAuth.getTaskDefinitionKey() == null ? sysActFormAuth.getTaskDefinitionKey() != null : !oldFormAuth.getTaskDefinitionKey().equals(sysActFormAuth.getTaskDefinitionKey())) {
            return false;
        }
        if (oldFormAuth.getFormName() == null ? sysActFormAuth.getFormName() != null : !oldFormAuth.getFormName().equals(sysActFormAuth.getFormName())) {
            return false;
        }
        if (oldFormAuth.getFormType() == null ? sysActFormAuth.getFormType() != null : !oldFormAuth.getFormType().equals(sysActFormAuth.getFormType())) {
            return false;
        }
        return !(oldFormAuth.getFormState() == null ? sysActFormAuth.getFormState() != null : !oldFormAuth.getFormState().equals(sysActFormAuth.getFormState()));
    }

    public void importHandleAuth(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, String> organVersionMap, Map<String, Integer> versionMap) {
        ArrayList<String> importHandleAuth = new ArrayList<String>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getHandleAuthData().booleanValue() || errorImportKeyList.contains(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":")) continue;
            importHandleAuth.add(workflow.getProcessKey() + ":" + workflow.getImportVersion() + ":");
        }
        if (!importHandleAuth.isEmpty()) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            for (String string : importHandleAuth) {
                String[] keys = string.split(":");
                removeWrapper.or(wp -> {
                    wp.eq(SysActHandleAuth::getProcessKey, (Object)keys[0]);
                    if (organVersionMap.containsKey(string)) {
                        wp.eq(SysActHandleAuth::getProcessVersion, organVersionMap.get(string));
                    } else {
                        wp.eq(SysActHandleAuth::getProcessVersion, (Object)keys[1]);
                    }
                });
            }
            if (!workflowLoadDto.getHandleAuthMsgs().isEmpty()) {
                ArrayList handleAuths = new ArrayList();
                for (String handleAuth : workflowLoadDto.getHandleAuthMsgs()) {
                    List list = JSON.parseArray((String)handleAuth, SysActHandleAuth.class);
                    if (list.isEmpty()) continue;
                    String processKey = ((SysActHandleAuth)list.get(0)).getProcessKey();
                    Integer version = ((SysActHandleAuth)list.get(0)).getProcessVersion();
                    String key = processKey + ":" + version + ":";
                    if (errorImportKeyList.contains(key)) continue;
                    if (organVersionMap.containsKey(key)) {
                        list.forEach(sysActHandleAuth -> {
                            if (organVersionMap.containsKey(sysActHandleAuth.getProcessKey() + ":" + sysActHandleAuth.getProcessVersion() + ":")) {
                                sysActHandleAuth.setProcessVersion((Integer)versionMap.get(organVersionMap.get(sysActHandleAuth.getProcessKey() + ":" + sysActHandleAuth.getProcessVersion() + ":")));
                            }
                        });
                    }
                    handleAuths.addAll(list);
                }
                if (!handleAuths.isEmpty()) {
                    List list = this.handleAuthService.list((Wrapper)removeWrapper);
                    ArrayList<Long> removeIds = new ArrayList<Long>();
                    block3: for (SysActHandleAuth sysActFormAuth : handleAuths) {
                        for (SysActHandleAuth oldFormAuth : list) {
                            if (!WorkflowMigrationUtil.isSameHandleAuth(oldFormAuth, sysActFormAuth)) continue;
                            removeIds.add(oldFormAuth.getId());
                            continue block3;
                        }
                    }
                    List removeIdList = WorkflowBpmUtil.getSqlIdList(removeIds);
                    for (List removeId : removeIdList) {
                        this.handleAuthService.removeByIds(removeId);
                    }
                    this.handleAuthService.saveBatch(handleAuths);
                }
            }
        }
    }

    public void importExtendProperties(WorkflowLoadDto workflowLoadDto, Set<String> errorImportKeyList, Map<String, String> organVersionMap, String oldAppCode, String newAppCode, String oldServiceImpl, String newServiceName) {
        List<Object> newSysActExtendProperties = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String extendPropertie : workflowLoadDto.getExpandMsgs()) {
            String procDefId;
            String processId;
            String[] processIds;
            String key;
            List extendProperties = JSON.parseArray((String)extendPropertie, SysActExtendProperties.class);
            if (HussarUtils.isEmpty((Object)extendProperties) || errorImportKeyList.contains(key = (processIds = (processId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId()).split(":"))[0] + ":" + processIds[1] + ":")) continue;
            if (organVersionMap.containsKey(key)) {
                procDefId = organVersionMap.get(key);
                importProcessIds.add(procDefId);
                for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                    sysActExtendProperties.setProcDefId(organVersionMap.get(key));
                    sysActExtendProperties.setId(null);
                }
            } else {
                procDefId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId();
                importProcessIds.add(procDefId);
                for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                    sysActExtendProperties.setId(null);
                }
            }
            for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                String newFormDetailKey = WorkflowMigrationUtil.convertFormKeyWithNewAppCode(sysActExtendProperties.getFormDetailKey(), oldAppCode, newAppCode, oldServiceImpl, newServiceName);
                String newCcFormDetailKey = WorkflowMigrationUtil.convertFormKeyWithNewAppCode(sysActExtendProperties.getCcFormDetailKey(), oldAppCode, newAppCode, oldServiceImpl, newServiceName);
                String newAssistFormDetailKey = WorkflowMigrationUtil.convertFormKeyWithNewAppCode(sysActExtendProperties.getAssistFormDetailKey(), oldAppCode, newAppCode, oldServiceImpl, newServiceName);
                sysActExtendProperties.setFormDetailKey(newFormDetailKey);
                sysActExtendProperties.setCcFormDetailKey(newCcFormDetailKey);
                sysActExtendProperties.setAssistFormDetailKey(newAssistFormDetailKey);
            }
            newSysActExtendProperties.addAll(extendProperties);
        }
        if (newSysActExtendProperties.isEmpty()) {
            return;
        }
        importProcessIds.forEach(SysActExtendPropertiesCacheUtil::clearExtendPropertiesCacheByProcessDefinitionId);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, importProcessIds);
        this.sysActExtendPropertiesService.remove((Wrapper)lambdaQueryWrapper);
        newSysActExtendProperties = newSysActExtendProperties.stream().collect(Collectors.toMap(item -> item.getProcDefId() + "_" + item.getTaskDefKey(), Function.identity(), (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
        this.sysActExtendPropertiesService.saveBatch(newSysActExtendProperties);
    }
}

