/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendCommonConverterUtil;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.TerminateEventDefinition;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.EndEventJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class ExtendEndEventJsonConverter
extends EndEventJsonConverter {
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        ExtendCommonConverterUtil.commonConvertElementToJson(propertiesNode, baseElement);
        EndEvent endEvent = (EndEvent)baseElement;
        Map elementsListMap = endEvent.getExtensionElements();
        List flowFormDetailKeyElement = (List)elementsListMap.get("flowFormDetailKey");
        if (flowFormDetailKeyElement != null && !flowFormDetailKeyElement.isEmpty()) {
            List flowFormDetailKeyList;
            String flowFormDetailKey = "";
            Map flowFormDetailKeyMap = ((ExtensionElement)flowFormDetailKeyElement.get(0)).getAttributes();
            if (flowFormDetailKeyMap != null && (flowFormDetailKeyList = (List)flowFormDetailKeyMap.get("flowFormDetailKey")) != null && !flowFormDetailKeyList.isEmpty()) {
                flowFormDetailKey = ((ExtensionAttribute)flowFormDetailKeyList.get(0)).getValue();
            }
            propertiesNode.put("flowFormDetailKey", flowFormDetailKey);
        }
        this.addEventProperties((Event)endEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        CancelEventDefinition eventDefinition;
        EndEvent endEvent = new EndEvent();
        ExtendCommonConverterUtil.commonConvertJsonToElement((FlowElement)endEvent, elementNode);
        String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)elementNode);
        if ("EndErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)endEvent);
        } else if ("EndCancelEvent".equals(stencilId)) {
            eventDefinition = new CancelEventDefinition();
            endEvent.getEventDefinitions().add(eventDefinition);
        } else if ("EndTerminateEvent".equals(stencilId)) {
            eventDefinition = new TerminateEventDefinition();
            String terminateAllStringValue = this.getPropertyValueAsString("terminateall", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)terminateAllStringValue)) {
                eventDefinition.setTerminateAll("true".equals(terminateAllStringValue));
            }
            endEvent.getEventDefinitions().add(eventDefinition);
        }
        ExtensionElement formDetailExtensionElementNode = new ExtensionElement();
        ExtensionAttribute formDetailExtensionAttributeNode = new ExtensionAttribute();
        String flowFormDetailKey = this.getPropertyValueAsString("flowFormDetailKey", elementNode);
        formDetailExtensionElementNode.setName("flowFormDetailKey");
        formDetailExtensionElementNode.setNamespacePrefix("extend");
        formDetailExtensionElementNode.setNamespace("http://activiti.org/bpmn");
        formDetailExtensionAttributeNode.setName("flowFormDetailKey");
        formDetailExtensionAttributeNode.setValue(flowFormDetailKey);
        formDetailExtensionElementNode.addAttribute(formDetailExtensionAttributeNode);
        endEvent.addExtensionElement(formDetailExtensionElementNode);
        return endEvent;
    }
}

