/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.function.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.GetTokenUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bpm.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.integrationPlatform.IntegrationPlatformInfoUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.assigneefunction.service.AssigneeFunctionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class WorkflowFunctionUtil {
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);
    private static ISysActFunctionService sysActFunctionService = (ISysActFunctionService)BpmSpringContextHolder.getBean(ISysActFunctionService.class);
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);
    private static Logger logger = LogManager.getLogger(WorkflowFunctionUtil.class);
    private static final List<String> CHECK_DEFAULT_FUNCTION_LIST = new ArrayList<String>();
    private static final String MICRO = "micro";
    private static final String SINGLE = "single";
    private static final Pattern REGEX;

    private static String getDeploymentModel() {
        return lcdpBpmProperties.getDeploymentModel();
    }

    public static String getFunctionCondition(String realCondition, Map<String, String> processInfo, String serviceName) {
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(44);
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = WorkflowFunctionUtil.functionUser((Map)JSON.parse((String)message), processInfo, serviceName);
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && !userList.isEmpty()) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        return realCondition;
    }

    private static List<String> functionUser(Map<String, Object> message, Map<String, String> processInfo, String serviceName) {
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        if (beanId == null) {
            return new ArrayList<String>();
        }
        Long appId = null;
        if (HussarUtils.isNotEmpty((Object)processInfo.get("appId"))) {
            appId = Long.valueOf(processInfo.get("appId"));
        }
        String appCode = processInfo.get("appCode");
        Map map = (Map)message.get(beanId);
        map.putAll(processInfo);
        SysActFunction function = sysActFunctionService.getFunctionByBeanId(beanId);
        if (HussarUtils.isEmpty((Object)function)) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_NO_EXIST_FUNCTION);
        }
        if ("1".equals(function.getFunctionDataType())) {
            return new ArrayList<String>();
        }
        String functionType = function.getFunctionType();
        String requestMethod = function.getRequestMethod();
        String deploymentModel = WorkflowFunctionUtil.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)functionType) || "local".equals(functionType)) {
            switch (deploymentModel) {
                case "single": {
                    AssigneeVisitor hussarBpmVariablesVisitor;
                    try {
                        hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((Long)appId, (String)beanId, (String)appCode);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                    return hussarBpmVariablesVisitor.visit(map);
                }
                case "micro": {
                    try {
                        if (CHECK_DEFAULT_FUNCTION_LIST.contains(beanId)) {
                            serviceName = "hussar-web";
                        }
                        AssigneeFunctionService assigneeFunctionService = (AssigneeFunctionService)BpmSpringContextHolder.getBean(AssigneeFunctionService.class);
                        return assigneeFunctionService.executeListener(beanId, map, serviceName);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
        }
        if ("remote".equals(functionType)) {
            String url = lcdpBpmProperties.getTenantCallAddress() + beanId;
            try {
                switch (requestMethod) {
                    case "GET": {
                        String response = HttpClient.doGet((String)url, (Map)map);
                        return JSON.parseArray((String)response, String.class);
                    }
                    case "POST": {
                        String response = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)map));
                        return JSON.parseArray((String)response, String.class);
                    }
                }
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_REQUEST_METHOD);
            }
            catch (Exception e) {
                String errorMsg = WorkflowFunctionUtil.getErrorFunctionRequest(function.getFunctionName());
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCATION_REQUEST.getCode(), errorMsg);
            }
        }
        if ("integrationPlatform".equals(functionType)) {
            try {
                JSONObject functionMap = JSON.parseObject((String)beanId);
                beanId = functionMap.get("functionAddress") + "";
            }
            catch (Exception e) {
                throw new BpmException("\u51fd\u6570\u7ba1\u7406\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (!beanId.startsWith("/")) {
                beanId = "/" + beanId;
            }
            String url = IntegrationPlatformInfoUtil.getIntegrationPlatformAddress() + beanId;
            try {
                String response = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)map), GetTokenUtil.buildHeaderMap(GetTokenUtil.getToken(), null, GetTokenUtil.getClientId()));
                return JSON.parseArray((String)JSON.parseObject((String)response).get((Object)"data").toString(), String.class);
            }
            catch (Exception e) {
                String errorMsg = WorkflowFunctionUtil.getErrorFunctionRequest(function.getFunctionName());
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCATION_REQUEST.getCode(), errorMsg);
            }
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
    }

    private static String getErrorFunctionRequest(String functionName) {
        String errorMsg = "\u8c03\u7528\u51fd\u6570" + functionName + "\u5931\u8d25";
        return errorMsg;
    }

    private static List<String> functionConditionUser(String beanId, Map<String, String> map, SysActFunction function, String serviceName) {
        Long appId = null;
        String appIdStr = String.valueOf(modelService.getAppId(map.get("workflowProcessKey")));
        if (HussarUtils.isNotEmpty((Object)appIdStr) && !"null".equals(appIdStr)) {
            appId = Long.valueOf(appIdStr);
        }
        String appCode = modelService.getAppCode(map.get("workflowProcessKey"));
        String functionType = function.getFunctionType();
        String requestMethod = function.getRequestMethod();
        String deploymentModel = WorkflowFunctionUtil.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)functionType) || "local".equals(functionType)) {
            switch (deploymentModel) {
                case "single": {
                    AssigneeVisitor hussarBpmVariablesVisitor;
                    try {
                        hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((Long)appId, (String)beanId, (String)appCode);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                    return hussarBpmVariablesVisitor.visit(map);
                }
                case "micro": {
                    try {
                        if (CHECK_DEFAULT_FUNCTION_LIST.contains(beanId)) {
                            serviceName = "hussar-web";
                        }
                        AssigneeFunctionService assigneeFunctionService = (AssigneeFunctionService)BpmSpringContextHolder.getBean(AssigneeFunctionService.class);
                        return assigneeFunctionService.executeListener(beanId, map, serviceName);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
        }
        if ("remote".equals(functionType)) {
            String url = lcdpBpmProperties.getTenantCallAddress() + beanId;
            try {
                switch (requestMethod) {
                    case "GET": {
                        String response = HttpClient.doGet((String)url, map);
                        return JSON.parseArray((String)response, String.class);
                    }
                    case "POST": {
                        String response = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                        return JSON.parseArray((String)response, String.class);
                    }
                }
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_REQUEST_METHOD);
            }
            catch (Exception e) {
                String errorMsg = WorkflowFunctionUtil.getErrorFunctionRequest(function.getFunctionName());
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCATION_REQUEST.getCode(), errorMsg);
            }
        }
        if ("integrationPlatform".equals(functionType)) {
            try {
                JSONObject functionMap = JSON.parseObject((String)beanId);
                beanId = functionMap.get("functionAddress") + "";
            }
            catch (Exception e) {
                throw new BpmException("\u51fd\u6570\u7ba1\u7406\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (!beanId.startsWith("/")) {
                beanId = "/" + beanId;
            }
            String url = IntegrationPlatformInfoUtil.getIntegrationPlatformAddress() + beanId;
            try {
                String response = HttpClient.doPost((String)url, (String)JSON.toJSONString(map), GetTokenUtil.buildHeaderMap(GetTokenUtil.getToken(), null, GetTokenUtil.getClientId()));
                return JSON.parseArray((String)JSON.parseObject((String)response).get((Object)"data").toString(), String.class);
            }
            catch (Exception e) {
                String errorMsg = WorkflowFunctionUtil.getErrorFunctionRequest(function.getFunctionName());
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCATION_REQUEST.getCode(), errorMsg);
            }
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
    }

    public static Map<String, Object> getFunctionFlowCondition(String realCondition, Map<String, String> map) {
        String serviceName = modelService.getServiceName(map.get("workflowProcessKey"));
        HashMap<String, Object> functionValueMap = new HashMap<String, Object>();
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(44);
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                Map messageMap = (Map)JSON.parse((String)message);
                String beanId = (String)new ArrayList(messageMap.keySet()).get(0);
                if (beanId == null) continue;
                Map funcitonVariablesMap = (Map)messageMap.get(beanId);
                map.putAll(funcitonVariablesMap);
                SysActFunction function = sysActFunctionService.getFunctionByBeanId(beanId);
                if (HussarUtils.isEmpty((Object)function)) {
                    throw new BpmException(BpmExceptionCodeEnum.ERROR_NO_EXIST_FUNCTION);
                }
                if ("1".equals(function.getFunctionDataType())) {
                    boolean functionFlowConditionValue = WorkflowFunctionUtil.functionFlowCondition(beanId, map, function, serviceName);
                    StringBuilder conditions = new StringBuilder();
                    String lineConditions = "";
                    String functionFlowConditionStr = null;
                    if (HussarUtils.isNotEmpty((Object)functionFlowConditionValue)) {
                        functionFlowConditionStr = String.valueOf(functionFlowConditionValue);
                        conditions.append(functionFlowConditionStr).append("','");
                        lineConditions = conditions.toString().substring(0, conditions.toString().length() - 3);
                    } else {
                        lineConditions = "";
                    }
                    realCondition = realCondition.replace(matcher.group(), lineConditions);
                    continue;
                }
                List<String> userList = WorkflowFunctionUtil.functionConditionUser(beanId, map, function, serviceName);
                functionValueMap.put(beanId, userList);
                realCondition = realCondition.replace(matcher.group(), beanId);
            }
        }
        functionValueMap.put("realCondition", realCondition);
        return functionValueMap;
    }

    private static boolean functionFlowCondition(String beanId, Map<String, String> map, SysActFunction function, String serviceName) {
        Long appId = null;
        String appIdStr = String.valueOf(modelService.getAppId(map.get("workflowProcessKey")));
        if (HussarUtils.isNotEmpty((Object)appIdStr) && !"null".equals(appIdStr)) {
            appId = Long.valueOf(appIdStr);
        }
        String appCode = modelService.getAppCode(map.get("workflowProcessKey"));
        String functionType = function.getFunctionType();
        String requestMethod = function.getRequestMethod();
        String deploymentModel = WorkflowFunctionUtil.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)functionType) || "local".equals(functionType)) {
            switch (deploymentModel) {
                case "single": {
                    AssigneeVisitor hussarBpmVariablesVisitor;
                    try {
                        hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((Long)appId, (String)beanId, (String)appCode);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return false;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return false;
                    }
                    return hussarBpmVariablesVisitor.visitBoolean(map);
                }
                case "micro": {
                    try {
                        AssigneeFunctionService assigneeFunctionService = (AssigneeFunctionService)BpmSpringContextHolder.getBean(AssigneeFunctionService.class);
                        return assigneeFunctionService.executeBooleanListener(beanId, map, serviceName);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return false;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
        }
        if ("remote".equals(functionType)) {
            String url = lcdpBpmProperties.getTenantCallAddress() + beanId;
            try {
                switch (requestMethod) {
                    case "GET": {
                        String response = HttpClient.doGet((String)url, map);
                        return Boolean.parseBoolean(response);
                    }
                    case "POST": {
                        String response = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                        return Boolean.parseBoolean(response);
                    }
                }
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_REQUEST_METHOD);
            }
            catch (Exception e) {
                String errorMsg = WorkflowFunctionUtil.getErrorFunctionRequest(function.getFunctionName());
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCATION_REQUEST.getCode(), errorMsg);
            }
        }
        if ("integrationPlatform".equals(functionType)) {
            try {
                JSONObject functionMap = JSON.parseObject((String)beanId);
                beanId = functionMap.get("functionAddress") + "";
            }
            catch (Exception e) {
                throw new BpmException("\u51fd\u6570\u7ba1\u7406\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (!beanId.startsWith("/")) {
                beanId = "/" + beanId;
            }
            String url = IntegrationPlatformInfoUtil.getIntegrationPlatformAddress() + beanId;
            try {
                String response = HttpClient.doPost((String)url, (String)JSON.toJSONString(map), GetTokenUtil.buildHeaderMap(GetTokenUtil.getToken(), null, GetTokenUtil.getClientId()));
                return Boolean.parseBoolean(JSON.parseObject((String)response).get((Object)"data").toString());
            }
            catch (Exception e) {
                String errorMsg = WorkflowFunctionUtil.getErrorFunctionRequest(function.getFunctionName());
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCATION_REQUEST.getCode(), errorMsg);
            }
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
    }

    static {
        CHECK_DEFAULT_FUNCTION_LIST.add("suprDeptHeadOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("suprDeptBranchLeadersOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("suprDeptLeadersOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("deptHeadOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("branchLeadersOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("deptLeadersOfStarter");
        REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    }
}

