/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import java.util.LinkedHashMap;
import java.util.Map;

public class BpmSecurityUtil {
    private static ISysDicRefService sysDicRefService = (ISysDicRefService)SpringContextHolder.getBean(ISysDicRefService.class);
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);

    public static String getSecurityLevelLabel(Integer securityLevel) {
        if (HussarUtils.isEmpty((Object)securityLevel) || !lcdpBpmProperties.isUseSecurityLevel()) {
            return null;
        }
        LinkedHashMap securityMap = sysDicRefService.getDictMapByType("security_level");
        Integer maxMatchingKey = null;
        Object securityLabel = null;
        for (Map.Entry entry : securityMap.entrySet()) {
            Integer keyInt = Integer.parseInt((String)entry.getKey());
            if (keyInt > securityLevel || maxMatchingKey != null && keyInt <= maxMatchingKey) continue;
            maxMatchingKey = keyInt;
            securityLabel = entry.getValue();
        }
        return HussarUtils.isNotEmpty(securityLabel) ? String.valueOf(securityLabel) : null;
    }
}

