/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.task.Task;

public class TaskCompleteCmd
extends AddAttributeCmd<TaskEntity> {
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)BpmSpringContextHolder.getBean(ISysActCcTaskService.class);
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    private String taskId;
    private String userId;
    private String mandator;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String comment;
    private Boolean notNeedCheckAssignee;
    private Boolean isNotAdd;
    private Map<String, Object> paramMap;

    public TaskCompleteCmd(String taskId, String userId, String mandator, Map<String, Object> variables, Boolean notNeedCheckAssignee, Boolean isNotAdd) {
        this(taskId, userId);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
        this.notNeedCheckAssignee = notNeedCheckAssignee;
        this.isNotAdd = isNotAdd;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables, Boolean notNeedCheckAssignee, Boolean isNotAdd) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
        this.notNeedCheckAssignee = notNeedCheckAssignee;
        this.isNotAdd = isNotAdd;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables, Boolean notNeedCheckAssignee, Boolean isNotAdd, Map<String, Object> paramMap) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
        this.notNeedCheckAssignee = notNeedCheckAssignee;
        this.isNotAdd = isNotAdd;
        this.paramMap = paramMap;
    }

    public TaskEntity execute(CommandContext commandContext) {
        Object isPushMobileMessage;
        this.addAttribute(commandContext);
        commandContext.addAttribute("notNeedCheckAssignee", (Object)this.notNeedCheckAssignee);
        commandContext.addAttribute("isNotAdd", (Object)this.isNotAdd);
        if (HussarUtils.isNotEmpty(this.paramMap) && HussarUtils.isNotEmpty((Object)(isPushMobileMessage = this.paramMap.get("isPushMobileMessage")))) {
            commandContext.addAttribute("isPushMobileMessage", (Object)Boolean.valueOf(isPushMobileMessage.toString()));
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        this.addExecutionAttribute(task.getProcessInstance());
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(this.taskId);
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        if (HussarUtils.isNotEmpty((Object)commandContext.getAttribute("multi_node_type"))) {
            HistoricProcessInstanceEntity historicProcessInstanceEntity = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(task.getProcessInstance().getProcessInstanceId());
            Map oldNodeMultiTypeMap = (Map)JSON.parseObject((String)historicProcessInstanceEntity.getNodeMultiType(), Map.class);
            Map newNodeMultiTypeMap = (Map)commandContext.getAttribute("multi_node_type");
            if (newNodeMultiTypeMap.containsKey(task.getTaskDefinitionKey())) {
                newNodeMultiTypeMap.remove(task.getTaskDefinitionKey());
            }
            Map resultMap = new HashMap();
            resultMap = HussarUtils.isEmpty((Object)oldNodeMultiTypeMap) ? newNodeMultiTypeMap : TaskCompleteCmd.mergeMaps(newNodeMultiTypeMap, oldNodeMultiTypeMap);
            historicProcessInstanceEntity.setNodeMultiType(JSON.toJSONString(resultMap));
            commandContext.getDbSqlSession().update((PersistentObject)historicProcessInstanceEntity);
        }
        commandContext.addAttribute("bpm_submit_source", (Object)task.getTaskDefinitionKey());
        task.getExecution().setAllPrevNode(task.getTaskDefinitionKey());
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        List childTasks = taskEntityManager.findTasksByParentTaskId(this.taskId);
        String processKey = null;
        String processDefinitionId = null;
        ExecutionEntity execution = task.getExecution();
        if (!childTasks.isEmpty()) {
            ArrayList childTaskIds = new ArrayList();
            childTasks.forEach(childTask -> {
                execution.removeTask((TaskEntity)childTask);
                taskEntityManager.deleteTask((TaskEntity)childTask, null, true);
                childTaskIds.add(childTask.getId());
            });
            processKey = ((Task)childTasks.get(0)).getProcessDefinitionId().split(",")[0];
            processDefinitionId = ((Task)childTasks.get(0)).getProcessDefinitionId();
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(processDefinitionId);
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessKey(processKey);
                dataPush.setProcessDefinitionId(processDefinitionId);
                dataPush.setTaskIds(childTaskIds);
                dataPush.setProcessInsId(execution.getProcessInstanceId());
                this.dataPushService.deleteMultiTask(dataPush);
            }
        }
        if (task.getDelegationState() != null) {
            task.resolve();
        }
        task.fireEvent("beforeComplete");
        if (task.getExecutionId() != null) {
            task.setExecutionVariables(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        ParamModel paramModel = this.getParamModel(task, this.variables);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        task.complete(this.variables, false, this.mandator);
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.taskId);
        }
        if (this.userId != null) {
            List ccTaskEntityList = Context.getCommandContext().getCcTaskEntityManager().getCcTaskByProcessInsIdAndTaskDefKey(task.getTaskDefinitionKey(), Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
            ArrayList<CcTaskEntity> privateCcTaskEntityList = new ArrayList<CcTaskEntity>();
            List<Object> userList = new ArrayList();
            userList = Arrays.asList(this.userId.split(","));
            for (CcTaskEntity ccTaskEntity : ccTaskEntityList) {
                if (!userList.contains(ccTaskEntity.getReceiveUser()) || !"0".equals(ccTaskEntity.getTaskState())) continue;
                privateCcTaskEntityList.add(ccTaskEntity);
            }
            if (HussarUtils.isNotEmpty(privateCcTaskEntityList)) {
                Date date = new Date();
                Timestamp endTime = new Timestamp(date.getTime());
                for (CcTaskEntity sysActCcTask : privateCcTaskEntityList) {
                    sysActCcTask.setTaskState("1");
                    sysActCcTask.setEndTime(endTime);
                    String version = sysActCcTask.getProcDefId().split(":")[1];
                    Map<String, JSONObject> pageTypeMap = CommonCodeUtil.getPageTypeByTaskType(sysActCcTask.getProcDefKey(), Integer.valueOf(version), sysActCcTask.getTaskDefKey(), "ccDone");
                    sysActCcTask.setPageType(JSON.toJSONString(pageTypeMap));
                    sysActCcTask.updateCcTask();
                    if (!this.dataPushService.isDataPush(sysActCcTask.getProcDefId())) continue;
                    DataPush dataPush = new DataPush();
                    dataPush.setUserId(sysActCcTask.getReceiveUser());
                    dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
                    dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                    dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
                    dataPush.setProcessInsId(String.valueOf(sysActCcTask.getProcessInsId()));
                    this.dataPushService.readCcTask(dataPush);
                }
            }
        }
        return task;
    }

    public TaskCompleteCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, Map<String, Object> variables) {
        this(taskId, userId);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public TaskCompleteCmd(String taskId, String userId, String comment) {
        this(taskId, userId);
        this.comment = comment;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public ParamModel getParamModel(TaskEntity task, Map<String, Object> variables) {
        ParamModel paramModel = new ParamModel();
        paramModel.mappingCompleteType(BpmAttribute.getTaskSourceFlag(task));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setHandler(this.userId);
        paramModel.setLastNodeId(task.getTaskDefinitionKey());
        paramModel.setLastTaskId(task.getId());
        paramModel.setLastNodeName(task.getName());
        paramModel.mappingLastCompleteType(BpmAttribute.getTaskSourceFlag(task));
        paramModel.setLastNodeHandler(this.userId);
        paramModel.setSendUser(this.userId);
        paramModel.setCreateReason("completeCreate");
        return paramModel;
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> map1, Map<K, V> map2) {
        HashMap<K, V> resultMap = new HashMap<K, V>(map1);
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (resultMap.containsKey(entry.getKey())) continue;
            resultMap.put(entry.getKey(), entry.getValue());
        }
        return resultMap;
    }
}

