/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.integrationPlatform.IntegrationPlatformInfoUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.service.PublicProcessApiService;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class PublicProcessWorkflowApiService
implements PublicProcessApiService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private BpmMsgPushService bpmMsgPushService;
    @Value(value="${spring.profiles.active:prod}")
    private String environmentType;

    public ApiResponse<Object> getEnvironmentType() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("deploymentModel", this.lcdpBpmProperties.getDeploymentModel());
        result.put("environmentType", this.environmentType);
        return ApiResponse.success(result);
    }

    public ApiResponse<String> getModifyConfigurationOnline() {
        return ApiResponse.success((String)String.valueOf(this.lcdpBpmProperties.isModifyConfigurationOnline()));
    }

    public ApiResponse<String> isProductionMode() {
        return ApiResponse.success((String)String.valueOf(this.lcdpBpmProperties.isEditableOnline()));
    }

    public ApiResponse<Object> isUseOrganProcess() {
        return ApiResponse.success((Object)this.lcdpBpmProperties.isUseOrganProcess());
    }

    public ApiResponse<Object> getWorkflowPlatformStandalone() {
        return ApiResponse.success((Object)this.lcdpBpmProperties.isWorkflowPlatformStandalone());
    }

    public ApiResponse<Object> getTenantIsBase() {
        return ApiResponse.success((Object)this.lcdpBpmProperties.isTenantIsBase());
    }

    public ApiResponse<Object> getTenantCallAddress() {
        String tenantCallAddress = this.lcdpBpmProperties.getTenantCallAddress();
        return ApiResponse.success((Object)tenantCallAddress, (String)ResultCode.SUCCESS.getMessage());
    }

    public BpmResponseResult getMessageChannel(String sceneCategory) {
        return this.bpmMsgPushService.getBpmActChannel(sceneCategory);
    }

    public ApiResponse<String> noCodeOpenType() {
        return ApiResponse.success((int)ResultCode.SUCCESS.getCode(), (Object)this.lcdpBpmProperties.noCodeOpenType(), (String)ResultCode.SUCCESS.getMessage());
    }

    public Boolean getIsUseSecurityLevel() {
        return this.lcdpBpmProperties.isUseSecurityLevel();
    }

    public Boolean isUseIntegrationPlatform() {
        return IntegrationPlatformInfoUtil.isUseIntegrationPlatform();
    }

    public ApiResponse<String> visitorGenerateType() {
        return ApiResponse.success((int)ResultCode.SUCCESS.getCode(), (Object)this.lcdpBpmProperties.visitorGenerateType(), (String)ResultCode.SUCCESS.getMessage());
    }

    public ApiResponse<String> getProcessFileType() {
        return ApiResponse.success((int)ResultCode.SUCCESS.getCode(), (Object)this.lcdpBpmProperties.getProcessFileType(), (String)ResultCode.SUCCESS.getMessage());
    }
}

