/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.customform.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarLocalTransactional;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.config.WorkflowSnowflakeIdGenerator;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.dao.BpmOtherSystemCustomFormTypeMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.dao.BpmOtherSystemMaintainMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.dto.BpmOtherSystemCustomFormTypeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.dto.BpmOtherSystemMaintainDto;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.BpmOtherSystemCustomFormType;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.BpmOtherSystemMaintain;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.IBpmOtherSystemCustomFormTypeService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.IBpmOtherSystemMaintainService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.vo.BpmOtherSystemCustomFormTypeVo;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.vo.BpmOtherSystemMaintainVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ThirdSystemDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.ThirdSystemDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.ThirdSystemLoadVo;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class BpmOtherSystemMaintainServiceImpl
extends HussarServiceImpl<BpmOtherSystemMaintainMapper, BpmOtherSystemMaintain>
implements IBpmOtherSystemMaintainService {
    private static final Logger logger = LoggerFactory.getLogger(BpmOtherSystemMaintainServiceImpl.class);
    @Autowired
    private IBpmOtherSystemCustomFormTypeService customFormTypeService;
    @Resource
    private BpmOtherSystemCustomFormTypeMapper bpmOtherSystemCustomFormTypeMapper;
    @Autowired
    private IBpmOtherSystemCustomFormTypeService bpmOtherSystemCustomFormTypeService;
    @Resource
    private BpmOtherSystemMaintainMapper bpmOtherSystemMaintainMapper;
    @Autowired
    private WorkflowSnowflakeIdGenerator workflowSnowflakeIDGenerator;

    @HussarTransactional
    @HussarLocalTransactional
    public boolean add(BpmOtherSystemMaintainDto otherSystemMaintainDto) {
        BpmOtherSystemMaintain otherSystemMaintain = new BpmOtherSystemMaintain();
        try {
            this.copy(otherSystemMaintain, otherSystemMaintainDto);
            List customFormTypeList = otherSystemMaintainDto.getCustomFormTypeList();
            ArrayList<BpmOtherSystemCustomFormType> resultList = new ArrayList<BpmOtherSystemCustomFormType>();
            String id = this.workflowSnowflakeIDGenerator.getNextId();
            otherSystemMaintain.setSystemId(Long.valueOf(id));
            for (BpmOtherSystemCustomFormTypeDto customFormType : customFormTypeList) {
                BpmOtherSystemCustomFormType bpmOtherSystemCustomFormType = new BpmOtherSystemCustomFormType();
                bpmOtherSystemCustomFormType.setFormTypeName(customFormType.getFormTypeName());
                bpmOtherSystemCustomFormType.setFormAddress(customFormType.getFormAddress().replaceAll("\\s+", ""));
                bpmOtherSystemCustomFormType.setServiceId(Long.valueOf(id));
                resultList.add(bpmOtherSystemCustomFormType);
            }
            otherSystemMaintain.setSystemType("1");
            LocalDateTime now = LocalDateTime.now();
            otherSystemMaintain.setCreateTime(now);
            otherSystemMaintain.setUpdateTime(now);
            boolean master = this.save((BaseEntity)otherSystemMaintain);
            boolean slave = true;
            if (!resultList.isEmpty()) {
                slave = this.customFormTypeService.saveBatch(resultList);
            }
            return master && slave;
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred while adding other system info", (Throwable)e);
            throw new BpmException("Unexpected error occurred while adding other system info : " + e.getMessage());
        }
    }

    public void copy(Object obj1, Object obj2) {
        BeanCopier copier = BeanCopier.create(obj2.getClass(), obj1.getClass(), (boolean)false);
        copier.copy(obj2, obj1, null);
    }

    @HussarTransactional
    @HussarLocalTransactional
    public boolean update(BpmOtherSystemMaintainDto otherSystemMaintainDto) {
        if (HussarUtils.isEmpty((Object)otherSystemMaintainDto.getSystemId())) {
            logger.error("Non empty parameters cannot be empty");
            return false;
        }
        BpmOtherSystemMaintain otherSystemMaintain = new BpmOtherSystemMaintain();
        try {
            this.copy(otherSystemMaintain, otherSystemMaintainDto);
            List customFormTypeList = otherSystemMaintainDto.getCustomFormTypeList();
            ArrayList<BpmOtherSystemCustomFormType> resultList = new ArrayList<BpmOtherSystemCustomFormType>();
            long id = otherSystemMaintain.getSystemId();
            this.customFormTypeService.remove((Wrapper)new LambdaQueryWrapper().eq(BpmOtherSystemCustomFormType::getServiceId, (Object)id));
            for (BpmOtherSystemCustomFormTypeDto customFormType : customFormTypeList) {
                BpmOtherSystemCustomFormType bpmOtherSystemCustomFormType = new BpmOtherSystemCustomFormType();
                bpmOtherSystemCustomFormType.setFormTypeName(customFormType.getFormTypeName());
                bpmOtherSystemCustomFormType.setFormAddress(customFormType.getFormAddress().replaceAll("\\s+", ""));
                bpmOtherSystemCustomFormType.setServiceId(Long.valueOf(id));
                resultList.add(bpmOtherSystemCustomFormType);
            }
            otherSystemMaintain.setUpdateTime(LocalDateTime.now());
            boolean master = this.updateById((BaseEntity)otherSystemMaintain);
            boolean slave = true;
            if (!resultList.isEmpty()) {
                slave = this.customFormTypeService.saveBatch(resultList);
            }
            return master && slave;
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred while updating other system info", (Throwable)e);
            throw new BpmException("Unexpected error occurred while updating other system info : " + e.getMessage());
        }
    }

    @HussarTransactional
    @HussarLocalTransactional
    public boolean delete(Long fromTypeId, boolean logicallyDelete) {
        if (fromTypeId == null) {
            logger.error("Non empty parameters cannot be empty");
            return false;
        }
        try {
            if (logicallyDelete) {
                // empty if block
            }
            boolean master = this.removeById(fromTypeId);
            boolean slave = this.customFormTypeService.remove((Wrapper)new LambdaQueryWrapper().eq(BpmOtherSystemCustomFormType::getServiceId, (Object)fromTypeId));
            return master && slave;
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred while deleting other system info", (Throwable)e);
            throw new BpmException("Failed to delete other system info : " + e.getMessage());
        }
    }

    public Page<BpmOtherSystemMaintainVo> detail(BpmOtherSystemMaintainDto otherSystemMaintainDto) {
        int page = HussarUtils.isEmpty((Object)otherSystemMaintainDto.getCurrent()) ? 1 : otherSystemMaintainDto.getCurrent();
        int size = HussarUtils.isEmpty((Object)otherSystemMaintainDto.getSize()) ? 10 : otherSystemMaintainDto.getSize();
        Page pages = new Page((long)page, (long)size);
        String systemName = otherSystemMaintainDto.getSystemName();
        if (HussarUtils.isNotEmpty((Object)systemName)) {
            systemName = systemName.replace("%", "\\%");
            otherSystemMaintainDto.setSystemName(systemName);
        }
        List<BpmOtherSystemMaintainVo> customFormTypeVos = ((BpmOtherSystemMaintainMapper)this.baseMapper).queryList((Page<BpmOtherSystemMaintainVo>)pages, otherSystemMaintainDto);
        List typeList = this.customFormTypeService.list();
        Map<Long, List<BpmOtherSystemCustomFormType>> collect = typeList.stream().collect(Collectors.groupingBy(BpmOtherSystemCustomFormType::getServiceId));
        for (BpmOtherSystemMaintainVo bpmOtherSystemMaintainVo : customFormTypeVos) {
            bpmOtherSystemMaintainVo.setCustomFormTypeList(collect.get(bpmOtherSystemMaintainVo.getSystemId()));
        }
        pages.setRecords(customFormTypeVos);
        return pages;
    }

    public List<BpmOtherSystemCustomFormTypeVo> getFormTypeInfo(Long systemId) {
        if (systemId == null) {
            return Collections.emptyList();
        }
        List list = this.customFormTypeService.list((Wrapper)new LambdaQueryWrapper().eq(BpmOtherSystemCustomFormType::getServiceId, (Object)systemId));
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().map(entity -> {
            BpmOtherSystemCustomFormTypeVo vo = new BpmOtherSystemCustomFormTypeVo();
            this.copy(vo, entity);
            return vo;
        }).collect(Collectors.toList());
    }

    public Map<String, Map<String, String>> getFormTypeInfo(List<Long> systemIdList) {
        if (HussarUtils.isEmpty(systemIdList)) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        List<BpmOtherSystemCustomFormTypeVo> list = this.bpmOtherSystemCustomFormTypeMapper.getAddressFromServiceInfo(null, systemIdList);
        for (Long systemId : systemIdList) {
            Map<Object, Object> systemAddressMap = new HashMap();
            if (HussarUtils.isNotEmpty(list)) {
                systemAddressMap = list.stream().filter(obj -> systemId.equals(obj.getServiceId())).collect(Collectors.toMap(BpmOtherSystemCustomFormTypeVo::getFormTypeName, o -> HussarUtils.isNotEmpty((Object)o.getFormAddress()) ? o.getFormAddress() : ""));
                Optional<BpmOtherSystemCustomFormTypeVo> first = list.stream().filter(obj -> systemId.equals(obj.getServiceId())).findFirst();
                if (HussarUtils.isNotEmpty(first)) {
                    BpmOtherSystemCustomFormTypeVo typeVo = list.stream().filter(obj -> systemId.equals(obj.getServiceId())).findFirst().get();
                    systemAddressMap.put("thirdSystemOpenType", HussarUtils.isNotEmpty((Object)typeVo) ? typeVo.getOpenType() : "");
                }
            }
            map.put(String.valueOf(systemId), systemAddressMap);
        }
        return map;
    }

    public List<ThirdSystemDumpVo> dump(ThirdSystemDumpDto thirdSystemDumpDto) {
        List systemIdList = thirdSystemDumpDto.getSystemIdList();
        List thirdSystemList = this.bpmOtherSystemMaintainMapper.selectList((Wrapper)new LambdaQueryWrapper().in(BpmOtherSystemMaintain::getSystemId, (Collection)systemIdList));
        List systemFormTypeList = this.bpmOtherSystemCustomFormTypeMapper.selectList((Wrapper)new LambdaQueryWrapper().in(BpmOtherSystemCustomFormType::getServiceId, (Collection)systemIdList));
        Map<Long, List<BpmOtherSystemCustomFormType>> systemFormTypeMap = systemFormTypeList.stream().collect(Collectors.groupingBy(BpmOtherSystemCustomFormType::getServiceId));
        List<ThirdSystemDumpVo> thirdSystemDumpVoList = thirdSystemList.stream().map(thirdSystem -> {
            List formTypeList = systemFormTypeMap.getOrDefault(thirdSystem.getSystemId(), Collections.emptyList());
            ThirdSystemDumpVo thirdSystemDumpVo = new ThirdSystemDumpVo();
            thirdSystemDumpVo.setBpmOtherSystemMaintain(thirdSystem);
            thirdSystemDumpVo.setBpmOtherSystemCustomFormTypeList(formTypeList);
            return thirdSystemDumpVo;
        }).collect(Collectors.toList());
        return thirdSystemDumpVoList;
    }

    public List<ThirdSystemLoadVo> preload(List<ThirdSystemDumpVo> thirdSystemDumpVoList) {
        List<ThirdSystemLoadVo> thirdSystemLoadVos = thirdSystemDumpVoList.stream().map(thirdSystemDumpVo -> {
            ThirdSystemLoadVo thirdSystemLoadVo = new ThirdSystemLoadVo();
            thirdSystemLoadVo.setSystemId(thirdSystemDumpVo.getBpmOtherSystemMaintain().getSystemId());
            thirdSystemLoadVo.setSystemName(thirdSystemDumpVo.getBpmOtherSystemMaintain().getSystemName());
            thirdSystemLoadVo.setSystemType(thirdSystemDumpVo.getBpmOtherSystemMaintain().getSystemType());
            thirdSystemLoadVo.setOpenType(thirdSystemDumpVo.getBpmOtherSystemMaintain().getOpenType());
            thirdSystemLoadVo.setFormRemark(thirdSystemDumpVo.getBpmOtherSystemMaintain().getFormRemark());
            thirdSystemLoadVo.setThirdSystemDumpVo(thirdSystemDumpVo);
            return thirdSystemLoadVo;
        }).collect(Collectors.toList());
        return thirdSystemLoadVos;
    }

    public List<ThirdSystemLoadVo> load(List<ThirdSystemLoadVo> thirdSystemLoadVos) {
        ArrayList<BpmOtherSystemMaintain> thirdSystemList = new ArrayList<BpmOtherSystemMaintain>();
        ArrayList systemFormTypeList = new ArrayList();
        for (ThirdSystemLoadVo thirdSystemLoadVo : thirdSystemLoadVos) {
            if (HussarUtils.isNotEmpty((Object)thirdSystemLoadVo.getThirdSystemDumpVo().getBpmOtherSystemMaintain())) {
                thirdSystemList.add(thirdSystemLoadVo.getThirdSystemDumpVo().getBpmOtherSystemMaintain());
            }
            if (!HussarUtils.isNotEmpty((Object)thirdSystemLoadVo.getThirdSystemDumpVo().getBpmOtherSystemCustomFormTypeList())) continue;
            systemFormTypeList.addAll(thirdSystemLoadVo.getThirdSystemDumpVo().getBpmOtherSystemCustomFormTypeList());
        }
        if (HussarUtils.isNotEmpty(thirdSystemList)) {
            this.saveOrUpdateBatch(thirdSystemList);
        }
        if (HussarUtils.isNotEmpty(systemFormTypeList)) {
            ((LambdaUpdateChainWrapper)this.bpmOtherSystemCustomFormTypeService.lambdaUpdate().in(BpmOtherSystemCustomFormType::getServiceId, (Collection)systemFormTypeList.stream().map(BpmOtherSystemCustomFormType::getServiceId).collect(Collectors.toSet()))).remove();
            this.bpmOtherSystemCustomFormTypeService.saveBatch(systemFormTypeList);
        }
        return thirdSystemLoadVos;
    }
}

