/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.service.impl;

import com.jxdinfo.hussar.workflow.engine.bpm.common.service.WorkflowCommonCacheService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import javax.annotation.Resource;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class WorkflowCommonCacheServiceImpl
implements WorkflowCommonCacheService {
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private FlowTaskMapper flowTaskMapper;

    @Cacheable(value={"workflow_process_real_version"}, key="'workflow_process_real_version'+#processDefId")
    public String getRealVersion(String processDefId) {
        return this.modelMapper.getRealVersion(processDefId);
    }

    @Cacheable(value={"workflow_process_real_version"}, key="'workflow_process_real_version'+#processDefKey+':'+#version+':'")
    public String getRealVersion(String processDefKey, String version) {
        return this.modelMapper.getRealVersionByIdPrefix(processDefKey + ":" + version + ":%");
    }

    @Cacheable(value={"service_name"}, key="'service_name:'+#processKey", unless="#result == null")
    public String getServiceName(String processKey) {
        return this.modelMapper.getServiceName(processKey);
    }

    @Cacheable(value={"workflow_process_app_id"}, key="'workflow_process_app_id'+#processKey", unless="#result == null")
    public String getProcessAppId(String processKey) {
        return this.flowTaskMapper.getProcessAppId(processKey);
    }

    @Cacheable(value={"workflow_process_model_type"}, key="'workflow_process_model_type'+#processKey", unless="#result == null")
    public String getProcessModelType(String processKey) {
        return this.modelMapper.getModelType(processKey);
    }
}

