/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.util.BpmMsgDetailBuildUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompleteListener
implements ActivitiEventListener {
    @Autowired
    private IFlowTaskService flowTaskService;
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Autowired
    private BpmMsgPushService msgPushService;
    private static Logger logger = LogManager.getLogger(ProcessCompleteListener.class);
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;
    @Autowired
    private DataPushService dataPushService;

    public void onEvent(ActivitiEvent activitiEvent) {
        ExecutionEntity entity = (ExecutionEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        BpmnModel bm = Context.getCommandContext().getProcessEngineConfiguration().getRepositoryService().getBpmnModel(entity.getProcessDefinitionId());
        String formId = null;
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(entity.getId());
        List list = Context.getCommandContext().getDbSqlSession().findInCache(HistoricTaskInstanceEntity.class);
        HistoricTaskInstanceEntity historicTaskInstance = null;
        for (HistoricTaskInstanceEntity historicTaskInstanceEntity : list) {
            if (!entity.getId().equals(historicTaskInstanceEntity.getProcessInstanceId())) continue;
            historicTaskInstance = historicTaskInstanceEntity;
            formId = historicTaskInstance.getFormId();
            break;
        }
        if (historicTaskInstance == null && !(list = ((HistoricTaskInstanceQuery)Context.getCommandContext().getProcessEngineConfiguration().getHistoryService().createHistoricTaskInstanceQuery().processInstanceId(entity.getId())).listPage(0, 1)).isEmpty()) {
            historicTaskInstance = (HistoricTaskInstance)list.get(0);
            formId = historicTaskInstance.getFormId();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("tenantId", entity.getTenantId());
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        map.put("processTitle", historicProcessInstance.getProcessTitle());
        map.put("dataDetail", historicProcessInstance.getDataDetail());
        map.put("taskName", entity.getCurrentActivityName());
        map.put("starter", historicProcessInstance.getStartUserId());
        map.put("formId", formId);
        Process process = (Process)bm.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        String targetNodeId = null;
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            targetNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
            break;
        }
        LambdaQueryWrapper extendPropertiesWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)extendPropertiesWrapper.eq(SysActExtendProperties::getProcDefId, (Object)entity.getProcessDefinitionId())).eq(SysActExtendProperties::getTaskDefKey, targetNodeId);
        SysActExtendProperties extendProperties = (SysActExtendProperties)this.sysActExtendPropertiesService.getOne((Wrapper)extendPropertiesWrapper);
        String formDetailKey = null;
        if (extendProperties != null) {
            formDetailKey = extendProperties.getFormDetailKey();
        }
        map.put("formDetailKey", formDetailKey);
        CommonCodeUtil.triggerEventHandleClass(map);
        if (entity.getProcessInstance().getSuperExecution() == null) {
            String sceneCode = "endProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity)) ? "terminated" : "complete";
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = BpmMsgDetailBuildUtil.executionMsgDetail((ExecutionEntity)entity, (String)sceneCode);
            bpmActMsgDetailList.add(bpmActMsgDetail);
            this.msgPushService.pushMessage(bpmActMsgDetailList);
        }
        new ProcessActionCmd(entity.getId(), entity.getProcessDefinitionId(), 1).execute(Context.getCommandContext());
        new ProcessNodeCmd(entity.getId(), entity.getProcessDefinitionId(), 1).execute(Context.getCommandContext());
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(entity.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(entity.getId());
            dataPush.setBusinessKey(entity.getBusinessKey());
            dataPush.setProcessKey(entity.getProcessDefinitionKey());
            dataPush.setProcessEndTime(new Date());
            if ("endProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity))) {
                dataPush.setProcessState("endProcess");
            } else if ("revokeProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity))) {
                dataPush.setProcessState("revokeProcess");
            } else {
                dataPush.setProcessState("completeProcess");
            }
            dataPush.setProcessDefinitionId(entity.getProcessDefinitionId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setDueDate(historicProcessInstance.getDueDate());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setStartOrganId(historicProcessInstance.getOrganId());
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush otherDataPush = new DataPush();
            otherDataPush.setBusinessKey(entity.getBusinessKey());
            otherDataPush.setProcessInsId(entity.getId());
            otherDataPush.setProcessEndTime(new Date());
            otherDataPush.setProcessKey(entity.getProcessDefinitionKey());
            this.dataPushService.updateStartProcess(otherDataPush);
        }
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

