/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.dto.TaskCommentDto;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.service.TaskCommentService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.vo.TaskCommentVO;
import com.jxdinfo.hussar.workflow.engine.bpm.common.service.WorkflowCommonBpmDeleteService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.EndProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.RestartProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.task.Comment;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ProcessInstServiceImpl
implements ProcessInstService {
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private ProcessInstMapper processInstMapper;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private TaskCommentService taskCommentService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private WorkflowCommonBpmDeleteService workflowCommonBpmDeleteService;
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstService.class);

    public IPage<ProcessInst> getProcessList(Page<ProcessInst> page, ProcessListDto processListDto) {
        if (HussarUtils.isNotEmpty((Object)processListDto.getProcessName())) {
            processListDto.setProcessName(processListDto.getProcessName().replace("%", "\\%").replace("_", "\\_"));
        }
        if (HussarUtils.isNotEmpty((Object)processListDto.getBusinessId())) {
            processListDto.setBusinessId(processListDto.getBusinessId().replace("%", "\\%").replace("_", "\\_"));
        }
        if (HussarUtils.isNotEmpty((Object)processListDto.getStartTimeEnd())) {
            long endTime = processListDto.getStartTimeEnd().getTime() + 999L;
            Date endTimeDate = new Date(endTime);
            processListDto.setStartTimeEnd(endTimeDate);
        }
        List<ProcessInst> instList = this.processInstMapper.getListMySql(page, processListDto);
        HashSet<Long> procInstIds = new HashSet<Long>();
        HashSet<Long> endProcInstIds = new HashSet<Long>();
        for (ProcessInst processInst : instList) {
            if (processInst.getEndTime() != null) {
                endProcInstIds.add(Long.parseLong(processInst.getProcessInsId()));
            }
            procInstIds.add(Long.parseLong(processInst.getProcessInsId()));
        }
        if (!instList.isEmpty()) {
            List<ProcessInstVo> nodeList = this.processInstMapper.getNodeNames(procInstIds);
            BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(nodeList, ProcessInstVo.class).translate(ProcessInstVo::getActNameTranslateTag, ProcessInstVo::setActName).execute();
            HashMap<Long, HashSet<String>> nodeMap = new HashMap<Long, HashSet<String>>();
            for (ProcessInstVo node : nodeList) {
                Long procInstId = node.getProcessInsId();
                HashSet<String> set = (HashSet<String>)nodeMap.get(procInstId);
                if (endProcInstIds.contains(procInstId)) {
                    if (!"endEvent".equals(node.getActType()) || set != null) continue;
                    set = new HashSet<String>();
                    set.add(node.getActName());
                    nodeMap.put(procInstId, set);
                    continue;
                }
                if ("endEvent".equals(node.getActType())) continue;
                if (set == null) {
                    set = new HashSet();
                }
                set.add(node.getActName());
                nodeMap.put(procInstId, set);
            }
            List<String> alreadyDealIds = this.processInstMapper.getAlreadyDealProcessInstanceIds(procInstIds);
            for (ProcessInst processInst : instList) {
                Set nodeNames = (Set)nodeMap.get(Long.parseLong(processInst.getProcessInsId()));
                if (nodeNames != null && !nodeNames.isEmpty()) {
                    processInst.setNames(String.join((CharSequence)",", nodeNames));
                }
                if (!alreadyDealIds.contains(processInst.getProcessInsId())) continue;
                processInst.setAlreadyDeal(true);
            }
        }
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(instList, ProcessInst.class).translate(ProcessInst::getProcessDefinitionNameTranslateTag, ProcessInst::setProcessDefinitionName).execute();
        page.setRecords(instList);
        return page;
    }

    public ApiResponse<String> suspendProcessInstanceById(String processInstCode) {
        try {
            this.instanceEngineService.suspendProcessInstanceById(processInstCode);
            return ApiResponse.success((String)BpmExceptionCodeEnum.HANGUP_SUCCESS.getMessage());
        }
        catch (BpmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_SUSPEND);
        }
    }

    public ApiResponse<String> activateProcessById(String processInstCode) {
        try {
            this.instanceEngineService.activateProcessInstanceById(processInstCode);
            return ApiResponse.success((String)BpmExceptionCodeEnum.ACTIVE_SUCCESS.getMessage());
        }
        catch (BpmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_ACTIVE);
        }
    }

    public ApiResponse<String> deleteProcessInstance(String processInsId) {
        try {
            this.workflowCommonBpmDeleteService.procInstDelete(processInsId, null, false);
            return ApiResponse.success((String)BpmExceptionCodeEnum.DELETE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_DELETE);
        }
    }

    public ApiResponse<String> deleteFinishedProcessInstance(String processInstCode) {
        try {
            this.workflowCommonBpmDeleteService.procInstDelete(processInstCode, null, false);
            return ApiResponse.success((String)BpmExceptionCodeEnum.DELETE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_DELETE);
        }
    }

    public ApiResponse<List<TaskCommentVO>> getProcessDetailList(ProcessDto processDto) {
        String processInsId = processDto.getProcessInsId();
        String businessId = processDto.getBusinessId();
        ArrayList<TaskCommentVO> taskComments = new ArrayList<TaskCommentVO>();
        String processDefinitionId = "";
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (instance != null) {
            if (HussarUtils.isEmpty((Object)processInsId)) {
                processInsId = instance.getId();
            }
        } else {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.PROCESS_INS_ID_NULL.getMessage());
        }
        processDefinitionId = instance.getProcessDefinitionId();
        JSONArray result = this.instanceEngineService.getAllProcessTraceForComment(processInsId);
        for (int i = 0; i < result.size(); ++i) {
            TaskCommentVO taskCommentVO;
            JSONObject jsonObject = result.getJSONObject(i);
            if (jsonObject.get((Object)"subProcessTask") != null) {
                taskCommentVO = new TaskCommentVO();
                taskComments.add(taskCommentVO);
                taskCommentVO.setTime((Date)jsonObject.getObject("end", Date.class));
                taskCommentVO.setTaskNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)processDefinitionId, (String)jsonObject.getString("activityId")));
                taskCommentVO.setActivityName(jsonObject.getString("activityName"));
                ArrayList<TaskCommentVO> subProcessComments = new ArrayList<TaskCommentVO>();
                taskCommentVO.setSubComment(subProcessComments);
                taskCommentVO.setTaskType(jsonObject.getString("taskType"));
                taskCommentVO.setTaskSourceFlag(jsonObject.getString("taskSourceFlag"));
                for (Object subProcessTask : (JSONArray)jsonObject.get((Object)"subProcessTask")) {
                    this.getCommentVoList(subProcessComments, (JSONObject)subProcessTask, processDefinitionId);
                }
                continue;
            }
            if (jsonObject.get((Object)"subProcess") != null) {
                taskCommentVO = new TaskCommentVO();
                taskComments.add(taskCommentVO);
                String endTime = jsonObject.getString("endTime");
                Date date = null;
                if (endTime != null) {
                    try {
                        date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime);
                    }
                    catch (ParseException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        throw new BpmException(BpmExceptionCodeEnum.ERROR_DATE_TRANSFER);
                    }
                }
                taskCommentVO.setTime(date);
                taskCommentVO.setActivityName(jsonObject.getString("activityName"));
                taskCommentVO.setTaskNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)processDefinitionId, (String)jsonObject.getString("activityId")));
                ArrayList<TaskCommentVO> subProcessComments = new ArrayList<TaskCommentVO>();
                taskCommentVO.setSubComment(subProcessComments);
                JSONArray subProcessList = (JSONArray)jsonObject.get((Object)"subProcess");
                for (int j = 0; j < subProcessList.size(); ++j) {
                    JSONObject subProcess = subProcessList.getJSONObject(j);
                    TaskCommentVO subProcessCommentVO = new TaskCommentVO();
                    subProcessComments.add(subProcessCommentVO);
                    subProcessCommentVO.setTime((Date)subProcess.getObject("end", Date.class));
                    subProcessCommentVO.setActivityName(subProcess.getString("activityName"));
                    subProcessCommentVO.setTaskNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)processDefinitionId, (String)jsonObject.getString("activityId")));
                    ArrayList<TaskCommentVO> subProcessTaskComments = new ArrayList<TaskCommentVO>();
                    subProcessCommentVO.setSubComment(subProcessTaskComments);
                    subProcessCommentVO.setTaskType(jsonObject.getString("taskType"));
                    subProcessCommentVO.setTaskSourceFlag(jsonObject.getString("taskSourceFlag"));
                    for (Object subProcessTask : (JSONArray)subProcess.get((Object)"subProcessTask")) {
                        this.getCommentVoList(subProcessTaskComments, (JSONObject)subProcessTask, processDefinitionId);
                    }
                }
                continue;
            }
            this.getCommentVoList(taskComments, jsonObject, processDefinitionId);
        }
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(taskComments, TaskCommentVO.class).translate(TaskCommentVO::getTaskNameTranslateKey, TaskCommentVO::setActivityName).execute();
        return ApiResponse.success(taskComments);
    }

    private void getCommentVoList(List<TaskCommentVO> taskComments, JSONObject jsonObject, String processDefinitionId) {
        String taskId = jsonObject.getString("taskId");
        String time = jsonObject.getString("endTime");
        if (HussarUtils.isEmpty((Object)time)) {
            return;
        }
        List comments = this.taskService.getTaskComments(taskId, "complete");
        if (HussarUtils.isNotEmpty((Object)comments)) {
            for (Comment comment : comments) {
                TaskCommentVO taskCommentVO = new TaskCommentVO();
                taskCommentVO.setId(comment.getId());
                taskCommentVO.setTaskId(taskId);
                taskCommentVO.setTime(comment.getTime());
                taskCommentVO.setFullMessage(comment.getFullMessage());
                taskCommentVO.setActivityName(jsonObject.getString("activityName"));
                taskCommentVO.setTaskNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)processDefinitionId, (String)jsonObject.getString("activityId")));
                taskCommentVO.setUserName(jsonObject.getString("assignee"));
                taskCommentVO.setTaskType(jsonObject.getString("taskType"));
                taskCommentVO.setTaskSourceFlag(jsonObject.getString("taskSourceFlag"));
                taskComments.add(taskCommentVO);
            }
        } else {
            TaskCommentVO taskCommentVO = new TaskCommentVO();
            taskCommentVO.setId(null);
            taskCommentVO.setTaskId(taskId);
            String endTime = jsonObject.getString("endTime");
            Date date = null;
            try {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BpmException(BpmExceptionCodeEnum.ERROR_DATE_TRANSFER);
            }
            taskCommentVO.setTime(date);
            taskCommentVO.setFullMessage("");
            taskCommentVO.setActivityName(jsonObject.getString("activityName"));
            taskCommentVO.setTaskNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)processDefinitionId, (String)jsonObject.getString("activityId")));
            taskCommentVO.setUserName(jsonObject.getString("assignee"));
            taskCommentVO.setTaskType(jsonObject.getString("taskType"));
            taskCommentVO.setTaskSourceFlag(jsonObject.getString("taskSourceFlag"));
            taskComments.add(taskCommentVO);
        }
    }

    public ApiResponse<String> updateComments(List<TaskCommentDto> taskComments) {
        try {
            ArrayList<TaskComment> taskCommentList;
            if (HussarUtils.isNotEmpty(taskComments)) {
                taskCommentList = new ArrayList<TaskComment>();
                for (TaskCommentDto taskCommentDto : taskComments) {
                    String taskId = taskCommentDto.getTaskId();
                    String fullMessage = taskCommentDto.getFullMessage();
                    TaskComment taskComment = new TaskComment(Long.valueOf(Long.parseLong(taskId)), fullMessage.getBytes());
                    if (HussarUtils.isEmpty((Object)taskCommentDto.getId())) {
                        HistoricTaskInstance hisTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().queryChildTask()).taskId(taskId)).singleResult();
                        taskComment.setUserId(hisTask.getAssignee());
                    } else {
                        taskComment.setId(Long.valueOf(Long.parseLong(taskCommentDto.getId())));
                    }
                    taskCommentList.add(taskComment);
                }
            } else {
                return ApiResponse.success((String)BpmExceptionCodeEnum.NULL_UPDATE_MESSAGE.getMessage());
            }
            this.taskCommentService.saveOrUpdateBatch(taskCommentList);
            return ApiResponse.success((String)BpmExceptionCodeEnum.SUCCESS_UPDATE.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_UPDATE);
        }
    }

    public BpmResponseResult endProcessByProcessInsId(EndProcessDto endProcessDto) {
        String processInsId = endProcessDto.getProcessInsId();
        String userId = endProcessDto.getUserId();
        return this.instanceEngineService.endProcessByProcessInsId(processInsId, userId, null);
    }

    public BpmResponseResult reStartProcess(RestartProcessDto restartProcessDto) {
        String processInsId = restartProcessDto.getProcessInsId();
        String userId = restartProcessDto.getUserId();
        String businessId = restartProcessDto.getBusinessId();
        String assignee = restartProcessDto.getAssignee();
        String taskDefinitionKey = restartProcessDto.getTaskDefinitionKey();
        boolean isSubmit = restartProcessDto.getSubmit();
        return this.taskEngineService.reStartProcess(processInsId, businessId, taskDefinitionKey, userId, assignee, isSubmit, null);
    }

    public void deleteProcessDataPush(List<String> stringProcIds, List<HistoricProcessInstance> historicProcessInstances, String reason) {
        List emulationProcess = historicProcessInstances.stream().filter(e -> "1".equals(e.getIsEmulation())).collect(Collectors.toList());
        List emulationProcessInsIds = emulationProcess.stream().map(HistoricProcessInstance::getId).collect(Collectors.toList());
        List emulationBusinessKey = emulationProcess.stream().map(HistoricProcessInstance::getBusinessKey).collect(Collectors.toList());
        HashMap<String, String> businessKeyMap = new HashMap<String, String>();
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        HashMap<String, List> processKeyInstanceMap = new HashMap<String, List>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            String businessIds = (String)businessKeyMap.get(historicProcessInstance.getProcessDefinitionId());
            businessIds = businessIds == null ? historicProcessInstance.getBusinessKey() : businessIds + "," + historicProcessInstance.getBusinessKey();
            businessKeyMap.put(historicProcessInstance.getProcessDefinitionId(), businessIds);
            processDefinitionIdList.add(historicProcessInstance.getProcessDefinitionId());
            processKeyInstanceMap.computeIfAbsent(historicProcessInstance.getProcessDefinitionKey(), k -> new ArrayList()).add(historicProcessInstance.getId());
        }
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessMap(businessKeyMap);
            dataPush.setComment(reason);
            dataPush.setProcessState("deleteProcess");
            dataPush.setProcessInsId(StringUtils.join(stringProcIds, (String)","));
            dataPush.setEmulationBusinessKey(emulationBusinessKey);
            dataPush.setEmulationProcessInsIds(emulationProcessInsIds);
            dataPush.setProcessKeyInstanceMap(processKeyInstanceMap);
            this.dataPushService.deleteDataPush(dataPush);
            this.dataPushService.changeProcessStateDataPush(dataPush);
            DataPush dataPushTemp = new DataPush();
            dataPushTemp.setProcessInsId(StringUtils.join(stringProcIds, (String)","));
            dataPushTemp.setBusinessMap(businessKeyMap);
            this.dataPushService.deleteStartProcess(dataPushTemp);
        }
    }
}

