/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.migration.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.manage.util.BpmPluginUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;

public class WorkflowMigrationUtil {
    private static final String REPLACE_REGEX = "^[^/]+";

    public static String convertFormKey(String formKey) {
        String tcode = HussarContextHolder.getHussarTenant().getTenantCode();
        JSONObject formKeyJson = JSON.parseObject((String)formKey);
        if (HussarUtils.isEmpty((Object)formKeyJson) || HussarUtils.isEmpty((Object)tcode)) {
            return null;
        }
        tcode = BpmPluginUtil.asIdentifier((String)tcode);
        String regexTCode = "/" + tcode;
        String uniFormKey = formKeyJson.getString("uni");
        String webFormKey = formKeyJson.getString("web");
        String mobileFormKey = formKeyJson.getString("mobile");
        if (HussarUtils.isNotEmpty((Object)uniFormKey)) {
            if (WorkflowMigrationUtil.startWithStr(uniFormKey, tcode)) {
                uniFormKey = uniFormKey.replaceFirst(tcode, "");
            } else if (WorkflowMigrationUtil.startWithStr(uniFormKey, regexTCode)) {
                uniFormKey = uniFormKey.replaceFirst(regexTCode, "");
            }
            formKeyJson.put("uni", (Object)uniFormKey);
        }
        if (HussarUtils.isNotEmpty((Object)webFormKey)) {
            if (WorkflowMigrationUtil.startWithStr(webFormKey, tcode)) {
                webFormKey = webFormKey.replaceFirst(tcode, "");
            } else if (WorkflowMigrationUtil.startWithStr(webFormKey, regexTCode)) {
                webFormKey = webFormKey.replaceFirst(regexTCode, "");
            }
            formKeyJson.put("web", (Object)webFormKey);
        }
        if (HussarUtils.isNotEmpty((Object)mobileFormKey)) {
            if (WorkflowMigrationUtil.startWithStr(mobileFormKey, tcode)) {
                mobileFormKey = mobileFormKey.replaceFirst(tcode, "");
            } else if (WorkflowMigrationUtil.startWithStr(mobileFormKey, regexTCode)) {
                mobileFormKey = mobileFormKey.replaceFirst(regexTCode, "");
            }
            formKeyJson.put("mobile", (Object)mobileFormKey);
        }
        return JSON.toJSONString((Object)formKeyJson);
    }

    public static String convertDetailFormKey(String formKey) {
        String tcode = HussarContextHolder.getHussarTenant().getTenantCode();
        JSONObject formKeyJson = JSON.parseObject((String)formKey);
        if (HussarUtils.isEmpty((Object)formKeyJson) || HussarUtils.isEmpty((Object)tcode)) {
            return null;
        }
        tcode = BpmPluginUtil.asIdentifier((String)tcode);
        JSONObject uniFormKeyJson = formKeyJson.getJSONObject("uni");
        JSONObject webFormKeyJson = formKeyJson.getJSONObject("web");
        JSONObject mobileFormKeyJson = formKeyJson.getJSONObject("mobile");
        String uniFormKey = "";
        String webFormKey = "";
        String mobileFormKey = "";
        if (HussarUtils.isNotEmpty((Object)uniFormKeyJson) && HussarUtils.isNotEmpty((Object)(uniFormKey = uniFormKeyJson.getString("url"))) && WorkflowMigrationUtil.startWithStr(uniFormKey, tcode)) {
            uniFormKey = uniFormKey.replaceFirst("^[^/]+[/]", "");
            uniFormKeyJson.put("url", (Object)uniFormKey);
        }
        if (HussarUtils.isNotEmpty((Object)webFormKeyJson) && HussarUtils.isNotEmpty((Object)(webFormKey = webFormKeyJson.getString("url"))) && WorkflowMigrationUtil.startWithStr(webFormKey, tcode)) {
            webFormKey = webFormKey.replaceFirst(REPLACE_REGEX, "");
            webFormKeyJson.put("url", (Object)webFormKey);
        }
        if (HussarUtils.isNotEmpty((Object)mobileFormKeyJson) && HussarUtils.isNotEmpty((Object)(mobileFormKey = mobileFormKeyJson.getString("url"))) && WorkflowMigrationUtil.startWithStr(mobileFormKey, tcode)) {
            mobileFormKey = mobileFormKey.replaceFirst(REPLACE_REGEX, "");
            mobileFormKeyJson.put("url", (Object)mobileFormKey);
        }
        return JSON.toJSONString((Object)formKeyJson);
    }

    public static boolean startWithStr(String str, String prefix) {
        if (HussarUtils.isNotEmpty((Object)str) && HussarUtils.isNotEmpty((Object)prefix) && str.length() > prefix.length()) {
            String strPrefix = str.substring(0, prefix.length());
            return prefix.equals(strPrefix);
        }
        return false;
    }

    public static void convertFileFormKey(SysActProcessFile sysActProcessFile) {
        String wfdFile = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
        JSONObject jsonObject = JSON.parseObject((String)wfdFile);
        JSONObject slots = jsonObject.getJSONObject("slots");
        if (HussarUtils.isNotEmpty((Object)slots)) {
            JSONArray nodes = slots.getJSONArray("default");
            for (int i = 0; i < nodes.size(); ++i) {
                JSONObject node = nodes.getJSONObject(i);
                if (BpmNodeTypeUtil.isStart((String)node.getString("name")) || BpmNodeTypeUtil.isUserTask((String)node.getString("name"))) {
                    String assistFormDetailAddress;
                    String ccFormAddress;
                    String assistFormAddress;
                    String formDetailAddress;
                    String ccFormDetailAddress;
                    JSONObject nodeProps = node.getJSONObject("props");
                    String formAddress = nodeProps.getString("formAddress");
                    if (HussarUtils.isNotEmpty((Object)formAddress)) {
                        String newFormAddress = WorkflowMigrationUtil.convertDetailFormKey(formAddress);
                        JSONObject newFormAddressJson = JSON.parseObject((String)newFormAddress);
                        nodeProps.put("formAddress", (Object)newFormAddressJson);
                    }
                    if (HussarUtils.isNotEmpty((Object)(ccFormDetailAddress = nodeProps.getString("ccFormDetailAddress")))) {
                        String newCcFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKey(ccFormDetailAddress);
                        JSONObject newCcFormDetailAddressJson = JSON.parseObject((String)newCcFormDetailAddress);
                        nodeProps.put("ccFormDetailAddress", (Object)newCcFormDetailAddressJson);
                    }
                    if (HussarUtils.isNotEmpty((Object)(formDetailAddress = nodeProps.getString("formDetailAddress")))) {
                        String newFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKey(formDetailAddress);
                        JSONObject newFormDetailAddressJson = JSON.parseObject((String)newFormDetailAddress);
                        nodeProps.put("formDetailAddress", (Object)newFormDetailAddressJson);
                    }
                    if (HussarUtils.isNotEmpty((Object)(assistFormAddress = nodeProps.getString("assistFormAddress")))) {
                        String newAssistFormAddress = WorkflowMigrationUtil.convertDetailFormKey(assistFormAddress);
                        JSONObject newAssistFormAddressJson = JSON.parseObject((String)newAssistFormAddress);
                        nodeProps.put("assistFormAddress", (Object)newAssistFormAddressJson);
                    }
                    if (HussarUtils.isNotEmpty((Object)(ccFormAddress = nodeProps.getString("ccFormAddress")))) {
                        String newCcFormAddress = WorkflowMigrationUtil.convertDetailFormKey(ccFormAddress);
                        JSONObject newCcFormAddressJson = JSON.parseObject((String)newCcFormAddress);
                        nodeProps.put("ccFormAddress", (Object)newCcFormAddressJson);
                    }
                    if (!HussarUtils.isNotEmpty((Object)(assistFormDetailAddress = nodeProps.getString("assistFormDetailAddress")))) continue;
                    String newAssistFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKey(assistFormDetailAddress);
                    JSONObject newAssistFormDetailAddressJson = JSON.parseObject((String)newAssistFormDetailAddress);
                    nodeProps.put("assistFormDetailAddress", (Object)newAssistFormDetailAddressJson);
                    continue;
                }
                if (!BpmNodeTypeUtil.isSubProcess((String)node.getString("name"))) continue;
                WorkflowMigrationUtil.convertSubProcessFileFormKey(node.getJSONObject("slots"));
            }
            wfdFile = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            sysActProcessFile.setContent(wfdFile.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void convertFlowElementFormKey(List<FlowElement> flowElementList) {
        for (FlowElement flowElement : flowElementList) {
            List assistFlowFormDetailKeyList;
            Map assistFlowFormDetailKeyMap;
            List assistFormKeyMapList;
            Map assistFormKeyMap;
            List ccDetailFormKeyList;
            Map ccDetailFormKeyMap;
            List ccFormKeyList;
            Map ccFormKeyMap;
            List flowFormDetailKeyList;
            Map flowFormDetailKeyElementMap;
            if (!(flowElement instanceof UserTask) && !(flowElement instanceof StartEvent)) continue;
            if (flowElement instanceof StartEvent) {
                StartEvent startEvent = (StartEvent)flowElement;
                String startEventFormKey = startEvent.getFormKey();
                String newStartEventFormKey = WorkflowMigrationUtil.convertFormKey(startEventFormKey);
                startEvent.setFormKey(newStartEventFormKey);
                continue;
            }
            UserTask userTask = (UserTask)flowElement;
            String userTaskFormKey = userTask.getFormKey();
            String newUserTaskFormKey = WorkflowMigrationUtil.convertFormKey(userTaskFormKey);
            userTask.setFormKey(newUserTaskFormKey);
            List flowFormDetailKeyElement = (List)userTask.getExtensionElements().get("flowFormDetailKey");
            String flowFormDetailKey = null;
            if (flowFormDetailKeyElement != null && !flowFormDetailKeyElement.isEmpty() && (flowFormDetailKeyElementMap = ((ExtensionElement)flowFormDetailKeyElement.get(0)).getAttributes()) != null && (flowFormDetailKeyList = (List)flowFormDetailKeyElementMap.get("flowFormDetailKey")) != null && !flowFormDetailKeyList.isEmpty()) {
                flowFormDetailKey = ((ExtensionAttribute)flowFormDetailKeyList.get(0)).getValue();
                String newflowFormDetailKey = WorkflowMigrationUtil.convertDetailFormKey(flowFormDetailKey);
                ((ExtensionAttribute)flowFormDetailKeyList.get(0)).setValue(newflowFormDetailKey);
            }
            List ccElement = (List)userTask.getExtensionElements().get("ccFormKey");
            String ccFormKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                ccFormKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
                String newCcFormKey = WorkflowMigrationUtil.convertFormKey(ccFormKey);
                ((ExtensionAttribute)ccFormKeyList.get(0)).setValue(newCcFormKey);
            }
            List ccDetailElement = (List)userTask.getExtensionElements().get("ccFlowFormDetailKey");
            String ccDetailFormKey = null;
            if (ccDetailElement != null && !ccDetailElement.isEmpty() && (ccDetailFormKeyMap = ((ExtensionElement)ccDetailElement.get(0)).getAttributes()) != null && (ccDetailFormKeyList = (List)ccDetailFormKeyMap.get("ccFlowFormDetailKey")) != null && !ccDetailFormKeyList.isEmpty()) {
                ccDetailFormKey = ((ExtensionAttribute)ccDetailFormKeyList.get(0)).getValue();
                String newCcDetailFormKey = WorkflowMigrationUtil.convertDetailFormKey(ccDetailFormKey);
                ((ExtensionAttribute)ccDetailFormKeyList.get(0)).setValue(newCcDetailFormKey);
            }
            List assistFormKeyElement = (List)userTask.getExtensionElements().get("assistFormKey");
            String assistFormKey = null;
            if (assistFormKeyElement != null && !assistFormKeyElement.isEmpty() && (assistFormKeyMap = ((ExtensionElement)assistFormKeyElement.get(0)).getAttributes()) != null && (assistFormKeyMapList = (List)assistFormKeyMap.get("assistFormKey")) != null && !assistFormKeyMapList.isEmpty()) {
                assistFormKey = ((ExtensionAttribute)assistFormKeyMapList.get(0)).getValue();
                String newAssistFormKey = WorkflowMigrationUtil.convertFormKey(assistFormKey);
                ((ExtensionAttribute)assistFormKeyMapList.get(0)).setValue(newAssistFormKey);
            }
            List assistFlowFormDetailKeyElement = (List)userTask.getExtensionElements().get("assistFlowFormDetailKey");
            String assistFlowFormDetailKey = null;
            if (assistFlowFormDetailKeyElement == null || assistFlowFormDetailKeyElement.isEmpty() || (assistFlowFormDetailKeyMap = ((ExtensionElement)assistFlowFormDetailKeyElement.get(0)).getAttributes()) == null || (assistFlowFormDetailKeyList = (List)assistFlowFormDetailKeyMap.get("assistFlowFormDetailKey")) == null || assistFlowFormDetailKeyList.isEmpty()) continue;
            assistFlowFormDetailKey = ((ExtensionAttribute)assistFlowFormDetailKeyList.get(0)).getValue();
            String newAssistFlowFormDetailKey = WorkflowMigrationUtil.convertDetailFormKey(assistFlowFormDetailKey);
            ((ExtensionAttribute)assistFlowFormDetailKeyList.get(0)).setValue(newAssistFlowFormDetailKey);
        }
    }

    public static void convertSubProcessFileFormKey(JSONObject slots) {
        if (HussarUtils.isNotEmpty((Object)slots)) {
            JSONArray nodes = slots.getJSONArray("default");
            for (int i = 0; i < nodes.size(); ++i) {
                String assistFormDetailAddress;
                String ccFormAddress;
                String assistFormAddress;
                String formDetailAddress;
                String ccFormDetailAddress;
                JSONObject node = nodes.getJSONObject(i);
                if (!BpmNodeTypeUtil.isStart((String)node.getString("name")) && !BpmNodeTypeUtil.isUserTask((String)node.getString("name"))) continue;
                JSONObject nodeProps = node.getJSONObject("props");
                String formAddress = nodeProps.getString("formAddress");
                if (HussarUtils.isNotEmpty((Object)formAddress)) {
                    String newFormAddress = WorkflowMigrationUtil.convertDetailFormKey(formAddress);
                    JSONObject newFormAddressJson = JSON.parseObject((String)newFormAddress);
                    nodeProps.put("formAddress", (Object)newFormAddressJson);
                }
                if (HussarUtils.isNotEmpty((Object)(ccFormDetailAddress = nodeProps.getString("ccFormDetailAddress")))) {
                    String newCcFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKey(ccFormDetailAddress);
                    JSONObject newCcFormDetailAddressJson = JSON.parseObject((String)newCcFormDetailAddress);
                    nodeProps.put("ccFormDetailAddress", (Object)newCcFormDetailAddressJson);
                }
                if (HussarUtils.isNotEmpty((Object)(formDetailAddress = nodeProps.getString("formDetailAddress")))) {
                    String newFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKey(formDetailAddress);
                    JSONObject newFormDetailAddressJson = JSON.parseObject((String)newFormDetailAddress);
                    nodeProps.put("formDetailAddress", (Object)newFormDetailAddressJson);
                }
                if (HussarUtils.isNotEmpty((Object)(assistFormAddress = nodeProps.getString("assistFormAddress")))) {
                    String newAssistFormAddress = WorkflowMigrationUtil.convertDetailFormKey(assistFormAddress);
                    JSONObject newAssistFormAddressJson = JSON.parseObject((String)newAssistFormAddress);
                    nodeProps.put("assistFormAddress", (Object)newAssistFormAddressJson);
                }
                if (HussarUtils.isNotEmpty((Object)(ccFormAddress = nodeProps.getString("ccFormAddress")))) {
                    String newCcFormAddress = WorkflowMigrationUtil.convertDetailFormKey(ccFormAddress);
                    JSONObject newCcFormAddressJson = JSON.parseObject((String)newCcFormAddress);
                    nodeProps.put("ccFormAddress", (Object)newCcFormAddressJson);
                }
                if (!HussarUtils.isNotEmpty((Object)(assistFormDetailAddress = nodeProps.getString("assistFormDetailAddress")))) continue;
                String newAssistFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKey(assistFormDetailAddress);
                JSONObject newAssistFormDetailAddressJson = JSON.parseObject((String)newAssistFormDetailAddress);
                nodeProps.put("assistFormDetailAddress", (Object)newAssistFormDetailAddressJson);
            }
        }
    }

    public static WorkFlow getWorkflow(List<SysActProcessFile> sysActProcessFiles) {
        SysActProcessFile wfd = null;
        SysActProcessFile meta = null;
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            if ("wfd".equals(sysActProcessFile.getType())) {
                wfd = sysActProcessFile;
                continue;
            }
            if (!"meta".equals(sysActProcessFile.getType())) continue;
            meta = sysActProcessFile;
        }
        if (HussarUtils.isEmpty(wfd) || HussarUtils.isEmpty(meta)) {
            return null;
        }
        WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(meta.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
        workFlow.setProcDefId(meta.getProcessId());
        workFlow.setModelId(meta.getModelId());
        workFlow.setData(new String(wfd.getContent(), StandardCharsets.UTF_8));
        return workFlow;
    }

    public static boolean isSameHandleAuth(SysActHandleAuth oldFormAuth, SysActHandleAuth sysActFormAuth) {
        if (oldFormAuth.getProcessKey() == null ? sysActFormAuth.getProcessKey() != null : !oldFormAuth.getProcessKey().equals(sysActFormAuth.getProcessKey())) {
            return false;
        }
        if (oldFormAuth.getProcessVersion() == null ? sysActFormAuth.getProcessVersion() != null : !oldFormAuth.getProcessVersion().equals(sysActFormAuth.getProcessVersion())) {
            return false;
        }
        if (oldFormAuth.getTaskDefinitionKey() == null ? sysActFormAuth.getTaskDefinitionKey() != null : !oldFormAuth.getTaskDefinitionKey().equals(sysActFormAuth.getTaskDefinitionKey())) {
            return false;
        }
        return !(oldFormAuth.getHandleType() == null ? sysActFormAuth.getHandleType() != null : !oldFormAuth.getHandleType().equals(sysActFormAuth.getHandleType()));
    }

    public static String changeAppCode(String formKey, String oldAppCode, String newAppCode) {
        if (HussarUtils.equals((Object)oldAppCode, (Object)newAppCode)) {
            return formKey;
        }
        if (formKey == null || oldAppCode == null || newAppCode == null) {
            return formKey;
        }
        CharSequence[] parts = formKey.split("/");
        for (int i = 0; i < parts.length; ++i) {
            if (!HussarUtils.isNotEmpty((Object)parts[i]) || !((String)parts[i]).equals(oldAppCode)) continue;
            parts[i] = newAppCode;
            break;
        }
        return String.join((CharSequence)"/", parts);
    }

    public static String changeServiceName(String formKey, String oldServiceName, String newServiceName) {
        if (HussarUtils.equals((Object)oldServiceName, (Object)newServiceName)) {
            return formKey;
        }
        if (formKey == null) {
            return formKey;
        }
        String[] parts = formKey.split("/");
        ArrayList<String> partList = new ArrayList<String>(Arrays.asList(parts));
        partList.removeIf(HussarUtils::isEmpty);
        if (((String)partList.get(0)).equals(BpmPluginUtil.asIdentifier((String)oldServiceName))) {
            if (HussarUtils.isNotEmpty((Object)newServiceName)) {
                partList.set(0, BpmPluginUtil.asIdentifier((String)newServiceName));
            } else {
                partList.remove(0);
            }
        } else if (HussarUtils.isNotEmpty((Object)newServiceName)) {
            partList.add(0, BpmPluginUtil.asIdentifier((String)newServiceName));
        }
        return String.join((CharSequence)"/", partList);
    }

    public static String convertFormKeyWithNewAppCode(String formKey, String oldAppCode, String newAppCode, String oldServiceName, String newServiceName) {
        boolean sameAppCode = HussarUtils.equals((Object)oldAppCode, (Object)newAppCode);
        boolean sameServiceName = HussarUtils.equals((Object)oldServiceName, (Object)newServiceName);
        if (sameAppCode && sameServiceName) {
            return formKey;
        }
        JSONObject formKeyJson = JSON.parseObject((String)formKey);
        if (HussarUtils.isEmpty((Object)formKeyJson)) {
            return null;
        }
        String uniFormKey = formKeyJson.getString("uni");
        String webFormKey = formKeyJson.getString("web");
        String mobileFormKey = formKeyJson.getString("mobile");
        if (HussarUtils.isNotEmpty((Object)uniFormKey)) {
            if (!sameAppCode) {
                uniFormKey = WorkflowMigrationUtil.changeAppCode(uniFormKey, oldAppCode, newAppCode);
            }
            if (!sameServiceName) {
                uniFormKey = WorkflowMigrationUtil.changeServiceName(uniFormKey, oldServiceName, newServiceName);
            }
            formKeyJson.put("uni", (Object)uniFormKey);
        }
        if (HussarUtils.isNotEmpty((Object)webFormKey)) {
            if (!sameAppCode) {
                webFormKey = WorkflowMigrationUtil.changeAppCode(webFormKey, oldAppCode, newAppCode);
            }
            if (!sameServiceName) {
                webFormKey = WorkflowMigrationUtil.changeServiceName(webFormKey, oldServiceName, newServiceName);
            }
            formKeyJson.put("web", (Object)webFormKey);
        }
        if (HussarUtils.isNotEmpty((Object)mobileFormKey)) {
            if (!sameAppCode) {
                mobileFormKey = WorkflowMigrationUtil.changeAppCode(mobileFormKey, oldAppCode, newAppCode);
            }
            if (!sameServiceName) {
                mobileFormKey = WorkflowMigrationUtil.changeServiceName(mobileFormKey, oldServiceName, newServiceName);
            }
            formKeyJson.put("mobile", (Object)mobileFormKey);
        }
        return JSON.toJSONString((Object)formKeyJson);
    }

    public static String convertDetailFormKeyWithNewAppCode(String formKey, String oldAppCode, String newAppCode, String oldServiceName, String newServiceName) {
        boolean sameAppCode = HussarUtils.equals((Object)oldAppCode, (Object)newAppCode);
        boolean sameServiceName = HussarUtils.equals((Object)oldServiceName, (Object)newServiceName);
        if (sameAppCode && sameServiceName) {
            return formKey;
        }
        JSONObject formKeyJson = JSON.parseObject((String)formKey);
        if (HussarUtils.isEmpty((Object)formKeyJson)) {
            return null;
        }
        JSONObject uniFormKeyJson = formKeyJson.getJSONObject("uni");
        JSONObject webFormKeyJson = formKeyJson.getJSONObject("web");
        JSONObject mobileFormKeyJson = formKeyJson.getJSONObject("mobile");
        String uniFormKey = "";
        String webFormKey = "";
        String mobileFormKey = "";
        if (HussarUtils.isNotEmpty((Object)uniFormKeyJson) && HussarUtils.isNotEmpty((Object)(uniFormKey = uniFormKeyJson.getString("url")))) {
            if (!sameAppCode) {
                uniFormKey = WorkflowMigrationUtil.changeAppCode(uniFormKey, oldAppCode, newAppCode);
            }
            if (!sameServiceName) {
                uniFormKey = WorkflowMigrationUtil.changeServiceName(uniFormKey, oldServiceName, newServiceName);
            }
            uniFormKeyJson.put("url", (Object)uniFormKey);
        }
        if (HussarUtils.isNotEmpty((Object)webFormKeyJson) && HussarUtils.isNotEmpty((Object)(webFormKey = webFormKeyJson.getString("url")))) {
            if (!sameAppCode) {
                webFormKey = WorkflowMigrationUtil.changeAppCode(webFormKey, oldAppCode, newAppCode);
            }
            if (!sameServiceName) {
                webFormKey = WorkflowMigrationUtil.changeServiceName(webFormKey, oldServiceName, newServiceName);
            }
            webFormKeyJson.put("url", (Object)webFormKey);
        }
        if (HussarUtils.isNotEmpty((Object)mobileFormKeyJson) && HussarUtils.isNotEmpty((Object)(mobileFormKey = mobileFormKeyJson.getString("url")))) {
            if (!sameAppCode) {
                mobileFormKey = WorkflowMigrationUtil.changeAppCode(mobileFormKey, oldAppCode, newAppCode);
            }
            if (!sameServiceName) {
                mobileFormKey = WorkflowMigrationUtil.changeServiceName(mobileFormKey, oldServiceName, newServiceName);
            }
            mobileFormKeyJson.put("url", (Object)mobileFormKey);
        }
        return JSON.toJSONString((Object)formKeyJson);
    }

    public static void convertFileFormKeyWithNewAppCode(SysActProcessFile sysActProcessFile, String oldAppCode, String newAppCode, String oldServiceName, String newServiceName) {
        boolean sameAppCode = HussarUtils.equals((Object)oldAppCode, (Object)newAppCode);
        boolean sameServiceName = HussarUtils.equals((Object)oldServiceName, (Object)newServiceName);
        if (sameAppCode && sameServiceName) {
            return;
        }
        String wfdFile = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
        JSONObject jsonObject = JSON.parseObject((String)wfdFile);
        JSONObject slots = jsonObject.getJSONObject("slots");
        if (HussarUtils.isNotEmpty((Object)slots)) {
            JSONArray nodes = slots.getJSONArray("default");
            for (int i = 0; i < nodes.size(); ++i) {
                JSONObject node = nodes.getJSONObject(i);
                if (BpmNodeTypeUtil.isStart((String)node.getString("name")) || BpmNodeTypeUtil.isUserTask((String)node.getString("name"))) {
                    String assistFormDetailAddress;
                    String ccFormAddress;
                    String assistFormAddress;
                    String formDetailAddress;
                    String ccFormDetailAddress;
                    JSONObject nodeProps = node.getJSONObject("props");
                    String formAddress = nodeProps.getString("formAddress");
                    if (HussarUtils.isNotEmpty((Object)formAddress)) {
                        String newFormAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(formAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                        JSONObject newFormAddressJson = JSON.parseObject((String)newFormAddress);
                        nodeProps.put("formAddress", (Object)newFormAddressJson);
                    }
                    if (HussarUtils.isNotEmpty((Object)(ccFormDetailAddress = nodeProps.getString("ccFormDetailAddress")))) {
                        String newCcFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(ccFormDetailAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                        JSONObject newCcFormDetailAddressJson = JSON.parseObject((String)newCcFormDetailAddress);
                        nodeProps.put("ccFormDetailAddress", (Object)newCcFormDetailAddressJson);
                    }
                    if (HussarUtils.isNotEmpty((Object)(formDetailAddress = nodeProps.getString("formDetailAddress")))) {
                        String newFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(formDetailAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                        JSONObject newFormDetailAddressJson = JSON.parseObject((String)newFormDetailAddress);
                        nodeProps.put("formDetailAddress", (Object)newFormDetailAddressJson);
                    }
                    if (HussarUtils.isNotEmpty((Object)(assistFormAddress = nodeProps.getString("assistFormAddress")))) {
                        String newAssistFormAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(assistFormAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                        JSONObject newAssistFormAddressJson = JSON.parseObject((String)newAssistFormAddress);
                        nodeProps.put("assistFormAddress", (Object)newAssistFormAddressJson);
                    }
                    if (HussarUtils.isNotEmpty((Object)(ccFormAddress = nodeProps.getString("ccFormAddress")))) {
                        String newCcFormAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(ccFormAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                        JSONObject newCcFormAddressJson = JSON.parseObject((String)newCcFormAddress);
                        nodeProps.put("ccFormAddress", (Object)newCcFormAddressJson);
                    }
                    if (!HussarUtils.isNotEmpty((Object)(assistFormDetailAddress = nodeProps.getString("assistFormDetailAddress")))) continue;
                    String newAssistFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(assistFormDetailAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                    JSONObject newAssistFormDetailAddressJson = JSON.parseObject((String)newAssistFormDetailAddress);
                    nodeProps.put("assistFormDetailAddress", (Object)newAssistFormDetailAddressJson);
                    continue;
                }
                if (!BpmNodeTypeUtil.isSubProcess((String)node.getString("name"))) continue;
                WorkflowMigrationUtil.convertSubProcessFileFormKeyWithNewAppCode(node.getJSONObject("slots"), oldAppCode, newAppCode, oldServiceName, newServiceName);
            }
            wfdFile = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            sysActProcessFile.setContent(wfdFile.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void convertFlowElementFormKeyWithNewAppCode(List<FlowElement> flowElementList, String oldAppCode, String newAppCode, String oldServiceName, String newServiceName) {
        boolean sameAppCode = HussarUtils.equals((Object)oldAppCode, (Object)newAppCode);
        boolean sameServiceName = HussarUtils.equals((Object)oldServiceName, (Object)newServiceName);
        if (sameAppCode && sameServiceName) {
            return;
        }
        for (FlowElement flowElement : flowElementList) {
            List assistFlowFormDetailKeyList;
            Map assistFlowFormDetailKeyMap;
            List assistFormKeyMapList;
            Map assistFormKeyMap;
            List ccDetailFormKeyList;
            Map ccDetailFormKeyMap;
            List ccFormKeyList;
            Map ccFormKeyMap;
            List flowFormDetailKeyList;
            Map flowFormDetailKeyElementMap;
            if (!(flowElement instanceof UserTask) && !(flowElement instanceof StartEvent)) continue;
            if (flowElement instanceof StartEvent) {
                StartEvent startEvent = (StartEvent)flowElement;
                String startEventFormKey = startEvent.getFormKey();
                String newStartEventFormKey = WorkflowMigrationUtil.convertFormKeyWithNewAppCode(startEventFormKey, oldAppCode, newAppCode, oldServiceName, newServiceName);
                startEvent.setFormKey(newStartEventFormKey);
                continue;
            }
            UserTask userTask = (UserTask)flowElement;
            String userTaskFormKey = userTask.getFormKey();
            String newUserTaskFormKey = WorkflowMigrationUtil.convertFormKeyWithNewAppCode(userTaskFormKey, oldAppCode, newAppCode, oldServiceName, newServiceName);
            userTask.setFormKey(newUserTaskFormKey);
            List flowFormDetailKeyElement = (List)userTask.getExtensionElements().get("flowFormDetailKey");
            String flowFormDetailKey = null;
            if (flowFormDetailKeyElement != null && !flowFormDetailKeyElement.isEmpty() && (flowFormDetailKeyElementMap = ((ExtensionElement)flowFormDetailKeyElement.get(0)).getAttributes()) != null && (flowFormDetailKeyList = (List)flowFormDetailKeyElementMap.get("flowFormDetailKey")) != null && !flowFormDetailKeyList.isEmpty()) {
                flowFormDetailKey = ((ExtensionAttribute)flowFormDetailKeyList.get(0)).getValue();
                String newflowFormDetailKey = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(flowFormDetailKey, oldAppCode, newAppCode, oldServiceName, newServiceName);
                ((ExtensionAttribute)flowFormDetailKeyList.get(0)).setValue(newflowFormDetailKey);
            }
            List ccElement = (List)userTask.getExtensionElements().get("ccFormKey");
            String ccFormKey = null;
            if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                ccFormKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
                String newCcFormKey = WorkflowMigrationUtil.convertFormKeyWithNewAppCode(ccFormKey, oldAppCode, newAppCode, oldServiceName, newServiceName);
                ((ExtensionAttribute)ccFormKeyList.get(0)).setValue(newCcFormKey);
            }
            List ccDetailElement = (List)userTask.getExtensionElements().get("ccFlowFormDetailKey");
            String ccDetailFormKey = null;
            if (ccDetailElement != null && !ccDetailElement.isEmpty() && (ccDetailFormKeyMap = ((ExtensionElement)ccDetailElement.get(0)).getAttributes()) != null && (ccDetailFormKeyList = (List)ccDetailFormKeyMap.get("ccFlowFormDetailKey")) != null && !ccDetailFormKeyList.isEmpty()) {
                ccDetailFormKey = ((ExtensionAttribute)ccDetailFormKeyList.get(0)).getValue();
                String newCcDetailFormKey = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(ccDetailFormKey, oldAppCode, newAppCode, oldServiceName, newServiceName);
                ((ExtensionAttribute)ccDetailFormKeyList.get(0)).setValue(newCcDetailFormKey);
            }
            List assistFormKeyElement = (List)userTask.getExtensionElements().get("assistFormKey");
            String assistFormKey = null;
            if (assistFormKeyElement != null && !assistFormKeyElement.isEmpty() && (assistFormKeyMap = ((ExtensionElement)assistFormKeyElement.get(0)).getAttributes()) != null && (assistFormKeyMapList = (List)assistFormKeyMap.get("assistFormKey")) != null && !assistFormKeyMapList.isEmpty()) {
                assistFormKey = ((ExtensionAttribute)assistFormKeyMapList.get(0)).getValue();
                String newAssistFormKey = WorkflowMigrationUtil.convertFormKeyWithNewAppCode(assistFormKey, oldAppCode, newAppCode, oldServiceName, newServiceName);
                ((ExtensionAttribute)assistFormKeyMapList.get(0)).setValue(newAssistFormKey);
            }
            List assistFlowFormDetailKeyElement = (List)userTask.getExtensionElements().get("assistFlowFormDetailKey");
            String assistFlowFormDetailKey = null;
            if (assistFlowFormDetailKeyElement == null || assistFlowFormDetailKeyElement.isEmpty() || (assistFlowFormDetailKeyMap = ((ExtensionElement)assistFlowFormDetailKeyElement.get(0)).getAttributes()) == null || (assistFlowFormDetailKeyList = (List)assistFlowFormDetailKeyMap.get("assistFlowFormDetailKey")) == null || assistFlowFormDetailKeyList.isEmpty()) continue;
            assistFlowFormDetailKey = ((ExtensionAttribute)assistFlowFormDetailKeyList.get(0)).getValue();
            String newAssistFlowFormDetailKey = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(assistFlowFormDetailKey, oldAppCode, newAppCode, oldServiceName, newServiceName);
            ((ExtensionAttribute)assistFlowFormDetailKeyList.get(0)).setValue(newAssistFlowFormDetailKey);
        }
    }

    public static void convertSubProcessFileFormKeyWithNewAppCode(JSONObject slots, String oldAppCode, String newAppCode, String oldServiceName, String newServiceName) {
        if (HussarUtils.equals((Object)oldAppCode, (Object)newAppCode)) {
            return;
        }
        if (HussarUtils.isNotEmpty((Object)slots)) {
            JSONArray nodes = slots.getJSONArray("default");
            for (int i = 0; i < nodes.size(); ++i) {
                String assistFormDetailAddress;
                String ccFormAddress;
                String assistFormAddress;
                String formDetailAddress;
                String ccFormDetailAddress;
                JSONObject node = nodes.getJSONObject(i);
                if (!BpmNodeTypeUtil.isStart((String)node.getString("name")) && !BpmNodeTypeUtil.isUserTask((String)node.getString("name"))) continue;
                JSONObject nodeProps = node.getJSONObject("props");
                String formAddress = nodeProps.getString("formAddress");
                if (HussarUtils.isNotEmpty((Object)formAddress)) {
                    String newFormAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(formAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                    JSONObject newFormAddressJson = JSON.parseObject((String)newFormAddress);
                    nodeProps.put("formAddress", (Object)newFormAddressJson);
                }
                if (HussarUtils.isNotEmpty((Object)(ccFormDetailAddress = nodeProps.getString("ccFormDetailAddress")))) {
                    String newCcFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(ccFormDetailAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                    JSONObject newCcFormDetailAddressJson = JSON.parseObject((String)newCcFormDetailAddress);
                    nodeProps.put("ccFormDetailAddress", (Object)newCcFormDetailAddressJson);
                }
                if (HussarUtils.isNotEmpty((Object)(formDetailAddress = nodeProps.getString("formDetailAddress")))) {
                    String newFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(formDetailAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                    JSONObject newFormDetailAddressJson = JSON.parseObject((String)newFormDetailAddress);
                    nodeProps.put("formDetailAddress", (Object)newFormDetailAddressJson);
                }
                if (HussarUtils.isNotEmpty((Object)(assistFormAddress = nodeProps.getString("assistFormAddress")))) {
                    String newAssistFormAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(assistFormAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                    JSONObject newAssistFormAddressJson = JSON.parseObject((String)newAssistFormAddress);
                    nodeProps.put("assistFormAddress", (Object)newAssistFormAddressJson);
                }
                if (HussarUtils.isNotEmpty((Object)(ccFormAddress = nodeProps.getString("ccFormAddress")))) {
                    String newCcFormAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(ccFormAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                    JSONObject newCcFormAddressJson = JSON.parseObject((String)newCcFormAddress);
                    nodeProps.put("ccFormAddress", (Object)newCcFormAddressJson);
                }
                if (!HussarUtils.isNotEmpty((Object)(assistFormDetailAddress = nodeProps.getString("assistFormDetailAddress")))) continue;
                String newAssistFormDetailAddress = WorkflowMigrationUtil.convertDetailFormKeyWithNewAppCode(assistFormDetailAddress, oldAppCode, newAppCode, oldServiceName, newServiceName);
                JSONObject newAssistFormDetailAddressJson = JSON.parseObject((String)newAssistFormDetailAddress);
                nodeProps.put("assistFormDetailAddress", (Object)newAssistFormDetailAddressJson);
            }
        }
    }
}

