/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmSecurityUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CompatibleCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowCompleteTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowCompleteTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowProcess;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowCompleteTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class FlowCompleteTaskServiceImpl
implements IFlowCompleteTaskService {
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private ISysActExtendPropertiesService extendPropertiesService;
    @Resource
    private FlowCompleteTaskMapper flowCompleteTaskMapper;
    @Autowired
    @Lazy
    private ModelService modelService;

    private List<TaskManagerQueryVo> hisTasksToVo(List<FlowTask> lists, Map<String, FlowProcess> processMap) {
        ArrayList<TaskManagerQueryVo> list = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (HussarUtils.isNotEmpty((Object)flowTask.getSendUser())) {
                    userIds.add(flowTask.getSendUser());
                }
                userIds.add(flowTask.getUserId());
                userIds.add(flowTask.getProcessStartUserId());
                ids.add(flowTask.getTaskDefinitionKey());
            }
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds);
        }
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                String modelType;
                String appId;
                TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setOwner(flowTask.getOwner());
                taskManagerQueryVo.setTaskState(flowTask.getTaskState());
                taskVariables.putAll(CompatibleCodeUtil.resetVariable(flowTask, processMap.get(flowTask.getProcessInsId())));
                taskManagerQueryVo.setTaskVariables(taskVariables);
                String taskSourceFlag = flowTask.getTaskSourceFlag();
                taskManagerQueryVo.setTaskSourceFlag(taskSourceFlag);
                String scope = taskSourceFlag;
                taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
                taskManagerQueryVo.setTaskType(flowTask.getTaskType());
                scope = TaskSourceFlag.isReject((String)scope) ? "\u5df2\u9a73\u56de" : (ToolUtil.isNotEmpty((Object)flowTask.getEndTime()) ? "\u5df2\u5b8c\u6210" : "\u672a\u5b8c\u6210");
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser(flowTask.getSendUser());
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(flowTask.getSendUser()));
                taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
                taskManagerQueryVo.setProcessStartUserName((String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
                taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                String formDetail = flowTask.getFormDetail();
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (HussarUtils.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                    taskManagerQueryVo.setUni(object.getString("uni"));
                }
                taskManagerQueryVo.setSecurityLevel(BpmSecurityUtil.getSecurityLevelLabel(flowTask.getSecurityLevel()));
                taskManagerQueryVo.setFormId(flowTask.getFormId());
                if (HussarUtils.isNotEmpty((Object)flowTask.getProcessKey()) && HussarUtils.isNotEmpty((Object)(appId = String.valueOf(this.modelService.getAppId(flowTask.getProcessKey()))))) {
                    taskManagerQueryVo.setAppId(appId);
                }
                if ("0".equals(modelType = this.modelService.getProcessModelType(flowTask.getProcessKey()))) {
                    taskManagerQueryVo.setProcessType("0");
                } else {
                    taskManagerQueryVo.setProcessType("1");
                }
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneNonCompleteList(Page<FlowTask> pages, FlowCompleteTaskQueryModel flowTaskQueryModel) {
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = BaseSecurityUtil.getSecurityLevel();
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowCompleteTaskMapper.countDoneTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty((Object)pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty((Object)pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        if (todoTotal == 0L) {
            pages.setTotal(todoTotal);
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> doneList = this.flowCompleteTaskMapper.doneNonCompleteList((Page<FlowTask>)pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        HashSet<String> procDefIds = new HashSet<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
            procDefIds.add(flowTask.getProcessDefinitionId());
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        List extendProperties = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowCompleteTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowCompleteTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowCompleteTaskMapper.getAllVariables(taskIds, null));
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, procDefIds);
            extendProperties = this.extendPropertiesService.list((Wrapper)lambdaQueryWrapper);
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, Object> extendPropertiesMap = new HashMap<String, Object>();
        for (Object sysActExtendProperties : extendProperties) {
            extendPropertiesMap.put(sysActExtendProperties.getProcDefId() + ":" + sysActExtendProperties.getTaskDefKey(), sysActExtendProperties);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        for (FlowTask flowTask : doneList) {
            SysActExtendProperties formDetailKeyMsg = (SysActExtendProperties)extendPropertiesMap.get(flowTask.getProcessDefinitionId() + ":" + flowTask.getTaskDefinitionKey());
            if (formDetailKeyMsg != null) {
                if ("2".equals(flowTask.getTaskType())) {
                    flowTask.setFormDetail(formDetailKeyMsg.getAssistFormDetailKey());
                } else {
                    flowTask.setFormDetail(formDetailKeyMsg.getFormDetailKey());
                }
            }
            flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
            flowTask.setSecurityLevel(flowProcess.getSecurityLevel());
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, processMap));
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)page.getRecords(), TaskManagerQueryVo.class).translate(TaskManagerQueryVo::getTaskNameTranslateKey, TaskManagerQueryVo::setTaskDefinitionName).translate(TaskManagerQueryVo::getProcNameTranslateKey, TaskManagerQueryVo::setProcessName).execute();
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> masterDoneNonCompleteList(Page<FlowTask> pages, FlowCompleteTaskQueryModel flowTaskQueryModel) {
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            String userId = flowTaskQueryModel.getUserId();
            if (HussarUtils.isEmpty((Object)userId)) {
                userId = flowTaskQueryModel.getMandator();
            }
            if (HussarUtils.isNotEmpty((Object)userId)) {
                DynamicDataSourceContextHolder.push((String)"master");
                securityLevel = this.iAssigneeChooseService.getSecurityLevel(userId, null);
                DynamicDataSourceContextHolder.poll();
            }
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowCompleteTaskMapper.countDoneTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty((Object)pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty((Object)pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        if (todoTotal == 0L) {
            pages.setTotal(todoTotal);
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> doneList = this.flowCompleteTaskMapper.doneNonCompleteList((Page<FlowTask>)pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        HashSet<String> procDefIds = new HashSet<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
            procDefIds.add(flowTask.getProcessDefinitionId());
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        List extendProperties = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowCompleteTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowCompleteTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowCompleteTaskMapper.getAllVariables(taskIds, null));
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, procDefIds);
            extendProperties = this.extendPropertiesService.list((Wrapper)lambdaQueryWrapper);
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, Object> extendPropertiesMap = new HashMap<String, Object>();
        for (Object sysActExtendProperties : extendProperties) {
            extendPropertiesMap.put(sysActExtendProperties.getProcDefId() + ":" + sysActExtendProperties.getTaskDefKey(), sysActExtendProperties);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        for (FlowTask flowTask : doneList) {
            SysActExtendProperties formDetailKeyMsg = (SysActExtendProperties)extendPropertiesMap.get(flowTask.getProcessDefinitionId() + ":" + flowTask.getTaskDefinitionKey());
            if (formDetailKeyMsg != null) {
                if ("2".equals(flowTask.getTaskType())) {
                    flowTask.setFormDetail(formDetailKeyMsg.getAssistFormDetailKey());
                } else {
                    flowTask.setFormDetail(formDetailKeyMsg.getFormDetailKey());
                }
            }
            flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
            flowTask.setSecurityLevel(flowProcess.getSecurityLevel());
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, processMap));
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)page.getRecords(), TaskManagerQueryVo.class).translate(TaskManagerQueryVo::getTaskNameTranslateKey, TaskManagerQueryVo::setTaskDefinitionName).translate(TaskManagerQueryVo::getProcNameTranslateKey, TaskManagerQueryVo::setProcessName).execute();
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> completeList(Page<FlowTask> pages, FlowCompleteTaskQueryModel flowTaskQueryModel) {
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = BaseSecurityUtil.getSecurityLevel();
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowCompleteTaskMapper.countDoneTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty((Object)pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty((Object)pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        if (todoTotal == 0L) {
            pages.setTotal(todoTotal);
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> doneList = this.flowCompleteTaskMapper.completeList((Page<FlowTask>)pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        HashSet<String> procDefIds = new HashSet<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
            procDefIds.add(flowTask.getProcessDefinitionId());
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        List extendProperties = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowCompleteTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowCompleteTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowCompleteTaskMapper.getAllVariables(taskIds, null));
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, procDefIds);
            extendProperties = this.extendPropertiesService.list((Wrapper)lambdaQueryWrapper);
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, Object> extendPropertiesMap = new HashMap<String, Object>();
        for (Object sysActExtendProperties : extendProperties) {
            extendPropertiesMap.put(sysActExtendProperties.getProcDefId() + ":" + sysActExtendProperties.getTaskDefKey(), sysActExtendProperties);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        for (FlowTask flowTask : doneList) {
            SysActExtendProperties formDetailKeyMsg = (SysActExtendProperties)extendPropertiesMap.get(flowTask.getProcessDefinitionId() + ":" + flowTask.getTaskDefinitionKey());
            if (formDetailKeyMsg != null) {
                if ("2".equals(flowTask.getTaskType())) {
                    flowTask.setFormDetail(formDetailKeyMsg.getAssistFormDetailKey());
                } else {
                    flowTask.setFormDetail(formDetailKeyMsg.getFormDetailKey());
                }
            }
            flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
            flowTask.setSecurityLevel(flowProcess.getSecurityLevel());
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, processMap));
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)page.getRecords(), TaskManagerQueryVo.class).translate(TaskManagerQueryVo::getTaskNameTranslateKey, TaskManagerQueryVo::setTaskDefinitionName).translate(TaskManagerQueryVo::getProcNameTranslateKey, TaskManagerQueryVo::setProcessName).execute();
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> masterCompleteList(Page<FlowTask> pages, FlowCompleteTaskQueryModel flowTaskQueryModel) {
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            String userId = flowTaskQueryModel.getUserId();
            if (HussarUtils.isEmpty((Object)userId)) {
                userId = flowTaskQueryModel.getMandator();
            }
            if (HussarUtils.isNotEmpty((Object)userId)) {
                DynamicDataSourceContextHolder.push((String)"master");
                securityLevel = this.iAssigneeChooseService.getSecurityLevel(userId, null);
                DynamicDataSourceContextHolder.poll();
            }
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowCompleteTaskMapper.countDoneTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty((Object)pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty((Object)pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        if (todoTotal == 0L) {
            pages.setTotal(todoTotal);
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> doneList = this.flowCompleteTaskMapper.completeList((Page<FlowTask>)pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        HashSet<String> procDefIds = new HashSet<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
            procDefIds.add(flowTask.getProcessDefinitionId());
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        List extendProperties = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowCompleteTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowCompleteTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowCompleteTaskMapper.getAllVariables(taskIds, null));
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, procDefIds);
            extendProperties = this.extendPropertiesService.list((Wrapper)lambdaQueryWrapper);
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, Object> extendPropertiesMap = new HashMap<String, Object>();
        for (Object sysActExtendProperties : extendProperties) {
            extendPropertiesMap.put(sysActExtendProperties.getProcDefId() + ":" + sysActExtendProperties.getTaskDefKey(), sysActExtendProperties);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        for (FlowTask flowTask : doneList) {
            SysActExtendProperties formDetailKeyMsg = (SysActExtendProperties)extendPropertiesMap.get(flowTask.getProcessDefinitionId() + ":" + flowTask.getTaskDefinitionKey());
            if (formDetailKeyMsg != null) {
                if ("2".equals(flowTask.getTaskType())) {
                    flowTask.setFormDetail(formDetailKeyMsg.getAssistFormDetailKey());
                } else {
                    flowTask.setFormDetail(formDetailKeyMsg.getFormDetailKey());
                }
            }
            flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
            flowTask.setSecurityLevel(flowProcess.getSecurityLevel());
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, processMap));
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)page.getRecords(), TaskManagerQueryVo.class).translate(TaskManagerQueryVo::getTaskNameTranslateKey, TaskManagerQueryVo::setTaskDefinitionName).translate(TaskManagerQueryVo::getProcNameTranslateKey, TaskManagerQueryVo::setProcessName).execute();
        return ApiResponse.success((Object)page);
    }
}

