/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.service.WorkflowCommonCacheService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowOrganProcessUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.form.WorkflowAuthConfigQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActHandleAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysFormHandleAuthService")
@HussarTokenDs
public class SysActHandleAuthServiceImpl
extends ServiceImpl<SysActHandleAuthMapper, SysActHandleAuth>
implements SysActHandleAuthService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private SysActHandleAuthMapper sysActHandleAuthMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private WorkflowCommonCacheService workflowCommonCacheService;
    private static final List<String> HANDLE_AUTH_LIST = new ArrayList<String>();

    private List<SysActHandleAuth> getListByTaskId(String taskId, String formType) {
        String procDefId;
        Integer version;
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).queryChildTask()).singleResult();
        if (historicTaskInstance == null) {
            return new ArrayList<SysActHandleAuth>();
        }
        Object historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance.getEndTime())) {
            return new ArrayList<SysActHandleAuth>();
        }
        if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getEndTime())) {
            switch (formType) {
                case "2": {
                    formType = "1";
                    break;
                }
                case "4": {
                    formType = "5";
                    break;
                }
            }
        }
        if ((version = Integer.valueOf((procDefId = historicTaskInstance.getProcessDefinitionId()).split(":")[1])) <= 0) {
            version = Integer.valueOf(this.workflowCommonCacheService.getRealVersion(historicTaskInstance.getProcessDefinitionId()));
        }
        Integer conditionVersion = version;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
        String nodeId = CommonCodeUtil.getVisitorNodeId(historicTaskInstance.getTaskDefinitionKey(), bpmnModel);
        String processKey = historicTaskInstance.getProcessDefinitionId().split(":")[0];
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysActHandleAuth::getProcessKey, (Object)processKey);
        lambdaQueryWrapper.eq(SysActHandleAuth::getTaskDefinitionKey, (Object)nodeId);
        lambdaQueryWrapper.eq(SysActHandleAuth::getProcessVersion, (Object)conditionVersion);
        List list = this.sysActHandleAuthMapper.selectList((Wrapper)lambdaQueryWrapper);
        for (SysActHandleAuth sysActHandleAuth : list) {
            sysActHandleAuth.setTaskDefinitionKey(historicTaskInstance.getTaskDefinitionKey());
        }
        return list;
    }

    public BpmResponseResult queryHandleAuthConfigs(String processKey, String taskDefintionKey, String processVersion, String taskId, String formType) {
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return InstallResult.fail((String)"");
        }
        JSONArray jsonArray = new JSONArray();
        List<Object> list = new ArrayList();
        if (HussarUtils.isEmpty((Object)taskId)) {
            try {
                if (HussarUtils.isEmpty((Object)processVersion)) {
                    processVersion = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null, null).split(":")[1];
                }
            }
            catch (PublicClientException e) {
                return InstallResult.fail((String)e.getReason());
            }
            list = this.sysActHandleAuthMapper.getHandleAuthWithoutRunning(processKey, processVersion, formType);
        } else {
            list = this.getListByTaskId(taskId, formType);
        }
        for (SysActHandleAuth sysActHandleAuth : list) {
            if ((!HussarUtils.isEmpty((Object)taskId) ? "Save".equals(sysActHandleAuth.getHandleType()) : HANDLE_AUTH_LIST.contains(sysActHandleAuth.getHandleType())) || ("2".equals(formType) ? "Revoke".equals(sysActHandleAuth.getHandleType()) : "1".equals(formType) && !"Revoke".equals(sysActHandleAuth.getHandleType()))) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("handleAuthId", (Object)sysActHandleAuth.getId());
            jsonObject.put("processDefinitionKey", (Object)sysActHandleAuth.getProcessKey());
            jsonObject.put("taskDefinitionKey", (Object)sysActHandleAuth.getTaskDefinitionKey());
            jsonObject.put("processVersion", (Object)String.valueOf(sysActHandleAuth.getProcessVersion()));
            jsonObject.put("handleName", (Object)sysActHandleAuth.getHandleName());
            jsonObject.put("handleType", (Object)sysActHandleAuth.getHandleType());
            jsonObject.put("extendConfiguration", (Object)sysActHandleAuth.getExtendConfiguration());
            jsonObject.put("handleIcon", (Object)sysActHandleAuth.getHandleIcon());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.success((JSONArray)jsonArray);
    }

    public JSONArray getAllAuthConfigs(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        JSONArray jsonArray = new JSONArray();
        List<Object> list = new ArrayList();
        if (HussarUtils.isEmpty((Object)workflowAuthConfigQueryDto.getTaskId())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getProcessKey()), SysActHandleAuth::getProcessKey, (Object)workflowAuthConfigQueryDto.getProcessKey());
            Integer n = workflowAuthConfigQueryDto.getVersion();
            if (n == null) {
                Integer conditionVersion;
                try {
                    String processDefinitionId = WorkflowOrganProcessUtil.getStartOrganProcessId(workflowAuthConfigQueryDto.getProcessKey(), null, workflowAuthConfigQueryDto.getUserId(), workflowAuthConfigQueryDto.getOrganId(), !workflowAuthConfigQueryDto.isGetLastVersion());
                    conditionVersion = Integer.valueOf(processDefinitionId.split(":")[1]);
                }
                catch (BpmException e) {
                    return new JSONArray();
                }
                lambdaQueryWrapper.eq(SysActHandleAuth::getProcessVersion, (Object)conditionVersion);
            } else {
                lambdaQueryWrapper.eq(SysActHandleAuth::getProcessVersion, (Object)n);
            }
            String taskDefinitionKey = workflowAuthConfigQueryDto.getTaskDefinitionKey();
            if (HussarUtils.isNotEmpty((Object)taskDefinitionKey)) {
                List<String> taskDefinitionKeyList = Arrays.asList(taskDefinitionKey.split(","));
                lambdaQueryWrapper.in(SysActHandleAuth::getTaskDefinitionKey, taskDefinitionKeyList);
            } else {
                lambdaQueryWrapper.isNull(SysActHandleAuth::getTaskDefinitionKey);
            }
            String handleType = workflowAuthConfigQueryDto.getHandleType();
            if (HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getHandleType())) {
                lambdaQueryWrapper.like(SysActHandleAuth::getHandleType, (Object)handleType);
            }
            list = this.sysActHandleAuthMapper.selectList((Wrapper)lambdaQueryWrapper);
        } else {
            String taskId = workflowAuthConfigQueryDto.getTaskId();
            workflowAuthConfigQueryDto.setTaskId(RealTaskId.getRealTaskId(taskId));
            list = this.getListByTaskId(workflowAuthConfigQueryDto.getTaskId(), workflowAuthConfigQueryDto.getFormType());
        }
        for (SysActHandleAuth sysActHandleAuth : list) {
            List<String> assigneeList;
            if (!HussarUtils.isEmpty((Object)workflowAuthConfigQueryDto.getTaskId()) ? "2".equals(workflowAuthConfigQueryDto.getFormType()) && "DelAssignee".equals(sysActHandleAuth.getHandleType()) && HussarUtils.isEmpty(assigneeList = CommonCodeUtil.queryMultiTodoAssignee(null, workflowAuthConfigQueryDto.getTaskDefinitionKey(), workflowAuthConfigQueryDto.getTaskId(), workflowAuthConfigQueryDto.getUserId())) || "Save".equals(sysActHandleAuth.getHandleType()) : HANDLE_AUTH_LIST.contains(sysActHandleAuth.getHandleType())) continue;
            if ("2".equals(workflowAuthConfigQueryDto.getFormType()) ? "Revoke".equals(sysActHandleAuth.getHandleType()) : "1".equals(workflowAuthConfigQueryDto.getFormType()) && !"Revoke".equals(sysActHandleAuth.getHandleType())) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("handleAuthId", (Object)sysActHandleAuth.getId());
            jsonObject.put("processDefinitionKey", (Object)sysActHandleAuth.getProcessKey());
            jsonObject.put("taskDefinitionKey", (Object)sysActHandleAuth.getTaskDefinitionKey());
            jsonObject.put("processVersion", (Object)String.valueOf(sysActHandleAuth.getProcessVersion()));
            jsonObject.put("handleName", (Object)sysActHandleAuth.getHandleName());
            jsonObject.put("extendConfiguration", (Object)sysActHandleAuth.getExtendConfiguration());
            jsonObject.put("handleIcon", (Object)sysActHandleAuth.getHandleIcon());
            jsonObject.put("handleType", (Object)sysActHandleAuth.getHandleType());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public BpmResponseResult queryHandleAuthConfigsByDto(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        return InstallResult.success((JSONArray)this.getAllAuthConfigs(workflowAuthConfigQueryDto));
    }

    public Map<String, Boolean> queryIsRequiredCommentSign(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        JSONArray allAuthConfigs = this.getAllAuthConfigs(workflowAuthConfigQueryDto);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        boolean isRequireComment = false;
        boolean isRequireSign = false;
        for (Object allAuthConfig : allAuthConfigs) {
            JSONObject authConfig = (JSONObject)allAuthConfig;
            JSONObject extendConfiguration = JSON.parseObject((String)authConfig.get((Object)"extendConfiguration").toString());
            if (HussarUtils.isNotEmpty((Object)extendConfiguration)) {
                isRequireComment = HussarUtils.isNotEmpty((Object)extendConfiguration.get((Object)"isRequireComment")) ? (Boolean)extendConfiguration.get((Object)"isRequireComment") : false;
                boolean bl = isRequireSign = HussarUtils.isNotEmpty((Object)extendConfiguration.get((Object)"isRequireSign")) ? (Boolean)extendConfiguration.get((Object)"isRequireSign") : false;
            }
            if (map.containsKey("isRequireComment")) {
                if (isRequireComment) {
                    map.put("isRequireComment", isRequireComment);
                }
            } else {
                map.put("isRequireComment", isRequireComment);
            }
            if (map.containsKey("isRequireSign")) {
                if (!isRequireSign) continue;
                map.put("isRequireSign", isRequireSign);
                continue;
            }
            map.put("isRequireSign", isRequireSign);
        }
        return map;
    }

    public boolean insertBatch(List<SysActHandleAuth> list) {
        return this.sysActHandleAuthMapper.insertBatch(list);
    }

    static {
        HANDLE_AUTH_LIST.add("EndProcess");
        HANDLE_AUTH_LIST.add("EntrustTask");
        HANDLE_AUTH_LIST.add("FreeJump");
        HANDLE_AUTH_LIST.add("AddAssignee");
        HANDLE_AUTH_LIST.add("DelAssignee");
    }
}

