/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;

public class ChildTaskCompleteCmd
extends CommonPrepareCmd {
    protected DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    protected String comment;

    @Override
    protected void taskAuthentication(TaskEntity task) {
        if (task == null) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
        }
        if (task.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED);
        }
        if (task.getParentTaskId() == null) {
            throw new BpmException(BpmExceptionCodeEnum.COMMON_TASK_WITH_ASSIST_HANDLE);
        }
    }

    @Override
    protected void follow(CommandContext commandContext, TaskEntity task) {
        TaskEntity parentTask = commandContext.getTaskEntityManager().findTaskById(task.getParentTaskId());
        if (parentTask != null) {
            if (HussarUtils.isNotEmpty((Object)this.comment)) {
                CommentEntity.addComment((String)this.userId, (String)this.taskId, (String)this.comment);
            }
            task.setTaskSourceFlag("assist_complete");
            if (!task.isDeleted()) {
                task.fireEvent("beforeComplete");
                task.setDeleted(true);
                String taskId = task.getId();
                commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByTaskId(taskId);
                commandContext.getVariableInstanceEntityManager().deleteVariableInstanceByTask(task);
                commandContext.getHistoryManager().recordTaskAssigneeChange(taskId, this.userId);
                commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)task, null, (boolean)false));
                commandContext.getHistoryManager().recordTaskEnd(taskId, "complete", this.mandator, this.taskState, ((IdentityLinkEntity)task.getIdentityLinks().get(0)).getAssistInitiator());
                task.fireEvent("complete");
                commandContext.getDbSqlSession().delete((PersistentObject)task);
                if (commandContext.getEventDispatcher().isEnabled()) {
                    commandContext.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.ENTITY_DELETED, (Object)task));
                }
            }
        }
        this.dataPushService.completeDataPush((Task)task, this.comment, this.userId, this.mandator, this.taskState, task.getTaskType());
        List ccTaskEntityList = Context.getCommandContext().getCcTaskEntityManager().getCcTaskByProcessInsIdAndTaskDefKey(task.getTaskDefinitionKey(), Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
        ArrayList<CcTaskEntity> privateCcTaskEntityList = new ArrayList<CcTaskEntity>();
        List<Object> userList = new ArrayList();
        userList = Arrays.asList(this.userId.split(","));
        for (CcTaskEntity ccTaskEntity : ccTaskEntityList) {
            if (!userList.contains(ccTaskEntity.getReceiveUser()) || !"0".equals(ccTaskEntity.getTaskState())) continue;
            privateCcTaskEntityList.add(ccTaskEntity);
        }
        if (HussarUtils.isNotEmpty(privateCcTaskEntityList)) {
            Date date = new Date();
            Timestamp endTime = new Timestamp(date.getTime());
            for (CcTaskEntity sysActCcTask : privateCcTaskEntityList) {
                sysActCcTask.setTaskState("1");
                sysActCcTask.setEndTime(endTime);
                sysActCcTask.updateCcTask();
                if (!this.dataPushService.isDataPush(sysActCcTask.getProcDefId())) continue;
                DataPush dataPush = new DataPush();
                dataPush.setUserId(sysActCcTask.getReceiveUser());
                dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
                dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
                dataPush.setProcessInsId(String.valueOf(sysActCcTask.getProcessInsId()));
                this.dataPushService.readCcTask(dataPush);
            }
        }
    }

    public ChildTaskCompleteCmd(String taskId, String userId, String comment) {
        super(taskId, userId);
        this.comment = comment;
    }

    public ChildTaskCompleteCmd(String taskId, String userId, String mandator, String comment) {
        super(taskId, userId, mandator);
        this.comment = comment;
    }
}

