/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.platform.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CharsetUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ResourceUtil;
import com.jxdinfo.hussar.platform.core.utils.id.UUID;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.dto.AddWorkflowDto;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.service.IBpmDesignerService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.translate.util.BpmTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class BpmDesignerServiceImpl
implements IBpmDesignerService {
    private final GodAxeModelService godAxeModelService;
    private final SysActProcessFileService sysActProcessFileService;
    private final SysActFormAuthService sysActFormAuthService;
    private final SysActAssigneeService sysActAssigneeService;
    private final ProcessDefinitionsService processDefinitionsService;
    private static final String BPM_TEMPLATE_RESOURCE = "bpm/template/bpm_template.json";

    public BpmDesignerServiceImpl(GodAxeModelService godAxeModelService, SysActProcessFileService sysActProcessFileService, SysActFormAuthService sysActFormAuthService, SysActAssigneeService sysActAssigneeService, ProcessDefinitionsService processDefinitionsService) {
        this.godAxeModelService = godAxeModelService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.sysActFormAuthService = sysActFormAuthService;
        this.sysActAssigneeService = sysActAssigneeService;
        this.processDefinitionsService = processDefinitionsService;
    }

    public ApiResponse<?> saveWorkflow(WorkFlow workFlow) {
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> addWorkflow(WorkFlow workFlow) {
        List list = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)workFlow.getIdentity()));
        if (HussarUtils.isNotEmpty((Object)list)) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.SAME_IDENTITY.getMessage());
        }
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> addWorkflow(AddWorkflowDto addWorkflowDto) {
        if (HussarUtils.isEmpty((Object)addWorkflowDto.getProcessKey()) || HussarUtils.isEmpty((Object)addWorkflowDto.getProcessName())) {
            throw new BpmException(BpmExceptionCodeEnum.NULL_IDENTITY_OR_NAME);
        }
        List list = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)addWorkflowDto.getProcessKey()));
        if (HussarUtils.isNotEmpty((Object)list)) {
            throw new BpmException(BpmExceptionCodeEnum.SAME_IDENTITY);
        }
        String bpmTemplate = ResourceUtil.readStr((String)BPM_TEMPLATE_RESOURCE, (Charset)CharsetUtil.CHARSET_UTF_8);
        WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)bpmTemplate, WorkFlow.class);
        workFlow.setId(UUID.randomUUID().toString());
        workFlow.setName(addWorkflowDto.getProcessName());
        workFlow.setIdentity(addWorkflowDto.getProcessKey());
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> publishNewVersion(WorkFlow workFlow) {
        boolean flag = DefinitionEngineService.queryIsPublish((String)workFlow.getIdentity());
        if (!flag && HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.ERROR_PUBLISH_PROCESS_ON_ORGAN.getMessage());
        }
        if (HussarUtils.isEmpty((Object)workFlow.getProcessTag())) {
            this.godAxeModelService.saveAndPublishWorkflow(workFlow, null, true);
        } else {
            this.godAxeModelService.saveWorkflowAboutOrgan(workFlow, null, null, null, null, true, true);
        }
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow);
    }

    private JSONObject changeFormAuth(JSONObject flowObject, List<SysActFormAuth> formAuthList) {
        JSONObject ccFormDetailAddressMap;
        JSONObject ccFormAddressMap;
        JSONObject assistFormDetailAddressMap;
        JSONObject assistFormAddressMap;
        JSONObject formDetailAddressMap;
        String taskDefinitionKey;
        Map<String, Map<String, Map<String, List<SysActFormAuth>>>> formAuthMap = formAuthList.stream().collect(Collectors.groupingBy(SysActFormAuth::getTaskDefinitionKey, Collectors.groupingBy(SysActFormAuth::getFormType, Collectors.groupingBy(SysActFormAuth::getFormState))));
        if (HussarUtils.isEmpty(formAuthMap.get(taskDefinitionKey = flowObject.getString("instanceKey")))) {
            return null;
        }
        JSONObject formAddressMap = flowObject.getJSONObject("props").getJSONObject("formAddress");
        if (HussarUtils.isNotEmpty((Object)formAddressMap)) {
            for (Object formState : formAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("2").get(formState))) continue;
                formAddressMap.getJSONObject((String)formState).put("formAuth", (Object)this.tranToFormAuthJson(formAddressMap.getJSONObject((String)formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("2").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(formDetailAddressMap = flowObject.getJSONObject("props").getJSONObject("formDetailAddress")))) {
            for (Object formState : formDetailAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("1").get(formState))) continue;
                formDetailAddressMap.getJSONObject((String)formState).put("formAuth", (Object)this.tranToFormAuthJson(formDetailAddressMap.getJSONObject((String)formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("1").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(assistFormAddressMap = flowObject.getJSONObject("props").getJSONObject("assistFormAddress")))) {
            for (Object formState : assistFormAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("4").get(formState))) continue;
                assistFormAddressMap.getJSONObject((String)formState).put("formAuth", (Object)this.tranToFormAuthJson(assistFormAddressMap.getJSONObject((String)formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("4").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(assistFormDetailAddressMap = flowObject.getJSONObject("props").getJSONObject("assistFormDetailAddress")))) {
            for (Object formState : assistFormDetailAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("5").get(formState))) continue;
                assistFormDetailAddressMap.getJSONObject((String)formState).put("formAuth", (Object)this.tranToFormAuthJson(assistFormDetailAddressMap.getJSONObject((String)formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("5").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(ccFormAddressMap = flowObject.getJSONObject("props").getJSONObject("ccFormAddress")))) {
            for (String formState : ccFormAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("6").get(formState))) continue;
                ccFormAddressMap.getJSONObject(formState).put("formAuth", (Object)this.tranToFormAuthJson(ccFormAddressMap.getJSONObject(formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("6").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(ccFormDetailAddressMap = flowObject.getJSONObject("props").getJSONObject("ccFormDetailAddress")))) {
            for (String formState : ccFormDetailAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("7").get(formState))) continue;
                ccFormDetailAddressMap.getJSONObject(formState).put("formAuth", (Object)this.tranToFormAuthJson(ccFormDetailAddressMap.getJSONObject(formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("7").get(formState).get(0)));
            }
        }
        return flowObject;
    }

    private JSONObject tranToFormAuthJson(JSONObject jsonObject, SysActFormAuth sysActFormAuth) {
        if (HussarUtils.isEmpty((Object)jsonObject)) {
            jsonObject = new JSONObject();
        }
        JSONArray jsonArray1 = JSONArray.parseArray((String)sysActFormAuth.getInsDisabled());
        JSONArray jsonArray2 = JSONArray.parseArray((String)sysActFormAuth.getInsHidden());
        JSONArray jsonArray3 = JSONArray.parseArray((String)sysActFormAuth.getInsNotCheck());
        jsonObject.put("insDisabled", (Object)jsonArray1);
        jsonObject.put("insHidden", (Object)jsonArray2);
        jsonObject.put("insNotCheck", (Object)jsonArray3);
        return jsonObject;
    }

    public ApiResponse<?> publishWorkflow(WorkFlow workFlow) {
        WorkFlow workFlowOnOrgan;
        if (!DefinitionEngineService.queryIsPublish((String)workFlow.getIdentity())) {
            if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
                return ApiResponse.fail((String)BpmExceptionCodeEnum.ERROR_PUBLISH_PROCESS_ON_ORGAN.getMessage());
            }
            return this.publishNewVersion(workFlow);
        }
        ApiResponse response = null;
        if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag()) && (workFlowOnOrgan = this.godAxeModelService.getFileByProcessKeyAndProcessIdAndOrganId(workFlow.getIdentity(), workFlow.getProcessTag())) == null) {
            response = this.godAxeModelService.saveWorkflowAboutOrgan(workFlow, null, null, null, null, true, true);
        }
        if (response == null) {
            response = this.godAxeModelService.updateProcess(workFlow, null, false);
        }
        workFlow.setData(null);
        if (response.isSuccess()) {
            return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return response;
    }

    public ApiResponse<?> forcePublishWorkflow(WorkFlow workFlow) {
        ApiResponse response = this.godAxeModelService.forcePublishProcess(workFlow);
        workFlow.setData(null);
        if (response.isSuccess()) {
            return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return response;
    }

    public ApiResponse<?> compatiblePublishWorkflow(WorkFlow workFlow) {
        ApiResponse response = this.godAxeModelService.compatiblePublishProcess(workFlow);
        workFlow.setData(null);
        if (response.isSuccess()) {
            return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return response;
    }

    public ApiResponse<?> updateProcessKey(String oldProcessKey, String processKey) {
        this.godAxeModelService.updateWorkflowProcessKey(processKey, oldProcessKey);
        return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
    }
}

