/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.exception;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=4)
public class BpmGlobalExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(BpmGlobalExceptionHandler.class);

    @ExceptionHandler(value={PropertyNotFoundException.class})
    public ApiResponse<Object> credentials(PropertyNotFoundException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error("activiti\u5185\u90e8\u5f02\u5e38\uff1a", (Throwable)e);
        BpmException bpmException = new BpmException(BpmExceptionCodeEnum.PROPERTY_NOT_FOUND);
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    public ApiResponse<Object> credentials(ActivitiIllegalArgumentException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error("activiti\u5185\u90e8\u5f02\u5e38\uff1a", (Throwable)e);
        BpmException bpmException = e.getMessage().contains(" null") ? new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL) : new BpmException(e.getMessage());
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    public ApiResponse<Object> credentials(ActivitiTaskAlreadyClaimedException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error("activiti\u5185\u90e8\u5f02\u5e38\uff1a", (Throwable)e);
        BpmException bpmException = new BpmException(BpmExceptionCodeEnum.TASK_ALREADY_CLAIMED);
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={ActivitiException.class})
    public ApiResponse<Object> credentials(ActivitiException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        BpmException bpmException = e.getMessage().startsWith("Cannot set suspension state 'suspended' for ProcessDefinitionEntity") ? new BpmException(BpmExceptionCodeEnum.MODEL_IS_SUSPENDED) : (e.getMessage().startsWith("Cannot set suspension state 'active' for ProcessDefinitionEntity") ? new BpmException(BpmExceptionCodeEnum.MODEL_IS_ACTIVATED) : (e.getMessage().startsWith("Cannot set suspension state 'suspended' for ProcessInstance") ? new BpmException(BpmExceptionCodeEnum.PROCESS_INS_IS_SUSPENDED) : (e.getMessage().startsWith("Cannot set suspension state 'active' for ProcessInstance") ? new BpmException(BpmExceptionCodeEnum.PROCESS_INSTANCE_IS_ACTIVE) : (e.getMessage().startsWith("Process instance is still running, cannot delete historic process instance") ? new BpmException(BpmExceptionCodeEnum.PROCESS_INSTANCE_IS_NOT_END) : ("Cannot claim a suspended task".equals(e.getMessage()) || "\u4efb\u52a1\u5df2\u6302\u8d77".equals(e.getMessage()) ? new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED, e) : (e.getMessage().startsWith("No outgoing sequence flow of") ? new BpmException(BpmExceptionCodeEnum.NO_OUT_GOING_SEQUENCE, e) : (e.getMessage().startsWith("Exception while invoking TaskListener:") ? new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_TASK_LISTENER, e) : new BpmException(e.getMessage()))))))));
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    public ApiResponse<Object> credentials(ActivitiObjectNotFoundException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        BpmException bpmException = e.getMessage().startsWith("Cannot find task with id ") ? new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND) : (e.getMessage().startsWith("Cannot find process definition for id ") || e.getMessage().startsWith("no deployed process definition found with id") ? new BpmException(BpmExceptionCodeEnum.MODEL_NOT_FOUND) : (e.getMessage().startsWith("Cannot find processInstance for id") || e.getMessage().startsWith("No process instance found for id") || e.getMessage().startsWith("No historic process instance found with id") ? new BpmException(BpmExceptionCodeEnum.PROCESS_NOT_FOUND) : new BpmException(e.getMessage())));
        return this.fail(bpmException);
    }

    @ExceptionHandler(value={BpmException.class})
    public ApiResponse<Object> credentials(BpmException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error("BpmException\uff1a", (Throwable)e);
        return this.fail(e);
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> credentials(PublicClientException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        BpmException bpmException = new BpmException(e.getReason());
        return this.fail(bpmException);
    }

    private void doResponse(HttpServletResponse response) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)response.getContentType(), (CharSequence)"application/json")) {
            response.setContentType("application/json");
        }
    }

    ApiResponse<Object> fail(BpmException e) {
        return ApiResponse.fail((int)e.getExceptionCode(), (String)e.getMessage());
    }
}

