/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.platform.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CharsetUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ResourceUtil;
import com.jxdinfo.hussar.platform.core.utils.id.UUID;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.form.WorkflowAuthConfigQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.dto.AddWorkflowDto;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.service.IBpmDesignerService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.translate.util.BpmTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class BpmDesignerServiceImpl
implements IBpmDesignerService {
    private final GodAxeModelService godAxeModelService;
    private final SysActProcessFileService sysActProcessFileService;
    private final SysActFormAuthService sysActFormAuthService;
    private final SysActAssigneeService sysActAssigneeService;
    private final ProcessDefinitionsService processDefinitionsService;
    private static final String BPM_TEMPLATE_RESOURCE = "bpm/template/bpm_template.json";

    public BpmDesignerServiceImpl(GodAxeModelService godAxeModelService, SysActProcessFileService sysActProcessFileService, SysActFormAuthService sysActFormAuthService, SysActAssigneeService sysActAssigneeService, ProcessDefinitionsService processDefinitionsService) {
        this.godAxeModelService = godAxeModelService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.sysActFormAuthService = sysActFormAuthService;
        this.sysActAssigneeService = sysActAssigneeService;
        this.processDefinitionsService = processDefinitionsService;
    }

    public ApiResponse<?> saveWorkflow(WorkFlow workFlow) {
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> addWorkflow(WorkFlow workFlow) {
        List list = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)workFlow.getIdentity()));
        if (HussarUtils.isNotEmpty((Object)list)) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.SAME_IDENTITY.getMessage());
        }
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> addWorkflow(AddWorkflowDto addWorkflowDto) {
        if (HussarUtils.isEmpty((Object)addWorkflowDto.getProcessKey()) || HussarUtils.isEmpty((Object)addWorkflowDto.getProcessName())) {
            throw new BpmException(BpmExceptionCodeEnum.NULL_IDENTITY_OR_NAME);
        }
        List list = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)addWorkflowDto.getProcessKey()));
        if (HussarUtils.isNotEmpty((Object)list)) {
            throw new BpmException(BpmExceptionCodeEnum.SAME_IDENTITY);
        }
        String bpmTemplate = ResourceUtil.readStr((String)BPM_TEMPLATE_RESOURCE, (Charset)CharsetUtil.CHARSET_UTF_8);
        WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)bpmTemplate, WorkFlow.class);
        workFlow.setId(UUID.randomUUID().toString());
        workFlow.setName(addWorkflowDto.getProcessName());
        workFlow.setIdentity(addWorkflowDto.getProcessKey());
        this.godAxeModelService.saveByBpmDesigner(workFlow);
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
    }

    public ApiResponse<?> publishNewVersion(WorkFlow workFlow) {
        boolean flag = DefinitionEngineService.queryIsPublish((String)workFlow.getIdentity());
        if (!flag && HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
            return ApiResponse.fail((String)BpmExceptionCodeEnum.ERROR_PUBLISH_PROCESS_ON_ORGAN.getMessage());
        }
        if (workFlow.isPublishBackTemplate()) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(workFlow.getIdentity(), workFlow.getProcessTag());
            int version = Integer.parseInt(definitionModel.getVersion());
            JSONObject flowModel = (JSONObject)JSON.parseObject((String)workFlow.getData(), JSONObject.class);
            JSONArray element = JSON.parseArray((String)flowModel.getJSONObject("slots").getJSONArray("default").toJSONString());
            JSONArray assigneeModelArray = this.sysActAssigneeService.getAssigneeModel(workFlow.getIdentity(), null, definitionModel.getVersion()).getResult();
            ArrayList<JSONObject> assigneeModelList = new ArrayList<JSONObject>();
            for (int i = 0; i < assigneeModelArray.size(); ++i) {
                assigneeModelList.add(assigneeModelArray.getJSONObject(i));
            }
            Map<String, Map<String, List<JSONObject>>> assigneeModelMap = assigneeModelList.stream().collect(Collectors.groupingBy(o -> o.getString("type"), Collectors.groupingBy(e -> e.getString("taskDefKey"))));
            for (int i = 0; i < element.size(); ++i) {
                JSONArray subProcessNodes;
                JSONObject jsonObject;
                JSONObject node = element.getJSONObject(i);
                JSONObject props = node.getJSONObject("props");
                String taskDefinitionKey = node.getString("instanceKey");
                if (BpmNodeTypeUtil.isUserTask((String)node.getString("name"))) {
                    if (HussarUtils.isNotEmpty(assigneeModelMap.get("assign_model"))) {
                        jsonObject = JSON.parseObject((String)String.valueOf(assigneeModelMap.get("assign_model").get(taskDefinitionKey).get(0).get((Object)"model")));
                        props.put("flowAssignment", (Object)(jsonObject == null ? new JSONObject() : jsonObject));
                    } else {
                        props.put("flowAssignment", (Object)new JSONObject());
                    }
                    if (HussarUtils.isNotEmpty(assigneeModelMap.get("cc_end_assign_model"))) {
                        jsonObject = JSON.parseObject((String)String.valueOf(assigneeModelMap.get("cc_end_assign_model").get(taskDefinitionKey).get(0).get((Object)"model")));
                        props.put("flowEndRecipients", (Object)(jsonObject == null ? new JSONObject() : jsonObject));
                    } else {
                        props.put("flowEndRecipients", (Object)new JSONObject());
                    }
                    if (HussarUtils.isNotEmpty(assigneeModelMap.get("cc_assign_model"))) {
                        jsonObject = JSON.parseObject((String)String.valueOf(assigneeModelMap.get("cc_assign_model").get(taskDefinitionKey).get(0).get((Object)"model")));
                        props.put("flowRecipients", (Object)(jsonObject == null ? new JSONObject() : jsonObject));
                        continue;
                    }
                    props.put("flowRecipients", (Object)new JSONObject());
                    continue;
                }
                if (BpmNodeTypeUtil.isCallActivity((String)node.getString("name"))) {
                    if (HussarUtils.isNotEmpty(assigneeModelMap.get("assign_model"))) {
                        jsonObject = JSON.parseObject((String)String.valueOf(assigneeModelMap.get("assign_model").get(taskDefinitionKey).get(0).get((Object)"model")));
                        props.put("flowSelector", (Object)(jsonObject == null ? new JSONObject() : jsonObject));
                        continue;
                    }
                    props.put("flowSelector", (Object)new JSONObject());
                    continue;
                }
                if (!BpmNodeTypeUtil.isSubProcess((String)node.getString("name"))) continue;
                if (HussarUtils.isNotEmpty(assigneeModelMap.get("assign_model"))) {
                    jsonObject = JSON.parseObject((String)String.valueOf(assigneeModelMap.get("assign_model").get(taskDefinitionKey).get(0).get((Object)"model")));
                    props.put("flowAssignment", (Object)(jsonObject == null ? new JSONObject() : jsonObject));
                } else {
                    props.put("flowAssignment", (Object)new JSONObject());
                }
                if (node.getJSONObject("slots") == null || (subProcessNodes = node.getJSONObject("slots").getJSONArray("default")) == null) continue;
                for (int j = 0; j < subProcessNodes.size(); ++j) {
                    JSONObject jsonObject2;
                    JSONObject subProcessNode = subProcessNodes.getJSONObject(j);
                    if (!BpmNodeTypeUtil.isUserTask((String)subProcessNode.getString("name"))) continue;
                    JSONObject subProcessProps = node.getJSONObject("props");
                    if (HussarUtils.isNotEmpty(assigneeModelMap.get("assign_model"))) {
                        jsonObject2 = JSON.parseObject((String)String.valueOf(assigneeModelMap.get("assign_model").get(taskDefinitionKey).get(0).get((Object)"model")));
                        subProcessProps.put("flowAssignment", (Object)(jsonObject2 == null ? new JSONObject() : jsonObject2));
                    } else {
                        subProcessProps.put("flowAssignment", (Object)new JSONObject());
                    }
                    if (HussarUtils.isNotEmpty(assigneeModelMap.get("cc_end_assign_model"))) {
                        jsonObject2 = JSON.parseObject((String)String.valueOf(assigneeModelMap.get("cc_end_assign_model").get(taskDefinitionKey).get(0).get((Object)"model")));
                        subProcessProps.put("flowEndRecipients", (Object)(jsonObject2 == null ? new JSONObject() : jsonObject2));
                    } else {
                        subProcessProps.put("flowEndRecipients", (Object)new JSONObject());
                    }
                    if (HussarUtils.isNotEmpty(assigneeModelMap.get("cc_assign_model"))) {
                        jsonObject2 = JSON.parseObject((String)String.valueOf(assigneeModelMap.get("cc_assign_model").get(taskDefinitionKey).get(0).get((Object)"model")));
                        subProcessProps.put("flowRecipients", (Object)(jsonObject2 == null ? new JSONObject() : jsonObject2));
                        continue;
                    }
                    subProcessProps.put("flowRecipients", (Object)new JSONObject());
                }
            }
            WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto = new WorkflowAuthConfigQueryDto();
            workflowAuthConfigQueryDto.setProcessKey(workFlow.getIdentity());
            workflowAuthConfigQueryDto.setTaskDefinitionKey("all_task_def_key");
            workflowAuthConfigQueryDto.setVersion(Integer.valueOf(version));
            workflowAuthConfigQueryDto.setOnlyExt(true);
            JSONArray formAuthArray = this.sysActFormAuthService.queryFormAuthConfig(workflowAuthConfigQueryDto);
            ArrayList<JSONObject> newElement = new ArrayList<JSONObject>();
            if (HussarUtils.isNotEmpty((Object)formAuthArray)) {
                List formAuthList = JSON.parseArray((String)formAuthArray.toJSONString(), SysActFormAuth.class);
                List unStartFormAuthList = formAuthList.stream().filter(sysActFormAuth -> HussarUtils.isEmpty((Object)sysActFormAuth.getTaskDefinitionKey())).collect(Collectors.toList());
                formAuthList.removeAll(unStartFormAuthList);
                for (int i = 0; i < element.size(); ++i) {
                    JSONObject flowObject = element.getJSONObject(i);
                    if (BpmNodeTypeUtil.isUserTask((String)flowObject.getString("name"))) {
                        JSONObject newFlowObject = this.changeFormAuth(flowObject, formAuthList);
                        if (HussarUtils.isNotEmpty((Object)newFlowObject)) {
                            newElement.add(newFlowObject);
                            continue;
                        }
                        newElement.add(flowObject);
                        continue;
                    }
                    if (BpmNodeTypeUtil.isSubProcess((String)flowObject.getString("name"))) {
                        List subFlowObjectList = JSON.parseArray((String)flowObject.getJSONObject("slots").getJSONArray("default").toJSONString(), JSONObject.class);
                        ArrayList<JSONObject> newSubFlowObjectList = new ArrayList<JSONObject>();
                        for (JSONObject subFlowObject : subFlowObjectList) {
                            JSONObject newSubFlowObject = this.changeFormAuth(subFlowObject, formAuthList);
                            if (HussarUtils.isNotEmpty((Object)newSubFlowObject)) {
                                newSubFlowObjectList.add(newSubFlowObject);
                                continue;
                            }
                            newSubFlowObjectList.add(subFlowObject);
                        }
                        JSONObject newFlowObject = new JSONObject();
                        newFlowObject = flowObject;
                        newFlowObject.getJSONObject("slots").put("default", newSubFlowObjectList);
                        newElement.add(newFlowObject);
                        continue;
                    }
                    newElement.add(flowObject);
                }
            }
            if (HussarUtils.isNotEmpty(newElement)) {
                flowModel.getJSONObject("slots").put("default", newElement);
            }
            workFlow.setData(JSON.toJSONString((Object)flowModel, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (HussarUtils.isEmpty((Object)workFlow.getProcessTag())) {
            this.godAxeModelService.saveAndPublishWorkflow(workFlow, null, true);
        } else {
            this.godAxeModelService.saveWorkflowAboutOrgan(workFlow, null, null, null, null, true, true);
        }
        workFlow.setData(null);
        return ApiResponse.success((Object)workFlow);
    }

    private JSONObject changeFormAuth(JSONObject flowObject, List<SysActFormAuth> formAuthList) {
        JSONObject ccFormDetailAddressMap;
        JSONObject ccFormAddressMap;
        JSONObject assistFormDetailAddressMap;
        JSONObject assistFormAddressMap;
        JSONObject formDetailAddressMap;
        String taskDefinitionKey;
        Map<String, Map<String, Map<String, List<SysActFormAuth>>>> formAuthMap = formAuthList.stream().collect(Collectors.groupingBy(SysActFormAuth::getTaskDefinitionKey, Collectors.groupingBy(SysActFormAuth::getFormType, Collectors.groupingBy(SysActFormAuth::getFormState))));
        if (HussarUtils.isEmpty(formAuthMap.get(taskDefinitionKey = flowObject.getString("instanceKey")))) {
            return null;
        }
        JSONObject formAddressMap = flowObject.getJSONObject("props").getJSONObject("formAddress");
        if (HussarUtils.isNotEmpty((Object)formAddressMap)) {
            for (Object formState : formAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("2").get(formState))) continue;
                formAddressMap.getJSONObject((String)formState).put("formAuth", (Object)this.tranToFormAuthJson(formAddressMap.getJSONObject((String)formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("2").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(formDetailAddressMap = flowObject.getJSONObject("props").getJSONObject("formDetailAddress")))) {
            for (Object formState : formDetailAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("1").get(formState))) continue;
                formDetailAddressMap.getJSONObject((String)formState).put("formAuth", (Object)this.tranToFormAuthJson(formDetailAddressMap.getJSONObject((String)formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("1").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(assistFormAddressMap = flowObject.getJSONObject("props").getJSONObject("assistFormAddress")))) {
            for (Object formState : assistFormAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("4").get(formState))) continue;
                assistFormAddressMap.getJSONObject((String)formState).put("formAuth", (Object)this.tranToFormAuthJson(assistFormAddressMap.getJSONObject((String)formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("4").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(assistFormDetailAddressMap = flowObject.getJSONObject("props").getJSONObject("assistFormDetailAddress")))) {
            for (Object formState : assistFormDetailAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("5").get(formState))) continue;
                assistFormDetailAddressMap.getJSONObject((String)formState).put("formAuth", (Object)this.tranToFormAuthJson(assistFormDetailAddressMap.getJSONObject((String)formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("5").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(ccFormAddressMap = flowObject.getJSONObject("props").getJSONObject("ccFormAddress")))) {
            for (String formState : ccFormAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("6").get(formState))) continue;
                ccFormAddressMap.getJSONObject(formState).put("formAuth", (Object)this.tranToFormAuthJson(ccFormAddressMap.getJSONObject(formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("6").get(formState).get(0)));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(ccFormDetailAddressMap = flowObject.getJSONObject("props").getJSONObject("ccFormDetailAddress")))) {
            for (String formState : ccFormDetailAddressMap.keySet()) {
                if (!HussarUtils.isNotEmpty(formAuthMap.get(taskDefinitionKey).get("7").get(formState))) continue;
                ccFormDetailAddressMap.getJSONObject(formState).put("formAuth", (Object)this.tranToFormAuthJson(ccFormDetailAddressMap.getJSONObject(formState).getJSONObject("formAuth"), formAuthMap.get(taskDefinitionKey).get("7").get(formState).get(0)));
            }
        }
        return flowObject;
    }

    private JSONObject tranToFormAuthJson(JSONObject jsonObject, SysActFormAuth sysActFormAuth) {
        if (HussarUtils.isEmpty((Object)jsonObject)) {
            jsonObject = new JSONObject();
        }
        JSONArray jsonArray1 = JSONArray.parseArray((String)sysActFormAuth.getInsDisabled());
        JSONArray jsonArray2 = JSONArray.parseArray((String)sysActFormAuth.getInsHidden());
        JSONArray jsonArray3 = JSONArray.parseArray((String)sysActFormAuth.getInsNotCheck());
        jsonObject.put("insDisabled", (Object)jsonArray1);
        jsonObject.put("insHidden", (Object)jsonArray2);
        jsonObject.put("insNotCheck", (Object)jsonArray3);
        return jsonObject;
    }

    public ApiResponse<?> publishWorkflow(WorkFlow workFlow) {
        WorkFlow workFlowOnOrgan;
        if (!DefinitionEngineService.queryIsPublish((String)workFlow.getIdentity())) {
            if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag())) {
                return ApiResponse.fail((String)BpmExceptionCodeEnum.ERROR_PUBLISH_PROCESS_ON_ORGAN.getMessage());
            }
            return this.publishNewVersion(workFlow);
        }
        ApiResponse response = null;
        if (HussarUtils.isNotEmpty((Object)workFlow.getProcessTag()) && (workFlowOnOrgan = this.godAxeModelService.getFileByProcessKeyAndProcessIdAndOrganId(workFlow.getIdentity(), workFlow.getProcessTag())) == null) {
            response = this.godAxeModelService.saveWorkflowAboutOrgan(workFlow, null, null, null, null, true, true);
        }
        if (response == null) {
            response = this.godAxeModelService.updateProcess(workFlow, null, false);
        }
        workFlow.setData(null);
        if (response.isSuccess()) {
            return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return response;
    }

    public ApiResponse<?> forcePublishWorkflow(WorkFlow workFlow) {
        ApiResponse response = this.godAxeModelService.forcePublishProcess(workFlow);
        workFlow.setData(null);
        if (response.isSuccess()) {
            return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return response;
    }

    public ApiResponse<?> compatiblePublishWorkflow(WorkFlow workFlow) {
        ApiResponse response = this.godAxeModelService.compatiblePublishProcess(workFlow);
        workFlow.setData(null);
        if (response.isSuccess()) {
            return ApiResponse.success((Object)workFlow, (String)BpmExceptionCodeEnum.SUCCESS_SAVE.getMessage());
        }
        return response;
    }

    public ApiResponse<?> updateProcessKey(String oldProcessKey, String processKey) {
        this.godAxeModelService.updateWorkflowProcessKey(processKey, oldProcessKey);
        return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
    }
}

