/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SysActProcessFileServiceImpl
extends HussarBaseServiceImpl<SysActProcessFileMapper, SysActProcessFile>
implements SysActProcessFileService {
    @Resource
    SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ModelService modelService;
    @Resource
    @Lazy
    private ProcessDefinitionsService processDefinitionsService;

    public void updateTempWorkflowFile(WorkFlow workFlow, Integer version) {
        if (HussarUtils.isEmpty((Object)version)) {
            version = 0;
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)workFlow.getIdentity());
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)version);
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile bpmWfdFile = null;
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (HussarUtils.equals((Object)"temp-wfd", (Object)sysActProcessFile.getType())) {
                bpmWfdFile = sysActProcessFile;
            }
            if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            if (!HussarUtils.equals((Object)"meta", (Object)sysActProcessFile.getType())) continue;
            metaFile = sysActProcessFile;
        }
        workFlow.setModelId(metaFile.getModelId());
        workFlow.setProcDefId(metaFile.getProcessId());
        if (bpmWfdFile == null) {
            bpmWfdFile = wfdFile;
            bpmWfdFile.setId(null);
            bpmWfdFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
            bpmWfdFile.setProcessName(workFlow.getName());
            bpmWfdFile.setLastTime(ts);
            bpmWfdFile.setType("temp-wfd");
            if (bpmWfdFile.getProcessKey() == null) {
                bpmWfdFile.setProcessKey(workFlow.getIdentity());
            }
            bpmWfdFile.setWorkflowStyle(workFlow.getWorkflowStyle());
            this.sysActProcessFileMapper.insert(bpmWfdFile);
        } else {
            bpmWfdFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
            bpmWfdFile.setProcessName(workFlow.getName());
            bpmWfdFile.setLastTime(ts);
            bpmWfdFile.setWorkflowStyle(workFlow.getWorkflowStyle());
            this.sysActProcessFileMapper.updateById(bpmWfdFile);
        }
        String data = workFlow.getData();
        workFlow.setData(null);
        metaFile.setContent(JSON.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
        metaFile.setProcessName(wfdFile.getProcessName());
        metaFile.setLastTime(ts);
        this.sysActProcessFileMapper.updateById(metaFile);
        workFlow.setData(data);
    }

    public void removeTempWorkflowFile(String processKey, Integer version) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)version);
        queryWrapper.eq(SysActProcessFile::getType, (Object)"temp-wfd");
        this.sysActProcessFileMapper.delete((Wrapper)queryWrapper);
    }

    public WorkFlow getTempFileByProcessKey(String processKey, Integer version) {
        Integer lastVersion = version;
        if (HussarUtils.isEmpty((Object)version)) {
            lastVersion = 0;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)lastVersion);
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile tempWfdFile = null;
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (HussarUtils.equals((Object)"temp-wfd", (Object)sysActProcessFile.getType())) {
                tempWfdFile = sysActProcessFile;
                continue;
            }
            if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            if (!HussarUtils.equals((Object)"meta", (Object)sysActProcessFile.getType())) continue;
            metaFile = sysActProcessFile;
        }
        boolean isTemp = false;
        if (tempWfdFile != null) {
            wfdFile = tempWfdFile;
            isTemp = true;
        }
        String wfdInfo = null;
        if (HussarUtils.isNotEmpty((Object)wfdFile)) {
            wfdInfo = wfdFile.getContent() == null ? null : new String(wfdFile.getContent(), StandardCharsets.UTF_8);
        }
        String metaInfo = null;
        if (HussarUtils.isNotEmpty((Object)metaFile)) {
            String string = metaInfo = metaFile.getContent() == null ? null : new String(metaFile.getContent(), StandardCharsets.UTF_8);
        }
        if (HussarUtils.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            if (metaFile.getProcessId() != null) {
                workFlow.setProcDefId(metaFile.getProcessId());
                workFlow.setModelId(metaFile.getModelId());
            }
            if (isTemp) {
                workFlow.setWorkflowStyle(wfdFile.getWorkflowStyle());
            }
            return workFlow;
        }
        return null;
    }

    public WorkFlow revertFile(String processKey, Integer version) {
        Integer lastVersion = version;
        if (HussarUtils.isEmpty((Object)version)) {
            lastVersion = 0;
        }
        Integer mainVersion = 0;
        List<DefinitionModel> mainProdef = this.processDefinitionsMapper.getMainProdef(processKey, null);
        if (HussarUtils.isEmpty(mainProdef)) {
            mainProdef = this.processDefinitionsMapper.getOtherProdef(processKey, null);
        }
        if (HussarUtils.isNotEmpty(mainProdef)) {
            mainVersion = Integer.valueOf(mainProdef.get(0).getVersion());
        }
        LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
        removeWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        if (lastVersion != 0 && lastVersion.equals(mainVersion)) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(lastVersion);
            list.add(0);
            removeWrapper.in(SysActProcessFile::getVersion, list);
        } else if (lastVersion == 0 && mainVersion > 0) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(mainVersion);
            list.add(0);
            removeWrapper.in(SysActProcessFile::getVersion, list);
        } else {
            removeWrapper.eq(SysActProcessFile::getVersion, (Object)lastVersion);
        }
        removeWrapper.eq(SysActProcessFile::getType, (Object)"temp-wfd");
        this.sysActProcessFileMapper.delete((Wrapper)removeWrapper);
        return this.getFileByProcessKeyAndProcessId(processKey, null, false, lastVersion, false);
    }

    public void updateFile(WorkFlow workFlow, Integer version) {
        HussarCacheUtil.evictKeysRightLike((String)"workflow_file", (String)("workflow_file:" + workFlow.getIdentity() + ":"));
        HussarCacheUtil.evictKeysRightLike((String)"workflow_assignee", (String)("workflow_assignee:" + workFlow.getIdentity() + ":"));
        HussarCacheUtil.evictKeysRightLike((String)"form_auth", (String)("form_auth" + workFlow.getIdentity() + ":"));
        if (HussarUtils.isEmpty((Object)version)) {
            version = 0;
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)workFlow.getIdentity());
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)version);
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            if (!HussarUtils.equals((Object)"meta", (Object)sysActProcessFile.getType())) continue;
            metaFile = sysActProcessFile;
        }
        wfdFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
        wfdFile.setModelId(workFlow.getModelId());
        wfdFile.setProcessName(workFlow.getName());
        wfdFile.setLastTime(ts);
        this.sysActProcessFileMapper.updateById(wfdFile);
        metaFile.setModelId(workFlow.getModelId());
        String data = workFlow.getData();
        workFlow.setData(null);
        metaFile.setContent(JSON.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
        metaFile.setProcessName(wfdFile.getProcessName());
        metaFile.setLastTime(ts);
        metaFile.setWorkflowStyle(workFlow.getWorkflowStyle());
        this.sysActProcessFileMapper.updateById(metaFile);
        workFlow.setData(data);
    }

    public void updateFileWithFiles(WorkFlow workFlow, List<SysActProcessFile> files) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : files) {
            if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            if (!HussarUtils.equals((Object)"meta", (Object)sysActProcessFile.getType())) continue;
            metaFile = sysActProcessFile;
        }
        wfdFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
        wfdFile.setModelId(workFlow.getModelId());
        wfdFile.setProcessName(workFlow.getName());
        wfdFile.setLastTime(ts);
        this.sysActProcessFileMapper.updateById(wfdFile);
        metaFile.setModelId(workFlow.getModelId());
        String data = workFlow.getData();
        workFlow.setData(null);
        metaFile.setContent(JSON.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
        metaFile.setProcessName(wfdFile.getProcessName());
        metaFile.setLastTime(ts);
        metaFile.setWorkflowStyle(workFlow.getWorkflowStyle());
        this.sysActProcessFileMapper.updateById(metaFile);
        workFlow.setData(data);
    }

    public void addFile(WorkFlow workFlow, Integer latestVersion) {
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        Integer realLatestVersion = latestVersion;
        if (HussarUtils.isEmpty((Object)latestVersion)) {
            realLatestVersion = this.sysActProcessFileMapper.selectLatestVersion(workFlow.getIdentity()) + 1;
        }
        SysActProcessFile file = new SysActProcessFile();
        file.setId(null);
        file.setCreateTime(ts);
        file.setLastTime(ts);
        file.setVersion(realLatestVersion);
        if (HussarUtils.isNotEmpty((Object)workFlow.getProcDefId()) && Integer.parseInt(workFlow.getProcDefId().split(":")[1]) < 1) {
            file.setVersion(Integer.valueOf(-1));
        } else if (HussarUtils.isNotEmpty((Object)workFlow.getVersion()) && Integer.parseInt(workFlow.getVersion()) > 0 && latestVersion == null) {
            file.setVersion(Integer.valueOf(Integer.parseInt(workFlow.getVersion())));
        }
        file.setProcessKey(workFlow.getIdentity());
        file.setModelId(workFlow.getModelId());
        file.setProcessId(workFlow.getProcDefId());
        file.setType("wfd");
        file.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
        file.setProcessName(workFlow.getName());
        this.sysActProcessFileMapper.insert(file);
        file.setId(null);
        file.setType("meta");
        String data = workFlow.getData();
        workFlow.setData(null);
        file.setContent(JSON.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
        file.setWorkflowStyle(workFlow.getWorkflowStyle());
        this.sysActProcessFileMapper.insert(file);
        workFlow.setData(data);
    }

    public void addFileBatch(List<WorkFlow> workFlowList) {
        ArrayList<SysActProcessFile> list = new ArrayList<SysActProcessFile>();
        for (WorkFlow workFlow : workFlowList) {
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            SysActProcessFile wfdFile = new SysActProcessFile();
            wfdFile.setId(null);
            wfdFile.setCreateTime(ts);
            wfdFile.setLastTime(ts);
            wfdFile.setVersion(Integer.valueOf(0));
            wfdFile.setProcessKey(workFlow.getIdentity());
            wfdFile.setModelId(workFlow.getModelId());
            wfdFile.setProcessId(workFlow.getProcDefId());
            wfdFile.setType("wfd");
            wfdFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
            wfdFile.setProcessName(workFlow.getName());
            wfdFile.setWorkflowStyle(workFlow.getWorkflowStyle());
            list.add(wfdFile);
            SysActProcessFile metaFile = new SysActProcessFile();
            BeanUtils.copyProperties((Object)wfdFile, (Object)metaFile);
            metaFile.setId(null);
            metaFile.setType("meta");
            String data = workFlow.getData();
            workFlow.setData(null);
            metaFile.setWorkflowStyle(workFlow.getWorkflowStyle());
            metaFile.setContent(JSON.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            list.add(metaFile);
            workFlow.setData(data);
        }
        this.saveBatch(list);
    }

    public WorkFlow getLastFileByProcessKey(String processKey) {
        int lastVersion = this.sysActProcessFileMapper.selectLatestVersion(processKey);
        return this.getFileByProcessKey(processKey, lastVersion);
    }

    @Cacheable(value={"workflow_file"}, key="'workflow_file:'+#processKey+':'+#version", unless="#result == null")
    public WorkFlow getFileByProcessKey(String processKey, Integer version) {
        Integer lastVersion = version;
        if (HussarUtils.isEmpty((Object)version)) {
            lastVersion = 0;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)lastVersion);
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        for (SysActProcessFile sysActProcessFile : list) {
            if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                wfdFile = sysActProcessFile;
                continue;
            }
            if (!HussarUtils.equals((Object)"meta", (Object)sysActProcessFile.getType())) continue;
            metaFile = sysActProcessFile;
        }
        String wfdInfo = null;
        if (HussarUtils.isNotEmpty((Object)wfdFile)) {
            wfdInfo = wfdFile.getContent() == null ? null : new String(wfdFile.getContent(), StandardCharsets.UTF_8);
        }
        String metaInfo = null;
        if (HussarUtils.isNotEmpty((Object)metaFile)) {
            String string = metaInfo = metaFile.getContent() == null ? null : new String(metaFile.getContent(), StandardCharsets.UTF_8);
        }
        if (HussarUtils.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            if (metaFile.getProcessId() != null) {
                workFlow.setProcDefId(metaFile.getProcessId());
                workFlow.setModelId(metaFile.getModelId());
            }
            return workFlow;
        }
        return null;
    }

    public List<WorkFlow> getFilesByProcessKeys(List<String> processKeys) {
        List<SysActProcessFile> list = this.sysActProcessFileMapper.getFilesByProcessKeys(processKeys);
        ArrayList<WorkFlow> workFlowList = new ArrayList<WorkFlow>();
        if (HussarUtils.isNotEmpty(list)) {
            for (SysActProcessFile sysActProcessfile : list) {
                WorkFlow workFlow = new WorkFlow();
                workFlow = (WorkFlow)JSON.parseObject((byte[])sysActProcessfile.getContent(), WorkFlow.class, (Feature[])new Feature[0]);
                workFlowList.add(workFlow);
            }
        }
        return workFlowList;
    }

    @Cacheable(value={"workflow_file"}, key="'workflow_file:'+#processDefId", unless="#result == null")
    public WorkFlow getFileByProcessDefId(String processDefId) {
        return this.getFileByProcessKeyAndProcessId(null, processDefId, false, null, false);
    }

    public WorkFlow getFileByProcessKeyAndProcessId(String processKey, String processId, boolean needGetTempFile, Integer version, boolean getLastFile) {
        LambdaQueryWrapper queryWrapper;
        if (getLastFile && HussarUtils.isNotEmpty((Object)processKey)) {
            version = this.sysActProcessFileMapper.selectLatestVersion(processKey);
        }
        String wfdInfo = null;
        String metaInfo = null;
        String tempWfdInfo = null;
        String processDefId = null;
        Long modelId = null;
        SysActProcessFile tempFile = null;
        SysActProcessFile metaFile = null;
        if (HussarUtils.equals((Object)processId, (Object)processKey)) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
            if (HussarUtils.isNotEmpty((Object)version)) {
                queryWrapper.eq(SysActProcessFile::getVersion, (Object)version);
            } else {
                queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
            }
            List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
            for (SysActProcessFile sysActProcessFile : list) {
                if (HussarUtils.equals((Object)"temp-wfd", (Object)sysActProcessFile.getType())) {
                    tempFile = sysActProcessFile;
                    tempWfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                    continue;
                }
                if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    wfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                    continue;
                }
                if (!HussarUtils.equals((Object)"meta", (Object)sysActProcessFile.getType())) continue;
                metaFile = sysActProcessFile;
                metaInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                processDefId = sysActProcessFile.getProcessId();
                modelId = sysActProcessFile.getModelId();
            }
        } else {
            queryWrapper = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)processId)) {
                queryWrapper.eq(SysActProcessFile::getProcessId, (Object)processId);
                if (HussarUtils.isNotEmpty((Object)processKey)) {
                    queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
                }
            } else if (HussarUtils.isNotEmpty((Object)processKey)) {
                queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
                if (HussarUtils.isNotEmpty((Object)version)) {
                    queryWrapper.eq(SysActProcessFile::getVersion, (Object)version);
                } else if (HussarUtils.isEmpty((Object)processId)) {
                    queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
                }
            }
            List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
            for (SysActProcessFile sysActProcessFile : list) {
                if (HussarUtils.equals((Object)"temp-wfd", (Object)sysActProcessFile.getType())) {
                    if (0 == sysActProcessFile.getVersion() && HussarUtils.isNotEmpty(tempFile)) continue;
                    tempFile = sysActProcessFile;
                    tempWfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                    continue;
                }
                if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFile.getType())) {
                    if (0 == sysActProcessFile.getVersion() && HussarUtils.isNotEmpty(wfdInfo)) continue;
                    wfdInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                    continue;
                }
                if (!HussarUtils.equals((Object)"meta", (Object)sysActProcessFile.getType()) || 0 == sysActProcessFile.getVersion() && HussarUtils.isNotEmpty(metaFile)) continue;
                metaFile = sysActProcessFile;
                metaInfo = sysActProcessFile.getContent() == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
                processDefId = sysActProcessFile.getProcessId();
                modelId = sysActProcessFile.getModelId();
            }
        }
        if (HussarUtils.isNotEmpty(metaInfo) && HussarUtils.isNotEmpty(metaFile)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject(metaInfo, WorkFlow.class);
            if (HussarUtils.isNotEmpty(processDefId)) {
                workFlow.setProcDefId(processDefId);
            }
            workFlow.setModelId(modelId);
            if (needGetTempFile && tempWfdInfo != null) {
                workFlow.setData(tempWfdInfo);
                workFlow.setTempWorkflow(true);
                workFlow.setWorkflowStyle(tempFile.getWorkflowStyle());
            } else {
                workFlow.setTempWorkflow(true);
                workFlow.setWorkflowStyle(metaFile.getWorkflowStyle());
                workFlow.setData(wfdInfo);
            }
            return workFlow;
        }
        return null;
    }

    public WorkFlow getFileByProcessKeyAndProcessIdAndOrganId(String processKey, String processId, boolean needGetTempFile, Integer version, boolean getLastFile, String organId) {
        WorkFlow workFlow;
        if (getLastFile && HussarUtils.isNotEmpty((Object)processKey)) {
            version = this.sysActProcessFileMapper.selectLatestVersionByProcessKey(processKey);
        }
        if (HussarUtils.isEmpty((Object)organId)) {
            workFlow = this.getFileByProcessKeyAndProcessId(processKey, processId, needGetTempFile, version, false);
        } else {
            if (HussarUtils.isEmpty((Object)version)) {
                version = this.processDefinitionsMapper.getMainVersionByOrganId(processKey, organId);
                Integer n = version = HussarUtils.isEmpty((Object)version) ? this.processDefinitionsMapper.getMaxVersionByOrganId(processKey, organId) : version;
            }
            if (HussarUtils.isEmpty((Object)version)) {
                return null;
            }
            workFlow = this.getFileByProcessKeyAndProcessId(processKey, processId, needGetTempFile, version, false);
            workFlow.setProcessTag(organId);
        }
        if (HussarUtils.isEmpty((Object)workFlow)) {
            return workFlow;
        }
        if (this.processDefinitionsService.isTemplateProcessById(workFlow.getProcDefId()) || this.processDefinitionsService.isTemplateProcessByProcessKeyAndVersion(workFlow.getIdentity(), HussarUtils.isNotEmpty((Object)workFlow.getVersion()) ? Integer.valueOf(workFlow.getVersion()) : null)) {
            workFlow.setModelTemplate(true);
        }
        workFlow.setModelResource(this.modelService.isModelResource(processKey).booleanValue());
        return workFlow;
    }

    public WorkFlow getLastFileByProcessKeyAndProcessIdAndOrganId(String processKey, String processId, boolean needGetTempFile, Integer version, boolean getLastFile, String organId) {
        WorkFlow workFlow;
        if (getLastFile && HussarUtils.isNotEmpty((Object)processKey)) {
            version = this.sysActProcessFileMapper.selectLatestVersionByKeyAndOrganId(processKey, organId);
        }
        if (HussarUtils.isEmpty((Object)organId)) {
            workFlow = this.getFileByProcessKeyAndProcessId(processKey, processId, needGetTempFile, version, false);
        } else {
            if (HussarUtils.isEmpty((Object)version)) {
                version = this.processDefinitionsMapper.getMainVersionByOrganId(processKey, organId);
                Integer n = version = HussarUtils.isEmpty((Object)version) ? this.processDefinitionsMapper.getMaxVersionByOrganId(processKey, organId) : version;
            }
            if (HussarUtils.isEmpty((Object)version)) {
                return null;
            }
            workFlow = this.getFileByProcessKeyAndProcessId(processKey, processId, needGetTempFile, version, false);
            workFlow.setProcessTag(organId);
        }
        if (HussarUtils.isEmpty((Object)workFlow)) {
            return new WorkFlow();
        }
        if (this.processDefinitionsService.isTemplateProcessById(workFlow.getProcDefId()) || this.processDefinitionsService.isTemplateProcessByProcessKeyAndVersion(workFlow.getIdentity(), HussarUtils.isNotEmpty((Object)workFlow.getVersion()) ? Integer.valueOf(workFlow.getVersion()) : null)) {
            workFlow.setModelTemplate(true);
        }
        workFlow.setModelResource(this.modelService.isModelResource(processKey).booleanValue());
        return workFlow;
    }

    public WorkFlow getTemplateFileByProcessKey(String processKey) {
        WorkFlow workFlow = this.modelService.getStandardWorkflowByKey(processKey, null);
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            return workFlow;
        }
        return new WorkFlow();
    }

    public List<SysActProcessFile> getBaseFileList(String processKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public boolean copyFiles(String processKey, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
        queryWrapper.and(wrapper -> {
            ((LambdaQueryWrapper)wrapper.eq(SysActProcessFile::getVersion, (Object)0)).or();
            if (HussarUtils.isNotEmpty((Object)id)) {
                wrapper.eq(SysActProcessFile::getProcessId, (Object)id);
            } else {
                int lastVersion = this.sysActProcessFileMapper.selectLatestVersionByKeyAndOrganId(processKey, null);
                wrapper.eq(SysActProcessFile::getVersion, (Object)lastVersion);
            }
        });
        List list = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFile zeroTempWfd = null;
        SysActProcessFile zeroWfd = new SysActProcessFile();
        SysActProcessFile zeroMeta = new SysActProcessFile();
        SysActProcessFile tempWfd = null;
        SysActProcessFile wfd = null;
        SysActProcessFile meta = null;
        for (SysActProcessFile sysActProcessFile : list) {
            if (0 == sysActProcessFile.getVersion()) {
                if ("temp-wfd".equals(sysActProcessFile.getType())) {
                    zeroTempWfd = sysActProcessFile;
                    continue;
                }
                if ("wfd".equals(sysActProcessFile.getType())) {
                    zeroWfd = sysActProcessFile;
                    continue;
                }
                if (!"meta".equals(sysActProcessFile.getType())) continue;
                zeroMeta = sysActProcessFile;
                continue;
            }
            if ("temp-wfd".equals(sysActProcessFile.getType())) {
                tempWfd = sysActProcessFile;
                continue;
            }
            if ("wfd".equals(sysActProcessFile.getType())) {
                wfd = sysActProcessFile;
                continue;
            }
            if (!"meta".equals(sysActProcessFile.getType())) continue;
            meta = sysActProcessFile;
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        zeroWfd.setProcessName(wfd.getProcessName());
        zeroWfd.setContent(wfd.getContent());
        zeroWfd.setLastTime(ts);
        zeroWfd.setModelId(wfd.getModelId());
        this.sysActProcessFileMapper.updateById(zeroWfd);
        zeroMeta.setProcessName(meta.getProcessName());
        zeroMeta.setContent(meta.getContent());
        zeroMeta.setLastTime(ts);
        zeroMeta.setModelId(meta.getModelId());
        zeroMeta.setWorkflowStyle(meta.getWorkflowStyle());
        this.sysActProcessFileMapper.updateById(zeroMeta);
        if (zeroTempWfd != null) {
            if (tempWfd != null) {
                zeroTempWfd.setProcessName(tempWfd.getProcessName());
                zeroTempWfd.setContent(tempWfd.getContent());
                zeroTempWfd.setLastTime(ts);
                this.sysActProcessFileMapper.updateById(zeroTempWfd);
            } else {
                this.sysActProcessFileMapper.deleteById(zeroTempWfd.getId());
            }
        } else if (tempWfd != null) {
            zeroTempWfd = zeroWfd;
            zeroTempWfd.setId(null);
            zeroTempWfd.setContent(tempWfd.getContent());
            zeroTempWfd.setProcessName(tempWfd.getProcessName());
            zeroTempWfd.setLastTime(ts);
            zeroTempWfd.setType("temp-wfd");
            this.sysActProcessFileMapper.insert(zeroTempWfd);
        }
        return true;
    }

    public List<SysActProcessFile> exportFileList(List<String> modelIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List longModelIds = modelIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        queryWrapper.in(SysActProcessFile::getModelId, longModelIds);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public List<SysActProcessFile> exportFileListByKeys(List<String> keys) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysActProcessFile::getProcessKey, keys);
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public List<SysActProcessFile> exportFileList(List<String> modelIds, List<String> keys, String procId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty(modelIds)) {
            List longModelIds = modelIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            queryWrapper.in(SysActProcessFile::getModelId, longModelIds);
        } else if (HussarUtils.isNotEmpty(keys)) {
            queryWrapper.in(SysActProcessFile::getProcessKey, keys);
        } else if (HussarUtils.isNotEmpty((Object)procId)) {
            queryWrapper.in(SysActProcessFile::getProcessId, new Object[]{procId});
        }
        queryWrapper.eq(SysActProcessFile::getVersion, (Object)0);
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public List<SysActProcessFile> exportFile(String procId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysActProcessFile::getProcessId, new Object[]{procId});
        return this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
    }

    public void updateMetaByIdentity(String identity, String name, String category) {
        HussarCacheUtil.evictKeysRightLike((String)"workflow_file", (String)("workflow_file:" + identity + ":"));
        HussarCacheUtil.evictKeysRightLike((String)"workflow_assignee", (String)("workflow_assignee:" + identity + ":"));
        HussarCacheUtil.evictKeysRightLike((String)"form_auth", (String)("form_auth" + identity + ":"));
        int lastVersion = this.sysActProcessFileMapper.selectLatestVersion(identity);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(lastVersion);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)identity);
        queryWrapper.in(SysActProcessFile::getVersion, list);
        queryWrapper.eq(SysActProcessFile::getType, (Object)"meta");
        List sysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        for (SysActProcessFile sysActProcessFile : sysActProcessFiles) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((byte[])sysActProcessFile.getContent(), WorkFlow.class, (Feature[])new Feature[0]);
            if (HussarUtils.isNotEmpty((Object)name)) {
                workFlow.setName(name);
            }
            sysActProcessFile.setContent(JSON.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            this.sysActProcessFileMapper.updateById(sysActProcessFile);
        }
    }
}

