/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bsp.taskmanager.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.CompleteTaskDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.EntrustTaskDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.FreeJumpDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.FreeRejectDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.UrgeTaskDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.vo.TaskVo;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4efb\u52a1\u7ba1\u7406"})
@RequestMapping(value={"/bpm/taskManager"})
public class TaskManagerController {
    @Autowired
    private TaskManagerService taskManagerService;
    @Autowired
    ITaskEngineService taskEngineService;
    @Autowired
    FlowEventsService flowEventsService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    @GetMapping(value={"/getTaskManager"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", notes="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<TaskManager>> getTaskManager(Page<TaskManager> page, GetTaskManagerDto taskManagerDto) {
        return this.taskManagerService.getTaskManager(page, taskManagerDto);
    }

    @PostMapping(value={"/suspendTaskById"})
    @ApiOperation(value="\u6302\u8d77\u6d41\u7a0b\u4efb\u52a1", notes="\u6302\u8d77\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u6302\u8d77\u6d41\u7a0b\u4efb\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> suspendTaskById(@RequestBody String processInsId) {
        return this.taskManagerService.suspendTaskById(processInsId);
    }

    @PostMapping(value={"/activateTaskById"})
    @ApiOperation(value="\u6fc0\u6d3b\u6d41\u7a0b\u4efb\u52a1", notes="\u6fc0\u6d3b\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u6fc0\u6d3b\u6d41\u7a0b\u4efb\u52a1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> activateTaskById(@RequestBody String processInsId) {
        return this.taskManagerService.activateTaskById(processInsId);
    }

    @PostMapping(value={"/completeTask"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="completeTaskDto", value="\u4efb\u52a1\u529e\u7406", required=true, paramType="body")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u4efb\u52a1\u529e\u7406", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> completeTask(@RequestBody CompleteTaskDto completeTaskDto) {
        BpmResponseResult bpmResponseResult;
        try {
            bpmResponseResult = this.taskEngineService.completeTask(completeTaskDto.getTaskId(), completeTaskDto.getUserInfo(), null, false);
        }
        catch (PublicClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PublicClientException(e.getMessage());
        }
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        throw new PublicClientException(bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/entrustTaskByTaskId"})
    @ApiOperation(value="\u4efb\u52a1\u8f6c\u529e", notes="\u4efb\u52a1\u8f6c\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="entrustTaskDto", value="\u4efb\u52a1\u8f6c\u529e", required=true, paramType="body")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u4efb\u52a1\u8f6c\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> entrustTask(@RequestBody EntrustTaskDto entrustTaskDto) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        try {
            bpmResponseResult = this.taskEngineService.entrustTask(entrustTaskDto.getTaskId(), entrustTaskDto.getMandataryInfo(), 1);
        }
        catch (PublicClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PublicClientException(bpmResponseResult.getMsg());
        }
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        if (String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()).equals(bpmResponseResult.getCode())) {
            throw new PublicClientException(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getMessage());
        }
        throw new PublicClientException(bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/getJumpTasks"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8282\u70b9", notes="\u83b7\u53d6\u4efb\u52a1\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", required=false, paramType="query"), @ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=false, paramType="query")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4efb\u52a1\u8282\u70b9", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<TaskVo>> getJumpTasks(@RequestParam(value="taskId", required=false) String taskId, @RequestParam(value="processInsId", required=false) String processInsId) {
        return this.taskManagerService.getJumpTasks(taskId, processInsId);
    }

    @PostMapping(value={"/freeJump"})
    @ApiOperation(value="\u81ea\u7531\u8df3\u8f6c", notes="\u81ea\u7531\u8df3\u8f6c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="freeJumpDto", value="\u81ea\u7531\u8df3\u8f6c", required=true, paramType="body")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u81ea\u7531\u8df3\u8f6c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> freeJump(@RequestBody FreeJumpDto freeJumpDto) {
        BpmResponseResult result;
        try {
            result = this.taskEngineService.freeJump(freeJumpDto.getTaskId(), freeJumpDto.getActivityId(), freeJumpDto.getUserInfo(), freeJumpDto.getAssigneesInfo(), null, true, false, null, null, false);
        }
        catch (PublicClientException e) {
            throw new PublicClientException(e.getReason());
        }
        if ("1".equals(result.getCode())) {
            return ApiResponse.success((String)this.bpmConstantProperties.getFreeJumpSuccess());
        }
        throw new PublicClientException(result.getMsg());
    }

    @PostMapping(value={"/urgeTask"})
    @ApiOperation(value="\u4efb\u52a1\u50ac\u529e", notes="\u4efb\u52a1\u50ac\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="urgeTaskDto", value="\u4efb\u52a1\u50ac\u529e", required=true, paramType="query")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u4efb\u52a1\u50ac\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> urgeTask(@RequestBody UrgeTaskDto urgeTaskDto) {
        return this.flowEventsService.urgeTask(urgeTaskDto.getProcessInsId(), String.valueOf(BaseSecurityUtil.getUser().getId()));
    }

    @PostMapping(value={"/rejectToFirstTask"})
    @ApiOperation(value="\u4efb\u52a1\u9a73\u56de\u81f3\u7b2c\u4e00\u4e2a\u8282\u70b9", notes="\u4efb\u52a1\u9a73\u56de\u81f3\u7b2c\u4e00\u4e2a\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="freeRejectDto", value="\u9a73\u56de\u6570\u636e", required=true, paramType="body")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u81ea\u7531\u9a73\u56de", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult rejectToFirstTask(@RequestBody FreeRejectDto freeRejectDto) {
        return this.taskManagerService.rejectToFirstTask(freeRejectDto);
    }

    @PostMapping(value={"/rejectToAnyTask"})
    @ApiOperation(value="\u4efb\u52a1\u9a73\u56de\u81f3\u4efb\u610f\u8282\u70b9", notes="\u4efb\u52a1\u9a73\u56de\u81f3\u4efb\u610f\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="freeRejectDto", value="\u9a73\u56de\u6570\u636e", required=true, paramType="body")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u81ea\u7531\u9a73\u56de", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult rejectToAnyTask(@RequestBody FreeRejectDto freeRejectDto) {
        return this.taskManagerService.rejectToAnyTask(freeRejectDto);
    }

    @PostMapping(value={"/rejectToLastTask"})
    @ApiOperation(value="\u4efb\u52a1\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9", notes="\u4efb\u52a1\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="freeRejectDto", value="\u9a73\u56de\u6570\u636e", required=true, paramType="body")})
    @AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406", eventDesc="\u81ea\u7531\u9a73\u56de", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public BpmResponseResult rejectToLastTask(@RequestBody FreeRejectDto freeRejectDto) {
        return this.taskManagerService.rejectToLastTask(freeRejectDto);
    }

    @GetMapping(value={"/queryRejectNode"})
    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9", notes="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public BpmResponseResult queryRejectNode(@RequestParam(value="taskId") String taskId) {
        return this.taskEngineService.queryRejectNode(taskId, true);
    }

    @PostMapping(value={"/unPreemptTask"})
    @ApiOperation(value="\u53d6\u6d88\u62a2\u5355", notes="\u53d6\u6d88\u62a2\u5355")
    public ApiResponse<String> unPreemptTask(@RequestBody PreemptCommonDto preemptCommonDto) {
        preemptCommonDto.setIsAuditAuthority(false);
        BpmResponseResult bpmResponseResult = this.taskEngineService.unPreemptTask(preemptCommonDto);
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }
}

