/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.exception;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.log.trace.annotation.Trace;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.BpmTenantException;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=4)
@Trace
public class WorkflowGlobalExceptionHander {
    private static Logger logger = LoggerFactory.getLogger(WorkflowGlobalExceptionHander.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    @ExceptionHandler(value={BpmTenantException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> credentials(BpmTenantException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        return ApiResponse.fail((String)BpmEnum.ERROR_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={PropertyNotFoundException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> credentials(PropertyNotFoundException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error(e.getMessage());
        return ApiResponse.fail((String)bpmConstantProperties.getPropertyNotFound());
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> credentials(ActivitiIllegalArgumentException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error(e.getMessage());
        if (e.getMessage().contains(" null")) {
            return ApiResponse.fail((String)bpmConstantProperties.getNotNullParamIsNull());
        }
        return ApiResponse.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> credentials(ActivitiTaskAlreadyClaimedException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error(e.getMessage());
        return ApiResponse.fail((String)bpmConstantProperties.getTaskAlreadyClaimed());
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> credentials(ActivitiException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error(e.getMessage());
        if (e.getMessage().startsWith("Cannot set suspensionState state 'suspended' for ProcessDefinitionEntity")) {
            return ApiResponse.fail((String)bpmConstantProperties.getSuspendedProcessDefinitionEntityError());
        }
        if (e.getMessage().startsWith("Cannot set suspensionState state 'active' for ProcessDefinitionEntity")) {
            return ApiResponse.fail((String)bpmConstantProperties.getActiveProcessDefinitionEntityError());
        }
        if (e.getMessage().startsWith("Cannot set suspensionState state 'suspended' for ProcessInstance")) {
            return ApiResponse.fail((String)bpmConstantProperties.getSuspendedProcessProcessInstanceError());
        }
        if (e.getMessage().startsWith("Cannot set suspensionState state 'active' for ProcessInstance")) {
            return ApiResponse.fail((String)bpmConstantProperties.getActiveProcessProcessInstanceError());
        }
        if (e.getMessage().startsWith("Process instance is still running, cannot delete historic process instance")) {
            return ApiResponse.fail((String)bpmConstantProperties.getProcessInstanceIsNotEnd());
        }
        if ("Cannot claim a suspended task".equals(e.getMessage())) {
            return ApiResponse.fail((String)bpmConstantProperties.getTaskIsSuspended());
        }
        if (e.getMessage().startsWith("No outgoing sequence flow of")) {
            return ApiResponse.fail((String)bpmConstantProperties.getNoOutgoingSequence());
        }
        if (e.getMessage().startsWith("Exception while invoking TaskListener:")) {
            return ApiResponse.fail((String)bpmConstantProperties.getErrorTaskListener());
        }
        return ApiResponse.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> credentials(ActivitiObjectNotFoundException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        logger.error(e.getMessage());
        if (e.getMessage().startsWith("Cannot find task with id ")) {
            return ApiResponse.fail((String)bpmConstantProperties.getTaskNotFound());
        }
        if (e.getMessage().startsWith("Cannot find process definition for id ") || e.getMessage().startsWith("no deployed process definition found with id")) {
            return ApiResponse.fail((String)bpmConstantProperties.getModelNotFound());
        }
        if (e.getMessage().startsWith("Cannot find processInstance for id") || e.getMessage().startsWith("No process instance found for id") || e.getMessage().startsWith("No historic process instance found with id")) {
            return ApiResponse.fail((String)bpmConstantProperties.getProcessNotFound());
        }
        return ApiResponse.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> credentials(PublicClientException e, HttpServletRequest request, HttpServletResponse response) {
        this.doResponse(response);
        return ApiResponse.fail((String)e.getReason());
    }

    private void doResponse(HttpServletResponse response) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)response.getContentType(), (CharSequence)"application/json")) {
            response.setContentType("application/json");
        }
    }
}

