/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.sqlcondition.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.impl.el.SqlConditionHandleService;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqlConditionHandleServiceImpl
implements SqlConditionHandleService {
    private static final Pattern SQL_REGEX = Pattern.compile("\\@Sql\\{([^@]|[^}]\\@)*\\}\\@");
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;

    private String replaceNextBuiltinVariable(String sql, Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            for (Map.Entry<String, Object> key : map.entrySet()) {
                if (sql.contains("(${" + key.getKey() + "})") && key.getValue() == null) {
                    newMap.put(key.getKey(), "null");
                    continue;
                }
                if (sql.contains("('${" + key.getKey() + "}')")) {
                    newMap.put(key.getKey(), String.valueOf(key.getValue()).replace(",", "','"));
                    continue;
                }
                newMap.put(key.getKey(), key.getValue());
            }
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newMap);
        ValueExpression e = factory.createValueExpression((ELContext)context, sql, String.class);
        String finalSql = e.getValue((ELContext)context).toString();
        finalSql = finalSql.replace("'null'", "null");
        return finalSql;
    }

    public String getSqlRealCondition(String condition, ExecutionEntity executionEntity) {
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        AnalyticalModelUtil.getSqlVariableMap(executionEntity, variableMap);
        condition = condition.substring(2, condition.length() - 1);
        String realCondition = condition = "${" + this.replaceNextBuiltinVariable(condition, variableMap) + "}";
        if (condition.contains("@Sql{")) {
            Matcher matcher = SQL_REGEX.matcher(condition);
            while (matcher.find()) {
                String message = matcher.group().substring(5, matcher.group().length() - 2);
                Map sqlMap = (Map)JSON.parseObject((String)message, Map.class);
                Boolean result = (Boolean)this.iAssigneeChooseService.getSqlResult(sqlMap);
                if (result == null) {
                    result = false;
                }
                realCondition = realCondition.replace(matcher.group(), String.valueOf(result));
            }
        }
        return realCondition;
    }

    public String getSqlRealCondition(String condition, Map<String, Object> map) {
        condition = condition.substring(2, condition.length() - 1);
        String realCondition = condition = "${" + this.replaceNextBuiltinVariable(condition, map) + "}";
        if (condition.contains("@Sql{")) {
            Matcher matcher = SQL_REGEX.matcher(condition);
            while (matcher.find()) {
                String message = matcher.group().substring(5, matcher.group().length() - 2);
                Map sqlMap = (Map)JSON.parseObject((String)message, Map.class);
                Boolean result = (Boolean)this.iAssigneeChooseService.getSqlResult(sqlMap);
                if (result == null) {
                    result = false;
                }
                realCondition = realCondition.replace(matcher.group(), String.valueOf(result));
            }
        }
        return realCondition;
    }
}

