/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import java.sql.Timestamp;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiSequenceFlowTakenEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SequenceFlowTakeListener
implements ActivitiEventListener {
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    private static Logger logger = LogManager.getLogger(SequenceFlowTakeListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        if (!activitiEvent.getType().equals((Object)ActivitiEventType.SEQUENCEFLOW_TAKEN)) {
            return;
        }
        ActivitiSequenceFlowTakenEventImpl sequenceFlowTakenEvent = (ActivitiSequenceFlowTakenEventImpl)activitiEvent;
        SysActHiLine sysActHiLine = new SysActHiLine();
        sysActHiLine.setProcessInsId(Long.valueOf(Long.parseLong(sequenceFlowTakenEvent.getProcessInstanceId())));
        sysActHiLine.setProcDefId(sequenceFlowTakenEvent.getProcessDefinitionId());
        sysActHiLine.setLineId(sequenceFlowTakenEvent.getId());
        sysActHiLine.setCompleteTime(new Timestamp(System.currentTimeMillis()));
        sysActHiLine.setOutNode(sequenceFlowTakenEvent.getSourceActivityId());
        sysActHiLine.setOutNodeName(sequenceFlowTakenEvent.getSourceActivityName());
        sysActHiLine.setInNode(sequenceFlowTakenEvent.getTargetActivityId());
        sysActHiLine.setInNodeName(sequenceFlowTakenEvent.getTargetActivityName());
        ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(activitiEvent.getExecutionId());
        Object separatedVariable = execution.getVariable("sub_process_key");
        if (HussarUtils.isNotEmpty((Object)separatedVariable)) {
            sysActHiLine.setSubProcessKey((String)separatedVariable);
            Integer cycleCount = (Integer)execution.getVariable("cycle_count");
            sysActHiLine.setCycleCount(cycleCount);
        }
        this.iSysActHiLineService.save((Object)sysActHiLine);
    }

    public boolean isFailOnException() {
        logger.error("\u4fdd\u5b58\u7ebf\u7684\u529e\u7406\u5386\u53f2\u51fa\u9519");
        return false;
    }
}

