/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    private static Logger logger = LogManager.getLogger(ProcessCompleteListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        ExecutionEntity entity = (ExecutionEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("tenantId", entity.getTenantId());
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        List linkEntityList = entity.getIdentityLinks();
        if (!linkEntityList.isEmpty()) {
            map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        if (!entity.getTasks().isEmpty()) {
            for (TaskEntity taskEntity : entity.getTasks()) {
                this.sysActUrgeTaskMapper.deleteByTaskId(Long.parseLong(taskEntity.getId()));
            }
        }
        CommandContext commandContext = Context.getCommandContext();
        List tasks = commandContext.getTaskEntityManager().findTasksByProcessInstanceId(entity.getId());
        for (TaskEntity task : tasks) {
            commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(task.getId()).setRevokeFlag("1");
        }
        this.taskEngineMapper.cancelNodeRevoke(Long.parseLong(entity.getId()), null, null);
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

