/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class PreemptTaskCmd
extends CommonPrepareCmd {
    protected static DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    protected static TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
    public static final String PREEMPT = "1";

    @Override
    protected CommonPrepareCmd.PrepareReturn execute(CommandContext commandContext, TaskEntity task) {
        task.setPreempted(PREEMPT);
        List identityLinkEntityList = task.getCandidates();
        Set users = identityLinkEntityList.stream().filter(identityLink -> !identityLink.isEntrust()).map(IdentityLinkEntity::getUserId).collect(Collectors.toSet());
        String userId = (String)this.userInfo.get("userId");
        users.remove(userId);
        String mandator = (String)this.mandatorInfo.get("userId");
        String mandatorDept = (String)this.mandatorInfo.get("deptId");
        if (dataPushService.isDataPush() && identityLinkEntityList.size() > 1) {
            HashMap<String, String> deleteUsers = new HashMap<String, String>();
            ArrayList deleteUserMaps = new ArrayList();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
                if (!identityLinkEntity.getUserId().equals(userId)) {
                    deleteUsers.put(identityLinkEntity.getUserId(), identityLinkEntity.getOrganId());
                }
                if (Objects.equals(identityLinkEntity.getUserId(), userId) && Objects.equals(identityLinkEntity.getMandator(), mandator) && identityLinkEntity.getOrganId().equals(mandatorDept)) continue;
                HashMap<String, String> deleteUserMap = new HashMap<String, String>();
                deleteUserMap.put("userId", identityLinkEntity.getUserId());
                if (identityLinkEntity.isEntrust()) {
                    deleteUserMap.put("mandator", identityLinkEntity.getMandator());
                    deleteUserMap.put("taskState", identityLinkEntity.getTaskState());
                }
                deleteUserMaps.add(deleteUserMap);
            }
            dataPushService.entrustDataPush(new DataPush().setConsignor(HussarUtils.isNotEmpty(deleteUsers) ? Collections.singletonList(deleteUsers) : null).setConsignorMaps(deleteUserMaps).setTaskId(this.taskId));
        }
        if (!users.isEmpty()) {
            taskEngineMapper.unPreemptDeduplication(users, this.taskId);
        }
        taskEngineMapper.preemptTask(this.taskId, userId, mandator);
        return new CommonPrepareCmd.PrepareReturn(this);
    }

    public PreemptTaskCmd(String taskId, Map<String, String> userInfo) {
        super(taskId, userInfo);
    }

    public PreemptTaskCmd(String taskId, Map<String, String> userInfo, Map<String, String> mandatorInfo) {
        super(taskId, userInfo, mandatorInfo);
    }

    public PreemptTaskCmd(String taskId, Map<String, String> userInfo, Map<String, String> mandatorInfo, boolean isAuditAuthority) {
        super(taskId, userInfo, mandatorInfo, isAuditAuthority);
    }
}

