/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class MultiInstanceJumpTaskCmd
implements Command<Void> {
    protected Map<String, String> userInfo;
    protected String organId;
    private String executionId;
    private String targetNodeIds;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private String taskId;
    private String comment;
    private String type;
    private Map<String, String> mandatorInfo;
    private TaskRejectModel taskRejectModel;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getBean(ISysActCcTaskService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private static Map<String, String> createType = new HashMap<String, String>();
    private static Map<String, String> deleteType = new HashMap<String, String>();

    public Void execute(CommandContext commandContext) {
        commandContext.addAttribute("type", (Object)this.type);
        boolean needRemoveTask = this.paramvar.get("ADD_HISTORY_TASK_START_TIME") != null;
        boolean reject = this.type.equals("reject");
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        this.organId = (String)commandContext.getAttribute("sendUserOrganId");
        if (this.organId == null) {
            String userId = this.userInfo.get("userId");
            this.organId = this.userInfo.get("deptId");
            commandContext.addAttribute("sendUser", (Object)userId);
            commandContext.addAttribute("sendUserOrganId", (Object)this.organId);
        }
        Object id = null;
        if (executionEntity.getParent() != null && (executionEntity = executionEntity.getParent()).getParent() != null) {
            executionEntity = executionEntity.getParent();
        }
        executionEntity.setExecutions(null);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        ArrayList taskEntities = new ArrayList();
        ExecutionEntity scopeExecution = (ExecutionEntity)executionEntity.getExecutions().get(0);
        for (ExecutionEntity taskExecution : scopeExecution.getExecutions()) {
            taskEntities.addAll(taskExecution.getTasks());
        }
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<Long> longTaskIds = new ArrayList<Long>();
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.getId().equals(this.taskId) && !needRemoveTask) continue;
            taskIds.add(taskEntity.getId());
            longTaskIds.add(Long.parseLong(taskEntity.getId()));
        }
        if (HussarUtils.isNotEmpty(taskIds)) {
            Object ccTasks;
            this.taskEngineMapper.removeMultiHistoryTask(longTaskIds);
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.deleteMultiTask(taskIds);
            }
            if (HussarUtils.isNotEmpty((Object)((TaskEntity)taskEntities.get(0)).getDueDate())) {
                this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
            }
            if (HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, longTaskIds))))) {
                ArrayList userList = new ArrayList();
                Iterator iterator = ccTasks.iterator();
                while (iterator.hasNext()) {
                    SysActCcTask ccTask = (SysActCcTask)iterator.next();
                    HashMap<String, String> map = new HashMap<String, String>();
                    ccTask.setTaskId(Long.valueOf(Long.parseLong(this.taskId)));
                    map.put("userId", ccTask.getReceiveUser());
                    map.put("deptId", ccTask.getReceiveUserDept());
                    userList.add(map);
                }
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush()) {
                    DataPush dataPush = new DataPush();
                    dataPush.setUserInfo(userList);
                    dataPush.setTaskId(this.taskId);
                    this.dataPushService.addCcTask(dataPush);
                }
            }
        }
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.getId().equals(this.taskId)) {
                taskEntity.setAssignee(this.userInfo.get("userId"), false, false, this.organId);
            }
            ParamModel paramModel = this.getParamModel(taskEntity, this.taskRejectModel);
            Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
            taskEntity.fireEvent("complete");
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            String mandatorId = "";
            String mandatorDept = "";
            if (HussarUtils.isNotEmpty(this.mandatorInfo)) {
                mandatorId = this.mandatorInfo.get("userId");
                mandatorDept = this.mandatorInfo.get("deptId");
            }
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "MultiInstanceJumpTaskCmd-Completed", false, mandatorId, mandatorDept, this.userInfo.get("deptId"));
        }
        List list = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity.getId());
        ExecutionEntity ee = new ExecutionEntity();
        for (ExecutionEntity executionEntity2 : list) {
            List parent = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity2.getId());
            for (ExecutionEntity executionEntity3 : parent) {
                executionEntity3.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity3);
            }
            executionEntity2.remove();
            List tasks = executionEntity2.getTasks();
            if (tasks != null && !tasks.isEmpty() && HussarUtils.isNotEmpty(this.userInfo)) {
                ((TaskEntity)tasks.get(0)).setAssignee(this.userInfo.get("userId"), false, false, this.organId);
            }
            ee = executionEntity2;
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        if (reject) {
            this.paramvar.put("reject_from", this.currentActivity.getId());
            this.paramvar.put("reject_to", this.targetNodeIds);
        }
        if (executionEntity.getActivityId() != null) {
            this.fireExecutionListener(executionEntity);
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.targetNodeIds, this.userInfo, this.type, this.paramvar));
        return null;
    }

    public MultiInstanceJumpTaskCmd(Map<String, String> userInfo, Map<String, String> mandatorInfo, String executionId, String targetNodeIds, String taskId, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userInfo = userInfo;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskId = taskId;
        this.comment = comment;
        this.type = type;
        this.mandatorInfo = mandatorInfo;
    }

    public MultiInstanceJumpTaskCmd(Map<String, String> userInfo, Map<String, String> mandatorInfo, String executionId, String targetNodeIds, String taskId, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userInfo = userInfo;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskId = taskId;
        this.comment = comment;
        this.type = type;
        this.mandatorInfo = mandatorInfo;
        this.taskRejectModel = taskRejectModel;
    }

    public ParamModel getParamModel(TaskEntity task, TaskRejectModel taskRejectModel) {
        ParamModel paramModel = new ParamModel();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        if (HussarUtils.isEmpty((Object)taskRejectModel)) {
            paramModel.setCompleteType(this.type);
            paramModel.setFrom(task.getTaskDefinitionKey());
            paramModel.setTo(this.targetNodeIds);
            String userId = this.userInfo.get("userId");
            paramModel.setHandler(userId);
            paramModel.setSendUser(userId);
            paramModel.setCreateReason(createType.get(this.type));
            paramModel.setLastNodeId(task.getTaskDefinitionKey());
            paramModel.setLastNodeName(task.getName());
            paramModel.setLastCompleteType(this.type);
            paramModel.setLastNodeHandler(userId);
            return paramModel;
        }
        paramModel.setCompleteType(taskRejectModel.getType());
        if (HussarUtils.isNotEmpty((Object)taskRejectModel.getTaskId())) {
            if (!task.getId().equals(taskRejectModel.getTaskId())) {
                paramModel.setDeleteType(deleteType.get(taskRejectModel.getType()));
            }
        } else {
            paramModel.setDeleteType(deleteType.get(taskRejectModel.getType()));
        }
        String targetIds = taskRejectModel.getTargetIds();
        Map<String, List<Object>> targetAssigneeMap = new HashMap<String, List>();
        if (taskRejectModel.getMap().containsKey("reject_appoint_assignee")) {
            List targetAssignee = (List)taskRejectModel.getMap().get("reject_appoint_assignee");
            targetAssigneeMap.put(targetIds, targetAssignee);
        } else if (taskRejectModel.getMap().containsKey("appoint_assignee")) {
            targetAssigneeMap = (Map)taskRejectModel.getMap().get("appoint_assignee");
        }
        paramModel.setTargetAssignee(targetAssigneeMap);
        paramModel.setTo(targetIds);
        paramModel.setFrom(task.getTaskDefinitionKey());
        paramModel.setAffectedNodeId(taskRejectModel.getAllAffectedTaskIds());
        paramModel.setHandler((String)taskRejectModel.getUserInfo().get("userId"));
        paramModel.setSendUser((String)taskRejectModel.getUserInfo().get("userId"));
        if (createType.containsKey(taskRejectModel.getType())) {
            paramModel.setCreateReason(createType.get(taskRejectModel.getType()));
        }
        paramModel.setLastNodeId(taskRejectModel.getTask().getTaskDefinitionKey());
        paramModel.setLastNodeName(taskRejectModel.getTask().getName());
        paramModel.setLastCompleteType(taskRejectModel.getType());
        paramModel.setLastNodeHandler((String)taskRejectModel.getUserInfo().get("userId"));
        paramModel.setActivityType("userTask");
        return paramModel;
    }

    public void fireExecutionListener(ExecutionEntity execution) {
        execution.setEventName("end");
        List executionListeners = execution.getActivity().getExecutionListeners("end");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PublicClientException("\u76d1\u542c\u5668\u6267\u884c\u5931\u8d25");
            }
        }
    }

    static {
        createType.put("reject", "rejectCreate");
        createType.put("revoke", "revokeCreate");
        createType.put("reject_revoke", "revokeCreate");
        createType.put("freejump", "freeJumpCreate");
        createType.put("complete", "completeToRejectCreate");
        deleteType.put("reject", "rejectDeleted");
        deleteType.put("revoke", "revokeDeleted");
        deleteType.put("reject_revoke", "revokeDeleted");
        deleteType.put("freejump", "freeJumpDeleted");
        deleteType.put("endProcess", "endProcessDeleted");
        deleteType.put("revokeProcess", "revokeProcessDeleted");
    }
}

