/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.Collections;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;

public class ChildTaskCompleteCmd
extends CommonPrepareCmd {
    protected DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    protected String comment;

    @Override
    protected void taskAuthentication(TaskEntity task) {
        if (task.getParentTaskId() == null) {
            if ("2".equals(task.getTaskType())) {
                throw new PublicClientException("\u534f\u529e\u65e0\u6cd5\u8c03\u7528\u6b64\u52a8\u4f5c\uff01");
            }
            throw new PublicClientException("\u6b64\u4efb\u52a1\u65e0\u6cd5\u8c03\u7528\u6b64\u52a8\u4f5c\uff01");
        }
    }

    @Override
    protected void follow(CommandContext commandContext, TaskEntity task) {
        TaskEntity parentTask = commandContext.getTaskEntityManager().findTaskById(task.getParentTaskId());
        String userId = (String)this.userInfo.get("userId");
        String userDept = (String)this.userInfo.get("deptId");
        String userName = null;
        String organFullName = null;
        if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser().getOrganFullName()) && HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser().getUserName())) {
            Map deptParams = BaseSecurityUtil.getUser().getOrganFullName();
            organFullName = (String)deptParams.get(userDept);
            userName = BaseSecurityUtil.getUser().getUserName();
        }
        if (parentTask != null) {
            CommentEntity.addComment((String)userId, (String)this.taskId, (String)this.comment, (String)userDept, userName, organFullName);
            task.setVariableLocal("complete_from", (Object)task.getTaskDefinitionKey());
            task.setVariableLocal("taskSourceFlag", (Object)"assist_complete");
            if (!task.isDeleted()) {
                task.setDeleted(true);
                String taskId = task.getId();
                commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByTaskId(taskId);
                commandContext.getVariableInstanceEntityManager().deleteVariableInstanceByTask(task);
                commandContext.getHistoryManager().recordTaskAssigneeChange(taskId, userId, userDept);
                commandContext.getHistoryManager().recordTaskEnd(taskId, "complete", (String)this.mandatorInfo.get("userId"), this.taskState, ((IdentityLinkEntity)task.getIdentityLinks().get(0)).getAssistInitiator(), (String)this.mandatorInfo.get("deptId"), (String)this.userInfo.get("deptId"));
                commandContext.getDbSqlSession().delete((PersistentObject)task);
                if (commandContext.getEventDispatcher().isEnabled()) {
                    commandContext.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.ENTITY_DELETED, (Object)task));
                }
            }
        }
        this.dataPushService.completeDataPush((Task)task, this.comment, this.userInfo, Collections.singletonList(this.mandatorInfo), this.taskState, task.getTaskType());
    }

    public ChildTaskCompleteCmd(String taskId, Map<String, String> userInfo, String comment) {
        super(taskId, userInfo);
        this.comment = comment;
    }

    public ChildTaskCompleteCmd(String taskId, Map<String, String> userInfo, Map<String, String> mandatorInfo, String comment) {
        super(taskId, userInfo, mandatorInfo);
        this.comment = comment;
    }
}

