/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.lang.dto.SysBatchMultiLangMgtDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.model.BpmWorkflowTranslateModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.i18n.LocaleContextHolder;

public class BpmWorkflowTranslateUtil {
    private static final Pattern CHINESE_REGEX = Pattern.compile("[\\u4e00-\\u9fa5]");

    public static <T> BpmWorkflowTranslateModel<T> createBpmWorkflowTranslateModel(Object object, Class<T> tClass) {
        if (JSONObject.class.equals(tClass)) {
            return new BpmWorkflowTranslateModel((JSONArray)object);
        }
        if (object instanceof List) {
            return new BpmWorkflowTranslateModel<List>((List)object);
        }
        return new BpmWorkflowTranslateModel<Object>(object);
    }

    public static BpmWorkflowTranslateModel<JSONObject> createBpmWorkflowTranslateModelJSONArray(Object object) {
        return new BpmWorkflowTranslateModel<JSONObject>((JSONArray)object, 3);
    }

    public static void translateJsonArray(JSONArray jsonArray, Map<Function<JSONObject, String>, BiConsumer<JSONObject, String>> translateMap, Map<Function<JSONObject, List<String>>, BiConsumer<JSONObject, Map<String, String>>> jsonObjectTranslateListMap, boolean isDefaultLang) {
        HashSet<String> translateTags = new HashSet<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            for (Function<JSONObject, String> function : translateMap.keySet()) {
                translateTags.add(function.apply(jsonObject));
            }
            for (Function<JSONObject, Object> function : jsonObjectTranslateListMap.keySet()) {
                List tags = (List)function.apply(jsonObject);
                if (tags == null) continue;
                translateTags.addAll(tags);
            }
        }
        translateTags.remove(null);
        translateTags.remove("");
        if (translateTags.isEmpty() || !BpmWorkflowTranslateUtil.getIsEnable()) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (isDefaultLang) {
            lang = TranslateUtil.getDefaultLang();
        }
        SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto = new SysBatchMultiLangMgtDto();
        sysBatchMultiLangMgtDto.setLangKeys(new ArrayList(translateTags));
        sysBatchMultiLangMgtDto.setLangCode(lang);
        Map map = TranslateUtil.getLangTextByListLangKey((SysBatchMultiLangMgtDto)sysBatchMultiLangMgtDto);
        HashMap hashMap = map == null ? new HashMap() : new HashMap(map);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            for (Map.Entry<Function<JSONObject, String>, BiConsumer<JSONObject, String>> entry : translateMap.entrySet()) {
                String translateTag = entry.getKey().apply(jsonObject);
                String newName = (String)hashMap.get(translateTag);
                if (!HussarUtils.isNotEmpty((Object)newName)) continue;
                entry.getValue().accept(jsonObject, newName);
            }
            for (BiConsumer biConsumer : jsonObjectTranslateListMap.values()) {
                biConsumer.accept(jsonObject, hashMap);
            }
            jsonArray.set(i, (Object)jsonObject);
        }
    }

    public static void translateJsonArrayWithArray(JSONArray jsonArray, Map<Function<JSONObject, String>, BiConsumer<JSONObject, String>> translateMap, Map<Function<JSONObject, List<String>>, BiConsumer<JSONObject, Map<String, String>>> jsonObjectTranslateListMap, boolean isDefaultLang) {
        HashSet<String> translateTags = new HashSet<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONArray arrayJSONArray = jsonArray.getJSONArray(i);
            for (int j = 0; j < arrayJSONArray.size(); ++j) {
                JSONObject jsonObject = arrayJSONArray.getJSONObject(j);
                for (Function<JSONObject, String> function : translateMap.keySet()) {
                    translateTags.add(function.apply(jsonObject));
                }
                for (Function<JSONObject, Object> function : jsonObjectTranslateListMap.keySet()) {
                    List tags = (List)function.apply(jsonObject);
                    if (tags == null) continue;
                    translateTags.addAll(tags);
                }
            }
        }
        translateTags.remove(null);
        translateTags.remove("");
        if (translateTags.isEmpty() || !BpmWorkflowTranslateUtil.getIsEnable()) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (isDefaultLang) {
            lang = TranslateUtil.getDefaultLang();
        }
        SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto = new SysBatchMultiLangMgtDto();
        sysBatchMultiLangMgtDto.setLangKeys(new ArrayList(translateTags));
        sysBatchMultiLangMgtDto.setLangCode(lang);
        HashMap translateResultMap = TranslateUtil.getLangTextByListLangKey((SysBatchMultiLangMgtDto)sysBatchMultiLangMgtDto);
        translateResultMap = translateResultMap == null ? new HashMap() : new HashMap(translateResultMap);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONArray jSONArray = jsonArray.getJSONArray(i);
            for (int j = 0; j < jSONArray.size(); ++j) {
                JSONObject jsonObject = jSONArray.getJSONObject(j);
                for (Map.Entry<Function<JSONObject, String>, BiConsumer<JSONObject, String>> entry : translateMap.entrySet()) {
                    String translateTag = entry.getKey().apply(jsonObject);
                    String newName = (String)translateResultMap.get(translateTag);
                    if (!HussarUtils.isNotEmpty((Object)newName)) continue;
                    entry.getValue().accept(jsonObject, newName);
                }
                for (BiConsumer biConsumer : jsonObjectTranslateListMap.values()) {
                    biConsumer.accept(jsonObject, translateResultMap);
                }
                jSONArray.set(j, (Object)jsonObject);
            }
            jsonArray.set(i, (Object)jSONArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void translate(T t, Map<Function<T, String>, BiConsumer<T, String>> translateMap, Map<Function<T, List<String>>, BiConsumer<T, Map<String, String>>> translateListMap, boolean isDefaultLang) {
        void var6_11;
        HashSet<String> translateTags = new HashSet<String>();
        for (Function<T, String> function : translateMap.keySet()) {
            translateTags.add(function.apply(t));
        }
        for (Function<T, Object> function : translateListMap.keySet()) {
            List tags = (List)function.apply(t);
            if (tags == null) continue;
            translateTags.addAll(tags);
        }
        translateTags.remove(null);
        translateTags.remove("");
        if (translateTags.isEmpty() || !BpmWorkflowTranslateUtil.getIsEnable()) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String string = locale.toLanguageTag();
        if (isDefaultLang) {
            String string2 = TranslateUtil.getDefaultLang();
        }
        SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto = new SysBatchMultiLangMgtDto();
        sysBatchMultiLangMgtDto.setLangKeys(new ArrayList(translateTags));
        sysBatchMultiLangMgtDto.setLangCode((String)var6_11);
        HashMap translateResultMap = TranslateUtil.getLangTextByListLangKey((SysBatchMultiLangMgtDto)sysBatchMultiLangMgtDto);
        translateResultMap = translateResultMap == null ? new HashMap() : new HashMap(translateResultMap);
        for (Map.Entry<Function<T, String>, BiConsumer<T, String>> entry : translateMap.entrySet()) {
            String translateTag = entry.getKey().apply(t);
            String newName = (String)translateResultMap.get(translateTag);
            if (!HussarUtils.isNotEmpty((Object)newName)) continue;
            entry.getValue().accept(t, newName);
        }
        for (BiConsumer biConsumer : translateListMap.values()) {
            biConsumer.accept(t, translateResultMap);
        }
    }

    public static <T> void translate(List<T> list, Map<Function<T, String>, BiConsumer<T, String>> translateMap, Map<Function<T, List<String>>, BiConsumer<T, Map<String, String>>> translateListMap, boolean isDefaultLang) {
        HashSet<String> translateTags = new HashSet<String>();
        for (T t : list) {
            for (Function<T, String> function : translateMap.keySet()) {
                translateTags.add(function.apply(t));
            }
            for (Function<T, Object> function : translateListMap.keySet()) {
                List tags = (List)function.apply(t);
                if (tags == null) continue;
                translateTags.addAll(tags);
            }
        }
        translateTags.remove(null);
        translateTags.remove("");
        if (translateTags.isEmpty() || !BpmWorkflowTranslateUtil.getIsEnable()) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (isDefaultLang) {
            lang = TranslateUtil.getDefaultLang();
        }
        SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto = new SysBatchMultiLangMgtDto();
        sysBatchMultiLangMgtDto.setLangKeys(new ArrayList(translateTags));
        sysBatchMultiLangMgtDto.setLangCode(lang);
        Map map = TranslateUtil.getLangTextByListLangKey((SysBatchMultiLangMgtDto)sysBatchMultiLangMgtDto);
        HashMap hashMap = map == null ? new HashMap() : new HashMap(map);
        for (T t : list) {
            for (Map.Entry<Function<T, String>, BiConsumer<T, String>> entry : translateMap.entrySet()) {
                String translateTag = entry.getKey().apply(t);
                String newName = (String)hashMap.get(translateTag);
                if (!HussarUtils.isNotEmpty((Object)newName)) continue;
                entry.getValue().accept(t, newName);
            }
            for (BiConsumer biConsumer : translateListMap.values()) {
                biConsumer.accept(t, hashMap);
            }
        }
    }

    public static String getTranslateName(String translateTag) {
        if (!BpmWorkflowTranslateUtil.getIsEnable()) {
            return null;
        }
        String value = TranslateUtil.getTranslateName((String)translateTag);
        if (HussarUtils.isEmpty((Object)value)) {
            value = TranslateUtil.getDefaultTranslateName((String)translateTag);
        }
        return value;
    }

    public static Map<String, Object> getTranslateNameMap(List<String> translateTags) {
        if (!BpmWorkflowTranslateUtil.getIsEnable()) {
            return new HashMap<String, Object>();
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        SysBatchMultiLangMgtDto sysBatchMultiLangMgtDto = new SysBatchMultiLangMgtDto();
        sysBatchMultiLangMgtDto.setLangKeys(new ArrayList<String>(translateTags));
        sysBatchMultiLangMgtDto.setLangCode(lang);
        HashMap<String, Object> translateResultMap = TranslateUtil.getLangTextByListLangKey((SysBatchMultiLangMgtDto)sysBatchMultiLangMgtDto);
        translateResultMap = translateResultMap == null ? new HashMap<String, Object>() : new HashMap(translateResultMap);
        return translateResultMap;
    }

    public static boolean getIsEnable() {
        return TranslateUtil.getIsEnable();
    }

    public static void evaluateWidthAndHeight(JSONObject lineObject, String str) {
        if (HussarUtils.isNotEmpty((Object)str)) {
            HashMap parameter = new HashMap();
            Double width = 0.0;
            int height = 0;
            Pattern pattern = CHINESE_REGEX;
            Matcher matcher = pattern.matcher(str);
            int chineseNum = 0;
            int length = str.length();
            while (matcher.find()) {
                ++chineseNum;
                --length;
            }
            int finalLength = 2 * chineseNum + length;
            if (finalLength > 16) {
                width = 126.0;
                height = 16 * (1 + (finalLength - 1) / 16);
            } else {
                width = 7.5 * (double)finalLength;
                height = 16;
            }
            lineObject.put("width", (Object)width);
            lineObject.put("height", (Object)height);
        }
    }
}

