/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.config.properties;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.config.properties.BpmYmlConfigurationProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import org.springframework.stereotype.Component;

@Component
public class UnifiedToDoDataPushProperties {
    private final IBpmConfigService bpmConfigService;
    private final BpmYmlConfigurationProperties bpmYmlConfigurationProperties;

    public UnifiedToDoDataPushProperties(IBpmConfigService bpmConfigService, BpmYmlConfigurationProperties bpmYmlConfigurationProperties, BpmYmlConfigurationProperties bpmYmlConfigurationProperties1) {
        this.bpmConfigService = bpmConfigService;
        this.bpmYmlConfigurationProperties = bpmYmlConfigurationProperties1;
    }

    public boolean isWorkflowPlatformStandalone() {
        return "workflow-platform".equals(this.bpmYmlConfigurationProperties.getDeploymentModel());
    }

    public boolean isUseDatapush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_data_push");
    }

    public Long getSystemId() {
        return this.bpmConfigService.getLongByKeyUseCache("unified_system_id");
    }

    public String getClientId() {
        return this.bpmConfigService.getStringByKeyUseCache("client_id");
    }

    public String getClientSecret() {
        return this.bpmConfigService.getStringByKeyUseCache("client_secret");
    }

    public String getClientScope() {
        return "permission_list";
    }

    public String getUnifiedToDoCallAddress() {
        String address = this.bpmConfigService.getStringByKeyUseCache("unified_to_do_call_address");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }

    public boolean isRemoteDatapush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("remote_data_push");
    }

    public String getUnifiedTodoServerName() {
        return this.bpmConfigService.getStringByKeyUseCache("unified_todo_server_name");
    }
}

