/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.callback.business.visitor.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.callback.business.visitor.service.IWorkflowCallbackVisitorService;
import com.jxdinfo.hussar.workflow.callback.business.visitor.service.impl.WorkflowCallbackVisitorInnerServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ProcessBinding;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowCallbackVisitorSingleServiceImpl
implements IWorkflowCallbackVisitorService {
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private WorkflowCallbackVisitorInnerServiceImpl workflowCallbackVisitorInnerService;

    public Map<String, Object> getVisitorResult(String beanId, String businessId, String procDefId) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessDefId(procDefId);
        if (HussarUtils.isEmpty((Object)workFlow)) {
            throw new PublicClientException(BpmExceptionCodeEnum.ERROR_PROCESS_IDENTITY.getMessage());
        }
        String appId = workFlow.getAppId();
        if (HussarUtils.isNotBlank((CharSequence)appId)) {
            FlowModel data = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
            FlowProps props = data.getProps();
            ProcessBinding binding = props.getProcessBinding();
            String mainTableName = "";
            if (binding != null) {
                mainTableName = binding.getMainTableName();
            }
            beanId = "GET /" + appId + "/" + mainTableName + "/FormQuery";
        }
        return this.workflowCallbackVisitorInnerService.getVisitorResult(beanId, businessId);
    }
}

