/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.bpa.platform.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.bpa.platform.dao.BpmActPlatformBpaMapper;
import com.jxdinfo.hussar.workflow.bpa.platform.model.BpmActPlatformBpa;
import com.jxdinfo.hussar.workflow.bpa.platform.model.PlatformProcessCountModel;
import com.jxdinfo.hussar.workflow.bpa.platform.model.PlatformProcessCountMsgDto;
import com.jxdinfo.hussar.workflow.bpa.platform.service.BpmActPlatformBpaService;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.AllProcessCountModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.ProcessDayCountModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.ResponseCountModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.service.IProcessCountService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class BpmActPlatformBpaServiceImpl
extends HussarServiceImpl<BpmActPlatformBpaMapper, BpmActPlatformBpa>
implements BpmActPlatformBpaService {
    private final IProcessCountService processCountService;
    private final BpmActPlatformBpaMapper bpmActPlatformBpaMapper;

    public BpmActPlatformBpaServiceImpl(IProcessCountService processCountService, BpmActPlatformBpaMapper bpmActPlatformBpaMapper) {
        this.processCountService = processCountService;
        this.bpmActPlatformBpaMapper = bpmActPlatformBpaMapper;
    }

    @HussarDs(value="#connName")
    public void queryPlatformProcessCount(PlatformProcessCountModel platformProcessCountModel, String tenantName, String connName) {
        ResponseCountModel responseCountModel = this.processCountService.queryProcessCountModel();
        AllProcessCountModel allProcessCountModel = this.processCountService.queryAllProcessCountMsg();
        Map dayChangeCountModel = this.processCountService.getDayChangeCountModel();
        platformProcessCountModel.getModelCountMap().put(tenantName, responseCountModel.getModel());
        platformProcessCountModel.getCompleteInstanceMap().put(tenantName, responseCountModel.getCompleteInstance());
        platformProcessCountModel.getRunningInstanceMap().put(tenantName, responseCountModel.getRunningInstance());
        platformProcessCountModel.getCompleteTaskMap().put(tenantName, responseCountModel.getCompleteTask());
        platformProcessCountModel.getRunningTaskMap().put(tenantName, responseCountModel.getRunningTask());
        platformProcessCountModel.getRejectTaskMap().put(tenantName, responseCountModel.getRejectTask());
        platformProcessCountModel.getRevokeTaskMap().put(tenantName, responseCountModel.getRevokeTask());
        platformProcessCountModel.getProcessCompleteRateMap().put(tenantName, responseCountModel.getProcessCompleteRate());
        platformProcessCountModel.getTaskCompleteRateMap().put(tenantName, responseCountModel.getTaskCompleteRate());
        platformProcessCountModel.getAllDurationMap().put(tenantName, responseCountModel.getAllDuration());
        platformProcessCountModel.getProcessCountMap().put(tenantName, allProcessCountModel.getProcessCount());
        platformProcessCountModel.getNormalCountMap().put(tenantName, allProcessCountModel.getNormalCount());
        platformProcessCountModel.getPauseCountMap().put(tenantName, allProcessCountModel.getPauseCount());
        platformProcessCountModel.getEndCountMap().put(tenantName, allProcessCountModel.getEndCount());
        platformProcessCountModel.getTerminatedCountMap().put(tenantName, allProcessCountModel.getTerminatedCount());
        platformProcessCountModel.getDayTaskCompleteMap().put(tenantName, dayChangeCountModel.get("taskComplete"));
        platformProcessCountModel.getDayProcessCompleteMap().put(tenantName, dayChangeCountModel.get("processComplete"));
        platformProcessCountModel.getDayProcessAddMap().put(tenantName, dayChangeCountModel.get("processAdd"));
        platformProcessCountModel.getDayTaskAddMap().put(tenantName, dayChangeCountModel.get("taskAdd"));
    }

    public BpmActPlatformBpa countPlatformProcess(PlatformProcessCountModel platformProcessCountModel) {
        BpmActPlatformBpa bpmActPlatformBpa = new BpmActPlatformBpa();
        bpmActPlatformBpa.setTenantModelCount(JSON.toJSONString((Object)platformProcessCountModel.getModelCountMap()));
        bpmActPlatformBpa.setModelCount(Integer.valueOf(platformProcessCountModel.getModelCountMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantProcessCount(JSON.toJSONString((Object)platformProcessCountModel.getProcessCountMap()));
        bpmActPlatformBpa.setProcessCount(Integer.valueOf(platformProcessCountModel.getProcessCountMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantAllDuration(JSON.toJSONString((Object)platformProcessCountModel.getAllDurationMap()));
        bpmActPlatformBpa.setAllDuration(String.format("%.2f", platformProcessCountModel.getAllDurationMap().values().stream().mapToDouble(Double::parseDouble).sum()));
        bpmActPlatformBpa.setTenantNormalCount(JSON.toJSONString((Object)platformProcessCountModel.getNormalCountMap()));
        bpmActPlatformBpa.setNormalCount(Integer.valueOf(platformProcessCountModel.getNormalCountMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantPauseCount(JSON.toJSONString((Object)platformProcessCountModel.getPauseCountMap()));
        bpmActPlatformBpa.setPauseCount(Integer.valueOf(platformProcessCountModel.getPauseCountMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantEndCount(JSON.toJSONString((Object)platformProcessCountModel.getEndCountMap()));
        bpmActPlatformBpa.setEndCount(Integer.valueOf(platformProcessCountModel.getEndCountMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantTerminatedCount(JSON.toJSONString((Object)platformProcessCountModel.getTerminatedCountMap()));
        bpmActPlatformBpa.setTerminatedCount(Integer.valueOf(platformProcessCountModel.getTerminatedCountMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantCompleteInstance(JSON.toJSONString((Object)platformProcessCountModel.getCompleteInstanceMap()));
        bpmActPlatformBpa.setCompleteInstance(Integer.valueOf(platformProcessCountModel.getCompleteInstanceMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantRunningInstance(JSON.toJSONString((Object)platformProcessCountModel.getRunningInstanceMap()));
        bpmActPlatformBpa.setRunningInstance(Integer.valueOf(platformProcessCountModel.getRunningInstanceMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantCompleteTask(JSON.toJSONString((Object)platformProcessCountModel.getCompleteTaskMap()));
        bpmActPlatformBpa.setCompleteTask(Integer.valueOf(platformProcessCountModel.getCompleteTaskMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantRunningTask(JSON.toJSONString((Object)platformProcessCountModel.getRunningTaskMap()));
        bpmActPlatformBpa.setRunningTask(Integer.valueOf(platformProcessCountModel.getRunningTaskMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantRejectTask(JSON.toJSONString((Object)platformProcessCountModel.getRejectTaskMap()));
        bpmActPlatformBpa.setRejectTask(Integer.valueOf(platformProcessCountModel.getRejectTaskMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantRevokeTask(JSON.toJSONString((Object)platformProcessCountModel.getRevokeTaskMap()));
        bpmActPlatformBpa.setRevokeTask(Integer.valueOf(platformProcessCountModel.getRevokeTaskMap().values().stream().mapToInt(Integer::intValue).sum()));
        bpmActPlatformBpa.setTenantProcessCompleteRate(JSON.toJSONString((Object)platformProcessCountModel.getProcessCompleteRateMap()));
        bpmActPlatformBpa.setProcessCompleteRate(String.format("%.2f", (double)(bpmActPlatformBpa.getCompleteInstance() * 100) / (double)(bpmActPlatformBpa.getCompleteInstance() + bpmActPlatformBpa.getRunningInstance())) + "%");
        bpmActPlatformBpa.setTenantTaskCompleteRate(JSON.toJSONString((Object)platformProcessCountModel.getTaskCompleteRateMap()));
        bpmActPlatformBpa.setTaskCompleteRate(String.format("%.2f", (double)(bpmActPlatformBpa.getCompleteTask() * 100) / (double)(bpmActPlatformBpa.getCompleteTask() + bpmActPlatformBpa.getRunningTask())) + "%");
        bpmActPlatformBpa.setTenantDayTaskComplete(JSON.toJSONStringWithDateFormat((Object)platformProcessCountModel.getDayTaskCompleteMap(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        bpmActPlatformBpa.setDayTaskComplete(this.computeDayProcessTrend(platformProcessCountModel.getDayTaskCompleteMap()));
        bpmActPlatformBpa.setTenantDayProcessComplete(JSON.toJSONStringWithDateFormat((Object)platformProcessCountModel.getDayProcessCompleteMap(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        bpmActPlatformBpa.setDayProcessComplete(this.computeDayProcessTrend(platformProcessCountModel.getDayProcessCompleteMap()));
        bpmActPlatformBpa.setTenantDayProcessAdd(JSON.toJSONStringWithDateFormat((Object)platformProcessCountModel.getDayProcessAddMap(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        bpmActPlatformBpa.setDayProcessAdd(this.computeDayProcessTrend(platformProcessCountModel.getDayProcessAddMap()));
        bpmActPlatformBpa.setTenantDayTaskAdd(JSON.toJSONStringWithDateFormat((Object)platformProcessCountModel.getDayTaskAddMap(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        bpmActPlatformBpa.setDayTaskAdd(this.computeDayProcessTrend(platformProcessCountModel.getDayTaskAddMap()));
        return bpmActPlatformBpa;
    }

    private String computeDayProcessTrend(Map<String, List<ProcessDayCountModel>> dayProcessInfo) {
        ArrayList<List<ProcessDayCountModel>> lists = new ArrayList<List<ProcessDayCountModel>>(dayProcessInfo.values());
        if (HussarUtils.isNotEmpty(lists)) {
            for (int i = 1; i < lists.size(); ++i) {
                for (int j = 0; j < ((List)lists.get(i)).size(); ++j) {
                    ((ProcessDayCountModel)((List)lists.get(1)).get(j)).setCountNum(Integer.valueOf(((ProcessDayCountModel)((List)lists.get(1)).get(j)).getCountNum() + ((ProcessDayCountModel)((List)lists.get(i)).get(j)).getCountNum()));
                }
            }
            return JSON.toJSONStringWithDateFormat(lists.get(0), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]);
        }
        return null;
    }

    @HussarDs(value="master")
    public boolean save(BpmActPlatformBpa bpmActPlatformBpa) {
        return SqlHelper.retBool((Integer)this.bpmActPlatformBpaMapper.insert(bpmActPlatformBpa));
    }

    public PlatformProcessCountMsgDto queryProcessCountMsg() {
        BpmActPlatformBpa bpmActPlatformBpa = this.getLastBpaInfo();
        PlatformProcessCountMsgDto dto = new PlatformProcessCountMsgDto();
        if (bpmActPlatformBpa != null) {
            dto.setModel(bpmActPlatformBpa.getModelCount());
            dto.setProcessCount(bpmActPlatformBpa.getProcessCount());
            dto.setAllDuration(bpmActPlatformBpa.getAllDuration());
            dto.setRejectTask(bpmActPlatformBpa.getRejectTask());
            dto.setRevokeTask(bpmActPlatformBpa.getRevokeTask());
            dto.setRunningInstance(bpmActPlatformBpa.getRunningInstance());
            dto.setCompleteInstance(bpmActPlatformBpa.getCompleteInstance());
            dto.setProcessCompleteRate(bpmActPlatformBpa.getProcessCompleteRate());
            dto.setRunningTask(bpmActPlatformBpa.getRunningTask());
            dto.setCompleteTask(bpmActPlatformBpa.getCompleteTask());
            dto.setTaskCompleteRate(bpmActPlatformBpa.getTaskCompleteRate());
            dto.setNormalCount(bpmActPlatformBpa.getNormalCount());
            dto.setPauseCount(bpmActPlatformBpa.getPauseCount());
            dto.setEndCount(bpmActPlatformBpa.getEndCount());
            dto.setTerminatedCount(bpmActPlatformBpa.getTerminatedCount());
        }
        return dto;
    }

    public Map<String, JSONArray> getDayChangeCountModel() {
        BpmActPlatformBpa bpmActPlatformBpa = this.getLastBpaInfo();
        HashMap<String, JSONArray> result = new HashMap<String, JSONArray>();
        if (bpmActPlatformBpa != null) {
            result.put("taskComplete", JSON.parseArray((String)bpmActPlatformBpa.getDayTaskComplete()));
            result.put("taskAdd", JSON.parseArray((String)bpmActPlatformBpa.getDayTaskAdd()));
            result.put("processComplete", JSON.parseArray((String)bpmActPlatformBpa.getDayProcessComplete()));
            result.put("processAdd", JSON.parseArray((String)bpmActPlatformBpa.getDayProcessAdd()));
        }
        return result;
    }

    public List<JSONObject> queryProcessDetail() {
        BpmActPlatformBpa bpmActPlatformBpa = this.getLastBpaInfo();
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        if (bpmActPlatformBpa != null) {
            JSONObject modelMap = JSON.parseObject((String)bpmActPlatformBpa.getTenantModelCount());
            JSONObject processMap = JSON.parseObject((String)bpmActPlatformBpa.getTenantProcessCount());
            for (String tenantName : modelMap.keySet()) {
                JSONObject countInfo = new JSONObject();
                countInfo.put("tenantName", (Object)tenantName);
                countInfo.put("model", (Object)modelMap.getInteger(String.valueOf(tenantName)));
                countInfo.put("processCount", (Object)processMap.getInteger(String.valueOf(tenantName)));
                result.add(countInfo);
            }
        }
        return result;
    }

    private BpmActPlatformBpa getLastBpaInfo() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BpmActPlatformBpa::getCountTime);
        Page page = new Page();
        page.setSize(1L);
        List records = this.bpmActPlatformBpaMapper.selectPage((IPage)page, (Wrapper)wrapper).getRecords();
        if (HussarUtils.isNotEmpty((Object)records)) {
            return (BpmActPlatformBpa)records.get(0);
        }
        return null;
    }
}

