/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.assignee.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.workflow.assignee.dao.WorkflowAssigneeChooseMapper;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.OrganOrPostInfo;
import com.jxdinfo.hussar.workflow.assignee.model.Personnel;
import com.jxdinfo.hussar.workflow.assignee.model.SysDepartment;
import com.jxdinfo.hussar.workflow.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.assignee.model.UserMainInfo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WorkflowAssigneeChooseServiceImpl
implements IWorkflowAssigneeChooseService {
    private final WorkflowAssigneeChooseMapper workflowAssigneeChooseMapper;
    private static final String DEFAULT_PARENTID = "11";
    private static final String DEFAULT_ORGAN_PARENTID = "1";
    public static final String ORGAN = "organ";
    public static final String USER = "user";
    private static final Pattern ORGAN_CONTAINS_CHILD_REGEX = Pattern.compile("O.PARENT_ID( NOT)? CONTAINSCHILD \\('([^)])*\\)");

    public WorkflowAssigneeChooseServiceImpl(WorkflowAssigneeChooseMapper workflowAssigneeChooseMapper) {
        this.workflowAssigneeChooseMapper = workflowAssigneeChooseMapper;
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost, boolean longIdType) {
        List<BpmTreeModel> result;
        block6: {
            String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
            result = this.workflowAssigneeChooseMapper.userTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, isMainPost, null, longIdType ? null : newId, null);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block6;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), isMainPost ? "userWithMainPost" : USER);
            List<Object> parentIdsLong = new ArrayList();
            if (longIdType) {
                parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return result;
    }

    public List<BpmTreeModel> deptTree(String id, boolean longIdType) {
        List<BpmTreeModel> result;
        block6: {
            String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
            result = this.workflowAssigneeChooseMapper.deptTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, null, longIdType ? null : newId, null);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block6;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), ORGAN);
            List<Object> parentIdsLong = new ArrayList();
            if (longIdType) {
                parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return result;
    }

    public List<BpmTreeModel> deptTree(String id, String organId, boolean longIdType) {
        String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        List<Object> result = new ArrayList();
        result = !StringUtils.isEmpty((Object)organId) ? this.workflowAssigneeChooseMapper.deptTree(null, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, null, longIdType ? null : organId) : this.workflowAssigneeChooseMapper.deptTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, null, longIdType ? null : newId, null);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<String> stringParentIds = new ArrayList<String>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!ORGAN.equals(bpmTreeModel.getType())) continue;
            if (longIdType) {
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                continue;
            }
            stringParentIds.add(bpmTreeModel.getId());
        }
        if (!parentIds.isEmpty() || !stringParentIds.isEmpty()) {
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), ORGAN);
            ArrayList arrayList = new ArrayList();
            if (longIdType) {
                List list = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !list.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            }
        }
        if (!StringUtils.isEmpty((Object)organId)) {
            List<BpmTreeModel> allDept = this.workflowAssigneeChooseMapper.getAllDept();
            List<BpmTreeModel> list = this.queryAllTreeByChildrenNode(result, 0);
            for (BpmTreeModel bpmTreeModel : allDept) {
                if (result.size() <= 0 || list.get(0).getId().equals(bpmTreeModel.getId()) || !bpmTreeModel.getParentId().equals(DEFAULT_PARENTID)) continue;
                list.add(bpmTreeModel);
            }
            return list;
        }
        return result;
    }

    public List<BpmTreeModel> deptTrees() {
        ArrayList<BpmTreeModel> result = new ArrayList();
        result = this.workflowAssigneeChooseMapper.deptTree(null, null, null, null);
        List<BpmTreeModel> bpmTreeModels = this.mergeTree(result, 11L);
        return bpmTreeModels;
    }

    private List<BpmTreeModel> mergeTree(List<BpmTreeModel> list, Long parentId) {
        HashMap<String, BpmTreeModel> map = new HashMap<String, BpmTreeModel>();
        String id = DEFAULT_PARENTID;
        for (BpmTreeModel bpmTreeModel : list) {
            if (DEFAULT_PARENTID.equals(bpmTreeModel.getParentId())) {
                id = bpmTreeModel.getId();
            }
            map.put(bpmTreeModel.getId(), bpmTreeModel);
        }
        for (BpmTreeModel temp : list) {
            BpmTreeModel bpmTreeModel = (BpmTreeModel)map.get(temp.getParentId());
            if (bpmTreeModel == null) continue;
            BpmTreeModel bpmTreeModel1 = (BpmTreeModel)map.get(temp.getId());
            bpmTreeModel1.setParentName("");
            bpmTreeModel1.setSort("");
            bpmTreeModel1.setType("");
            bpmTreeModel.getChildren().add(bpmTreeModel1);
        }
        ArrayList<BpmTreeModel> bpmTreeModels = new ArrayList<BpmTreeModel>();
        bpmTreeModels.add((BpmTreeModel)map.get(id));
        return bpmTreeModels;
    }

    public List<BpmTreeModel> roleTree() {
        List<BpmTreeModel> result = this.workflowAssigneeChooseMapper.roleTree(null, null, null, null);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (BpmTreeModel bpmTreeModel : result) {
            parentIds.add(Long.valueOf(bpmTreeModel.getId()));
        }
        if (!parentIds.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : result) {
                if (!parentIds.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                bpmTreeModel.setIsLeaf("false");
            }
        }
        return result;
    }

    public List<BpmTreeModel> roleTree(String id, boolean longIdType) {
        List<BpmTreeModel> result;
        block6: {
            String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_ORGAN_PARENTID : id;
            result = this.workflowAssigneeChooseMapper.roleTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, null, longIdType ? null : newId, null);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block6;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafRoleParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds));
            List<Object> parentIdsLong = new ArrayList();
            if (longIdType) {
                parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return result;
    }

    public List<BpmTreeModel> roleTree(String id, String roleId, boolean longIdType) {
        String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_ORGAN_PARENTID : id;
        List<Object> result = new ArrayList();
        result = !StringUtils.isEmpty((Object)roleId) ? this.workflowAssigneeChooseMapper.roleTree(null, longIdType ? Long.valueOf(Long.parseLong(roleId)) : null, null, longIdType ? null : roleId) : this.workflowAssigneeChooseMapper.roleTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, null, longIdType ? null : newId, null);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<String> stringParentIds = new ArrayList<String>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (longIdType) {
                if (!"GROUP".equals(bpmTreeModel.getType())) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                continue;
            }
            if (!"GROUP".equals(bpmTreeModel.getType())) continue;
            stringParentIds.add(bpmTreeModel.getId());
        }
        if (!parentIds.isEmpty() || !stringParentIds.isEmpty()) {
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafRoleParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds));
            ArrayList arrayList = new ArrayList();
            if (longIdType) {
                List list = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!list.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            }
        }
        if (!StringUtils.isEmpty((Object)roleId)) {
            List<BpmTreeModel> allDept = this.workflowAssigneeChooseMapper.getAllRole();
            List<BpmTreeModel> list = this.queryAllTreeByChildrenNode(result, 1);
            for (BpmTreeModel bpmTreeModel : allDept) {
                if (result.size() <= 0 || list.get(0).getId().equals(bpmTreeModel.getId()) || !bpmTreeModel.getParentId().equals(DEFAULT_ORGAN_PARENTID) || !"GROUP".equals(bpmTreeModel.getType())) continue;
                list.add(bpmTreeModel);
            }
            return list;
        }
        return result;
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, boolean longIdType) {
        if ((userIds = new ArrayList<String>(new HashSet<String>(userIds))) != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            removeList.add(null);
            removeList.add("null");
            userIds.removeAll(removeList);
        }
        if (StringUtils.isEmpty(userIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        ArrayList<Long> userIdL = new ArrayList<Long>();
        ArrayList<String> userIdStr = new ArrayList<String>();
        for (String str : userIds) {
            if (StringUtils.isEmpty((Object)str)) continue;
            if (longIdType) {
                userIdL.add(Long.parseLong(str));
                continue;
            }
            userIdStr.add(str);
        }
        return this.workflowAssigneeChooseMapper.userDetail(longIdType ? this.getInListSqlCondition(userIdL) : null, longIdType ? null : this.getStringListSqlCondition(userIdStr));
    }

    public List<BpmTreeModel> organDetail(List<String> organIds, boolean longIdType) {
        if ((organIds = new ArrayList<String>(new HashSet<String>(organIds))) != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            removeList.add(null);
            removeList.add("null");
            organIds.removeAll(removeList);
        }
        if (StringUtils.isEmpty(organIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        ArrayList<Long> organIdL = new ArrayList<Long>();
        ArrayList<String> organIdStr = new ArrayList<String>();
        for (String str : organIds) {
            if (StringUtils.isEmpty((Object)str)) continue;
            if (longIdType) {
                organIdL.add(Long.parseLong(str));
                continue;
            }
            organIdStr.add(str);
        }
        return this.workflowAssigneeChooseMapper.organDetail(longIdType ? this.getInListSqlCondition(organIdL) : null, longIdType ? null : this.getStringListSqlCondition(organIdStr));
    }

    public List<BpmTreeModel> userDeptDetail(String userId, boolean longIdType) {
        List<BpmTreeModel> result = this.workflowAssigneeChooseMapper.userDeptDetail(longIdType ? Long.valueOf(Long.parseLong(userId)) : null, longIdType ? null : userId);
        for (BpmTreeModel bpmTreeModel : result) {
            if (!DEFAULT_PARENTID.equals(bpmTreeModel.getParentId())) continue;
            bpmTreeModel.setParentId(null);
        }
        return result;
    }

    public List<String> getCandidateUser(String condition, Integer securityLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT O.ORGAN_ID AS userId FROM HUSSAR_BPM_ORGAN_VIEW O ");
        if (condition.contains("GRANTED_ROLE")) {
            sb.append("  LEFT JOIN HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID");
        }
        sb.append("  WHERE O.ORGAN_TYPE = 'user'");
        sb.append(condition);
        String sql = sb.toString().replace("''", "'0'");
        return new ArrayList<String>(new HashSet<String>(this.workflowAssigneeChooseMapper.getCandidateUsers(sql, securityLevel)));
    }

    public List<BpmTreeModel> getCandidateUserWithParent(String condition, Integer securityLevel) {
        condition = this.getRealCondition(condition);
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT O.ORGAN_ID AS id, ").append(" O.PARENT_ID AS parentid, ").append(" P.ORGAN_NAME AS parentName ").append(" FROM HUSSAR_BPM_ORGAN_VIEW O ").append("  LEFT JOIN HUSSAR_BPM_ORGAN_VIEW P ON P.ORGAN_ID = O.PARENT_ID ").append("  LEFT JOIN HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID ").append("  WHERE O.ORGAN_TYPE = 'user'  ");
        sb.append(condition);
        String sql = sb.toString().replace("''", "'0'");
        List<BpmTreeModel> result = this.workflowAssigneeChooseMapper.getCandidateUsersWithParent(sql, securityLevel);
        ArrayList<BpmTreeModel> finalResult = new ArrayList<BpmTreeModel>();
        HashMap<String, Set> map = new HashMap<String, Set>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!map.computeIfAbsent(bpmTreeModel.getId(), k -> new HashSet()).add(bpmTreeModel.getParentId())) continue;
            finalResult.add(bpmTreeModel);
        }
        return finalResult;
    }

    public String getRealCondition(String realCondition) {
        if (realCondition.contains("CONTAINSCHILD")) {
            List<AssigneeChooseDto> allOrgans = this.workflowAssigneeChooseMapper.getAllOrgans();
            HashMap<String, ArrayList<String>> maps = new HashMap<String, ArrayList<String>>();
            for (AssigneeChooseDto assigneeChooseDto : allOrgans) {
                String organId = assigneeChooseDto.getUserId();
                String parentId = assigneeChooseDto.getParentId();
                ArrayList<String> list = (ArrayList<String>)maps.get(parentId);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(organId);
                maps.put(parentId, list);
            }
            Matcher organMatcher = ORGAN_CONTAINS_CHILD_REGEX.matcher(realCondition);
            while (organMatcher.find()) {
                int i;
                String organCondition = organMatcher.group();
                String[] organConditions = organCondition.split("'");
                ArrayList<String> organIds = new ArrayList<String>();
                for (i = 1; i < organConditions.length; i += 2) {
                    organIds.add(organConditions[i]);
                }
                for (i = 0; i < organIds.size(); ++i) {
                    List addOrgans = (List)maps.get(organIds.get(i));
                    if (addOrgans == null) continue;
                    organIds.addAll(addOrgans);
                }
                organIds = new ArrayList(new HashSet(organIds));
                StringBuilder stringBuilder = new StringBuilder();
                boolean isConditionNotIn = organCondition.contains("NOT CONTAINSCHILD");
                if (isConditionNotIn) {
                    stringBuilder.append("O.PARENT_ID NOT IN (");
                } else {
                    stringBuilder.append("O.PARENT_ID IN (");
                }
                for (String s : organIds) {
                    stringBuilder.append("'").append(s).append("',");
                }
                stringBuilder.append("'')");
                String replactCondition = stringBuilder.toString();
                while (replactCondition.contains(",''")) {
                    replactCondition = replactCondition.replace(",''", "");
                }
                while (replactCondition.contains("'',")) {
                    replactCondition = replactCondition.replace("'',", "");
                }
                if (replactCondition.contains("('')")) {
                    replactCondition = isConditionNotIn ? "1=1" : "1!=1";
                }
                realCondition = realCondition.replace(organCondition, replactCondition);
            }
        }
        return realCondition;
    }

    public Integer getSecurityLevel(String userId, boolean longIdType) {
        return this.workflowAssigneeChooseMapper.getSecurityLevel(longIdType ? Long.valueOf(Long.parseLong(userId)) : null, longIdType ? null : userId);
    }

    public String getSameLevelDeptIdByUserId(String userId, boolean longIdType) {
        List<String> deptId = this.workflowAssigneeChooseMapper.getSameLevelDeptIdByUserId(longIdType ? Long.valueOf(Long.parseLong(userId)) : null, longIdType ? null : userId);
        return String.join((CharSequence)",", deptId);
    }

    public String getParentDeptIdByUserId(String userId, boolean longIdType) {
        List<String> deptId = this.workflowAssigneeChooseMapper.getParentDeptIdByUserId(longIdType ? Long.valueOf(Long.parseLong(userId)) : null, longIdType ? null : userId);
        return String.join((CharSequence)",", deptId);
    }

    public String getDeptIdByUserIds(String userId, boolean longIdType) {
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
        ArrayList<Long> longUserIds = new ArrayList();
        ArrayList<String> stringUserIds = new ArrayList();
        if (longIdType) {
            longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            stringUserIds = users.stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        List<String> deptId = this.workflowAssigneeChooseMapper.getDeptIdByUserIds(longIdType ? this.getInListSqlCondition(longUserIds) : null, longIdType ? null : this.getStringListSqlCondition(stringUserIds));
        return String.join((CharSequence)",", new HashSet<String>(deptId));
    }

    public String getSameLevelDeptIdByUserIds(String userId, boolean longIdType) {
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
        ArrayList<Long> longUserIds = new ArrayList();
        ArrayList<String> stringUserIds = new ArrayList();
        if (longIdType) {
            longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            stringUserIds = users.stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        List<String> deptId = this.workflowAssigneeChooseMapper.getSameLevelDeptIdByUserIds(longIdType ? this.getInListSqlCondition(longUserIds) : null, longIdType ? null : this.getStringListSqlCondition(stringUserIds));
        return String.join((CharSequence)",", new HashSet<String>(deptId));
    }

    public String getParentDeptIdByUserIds(String userId, boolean longIdType) {
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
        ArrayList<Long> longUserIds = new ArrayList();
        ArrayList<String> stringUserIds = new ArrayList();
        if (longIdType) {
            longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            stringUserIds = users.stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        List<String> deptId = this.workflowAssigneeChooseMapper.getParentDeptIdByUserIds(longIdType ? this.getInListSqlCondition(longUserIds) : null, longIdType ? null : this.getStringListSqlCondition(stringUserIds));
        return String.join((CharSequence)",", new HashSet<String>(deptId));
    }

    public List<BpmTreeModel> queryUserTree(String organName) {
        return this.workflowAssigneeChooseMapper.queryUserTree(organName);
    }

    public List<BpmTreeModel> postTree() {
        return this.workflowAssigneeChooseMapper.postTree();
    }

    public List<BpmTreeModel> deptName(List<Long> ids) {
        return this.workflowAssigneeChooseMapper.deptName(ids);
    }

    public List<String> getListStringSqlResult(String sql) {
        return this.workflowAssigneeChooseMapper.getListStringSqlResult(sql);
    }

    public List<Map<String, String>> getListMapSqlResult(String sql) {
        return this.workflowAssigneeChooseMapper.getListMapSqlResult(sql);
    }

    public Boolean getBooleanSqlResult(String sql) {
        return this.workflowAssigneeChooseMapper.getBooleanSqlResult(sql);
    }

    public String getparentId(String userId) {
        return this.workflowAssigneeChooseMapper.getParentId(userId);
    }

    public List<SysDepartment> getDepartmentList() {
        return this.workflowAssigneeChooseMapper.getDepartmentList();
    }

    public String getOrganIdByOutOrganId(String outOrganId) {
        return this.workflowAssigneeChooseMapper.getOrganIdByOutOrganId(outOrganId);
    }

    public String getOrganIdByOutStruId(String outStruId) {
        return this.workflowAssigneeChooseMapper.getOrganIdByOutStruId(outStruId);
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> page, String organId, String type, boolean longIdType) {
        if (StringUtils.isEmpty((Object)organId) || StringUtils.isEmpty((Object)type)) {
            return page.setRecords(this.workflowAssigneeChooseMapper.getUserListByParentId((IPage<BpmTreeModel>)page, null, null));
        }
        if (ORGAN.equals(type)) {
            return page.setRecords(this.workflowAssigneeChooseMapper.getUserListByParentId((IPage<BpmTreeModel>)page, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId));
        }
        if (USER.equals(type)) {
            return page.setRecords(this.workflowAssigneeChooseMapper.getUserListByUserId((IPage<BpmTreeModel>)page, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId));
        }
        return new Page();
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        if (StringUtils.isEmpty((Object)bpmTreeModel.getId()) || StringUtils.isEmpty((Object)bpmTreeModel.getParentId())) {
            return new ArrayList<BpmTreeModel>();
        }
        List<BpmTreeModel> allDept = this.workflowAssigneeChooseMapper.getAllDept();
        HashMap<String, BpmTreeModel> deptmap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptmap.put(dept.getId(), dept);
        }
        if (USER.equals(bpmTreeModel.getType())) {
            if ((bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())) != null) {
                return new ArrayList<BpmTreeModel>();
            }
        } else if (ORGAN.equals(bpmTreeModel.getType())) {
            bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getId());
        }
        while (deptmap.containsKey(bpmTreeModel.getParentId())) {
            ArrayList<BpmTreeModel> children = new ArrayList<BpmTreeModel>();
            children.add(bpmTreeModel);
            bpmTreeModel = ((BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())).setChildrenList(children);
        }
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        result.add(bpmTreeModel);
        return result;
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName, boolean longIdType) {
        if (users == null || users.size() == 0 || StringUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        ArrayList<Long> longUserIds = new ArrayList();
        ArrayList<String> stringUserIds = new ArrayList();
        if (longIdType) {
            longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            stringUserIds = users.stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        return this.workflowAssigneeChooseMapper.queryAssigneeAndDept(longIdType ? this.getInListSqlCondition(longUserIds) : null, longIdType ? null : this.getStringListSqlCondition(stringUserIds), organName);
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> users, String organId, String type, boolean longIdType) {
        ArrayList<Long> longUsers = new ArrayList<Long>();
        ArrayList<String> stringUsers = new ArrayList<String>();
        for (String user : users) {
            if (longIdType) {
                longUsers.add(Long.parseLong(user));
                continue;
            }
            stringUsers.add(user);
        }
        if (StringUtils.isEmpty((Object)organId) || StringUtils.isEmpty((Object)type)) {
            return pages.setRecords(this.workflowAssigneeChooseMapper.getNodeAssigneeListByParentId((IPage<BpmTreeModel>)pages, null, null, longIdType ? this.getInListSqlCondition(longUsers) : null, longIdType ? null : this.getStringListSqlCondition(stringUsers)));
        }
        List<Object> list = new ArrayList();
        if (ORGAN.equals(type)) {
            list = this.workflowAssigneeChooseMapper.getUserListByParentId((IPage<BpmTreeModel>)pages, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId).stream().filter(a -> users.contains(a.getId())).collect(Collectors.toList());
        } else if (USER.equals(type)) {
            list = this.workflowAssigneeChooseMapper.getNodeAssigneeListByUserId((IPage<BpmTreeModel>)pages, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId).stream().filter(a -> users.contains(a.getId())).collect(Collectors.toList());
        }
        return pages.setRecords(list);
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> users, String organId, String type, boolean longIdType, String organName) {
        List<Object> list;
        ArrayList<Map<String, Long>> longUsers = new ArrayList<Map<String, Long>>();
        ArrayList<Map<String, String>> stringUsers = new ArrayList<Map<String, String>>();
        HashMap<String, List> usersMap = new HashMap<String, List>();
        for (BpmTreeModel bpmTreeModel : users) {
            HashMap<String, Object> map;
            List parentIds = usersMap.computeIfAbsent(bpmTreeModel.getId(), k -> new ArrayList());
            if (bpmTreeModel.getParentId() != null) {
                parentIds.add(bpmTreeModel.getParentId());
            }
            if (longIdType) {
                map = new HashMap<String, Object>();
                map.put("id", Long.parseLong(bpmTreeModel.getId()));
                if (bpmTreeModel.getParentId() != null) {
                    map.put("parentId", Long.parseLong(bpmTreeModel.getParentId()));
                }
                longUsers.add(map);
                continue;
            }
            map = new HashMap();
            map.put("id", bpmTreeModel.getId());
            map.put("parentId", bpmTreeModel.getParentId());
            stringUsers.add(map);
        }
        if (StringUtils.isEmpty((Object)organId) || StringUtils.isEmpty((Object)type)) {
            list = this.workflowAssigneeChooseMapper.getNodeAssigneeListWithParentByParentId((IPage<BpmTreeModel>)pages, null, null, (List<Map<String, Long>>)(longIdType ? longUsers : null), (List<Map<String, String>>)(longIdType ? null : stringUsers), organName);
            return pages.setRecords(list);
        }
        list = new ArrayList();
        if (ORGAN.equals(type)) {
            list = this.workflowAssigneeChooseMapper.getUserListByParentId((IPage<BpmTreeModel>)pages, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId).stream().filter(a -> usersMap.containsKey(a.getId()) && (((List)usersMap.get(a.getId())).isEmpty() || ((List)usersMap.get(a.getId())).contains(a.getParentId()))).collect(Collectors.toList());
        } else if (USER.equals(type)) {
            list = this.workflowAssigneeChooseMapper.getNodeAssigneeListByUserIdWithParent((IPage<BpmTreeModel>)pages, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId).stream().filter(a -> usersMap.containsKey(a.getId()) && (((List)usersMap.get(a.getId())).isEmpty() || ((List)usersMap.get(a.getId())).contains(a.getParentId()))).collect(Collectors.toList());
        }
        return pages.setRecords(list);
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName, boolean longIdType) {
        List<BpmTreeModel> result;
        block6: {
            organName = organName.replace("%", "\\%").replace("_", "\\_");
            result = this.workflowAssigneeChooseMapper.queryDeptTreeByDeptName(organName);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block6;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), ORGAN);
            List<Object> parentIdsLong = new ArrayList();
            if (longIdType) {
                parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return this.queryAllTreeByChildrenNode(result, 0);
    }

    private List<BpmTreeModel> queryAllTreeByChildrenNode(List<BpmTreeModel> childrenNode, Integer type) {
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        List<BpmTreeModel> allDept = type == 0 ? this.workflowAssigneeChooseMapper.getAllDept() : this.workflowAssigneeChooseMapper.getAllRole();
        HashMap<String, BpmTreeModel> deptMap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptMap.put(dept.getId(), dept);
        }
        block1: for (BpmTreeModel bpmTreeModel : childrenNode) {
            BpmTreeModel children = bpmTreeModel;
            if (deptMap.containsKey(children.getId())) {
                children = (BpmTreeModel)deptMap.get(children.getId());
            }
            while (true) {
                if (!deptMap.containsKey(children.getParentId())) {
                    int i;
                    for (BpmTreeModel rootNode : result) {
                        if (!rootNode.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < result.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)result.get(i)).getType())) {
                                result.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < result.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)result.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    }
                    result.add(children);
                    continue block1;
                }
                BpmTreeModel parent = (BpmTreeModel)deptMap.get(children.getParentId());
                ArrayList<BpmTreeModel> childrenList = parent.getChildrenList();
                if (childrenList != null && childrenList.size() != 0) {
                    int i;
                    for (BpmTreeModel parentChildrenList : childrenList) {
                        if (!parentChildrenList.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)childrenList.get(i)).getType())) {
                                childrenList.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)childrenList.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    }
                    childrenList.add(children);
                    continue block1;
                }
                childrenList = new ArrayList<BpmTreeModel>();
                childrenList.add(children);
                parent.setChildrenList(childrenList);
                children = parent;
            }
        }
        return result;
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        if (StringUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        List<BpmTreeModel> childrenNode = this.workflowAssigneeChooseMapper.queryUserTreeByUserName(organName);
        return this.queryAllTreeByChildrenNode(childrenNode, 0);
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        if (StringUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        return this.workflowAssigneeChooseMapper.queryUserTreeByUserName(organName);
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName, boolean longIdType) {
        List<BpmTreeModel> result;
        block7: {
            if (StringUtils.isEmpty((Object)roleName)) {
                return new ArrayList<BpmTreeModel>();
            }
            roleName = roleName.replace("%", "\\%").replace("_", "\\_");
            result = this.workflowAssigneeChooseMapper.queryRoleTreeByRoleName(roleName);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block7;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafRoleParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds));
            List<Object> parentIdsLong = new ArrayList();
            if (longIdType) {
                parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return this.queryAllTreeByChildrenNode(result, 1);
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds, boolean longIdType) {
        ArrayList<Long> longUsers = new ArrayList<Long>();
        ArrayList<String> stringUsers = new ArrayList<String>();
        for (String user : userIds) {
            if (longIdType) {
                longUsers.add(Long.parseLong(user));
                continue;
            }
            stringUsers.add(user);
        }
        return this.workflowAssigneeChooseMapper.getUserAndAccountListByUserId(longIdType ? this.getInListSqlCondition(longUsers) : null, longIdType ? null : this.getStringListSqlCondition(stringUsers));
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds, boolean longIdType) {
        if (userIds == null || userIds.size() == 0) {
            return new ArrayList<BpmUserInfoVo>();
        }
        ArrayList<Long> ids = new ArrayList();
        ArrayList<String> stringIds = new ArrayList();
        if (longIdType) {
            ids = userIds.stream().map(Long::parseLong).collect(Collectors.toList());
        } else {
            stringIds = userIds.stream().map(String::valueOf).collect(Collectors.toList());
        }
        return this.workflowAssigneeChooseMapper.getUserMsgByUserIds(longIdType ? this.getInListSqlCondition(ids) : null, longIdType ? null : this.getStringListSqlCondition(stringIds));
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto, boolean longIdType) {
        if (DEFAULT_PARENTID.equals(getListDto.getDeptId())) {
            getListDto.setDeptId("");
        }
        if (longIdType) {
            if (!StringUtils.isEmpty((Object)getListDto.getDeptId())) {
                getListDto.setLongDeptId(Long.valueOf(Long.parseLong(getListDto.getDeptId())));
            }
            if (!StringUtils.isEmpty((Object)getListDto.getRoleId())) {
                getListDto.setLongRoleId(Long.valueOf(Long.parseLong(getListDto.getRoleId())));
            }
        }
        return page.setRecords(this.workflowAssigneeChooseMapper.queryList((IPage<BpmUserInfoVo>)page, getListDto));
    }

    private List<List<Long>> getInListSqlCondition(List<Long> longList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int size = longList.size();
        for (int i = 0; i < size; i += 1000) {
            List<Long> list = longList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }

    private List<List<String>> getStringListSqlCondition(List<String> stringList) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        int size = stringList.size();
        for (int i = 0; i < size; i += 1000) {
            List<String> list = stringList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }

    public List<AssigneeManageInfoVo> queryDept(String name) {
        return this.workflowAssigneeChooseMapper.queryOrganization(name);
    }

    public List<AssigneeManageInfoVo> queryRole(String name) {
        return this.workflowAssigneeChooseMapper.queryRole(name);
    }

    public List<UserDepartmentAndPostModel> getUserMainInfo(Collection<String> userIds) {
        return this.workflowAssigneeChooseMapper.getUserMainInfo(userIds);
    }

    public Map<String, Object> getDeptParamsByUserId(String userId) {
        return this.workflowAssigneeChooseMapper.getDeptParamsByUserId(userId);
    }

    public List<Personnel> getPersonnelByDepartmentId(String organType, String departmentId) {
        return this.workflowAssigneeChooseMapper.getPersonnelByDepartmentId(organType, departmentId);
    }

    public List<Personnel> getPersonnelByUserName(String userName) {
        return this.workflowAssigneeChooseMapper.getPersonnelByUserName(userName);
    }

    public List<UserDepartmentAndPostModel> getUserDepartmentAndPostModelByUserIds(List<String> userIds) {
        return this.workflowAssigneeChooseMapper.getUserDepartmentAndPostModelByUserIds(userIds);
    }

    public List<UserMainInfo> getUserOutMainInfo(HashSet<String> userIds, String userIdType) {
        List<Object> userMainInfos = new ArrayList();
        if (userIdType.equals("outOriginId")) {
            userMainInfos = this.workflowAssigneeChooseMapper.getUserOutMainInfo(userIds);
        } else if (userIdType.equals("outUserId")) {
            userMainInfos = this.workflowAssigneeChooseMapper.getUserOutMainInfoOut(userIds);
        }
        return userMainInfos;
    }

    public List<OrganOrPostInfo> getUserOutOrganInfo(HashSet<String> userIds, String userIdType) {
        List<Object> organOrPostInfos = new ArrayList();
        if (userIdType.equals("outOriginId")) {
            organOrPostInfos = this.workflowAssigneeChooseMapper.getUserOutOrganInfo(userIds);
        } else if (userIdType.equals("outUserId")) {
            organOrPostInfos = this.workflowAssigneeChooseMapper.getUserOutOrganInfoOut(userIds);
        }
        return organOrPostInfos;
    }

    public List<OrganOrPostInfo> getUserOutPostInfo(HashSet<String> userIds) {
        return this.workflowAssigneeChooseMapper.getUserOutPostInfo(userIds);
    }

    public List<Map<String, Object>> getDepartmentNameBydepartmentIds(List<String> departmentIds) {
        return this.workflowAssigneeChooseMapper.getDepartmentNameBydepartmentIds(departmentIds);
    }

    public List<Map<String, Object>> getPostNameBypostIds(List<String> postIds) {
        return this.workflowAssigneeChooseMapper.getPostNameBypostIds(postIds);
    }

    public List<Map<String, String>> getDepartmentIdAndPost(List<String> postIdList, List<String> postOrganIdList, List<String> userIdList) {
        return this.workflowAssigneeChooseMapper.getDepartmentIdAndPost(postIdList, postOrganIdList, userIdList);
    }

    public List<Map<String, String>> getAllOrgansBysk() {
        return this.workflowAssigneeChooseMapper.getAllOrgansBysk();
    }

    public List<UserDepartmentAndPostModel> getUserInfoByPost(List<String> departmentIdList, List<Long> postIdList) {
        return this.workflowAssigneeChooseMapper.getUserInfoByPost(departmentIdList, postIdList);
    }

    public Collection<String> getUserIdsByUserName(String userName) {
        return this.workflowAssigneeChooseMapper.getUserIdsByUserName(userName);
    }

    public Collection<String> getPostIdsByPostName(String postName) {
        return this.workflowAssigneeChooseMapper.getPostIdsByPostName(postName);
    }

    public Collection<String> getDeptIdsByDeptName(String deptName) {
        return this.workflowAssigneeChooseMapper.getDeptIdsByDeptName(deptName);
    }

    public String getUserIdByUserNumber(String userNumber) {
        return this.workflowAssigneeChooseMapper.getUserIdByUserNumber(userNumber);
    }

    public String getUserIdByUserAccount(String userAccount) {
        return this.workflowAssigneeChooseMapper.getUserIdByUserAccount(userAccount);
    }
}

