/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class BpmPluginUtil {
    private static final Pattern REGEXP_IDENTIFIER = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    public static String asIdentifier(String ident) {
        if (ident == null) {
            return "_";
        }
        if (REGEXP_IDENTIFIER.matcher(ident).matches() && !JAVA_KEYWORDS.contains(ident.toLowerCase())) {
            return ident;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('_');
        for (int i = 0; i < ident.length(); ++i) {
            char ch = ident.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') && ch != '_') continue;
            builder.append(ch);
        }
        return builder.toString();
    }
}

